/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.auth;

import com.codiform.moo.curry.Translate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.auth.RoleMembershipDto;
import org.kuali.coeus.sys.framework.controller.rest.SimpleCrudMapBasedRestController;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.role.RoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public class RoleMembershipController
extends SimpleCrudMapBasedRestController {
    private static final String NAMESPACE_NAME_DELIMETER = ":";
    private static final String QUALIFIER_NAME_VALUE_DELIMETER = ":";
    @Autowired
    @Qualifier(value="roleService")
    private RoleService roleService;
    @Autowired
    @Qualifier(value="personService")
    private PersonService personService;

    @RequestMapping(method={RequestMethod.GET}, value={"api/v1/roles/{roleId}/principals/{memberId}"})
    @ResponseBody
    public List<RoleMembershipDto> getRoleMembershipsForMemberId(@PathVariable String roleId, @PathVariable String memberId, @RequestParam(value="qualification", required=false) String[] qualification) {
        this.assertMethodSupported(RequestMethod.GET);
        if (StringUtils.isBlank((CharSequence)roleId)) {
            throw new ResourceNotFoundException("roleId is blank");
        }
        if (StringUtils.isBlank((CharSequence)memberId)) {
            throw new ResourceNotFoundException("memberId is blank");
        }
        Map<String, String> qualificationMap = this.withPrincipalQualifier(memberId, this.getQualifierMap(qualification != null ? Arrays.asList(qualification) : Collections.emptyList()));
        List roleMembers = this.roleService.getRoleMembers(Collections.singletonList(this.getActualRoleId(roleId)), qualificationMap).stream().filter(m -> m.getType() == MemberType.PRINCIPAL).filter(m -> m.getMemberId().equals(memberId)).collect(Collectors.toList());
        if (roleMembers.isEmpty()) {
            throw new ResourceNotFoundException("no results");
        }
        List roleMembershipDtoList = Translate.to(RoleMembershipDto.class).fromEach(roleMembers);
        HashMap personMap = new HashMap();
        roleMembershipDtoList.stream().forEach(roleMembershipDto -> this.populatePersonData((RoleMembershipDto)roleMembershipDto, personMap));
        return roleMembershipDtoList;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"api/v1/roles/{roleId}/principals/"})
    @ResponseBody
    public List<RoleMembershipDto> getRoleMemberships(@PathVariable String roleId, @RequestParam(value="qualification", required=false) String[] qualification) {
        this.assertMethodSupported(RequestMethod.GET);
        if (StringUtils.isBlank((CharSequence)roleId)) {
            throw new ResourceNotFoundException("roleId is blank");
        }
        Map<String, String> qualificationMap = this.getQualifierMap(qualification != null ? Arrays.asList(qualification) : Collections.emptyList());
        List roleMembers = this.roleService.getRoleMembers(Collections.singletonList(this.getActualRoleId(roleId)), qualificationMap).stream().filter(m -> m.getType() == MemberType.PRINCIPAL).collect(Collectors.toList());
        if (roleMembers.isEmpty()) {
            throw new ResourceNotFoundException("no results");
        }
        List roleMembershipDtoList = Translate.to(RoleMembershipDto.class).fromEach(roleMembers);
        HashMap personMap = new HashMap();
        roleMembershipDtoList.stream().forEach(roleMembershipDto -> this.populatePersonData((RoleMembershipDto)roleMembershipDto, personMap));
        return roleMembershipDtoList;
    }

    protected void populatePersonData(RoleMembershipDto roleMembershipDto, Map<String, Person> personMap) {
        Person person;
        if (!personMap.containsKey(roleMembershipDto.getMemberId())) {
            person = this.getPersonService().getPerson(roleMembershipDto.getMemberId());
            personMap.put(roleMembershipDto.getMemberId(), person);
        } else {
            person = personMap.get(roleMembershipDto.getMemberId());
        }
        if (person != null) {
            roleMembershipDto.setFullName((person.getFirstName() + " " + person.getLastName()).trim());
            roleMembershipDto.setEmail(person.getEmailAddress());
        }
    }

    protected Map<String, String> withPrincipalQualifier(String memberId, Map<String, String> qualificationMap) {
        HashMap<String, String> map = new HashMap<String, String>(qualificationMap);
        map.put("principalId", memberId);
        return map;
    }

    protected Map<String, String> getQualifierMap(List<String> qualification) {
        return qualification.stream().map(qualifier -> {
            String[] q = qualifier.split(":");
            return CollectionUtils.entry(q[0], q[1]);
        }).collect(CollectionUtils.entriesToMap());
    }

    protected String getActualRoleId(String roleId) {
        String actualRoleId;
        if (roleId.contains(":")) {
            String[] namespaceAndName = roleId.split(":");
            String namespace = namespaceAndName[0];
            String name = namespaceAndName[1];
            if (StringUtils.isBlank((CharSequence)namespace)) {
                throw new ResourceNotFoundException("blank namespace from roleId");
            }
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new ResourceNotFoundException("blank name from roleId");
            }
            actualRoleId = this.roleService.getRoleIdByNamespaceCodeAndName(namespace, name);
        } else {
            actualRoleId = roleId;
        }
        if (StringUtils.isBlank((CharSequence)actualRoleId)) {
            throw new ResourceNotFoundException("roleId not found");
        }
        return actualRoleId;
    }

    public RoleService getRoleService() {
        return this.roleService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

