/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.workflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.document.DocumentWorkflowUserDetails;
import org.kuali.coeus.common.api.document.DocumentWorkloadDetails;
import org.kuali.coeus.common.api.document.dto.PagedResultsDto;
import org.kuali.coeus.sys.framework.workflow.KewDocHeaderDao;
import org.kuali.kra.infrastructure.DocumentType;
import org.kuali.rice.core.api.criteria.CountFlag;
import org.kuali.rice.core.api.criteria.OrderByField;
import org.kuali.rice.core.api.criteria.OrderDirection;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.framework.persistence.platform.MySQLDatabasePlatform;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResult;
import org.kuali.rice.kew.docsearch.service.DocumentSearchService;
import org.kuali.rice.krad.dao.impl.LookupDaoOjb;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.stereotype.Repository;

@Repository(value="kewDocHeaderDao")
public class KewDocHeaderDaoImpl
extends LookupDaoOjb
implements KewDocHeaderDao {
    private static final String ID = "id";
    private static final String PRINCIPAL_ID = "principalId";
    private static final String STEPS = "steps";
    private static final List<String> INDEXABLE_DOC_TYPES = Arrays.asList("ProposalDevelopmentDocument", "InstitutionalProposalDocument", "AwardDocument", "SubAwardDocument", "NegotiationDocument");
    private static final String ALL_DOCUMENT_IDS_QUERY = "select doc_hdr_id from krew_doc_hdr_t where doc_typ_id in (select doc_typ_id from krew_doc_typ_t where doc_typ_nm in ('" + String.join((CharSequence)"', '", INDEXABLE_DOC_TYPES) + "'))and doc_hdr_stat_cd not in ('I', 'D', 'X') order by crte_dt desc";
    private static final String PAGED_DOCUMENT_IDS_QUERY_ORACLE = "select doc_hdr_id from (select doc_hdr_id, crte_dt, row_number() over (order by crte_dt desc) rn from krew_doc_hdr_t where doc_typ_id in (select doc_typ_id from krew_doc_typ_t where doc_typ_nm in ('" + String.join((CharSequence)"', '", INDEXABLE_DOC_TYPES) + "')) and doc_hdr_stat_cd not in ('I', 'D', 'X')) where rn between %d and %d order by crte_dt desc";
    private static final String CURRENT_PEOPLE_FLOW_STOP = "currentPeopleFlowStop";
    @Autowired
    @Qualifier(value="documentSearchService")
    private DocumentSearchService documentSearchService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="jdbcOperations")
    private JdbcOperations jdbcOperations;

    @Override
    public List<String> getAllDocumentIds() {
        return this.getAllDocumentIds(null, null);
    }

    @Override
    public List<String> getAllDocumentIds(Integer limit, Integer skip) {
        String pagedQuery = this.getPagedAllDocumentIdsQuery(limit, skip);
        return this.jdbcOperations.query(c -> c.prepareStatement(pagedQuery), (rs, rowNum) -> rs.getString(1));
    }

    private String getPagedAllDocumentIdsQuery(Integer limit, Integer skip) {
        int start;
        String sql = ALL_DOCUMENT_IDS_QUERY;
        if (skip == null || skip <= 0) {
            skip = 0;
        }
        int n = start = skip == 0 ? skip : skip + 1;
        if (limit != null && limit >= 0) {
            if (this.getDbPlatform() instanceof MySQLDatabasePlatform) {
                return String.format("%s LIMIT %d,%d", sql, skip, limit);
            }
            return String.format(PAGED_DOCUMENT_IDS_QUERY_ORACLE, start, skip + limit);
        }
        return sql;
    }

    @Override
    public List<DocumentSearchResult> getEnrouteProposalDocs(String user, Integer limit, Integer skip) {
        DocumentSearchCriteria.Builder builder = DocumentSearchCriteria.Builder.create();
        builder.setDocumentStatuses(Arrays.asList(DocumentStatus.ENROUTE));
        if (!Objects.isNull(limit)) {
            builder.setMaxResults(limit);
        }
        if (!Objects.isNull(skip)) {
            builder.setStartAtIndex(skip);
        }
        builder.setDocumentTypeName("ProposalDevelopmentDocument");
        return this.documentSearchService.lookupDocuments(user, builder.build()).getSearchResults();
    }

    @Override
    public List<DocumentSearchResult> getSavedDocuments(String user, String documentTypeFilter, Integer limit, Integer skip) {
        DocumentSearchCriteria.Builder builder = DocumentSearchCriteria.Builder.create();
        if (StringUtils.isNotEmpty((CharSequence)documentTypeFilter)) {
            builder.setDocumentTypeName(documentTypeFilter);
        } else {
            builder.setDocumentTypeName(DocumentType.AWARD_DOCUMENT.getName());
            ArrayList<String> additionalDocTypes = new ArrayList<String>();
            additionalDocTypes.add(DocumentType.NEGOTIATION_DOCUMENT.getName());
            additionalDocTypes.add(DocumentType.SUBAWARD_DOCUMENT.getName());
            additionalDocTypes.add(DocumentType.INSTITUTIONAL_PROPOSAL_DOCUMENT.getName());
            additionalDocTypes.add(DocumentType.AWARD_BUDGET_DOCUMENT.getName());
            builder.setAdditionalDocumentTypeNames(additionalDocTypes);
        }
        builder.setDocumentStatuses(List.of(DocumentStatus.SAVED));
        builder.setViewerPrincipalId(user);
        if (!Objects.isNull(limit)) {
            builder.setMaxResults(limit);
        }
        if (!Objects.isNull(skip)) {
            builder.setStartAtIndex(skip);
        }
        return this.documentSearchService.lookupDocuments(user, builder.build()).getSearchResults();
    }

    @Override
    public PagedResultsDto<DocumentWorkflowUserDetails> getWorkflowDetailsOfEnrouteProposalsForUser(String user, Integer limit, Integer skip) {
        Map<String, String> principalIdCriteria = Collections.singletonMap(PRINCIPAL_ID, user);
        QueryByCriteria.Builder query = QueryByCriteria.Builder.andAttributes(principalIdCriteria);
        query.setOrderByFields(List.of(OrderByField.Builder.create((String)STEPS, (OrderDirection)OrderDirection.ASCENDING).build(), OrderByField.Builder.create((String)ID, (OrderDirection)OrderDirection.ASCENDING).build()));
        this.addOrderByAndPagingFields(limit, skip, query);
        List userDetails = this.dataObjectService.findMatching(DocumentWorkflowUserDetails.class, query.build()).getResults();
        int totalRows = this.dataObjectService.findMatching(DocumentWorkflowUserDetails.class, QueryByCriteria.Builder.andAttributes(principalIdCriteria).setCountFlag(CountFlag.ONLY).build()).getTotalRowCount();
        return new PagedResultsDto<DocumentWorkflowUserDetails>(userDetails, totalRows);
    }

    @Override
    public PagedResultsDto<DocumentWorkloadDetails> getProposalsInWorkloadStop(String stopNumber, Integer limit, Integer skip) {
        Map<String, String> peopleFlowStopCriteria = Collections.singletonMap(CURRENT_PEOPLE_FLOW_STOP, stopNumber);
        QueryByCriteria.Builder query = QueryByCriteria.Builder.andAttributes(peopleFlowStopCriteria);
        this.addOrderByAndPagingFields(limit, skip, query);
        List documentDetails = this.dataObjectService.findMatching(DocumentWorkloadDetails.class, query.build()).getResults();
        int totalRows = this.dataObjectService.findMatching(DocumentWorkloadDetails.class, QueryByCriteria.Builder.andAttributes(peopleFlowStopCriteria).setCountFlag(CountFlag.ONLY).build()).getTotalRowCount();
        return new PagedResultsDto<DocumentWorkloadDetails>(documentDetails, totalRows);
    }

    public QueryByCriteria.Builder addOrderByAndPagingFields(Integer limit, Integer skip, QueryByCriteria.Builder query) {
        if (limit != null) {
            query.setMaxResults(limit);
        }
        if (skip != null && skip > 0) {
            query.setStartAtIndex(skip);
        }
        return query;
    }
}

