/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget.calculator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.kuali.coeus.common.budget.framework.core.CostElement;
import org.kuali.coeus.common.budget.framework.core.category.BudgetCategoryType;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.impl.calculator.BudgetCalculationServiceImpl;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.AwardBudgetLineItemExt;
import org.kuali.kra.award.budget.calculator.AwardBudgetCalculationService;

public class AwardBudgetCalculationServiceImpl
extends BudgetCalculationServiceImpl
implements AwardBudgetCalculationService {
    @Override
    public void calculateBudgetSummaryTotals(AwardBudgetExt budget, boolean includePrevious) {
        this.calculateBudgetSummaryTotals(budget);
        this.aggregatePeriodSummaryTotals(budget);
        if (includePrevious) {
            AwardBudgetExt prevBudget;
            AwardBudgetExt prevBudgetOverview = budget.getPrevBudget();
            while (prevBudgetOverview != null && prevBudgetOverview.getBudgetId() != null && (prevBudget = (AwardBudgetExt)this.getBusinessObjectService().findBySinglePrimaryKey(AwardBudgetExt.class, (Object)prevBudgetOverview.getBudgetId())) != null) {
                this.calculateBudgetSummaryTotals(prevBudget);
                this.aggregatePeriodSummaryTotals(prevBudget);
                this.mergePrevSummary(budget, prevBudget);
                prevBudgetOverview = prevBudget.getPrevBudget();
            }
        }
    }

    protected void aggregatePeriodSummaryTotals(AwardBudgetExt budget) {
        budget.setObjectCodeBudgetTotals(this.getSumOfElements(budget.getObjectCodeTotals()));
        budget.setCalculatedExpenseBudgetTotals(this.getSumOfElements(budget.getCalculatedExpenseTotals()));
        budget.setTotalBudgetSummaryTotals(this.getSumOfElements(budget.getBudgetSummaryTotals()));
        budget.setObjectCodePersonnelFringeBudgetTotals(this.getSumOfElements(budget.getObjectCodePersonnelFringeTotals()));
        budget.setPersonnelCalculatedExpenseBudgetTotals(this.getSumOfElements(budget.getPersonnelCalculatedExpenseTotals()));
        budget.setNonPersonnelCalculatedExpenseBudgetTotals(this.getSumOfElements(budget.getNonPersonnelCalculatedExpenseTotals()));
    }

    protected void mergePrevSummary(AwardBudgetExt budget, AwardBudgetExt prevBudget) {
        for (Map.Entry<BudgetCategoryType, List<CostElement>> entry : prevBudget.getObjectCodeListByBudgetCategoryType().entrySet()) {
            List curElements = (List)budget.getObjectCodeListByBudgetCategoryType().get(entry.getKey());
            if (curElements == null) {
                budget.getObjectCodeListByBudgetCategoryType().put(entry.getKey(), new ArrayList(entry.getValue()));
                continue;
            }
            HashSet uniqueSet = new HashSet(curElements);
            uniqueSet.addAll(entry.getValue());
            budget.getObjectCodeListByBudgetCategoryType().put(entry.getKey(), new ArrayList(uniqueSet));
        }
        budget.setObjectCodeBudgetTotals(this.mergeMaps(budget.getObjectCodeBudgetTotals(), prevBudget.getObjectCodeBudgetTotals()));
        budget.setCalculatedExpenseBudgetTotals(this.mergeMaps(budget.getCalculatedExpenseBudgetTotals(), prevBudget.getCalculatedExpenseBudgetTotals()));
        budget.setTotalBudgetSummaryTotals(this.mergeMaps(budget.getTotalBudgetSummaryTotals(), prevBudget.getTotalBudgetSummaryTotals()));
        budget.setObjectCodePersonnelFringeBudgetTotals(this.mergeMaps(budget.getObjectCodePersonnelFringeBudgetTotals(), prevBudget.getObjectCodePersonnelFringeBudgetTotals()));
        budget.setPersonnelCalculatedExpenseBudgetTotals(this.mergeMaps(budget.getPersonnelCalculatedExpenseBudgetTotals(), prevBudget.getPersonnelCalculatedExpenseBudgetTotals()));
        budget.setNonPersonnelCalculatedExpenseBudgetTotals(this.mergeMaps(budget.getNonPersonnelCalculatedExpenseBudgetTotals(), prevBudget.getNonPersonnelCalculatedExpenseBudgetTotals()));
    }

    protected SortedMap<? extends Object, ScaleTwoDecimal> mergeMaps(Map<? extends Object, ScaleTwoDecimal> totals, Map<? extends Object, ScaleTwoDecimal> previous) {
        TreeMap<Object, ScaleTwoDecimal> result = new TreeMap<Object, ScaleTwoDecimal>();
        for (Map.Entry<? extends Object, ScaleTwoDecimal> entry : totals.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<? extends Object, ScaleTwoDecimal> entry : previous.entrySet()) {
            Object key = entry.getKey();
            ScaleTwoDecimal total = totals.get(key);
            if (total == null) continue;
            if (total == null) {
                result.put(key, entry.getValue());
                continue;
            }
            result.put(key, (ScaleTwoDecimal)total.add((AbstractDecimal)entry.getValue()));
        }
        return result;
    }

    protected SortedMap<? extends Object, ScaleTwoDecimal> getSumOfElements(Map<? extends Object, List<ScaleTwoDecimal>> map) {
        TreeMap<Object, ScaleTwoDecimal> result = new TreeMap<Object, ScaleTwoDecimal>();
        for (Map.Entry<? extends Object, List<ScaleTwoDecimal>> entry : map.entrySet()) {
            ScaleTwoDecimal total = ScaleTwoDecimal.ZERO;
            for (ScaleTwoDecimal amt : entry.getValue()) {
                total = (ScaleTwoDecimal)total.add((AbstractDecimal)amt);
            }
            Object key = entry.getKey();
            if (key instanceof String) {
                String strKey = (String)entry.getKey();
                key = strKey.replaceAll(",.*", "");
            }
            result.put(key, total);
        }
        return result;
    }

    @Override
    protected Collection<? extends BudgetLineItem> getLineItemsFromDatabase(BudgetPeriod budgetPeriod) {
        HashMap<String, Number> fieldValues = new HashMap<String, Number>();
        fieldValues.put("budgetId", budgetPeriod.getBudgetId());
        fieldValues.put("budgetPeriod", budgetPeriod.getBudgetPeriod());
        Collection deletedLineItems = this.getBusinessObjectService().findMatching(AwardBudgetLineItemExt.class, fieldValues);
        return deletedLineItems;
    }
}

