/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.award.paymentreports.FrequencyBase;
import org.kuali.kra.award.paymentreports.ValidFrequencyBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.KeyValuesService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;

public class FrequencyBaseCodeValuesFinder
extends UifKeyValuesFinderBase {
    private static final Comparator<KeyValue> COMPARATOR = new FrequenceBaseComparator();
    private String frequencyCode;
    private KeyValuesService keyValuesService;

    public FrequencyBaseCodeValuesFinder() {
    }

    public FrequencyBaseCodeValuesFinder(String frequencyCode) {
        this.frequencyCode = frequencyCode;
    }

    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add(ValuesFinderUtils.getSelectOption());
        if (this.getFrequencyCode() != null) {
            keyValues.addAll(this.getKeyValues(this.getValidFrequencyBaseCodes()));
        }
        return keyValues;
    }

    protected List<String> getValidFrequencyBaseCodes() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("frequencyCode", this.getFrequencyCode());
        return this.getKeyValuesService().findMatching(ValidFrequencyBase.class, criteria).stream().map(ValidFrequencyBase::getFrequencyBaseCode).collect(Collectors.toList());
    }

    protected List<KeyValue> getKeyValues(List<String> validFrequencyBaseCodes) {
        return CollectionUtils.isEmpty(validFrequencyBaseCodes) ? Collections.emptyList() : this.getKeyValuesService().findMatching(FrequencyBase.class, Collections.singletonMap("frequencyBaseCode", validFrequencyBaseCodes)).stream().map(freqBase -> new ConcreteKeyValue(freqBase.getFrequencyBaseCode(), freqBase.getDescription())).sorted(COMPARATOR).collect(Collectors.toList());
    }

    public String getFrequencyCode() {
        return this.frequencyCode;
    }

    public void setFrequencyCode(String frequencyCode) {
        this.frequencyCode = frequencyCode;
    }

    protected KeyValuesService getKeyValuesService() {
        if (this.keyValuesService == null) {
            this.keyValuesService = (KeyValuesService)KcServiceLocator.getService("keyValuesService");
        }
        return this.keyValuesService;
    }

    static class FrequenceBaseComparator
    implements Comparator<KeyValue> {
        FrequenceBaseComparator() {
        }

        @Override
        public int compare(KeyValue kv1, KeyValue kv2) {
            try {
                String desc1 = kv1.getValue();
                String desc2 = kv2.getValue();
                if (desc1 == null) {
                    desc1 = "";
                }
                if (desc2 == null) {
                    desc2 = "";
                }
                return desc1.compareTo(desc2);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

