/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.sponsor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.kra.external.service.KcDtoService;
import org.kuali.kra.external.sponsor.SponsorCriteriaDto;
import org.kuali.kra.external.sponsor.SponsorDTO;
import org.kuali.kra.external.sponsor.SponsorWebService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.util.ObjectUtils;

public class SponsorWebServiceImpl
implements SponsorWebService {
    private BusinessObjectService businessObjectService;
    private LegacyDataAdapter legacyDataAdapter;
    private KcDtoService<SponsorDTO, Sponsor> sponsorDtoService;

    @Override
    public SponsorDTO getSponsor(String sponsorCode) {
        Sponsor sponsor;
        if (StringUtils.isNotBlank((CharSequence)sponsorCode) && (sponsor = (Sponsor)this.getBusinessObjectService().findBySinglePrimaryKey(Sponsor.class, (Object)sponsorCode)) != null) {
            SponsorDTO result = this.sponsorDtoService.buildDto(sponsor);
            return result;
        }
        return null;
    }

    @Override
    public List<SponsorDTO> getMatchingSponsors(SponsorCriteriaDto searchCriteria) {
        ArrayList<SponsorDTO> results = new ArrayList<SponsorDTO>();
        Collection sponsors = ObjectUtils.isNull((Object)searchCriteria) || StringUtils.isEmpty((CharSequence)searchCriteria.getSponsorCode()) && StringUtils.isEmpty((CharSequence)searchCriteria.getCustomerNumber()) ? this.getBusinessObjectService().findAll(Sponsor.class) : (StringUtils.isNotEmpty((CharSequence)searchCriteria.getSponsorCode()) ? this.legacyDataAdapter.findCollectionBySearchHelper(Sponsor.class, Collections.singletonMap("sponsorCode", searchCriteria.getSponsorCode()), Collections.emptyList(), true, false, Integer.valueOf(0)) : this.legacyDataAdapter.findCollectionBySearchHelper(Sponsor.class, Collections.singletonMap("customerNumber", searchCriteria.getCustomerNumber()), Collections.emptyList(), true, false, Integer.valueOf(0)));
        if (sponsors != null && !sponsors.isEmpty()) {
            for (Sponsor sponsor : sponsors) {
                results.add(this.sponsorDtoService.buildDto(sponsor));
            }
        }
        return results;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public LegacyDataAdapter getLookupService() {
        return this.legacyDataAdapter;
    }

    public void setLegacyDataAdapter(LegacyDataAdapter legacyDataAdapter) {
        this.legacyDataAdapter = legacyDataAdapter;
    }

    public KcDtoService<SponsorDTO, Sponsor> getSponsorDtoService() {
        return this.sponsorDtoService;
    }

    public void setSponsorDtoService(KcDtoService<SponsorDTO, Sponsor> sponsorDtoService) {
        this.sponsorDtoService = sponsorDtoService;
    }
}

