/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.request;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.actions.request.IacucProtocolRequestBean;
import org.kuali.kra.iacuc.actions.request.IacucProtocolRequestEvent;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.util.GlobalVariables;

public class IacucProtocolRequestRule
extends KcTransactionalDocumentRuleBase
implements KcBusinessRule<IacucProtocolRequestEvent> {
    private static final String MANDATORY = "M";
    private ParameterService parameterService;

    @Override
    public boolean processRules(IacucProtocolRequestEvent event) {
        boolean valid = true;
        if (this.isMandatory()) {
            valid &= this.validateCommittee(event.getPropertyKey(), event.getRequestBean());
        }
        return valid;
    }

    private boolean validateCommittee(String propertyKey, IacucProtocolRequestBean requestBean) {
        boolean valid = true;
        if (StringUtils.isBlank((CharSequence)requestBean.getCommitteeId())) {
            valid = false;
            GlobalVariables.getMessageMap().putError(propertyKey + ".committeeId", "error.protocol.submission.committee.required", new String[0]);
        }
        return valid;
    }

    private boolean isMandatory() {
        String param = this.getParameterService().getParameterValueAsString(IacucProtocolDocument.class, "IRB_COMM_SELECTION_DURING_SUBMISSION");
        return StringUtils.equalsIgnoreCase((CharSequence)MANDATORY, (CharSequence)param);
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }
}

