/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.rules;

import org.kuali.coeus.common.framework.attachment.KcAttachmentService;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.institutionalproposal.attachments.InstitutionalProposalAttachment;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalAddAttachmentRule;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalAddAttachmentRuleEvent;

public class InstitutionalProposalAddAttachmentRuleImpl
extends KcTransactionalDocumentRuleBase
implements InstitutionalProposalAddAttachmentRule {
    private static final String ATTACHMENT_TYPE_CODE = "institutionalProposalAttachmentBean.newAttachment.attachmentTypeCode";
    private static final String NEW_FILE = "institutionalProposalAttachmentBean.newAttachment.newFile";
    public static final String INDEXED_ATTACHMENT_TYPE_CODE = "document.institutionalProposalList[0].instProposalAttachments[%d].attachmentTypeCode";

    @Override
    public boolean processAddInstitutionalProposalAttachmentBusinessRules(InstitutionalProposalAddAttachmentRuleEvent institutionalProposalRuleEvent) {
        InstitutionalProposalAttachment proposalAttachment = institutionalProposalRuleEvent.getInstitutionalProposalAttachmentForValidation();
        boolean valid = true;
        if (proposalAttachment.getAttachmentTypeCode() == null) {
            valid = false;
            this.reportError(ATTACHMENT_TYPE_CODE, "error.institutionalProposalAttachments.attachment.typeRequired", new String[0]);
        }
        if (!this.getKcAttachmentService().doesNewFileExist(proposalAttachment.getNewFile())) {
            valid = false;
            this.reportError(NEW_FILE, "error.institutionalProposalAttachments.attachment.fileRequired", new String[0]);
        }
        return valid;
    }

    @Override
    public boolean processSaveInstitutionalProposalAttachment(InstitutionalProposalAddAttachmentRuleEvent institutionalProposalRuleEvent, int i) {
        InstitutionalProposalAttachment proposalAttachment = institutionalProposalRuleEvent.getInstitutionalProposalDocument().getInstitutionalProposal().getInstProposalAttachment(i);
        boolean valid = true;
        if (proposalAttachment.getAttachmentTypeCode() == null) {
            valid = false;
            this.reportError(String.format(INDEXED_ATTACHMENT_TYPE_CODE, i), "error.institutionalProposalAttachments.attachment.typeRequired", new String[0]);
        }
        return valid;
    }

    private KcAttachmentService getKcAttachmentService() {
        return KcServiceLocator.getService(KcAttachmentService.class);
    }
}

