/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.approve;

import java.sql.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.approve.ProtocolApproveBean;
import org.kuali.kra.irb.actions.approve.ProtocolApproveService;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericCorrespondence;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.approve.ProtocolApproveServiceImplBase;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionsCorrespondenceBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class ProtocolApproveServiceImpl
extends ProtocolApproveServiceImplBase
implements ProtocolApproveService {
    private static final String FULL_APPROVAL_FINALIZE_OLR_ANNOTATION = "Online Review finalized as part of full approval action on protocol.";
    private static final String EXPEDITED_APPROVAL_FINALIZE_OLR_ANNOTATION = "Online Review finalized as part of expedited approval action on protocol.";
    private ParameterService parameterService;

    @Override
    public void grantFullApproval(ProtocolDocumentBase protocolDocument, org.kuali.kra.protocol.actions.approve.ProtocolApproveBean actionBean) throws Exception {
        String exemptProtocolTypeCode;
        this.generateProtocolActionAndAttach(protocolDocument.getProtocol(), actionBean, "204");
        if (protocolDocument.getProtocol().getApprovalDate() == null) {
            protocolDocument.getProtocol().setApprovalDate(actionBean.getApprovalDate());
        }
        if (!protocolDocument.getProtocol().isNew()) {
            protocolDocument.getProtocol().setLastApprovalDate(actionBean.getApprovalDate());
        }
        if (!StringUtils.equals((CharSequence)(exemptProtocolTypeCode = this.parameterService.getParameterValueAsString(ProtocolDocument.class, "irb.protocol.protocoltype.exempt")), (CharSequence)protocolDocument.getProtocol().getProtocolTypeCode())) {
            protocolDocument.getProtocol().setExpirationDate(actionBean.getExpirationDate());
        }
        this.finalizeReviewsAndSave(protocolDocument, "204", FULL_APPROVAL_FINALIZE_OLR_ANNOTATION);
    }

    @Override
    public void grantExpeditedApproval(ProtocolDocumentBase protocolDocument, ProtocolApproveBean actionBean) throws Exception {
        this.generateProtocolActionAndAttach(protocolDocument.getProtocol(), actionBean, "205");
        protocolDocument.getProtocol().setApprovalDate(actionBean.getApprovalDate());
        protocolDocument.getProtocol().setExpirationDate(actionBean.getExpirationDate());
        if (!protocolDocument.getProtocol().isNew()) {
            protocolDocument.getProtocol().setLastApprovalDate(actionBean.getApprovalDate());
        }
        this.finalizeReviewsAndSave(protocolDocument, "205", EXPEDITED_APPROVAL_FINALIZE_OLR_ANNOTATION);
        protocolDocument.getDocumentHeader().getWorkflowDocument().approve(actionBean.getComments());
    }

    public void grantResponseApproval(ProtocolDocumentBase protocolDocument, ProtocolApproveBean actionBean) throws Exception {
        this.generateProtocolActionAndAttach(protocolDocument.getProtocol(), actionBean, "208");
        if (protocolDocument.getProtocol().getApprovalDate() == null) {
            protocolDocument.getProtocol().setApprovalDate(actionBean.getApprovalDate());
        }
        if (!protocolDocument.getProtocol().isNew()) {
            protocolDocument.getProtocol().setLastApprovalDate(actionBean.getApprovalDate());
        }
        protocolDocument.getProtocol().setExpirationDate(actionBean.getExpirationDate());
        this.finalizeReviewsAndSave(protocolDocument, "204", "Online Review finalized as part of response approval action on protocol.");
        protocolDocument.getDocumentHeader().getWorkflowDocument().approve(actionBean.getComments());
    }

    @Override
    public Date buildExpirationDate(ProtocolBase protocol, Date approvalDate) {
        Date expirationDate = protocol.getExpirationDate();
        if (expirationDate == null || protocol.isNew() || protocol.isRenewal()) {
            java.util.Date newExpirationDate = DateUtils.addYears((java.util.Date)approvalDate, (int)this.getDefaultExpirationDateDifference());
            newExpirationDate = DateUtils.addDays((java.util.Date)newExpirationDate, (int)-1);
            expirationDate = org.kuali.coeus.sys.framework.util.DateUtils.convertToSqlDate(newExpirationDate);
        }
        return expirationDate;
    }

    @Override
    public int getDefaultExpirationDateDifference() {
        return 1;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    protected String getProtocolActionTypeCodeForResponseApprovalHook() {
        return "208";
    }

    @Override
    protected String getProtocolActionTypeCodeForAdminApprovalHook() {
        return null;
    }

    @Override
    protected ProtocolActionBase getNewProtocolActionInstanceHook(ProtocolBase protocol, ProtocolSubmissionBase submission, String protocolActionTypeCode) {
        return new ProtocolAction((Protocol)protocol, (ProtocolSubmission)submission, protocolActionTypeCode);
    }

    @Override
    protected ProtocolActionsCorrespondenceBase getNewProtocolActionsCorrespondence(String protocolActionTypeCode) {
        return new ProtocolGenericCorrespondence(protocolActionTypeCode);
    }
}

