/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.assigncmtsched;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.assigncmtsched.ProtocolAssignCmtSchedBean;
import org.kuali.kra.irb.actions.assigncmtsched.ProtocolAssignCmtSchedService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReviewService;
import org.kuali.kra.meeting.CommitteeScheduleMinute;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProtocolAssignCmtSchedServiceImpl
implements ProtocolAssignCmtSchedService {
    private static final String NEXT_ACTION_ID_KEY = "actionId";
    private BusinessObjectService businessObjectService;
    private CommitteeService committeeService;
    private ProtocolOnlineReviewService protocolOnlineReviewService;

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setCommitteeService(CommitteeService committeeService) {
        this.committeeService = committeeService;
    }

    public void setProtocolOnlineReviewService(ProtocolOnlineReviewService protocolOnlineReviewService) {
        this.protocolOnlineReviewService = protocolOnlineReviewService;
    }

    @Override
    public String getAssignedCommitteeId(Protocol protocol) {
        ProtocolSubmission submission = this.findSubmissionIncludingInAgenda(protocol);
        if (submission != null && (StringUtils.equals((CharSequence)submission.getSubmissionStatusCode(), (CharSequence)"100") || StringUtils.equals((CharSequence)submission.getSubmissionStatusCode(), (CharSequence)"101") || StringUtils.equals((CharSequence)submission.getSubmissionStatusCode(), (CharSequence)"102") & StringUtils.equals((CharSequence)submission.getSubmissionTypeCode(), (CharSequence)"110"))) {
            return submission.getCommitteeId();
        }
        return null;
    }

    @Override
    public String getAssignedScheduleId(Protocol protocol) {
        ProtocolSubmission submission = this.findSubmissionIncludingInAgenda(protocol);
        if (submission != null && StringUtils.equals((CharSequence)submission.getSubmissionStatusCode(), (CharSequence)"100") || StringUtils.equals((CharSequence)submission.getSubmissionStatusCode(), (CharSequence)"101")) {
            return submission.getScheduleId();
        }
        return null;
    }

    @Override
    public void assignToCommitteeAndSchedule(Protocol protocol, ProtocolAssignCmtSchedBean actionBean) throws Exception {
        this.assignToCommitteeAndSchedule(protocol, actionBean, false);
    }

    @Override
    public void assignToCommitteeAndSchedulePostAgendaAssignment(Protocol protocol, ProtocolAssignCmtSchedBean cmtAssignBean) throws Exception {
        this.assignToCommitteeAndSchedule(protocol, cmtAssignBean, true);
    }

    private void assignToCommitteeAndSchedule(Protocol protocol, ProtocolAssignCmtSchedBean actionBean, boolean isPostAgendaAssignment) throws Exception {
        ProtocolSubmission submission = null;
        submission = isPostAgendaAssignment ? this.findSubmissionIncludingInAgenda(protocol) : this.findSubmission(protocol);
        if (submission != null) {
            this.setSchedule(submission, actionBean.getNewCommitteeId(), actionBean.getNewScheduleId());
            if (!isPostAgendaAssignment) {
                submission.setSubmissionStatusCode("100");
            }
            protocol.refreshReferenceObject("protocolStatus");
            if (actionBean.scheduleHasChanged() && this.protocolOnlineReviewService.getProtocolReviewDocumentsForCurrentSubmission(protocol).size() > 0) {
                ProtocolSubmission tmpSubmission = new ProtocolSubmission();
                tmpSubmission.setProtocolOnlineReviews(submission.getProtocolOnlineReviews());
                this.protocolOnlineReviewService.moveOnlineReviews(tmpSubmission, submission);
            }
        } else if ("109".equals(protocol.getLastProtocolAction().getFollowupActionCode())) {
            this.updateSubmission(protocol, actionBean);
            this.addNewAction(protocol, actionBean);
        }
        this.businessObjectService.save((PersistableBusinessObject)protocol);
    }

    private void updateSubmission(Protocol protocol, ProtocolAssignCmtSchedBean actionBean) {
        for (ProtocolSubmissionBase submission : protocol.getProtocolSubmissions()) {
            if (!submission.getSubmissionNumber().equals(protocol.getLastProtocolAction().getSubmissionNumber())) continue;
            this.setSchedule((ProtocolSubmission)submission, actionBean.getNewCommitteeId(), actionBean.getNewScheduleId());
            break;
        }
    }

    private void addNewAction(Protocol protocol, ProtocolAssignCmtSchedBean actionBean) {
        ProtocolAction newAction = new ProtocolAction();
        newAction.setActionId(protocol.getNextValue(NEXT_ACTION_ID_KEY));
        newAction.setActualActionDate(new Timestamp(System.currentTimeMillis()));
        newAction.setActionDate(new Timestamp(System.currentTimeMillis()));
        newAction.setProtocolActionTypeCode("109");
        ProtocolSubmission submission = protocol.getProtocolSubmission();
        if (submission != null) {
            newAction.setSubmissionIdFk(submission.getSubmissionId());
            newAction.setSubmissionNumber(submission.getSubmissionNumber());
        }
        newAction.setProtocolNumber(protocol.getProtocolNumber());
        newAction.setProtocolId(protocol.getProtocolId());
        newAction.setSequenceNumber(protocol.getSequenceNumber());
        protocol.getProtocolActions().add(newAction);
    }

    protected ProtocolSubmission findSubmission(Protocol protocol) {
        return this.findSubmission(protocol, false);
    }

    protected ProtocolSubmission findSubmissionIncludingInAgenda(Protocol protocol) {
        return this.findSubmission(protocol, true);
    }

    private ProtocolSubmission findSubmission(Protocol protocol, boolean includeInAgenda) {
        ProtocolSubmission protocolSubmission = null;
        for (ProtocolSubmissionBase submission : protocol.getProtocolSubmissions()) {
            if (!StringUtils.equals((CharSequence)submission.getSubmissionStatusCode(), (CharSequence)"102") && !StringUtils.equals((CharSequence)submission.getSubmissionStatusCode(), (CharSequence)"100") && (!includeInAgenda || !StringUtils.equals((CharSequence)submission.getSubmissionStatusCode(), (CharSequence)"101"))) continue;
            protocolSubmission = (ProtocolSubmission)submission;
        }
        return protocolSubmission;
    }

    public void setSchedule(ProtocolSubmission submission, String committeeId, String scheduleId) {
        if (!this.setCommittee(submission, committeeId)) {
            submission.setScheduleId(null);
            submission.setScheduleIdFk(null);
            submission.setCommitteeSchedule(null);
        } else {
            CommitteeSchedule schedule = (CommitteeSchedule)this.committeeService.getCommitteeSchedule(submission.getCommittee(), scheduleId);
            if (schedule == null) {
                submission.setScheduleId(null);
                submission.setScheduleIdFk(null);
                submission.setCommitteeSchedule(null);
                this.updateDefaultSchedule(submission);
            } else {
                submission.setScheduleId(schedule.getScheduleId());
                submission.setScheduleIdFk(schedule.getId());
                submission.setCommitteeSchedule(schedule);
                this.updateDefaultSchedule(submission);
            }
        }
    }

    protected void updateDefaultSchedule(ProtocolSubmission submission) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("protocolIdFk", submission.getProtocolId().toString());
        List minutes = (List)this.businessObjectService.findMatching(CommitteeScheduleMinute.class, fieldValues);
        if (!minutes.isEmpty()) {
            for (CommitteeScheduleMinute minute : minutes) {
                if (submission.getScheduleIdFk() == null) {
                    minute.setScheduleIdFk(CommitteeSchedule.DEFAULT_SCHEDULE_ID);
                    continue;
                }
                minute.setScheduleIdFk(submission.getScheduleIdFk());
            }
            this.businessObjectService.save(minutes);
        }
    }

    public boolean setCommittee(ProtocolSubmission submission, String committeeId) {
        Committee committee = (Committee)this.committeeService.getCommitteeById(committeeId);
        if (committee == null) {
            submission.setCommitteeId(null);
            submission.setCommitteeIdFk(null);
            submission.setCommittee(null);
            return false;
        }
        submission.setCommitteeId(committee.getCommitteeId());
        submission.setCommitteeIdFk(committee.getId());
        submission.setCommittee(committee);
        return true;
    }
}

