/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.submit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.IrbActionsKeyValuesBase;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.actions.submit.ProtocolSubmissionType;
import org.kuali.kra.protocol.ProtocolSpecialVersion;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;

public class SubmissionTypeValuesFinder
extends IrbActionsKeyValuesBase {
    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add(ValuesFinderUtils.getSelectOption());
        Collection submissionTypes = this.getKeyValuesService().findAll(ProtocolSubmissionType.class);
        for (ProtocolSubmissionType submissionType : submissionTypes) {
            if (!this.isSubmitForReviewType(submissionType)) continue;
            keyValues.add((KeyValue)new ConcreteKeyValue(submissionType.getSubmissionTypeCode(), submissionType.getDescription()));
        }
        return keyValues;
    }

    private boolean isSubmitForReviewType(ProtocolSubmissionType submissionType) {
        Collection<String> typeCodes = this.getValidSubmissionTypes();
        for (String typeCode : typeCodes) {
            if (!StringUtils.equals((CharSequence)typeCode, (CharSequence)submissionType.getSubmissionTypeCode())) continue;
            return true;
        }
        return false;
    }

    private Collection<String> getValidSubmissionTypes() {
        ArrayList<String> types = new ArrayList<String>();
        ProtocolDocument pd = (ProtocolDocument)this.getDocument();
        if (pd != null) {
            String currentStatus = pd.getProtocol().getProtocolStatusCode();
            if (this.displayInitialSubmission(currentStatus)) {
                types.add("100");
            }
            if (this.displayAmendment(currentStatus, pd.getProtocol())) {
                types.add("102");
            }
            if (this.displayContinuation(currentStatus, pd.getProtocol())) {
                types.add("101");
            }
            if (this.displayContinuationWithAmendment(currentStatus, pd.getProtocol())) {
                types.add("115");
            }
            if (this.displayResponseToPrevIRBNotication(currentStatus)) {
                types.add("103");
            }
            if (this.displayResubmission(currentStatus)) {
                types.add("116");
            }
            if (this.displayRequestForSuspension(currentStatus, pd.getProtocol())) {
                Collection submissionTypes = this.getKeyValuesService().findAll(ProtocolSubmissionType.class);
                for (ProtocolSubmissionType submissionType : submissionTypes) {
                    types.add(submissionType.getSubmissionTypeCode());
                }
            }
            if (this.displayNotifyIrb(currentStatus, pd.getProtocol())) {
                types.add("112");
            }
        }
        return types;
    }

    private boolean displayInitialSubmission(String currentStatus) {
        String[] validStatuses = new String[]{"100", "304", "101", "402"};
        return this.validateCurrentStatus(currentStatus, validStatuses);
    }

    private boolean displayResponseToPrevIRBNotication(String currentStatus) {
        String[] validStatuses = new String[]{"102", "104", "103", "101"};
        return this.validateCurrentStatus(currentStatus, validStatuses);
    }

    private boolean displayAmendment(String currentStatus, Protocol protocol) {
        String[] validStatuses = new String[]{"304", "105", "101"};
        return this.validateCurrentStatus(currentStatus, validStatuses) && this.hasAmmendmentProtocolNumber(protocol.getProtocolNumber());
    }

    private boolean displayContinuation(String currentStatus, Protocol protocol) {
        String[] validStatuses = new String[]{"304", "106", "101"};
        return this.validateCurrentStatus(currentStatus, validStatuses) && this.hasRenewalProtocolNumber(protocol.getProtocolNumber());
    }

    private boolean displayContinuationWithAmendment(String currentStatus, Protocol protocol) {
        String[] validStatuses = new String[]{"304", "106", "101"};
        return this.validateCurrentStatus(currentStatus, validStatuses) && this.hasRenewalProtocolNumber(protocol.getProtocolNumber());
    }

    protected boolean displayRequestForSuspension(String currentStatus, Protocol protocol) {
        String[] validStatuses = new String[]{"200"};
        return this.validateCurrentStatus(currentStatus, validStatuses) && this.wasRequestForSuspension(protocol.getProtocolSubmission());
    }

    private boolean hasAmmendmentProtocolNumber(String protocolNumber) {
        return protocolNumber.contains(ProtocolSpecialVersion.AMENDMENT.getCode());
    }

    private boolean hasRenewalProtocolNumber(String protocolNumber) {
        return protocolNumber.contains(ProtocolSpecialVersion.RENEWAL.getCode());
    }

    private boolean hasFyiProtocolNumber(String protocolNumber) {
        return protocolNumber.contains(ProtocolSpecialVersion.FYI.getCode());
    }

    private boolean displayResubmission(String currentStatus) {
        String[] validStatuses = new String[]{"304", "101", "107"};
        return this.validateCurrentStatus(currentStatus, validStatuses);
    }

    protected boolean displayNotifyIrb(String currentStatus, Protocol protocol) {
        boolean useAlternateNotifyIrbAction = this.getParameterService().getParameterValueAsBoolean(ProtocolDocument.class, "ALTERNATE_NOTIFY_IRB_ACTION_PARAM", Boolean.valueOf(false));
        if (useAlternateNotifyIrbAction) {
            String[] validStatuses = new String[]{"304", "900", "101"};
            return this.validateCurrentStatus(currentStatus, validStatuses) && this.hasFyiProtocolNumber(protocol.getProtocolNumber());
        }
        String[] validStatuses = new String[]{"200"};
        String[] validSumissionStatuses = new String[]{"100"};
        String currentSubmissionStatus = protocol.getProtocolSubmission().getSubmissionStatusCode();
        return this.validateCurrentStatus(currentStatus, validStatuses) && this.validateCurrentSubmissionStatus(currentSubmissionStatus, validSumissionStatuses);
    }

    private boolean validateCurrentStatus(String currentStatus, String[] validStatuses) {
        for (String status : validStatuses) {
            if (!StringUtils.equals((CharSequence)currentStatus, (CharSequence)status)) continue;
            return true;
        }
        return false;
    }

    protected boolean validateCurrentSubmissionStatus(String currentSubmissionStatus, String[] validSubmissionStatuses) {
        for (String status : validSubmissionStatuses) {
            if (!StringUtils.equals((CharSequence)currentSubmissionStatus, (CharSequence)status)) continue;
            return true;
        }
        return false;
    }

    private boolean wasRequestForSuspension(ProtocolSubmission protocolSubmission) {
        return "110".equals(protocolSubmission.getSubmissionTypeCode());
    }
}

