/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.undo;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolSpecialVersion;
import org.kuali.kra.protocol.actions.ProtocolActionBase;

public abstract class UndoLastActionBeanHelperBase
implements Serializable {
    protected static final String AMEND_COMMENT = ProtocolSpecialVersion.AMENDMENT.getDescription() + "-";
    protected static final String RENEW_COMMENT = ProtocolSpecialVersion.RENEWAL.getDescription() + "-";
    protected static final String FYI_COMMENT = ProtocolSpecialVersion.FYI.getDescription() + "-";

    protected abstract String[] getNotUndoableActions();

    protected abstract String getApprovedActionTypeCodeHook();

    protected abstract String getDeletedProtocolStatusHook();

    public boolean canUndoLastAction(ProtocolBase protocol) {
        ProtocolActionBase action = this.getLastPerformedAction(protocol.getProtocolActions());
        if (!(action == null || !StringUtils.isBlank((CharSequence)action.getComments()) && action.getProtocolActionTypeCode().equals(this.getApprovedActionTypeCodeHook()) && (action.getComments().startsWith(RENEW_COMMENT) || action.getComments().startsWith(AMEND_COMMENT) || action.getComments().startsWith(FYI_COMMENT)))) {
            return this.isActionUndoable(action.getProtocolActionTypeCode()) || this.isActionProtocolApproval(action, action.getProtocolNumber()) || this.isProtocolDeleted(protocol);
        }
        return false;
    }

    public ProtocolActionBase getLastPerformedAction(List<ProtocolActionBase> actionsPerformed) {
        this.sortActions(actionsPerformed);
        return actionsPerformed.size() > 0 ? actionsPerformed.get(0) : null;
    }

    protected boolean isActionUndoable(String actionTypeCode) {
        for (int i = 0; i < this.getNotUndoableActions().length; ++i) {
            if (!actionTypeCode.equalsIgnoreCase(this.getNotUndoableActions()[i])) continue;
            return false;
        }
        return true;
    }

    protected void sortActions(List<ProtocolActionBase> actionsPerformed) {
        Collections.sort(actionsPerformed, new Comparator<ProtocolActionBase>(){

            @Override
            public int compare(ProtocolActionBase action1, ProtocolActionBase action2) {
                return action2.getActualActionDate().compareTo(action1.getActualActionDate());
            }
        });
    }

    protected boolean isActionProtocolApproval(ProtocolActionBase action, String protocolNumber) {
        String protocolNumberUpper = protocolNumber.toUpperCase();
        boolean amendmentOrRenewal = protocolNumberUpper.contains(ProtocolSpecialVersion.AMENDMENT.getCode()) || protocolNumberUpper.contains(ProtocolSpecialVersion.RENEWAL.getCode()) || protocolNumberUpper.contains(ProtocolSpecialVersion.FYI.getCode());
        return this.getApprovedActionTypeCodeHook().equals(action.getProtocolActionTypeCode()) && !amendmentOrRenewal;
    }

    protected boolean isProtocolDeleted(ProtocolBase protocol) {
        return this.getDeletedProtocolStatusHook().equals(protocol.getProtocolStatusCode());
    }
}

