/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.questionnaire;

import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.common.questionnaire.framework.answer.Answer;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.ModuleQuestionnaireBean;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFinderDao;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewModuleBase;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.kra.protocol.questionnaire.ProtocolModuleQuestionnaireBeanBase;

public abstract class QuestionnaireHelperBase
extends org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireHelperBase {
    private static final long serialVersionUID = 3436562040789756688L;
    private ProtocolFormBase form;
    private String protocolNumber;
    private List<AnswerHeader> printAnswerHeaders;
    private List<String> printHeaderLabels;

    public QuestionnaireHelperBase(ProtocolFormBase form) {
        this.form = form;
    }

    public void prepareView() {
        this.initializePermissions(this.getProtocol());
    }

    private void initializePermissions(ProtocolBase protocol) {
        ProtocolTaskBase task = this.getModifyQnnrTaskHook(protocol);
        this.setAnswerQuestionnaire(this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task));
    }

    protected abstract ProtocolTaskBase getModifyQnnrTaskHook(ProtocolBase var1);

    @Override
    public abstract String getModuleCode();

    @Override
    public ModuleQuestionnaireBean getModuleQnBean() {
        ProtocolModuleQuestionnaireBeanBase moduleQuestionnaireBean = this.getProtocolModuleQuestionnaireBeanHook(this.getProtocol());
        return moduleQuestionnaireBean;
    }

    protected abstract ProtocolModuleQuestionnaireBeanBase getProtocolModuleQuestionnaireBeanHook(ProtocolBase var1);

    @Override
    public void populateAnswers() {
        if (this.isAmendQuestionnaire()) {
            super.populateAnswers();
            List<Object> answerHeaders = new ArrayList();
            ModuleQuestionnaireBean moduleBean = this.getAmendModuleBean();
            answerHeaders = this.getQuestionnaireAnswerService().getQuestionnaireAnswer(moduleBean);
            if (!answerHeaders.isEmpty() && ((AnswerHeader)answerHeaders.get(0)).getId() == null) {
                answerHeaders = new ArrayList();
            }
            if (answerHeaders.isEmpty()) {
                answerHeaders = this.getAnswerHeadersForCurrentProtocol(moduleBean);
            }
            if (!answerHeaders.isEmpty()) {
                for (AnswerHeader answerHeader : answerHeaders) {
                    this.getAnswerHeaders().add(answerHeader);
                }
                this.resetHeaderLabels();
            }
        } else {
            super.populateAnswers();
        }
        this.setQuestionnaireActiveStatuses();
    }

    private ModuleQuestionnaireBean getAmendModuleBean() {
        ModuleQuestionnaireBean moduleBean = this.getModuleQnBean();
        moduleBean.setModuleSubItemCode("0");
        return moduleBean;
    }

    @Override
    public void updateQuestionnaireAnswer(int answerHeaderIndex) {
        AnswerHeader answerHeader = this.getAnswerHeaders().get(answerHeaderIndex);
        if (this.isAmendQuestionnaire() && "0".equals(answerHeader.getModuleSubItemCode())) {
            ModuleQuestionnaireBean moduleBean = this.getAmendModuleBean();
            if ("1".equals(answerHeader.getUpdateOption())) {
                this.getAnswerHeaders().remove(answerHeaderIndex);
                this.getAnswerHeaders().add(answerHeaderIndex, this.getQuestionnaireAnswerService().getNewVersionAnswerHeader(moduleBean, answerHeader.getQuestionnaire()));
            } else {
                AnswerHeader newAnswerHeader = this.getQuestionnaireAnswerService().getNewVersionAnswerHeader(moduleBean, answerHeader.getQuestionnaire());
                this.getQuestionnaireAnswerService().copyAnswerToNewVersion(answerHeader, newAnswerHeader);
                this.getAnswerHeaders().remove(answerHeaderIndex);
                this.getAnswerHeaders().add(answerHeaderIndex, newAnswerHeader);
            }
            this.resetHeaderLabels();
        } else {
            super.updateQuestionnaireAnswer(answerHeaderIndex);
        }
    }

    private List<AnswerHeader> getAnswerHeadersForCurrentProtocol(ModuleQuestionnaireBean moduleBean) {
        ProtocolBase currentProtocol = this.getProtocolFinder().findCurrentProtocolByNumber(this.getProtocol().getProtocolNumber().substring(0, 10));
        moduleBean.setModuleItemKey(currentProtocol.getProtocolNumber());
        moduleBean.setModuleSubItemKey(currentProtocol.getSequenceNumber().toString());
        List<AnswerHeader> answerHeaders = this.getQuestionnaireAnswerService().getQuestionnaireAnswer(moduleBean);
        if (!answerHeaders.isEmpty()) {
            ProtocolBase protocol = this.getProtocol();
            for (AnswerHeader answerHeader : answerHeaders) {
                for (Answer answer : answerHeader.getAnswers()) {
                    answer.setAnswerHeaderId(null);
                    answer.setId(null);
                }
                answerHeader.setId(null);
                answerHeader.setModuleItemKey(protocol.getProtocolNumber());
                answerHeader.setModuleSubItemKey(protocol.getSequenceNumber().toString());
            }
        }
        return answerHeaders;
    }

    private ProtocolFinderDao getProtocolFinder() {
        return KcServiceLocator.getService(this.getProtocolFinderDaoClassHook());
    }

    protected abstract Class<? extends ProtocolFinderDao> getProtocolFinderDaoClassHook();

    private boolean isAmendQuestionnaire() {
        ProtocolBase protocol = this.getProtocol();
        boolean isAmendQuestionnaire = false;
        if (protocol.isAmendment() || protocol.isRenewal()) {
            for (ProtocolAmendRenewModuleBase module : protocol.getProtocolAmendRenewal().getModules()) {
                if (!this.getProtocolModuleCodeForQuestionnaireHook().equals(module.getProtocolModuleTypeCode())) continue;
                isAmendQuestionnaire = true;
                break;
            }
        }
        return isAmendQuestionnaire;
    }

    protected abstract String getProtocolModuleCodeForQuestionnaireHook();

    private ProtocolBase getProtocol() {
        ProtocolDocumentBase document = this.form.getProtocolDocument();
        if (document == null || document.getProtocol() == null) {
            throw new IllegalArgumentException("invalid (null) ProtocolDocumentBase in ProtocolFormBase");
        }
        return document.getProtocol();
    }

    public String getProtocolNumber() {
        return this.protocolNumber;
    }

    public void setProtocolNumber(String protocolNumber) {
        this.protocolNumber = protocolNumber;
    }

    private boolean isAmendmentOrRenewal() {
        boolean isAmendmentOrRenewal = false;
        ProtocolBase protocol = this.getProtocol();
        if (protocol.isAmendment() || protocol.isRenewal()) {
            isAmendmentOrRenewal = true;
        }
        return isAmendmentOrRenewal;
    }

    public List<AnswerHeader> getPrintAnswerHeaders() {
        return this.printAnswerHeaders;
    }

    public void setPrintAnswerHeaders(List<AnswerHeader> printAnswerHeaders) {
        this.printAnswerHeaders = printAnswerHeaders;
    }

    public List<String> getPrintHeaderLabels() {
        return this.printHeaderLabels;
    }

    public void setPrintHeaderLabels(List<String> printHeaderLabels) {
        this.printHeaderLabels = printHeaderLabels;
    }

    public void resetPrintHeaderLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        for (AnswerHeader printAnswerHeader : this.printAnswerHeaders) {
            labels.add(this.getQuestionnaireLabel(printAnswerHeader.getQuestionnaire().getQuestionnaireUsages(), printAnswerHeader.getModuleSubItemCode()));
        }
        this.setPrintHeaderLabels(labels);
    }

    public void populatePrintAnswers() {
        if (this.isAmendmentOrRenewal()) {
            this.setPrintAnswerHeaders(this.getQuestionnaireAnswerService().getQuestionnaireAnswer(this.getModuleQnBean()));
            this.resetPrintHeaderLabels();
            List<Object> printAnswerHeaders = new ArrayList();
            ModuleQuestionnaireBean moduleBean = this.getAmendModuleBean();
            printAnswerHeaders = this.getQuestionnaireAnswerService().getQuestionnaireAnswer(moduleBean);
            if (!printAnswerHeaders.isEmpty() && ((AnswerHeader)printAnswerHeaders.get(0)).getId() == null) {
                printAnswerHeaders = new ArrayList();
            }
            if (printAnswerHeaders.isEmpty()) {
                printAnswerHeaders = this.getAnswerHeadersForCurrentProtocol(moduleBean);
            }
            if (!printAnswerHeaders.isEmpty()) {
                for (AnswerHeader answerHeader : printAnswerHeaders) {
                    this.getPrintAnswerHeaders().add(answerHeader);
                }
                this.resetPrintHeaderLabels();
            }
        } else {
            this.setPrintAnswerHeaders(this.getQuestionnaireAnswerService().getQuestionnaireAnswer(this.getModuleQnBean()));
            this.resetPrintHeaderLabels();
        }
        this.setPrintQuestionnaireActiveStatuses();
    }

    public void setPrintQuestionnaireActiveStatuses() {
        for (AnswerHeader printAnswerHeader : this.printAnswerHeaders) {
            if (this.isQuestionnaireActive(printAnswerHeader)) {
                printAnswerHeader.setActiveQuestionnaire(true);
                continue;
            }
            printAnswerHeader.setActiveQuestionnaire(false);
        }
    }
}

