/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.identity.name;

import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kim.api.identity.name.EntityName;
import org.kuali.rice.kim.api.identity.name.EntityNameContract;
import org.kuali.rice.kim.impl.identity.name.EntityNameBase;
import org.kuali.rice.kim.impl.identity.name.EntityNameTypeBo;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Cacheable(value=false)
@Table(name="KRIM_ENTITY_NM_T")
@NamedQuery(name="EntityNameBo.findDefaultNamesForPrincipalIds", query="SELECT NEW org.kuali.rice.kim.impl.identity.IdentityServiceDaoJpa.NameHolder(en, p.principalId, p.principalName, pp.suppressName) FROM EntityNameBo en, PrincipalBo p LEFT JOIN EntityPrivacyPreferencesBo pp ON pp.entityId = p.entityId WHERE en.active = true AND en.defaultValue = true AND en.entityId = p.entityId AND p.principalId IN :principalIds")
public class EntityNameBo
extends EntityNameBase
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = -1449221117942310530L;
    @PortableSequenceGenerator(name="KRIM_ENTITY_NM_ID_S")
    @GeneratedValue(generator="KRIM_ENTITY_NM_ID_S")
    @Id
    @Column(name="ENTITY_NM_ID")
    private String id;
    @JoinFetch(value=JoinFetchType.OUTER)
    @ManyToOne(targetEntity=EntityNameTypeBo.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="NM_TYP_CD", referencedColumnName="ENT_NM_TYP_CD", insertable=false, updatable=false)
    private EntityNameTypeBo nameType;

    public static EntityName to(EntityNameBo bo) {
        if (bo == null) {
            return null;
        }
        return EntityName.Builder.create((EntityNameContract)bo).build();
    }

    public static EntityNameBo from(EntityName immutable) {
        if (immutable == null) {
            return null;
        }
        EntityNameBo bo = new EntityNameBo();
        bo.setId(immutable.getId());
        bo.setActive(immutable.isActive());
        bo.setEntityId(immutable.getEntityId());
        bo.setNameType(EntityNameTypeBo.from(immutable.getNameType()));
        if (immutable.getNameType() != null) {
            bo.setNameCode(immutable.getNameType().getCode());
        }
        bo.setFirstName(immutable.getFirstNameUnmasked());
        bo.setLastName(immutable.getLastNameUnmasked());
        bo.setMiddleName(immutable.getMiddleNameUnmasked());
        bo.setNamePrefix(immutable.getNamePrefixUnmasked());
        bo.setNameTitle(immutable.getNameTitleUnmasked());
        bo.setNameSuffix(immutable.getNameSuffixUnmasked());
        bo.setNoteMessage(immutable.getNoteMessage());
        bo.setNameChangedDate(immutable.getNameChangedDate());
        bo.setDefaultValue(immutable.isDefaultValue());
        bo.setVersionNumber(immutable.getVersionNumber());
        bo.setObjectId(immutable.getObjectId());
        return bo;
    }

    public EntityNameTypeBo getNameType() {
        return this._persistence_get_nameType();
    }

    public void setNameType(EntityNameTypeBo nameType) {
        this._persistence_set_nameType(nameType);
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new EntityNameBo();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "nameType") {
            return this.nameType;
        }
        if (string == "id") {
            return this.id;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "nameType") {
            this.nameType = (EntityNameTypeBo)((Object)object);
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public EntityNameTypeBo _persistence_get_nameType() {
        this._persistence_checkFetched("nameType");
        return this.nameType;
    }

    public void _persistence_set_nameType(EntityNameTypeBo entityNameTypeBo) {
        this._persistence_checkFetchedForSet("nameType");
        this._persistence_propertyChange("nameType", (Object)this.nameType, (Object)entityNameTypeBo);
        this.nameType = entityNameTypeBo;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }
}

