/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.data;

import java.util.Calendar;
import java.util.Date;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.data.Plottable;

public class CubicSplineInterpolator
extends Plottable {
    private double[] x;
    private double[] y;
    private double[] y2;
    private int n;
    private int klo;
    private int khi;

    public CubicSplineInterpolator(long[] timestamps, double[] values) throws RrdException {
        this.x = new double[timestamps.length];
        int i = 0;
        while (i < timestamps.length) {
            this.x[i] = timestamps[i];
            ++i;
        }
        this.y = values;
        this.validate();
        this.spline();
    }

    public CubicSplineInterpolator(Date[] dates, double[] values) throws RrdException {
        this.x = new double[dates.length];
        int i = 0;
        while (i < dates.length) {
            this.x[i] = Util.getTimestamp(dates[i]);
            ++i;
        }
        this.y = values;
        this.validate();
        this.spline();
    }

    public CubicSplineInterpolator(Calendar[] dates, double[] values) throws RrdException {
        this.x = new double[dates.length];
        int i = 0;
        while (i < dates.length) {
            this.x[i] = Util.getTimestamp(dates[i]);
            ++i;
        }
        this.y = values;
        this.validate();
        this.spline();
    }

    public CubicSplineInterpolator(double[] x, double[] y) throws RrdException {
        this.x = x;
        this.y = y;
        this.validate();
        this.spline();
    }

    private void validate() throws RrdException {
        boolean ok = true;
        if (this.x.length != this.y.length || this.x.length < 3) {
            ok = false;
        }
        int i = 0;
        while (i < this.x.length - 1 && ok) {
            if (this.x[i] >= this.x[i + 1] || Double.isNaN(this.y[i])) {
                ok = false;
            }
            ++i;
        }
        if (!ok) {
            throw new RrdException("Invalid plottable data supplied");
        }
    }

    private void spline() {
        this.n = this.x.length;
        this.y2 = new double[this.n];
        double[] u = new double[this.n - 1];
        this.y2[this.n - 1] = 0.0;
        this.y2[0] = 0.0;
        u[0] = 0.0;
        int i = 1;
        while (i <= this.n - 2) {
            double sig = (this.x[i] - this.x[i - 1]) / (this.x[i + 1] - this.x[i - 1]);
            double p = sig * this.y2[i - 1] + 2.0;
            this.y2[i] = (sig - 1.0) / p;
            u[i] = (this.y[i + 1] - this.y[i]) / (this.x[i + 1] - this.x[i]) - (this.y[i] - this.y[i - 1]) / (this.x[i] - this.x[i - 1]);
            u[i] = (6.0 * u[i] / (this.x[i + 1] - this.x[i - 1]) - sig * u[i - 1]) / p;
            ++i;
        }
        int k = this.n - 2;
        while (k >= 0) {
            this.y2[k] = this.y2[k] * this.y2[k + 1] + u[k];
            --k;
        }
        this.klo = 0;
        this.khi = this.n - 1;
    }

    public double getValue(double xval) {
        if (xval < this.x[0] || xval > this.x[this.n - 1]) {
            return Double.NaN;
        }
        if (xval < this.x[this.klo] || xval > this.x[this.khi]) {
            this.klo = 0;
            this.khi = this.n - 1;
        }
        while (this.khi - this.klo > 1) {
            int k = (this.khi + this.klo) / 2;
            if (this.x[k] > xval) {
                this.khi = k;
                continue;
            }
            this.klo = k;
        }
        double h = this.x[this.khi] - this.x[this.klo];
        double a = (this.x[this.khi] - xval) / h;
        double b = (xval - this.x[this.klo]) / h;
        return a * this.y[this.klo] + b * this.y[this.khi] + ((a * a * a - a) * this.y2[this.klo] + (b * b * b - b) * this.y2[this.khi]) * (h * h) / 6.0;
    }

    public double getValue(long timestamp) {
        return this.getValue((double)timestamp);
    }
}

