/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.data.metadata.DataObjectAttribute;
import org.kuali.rice.krad.datadictionary.DataDictionaryDefinitionBase;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validation.capability.ExistenceConstrainable;
import org.kuali.rice.krad.datadictionary.validation.capability.SimpleConstrainable;
import org.kuali.rice.krad.datadictionary.validation.constraint.SimpleConstraint;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

public abstract class AttributeDefinitionBase
extends DataDictionaryDefinitionBase
implements ExistenceConstrainable,
SimpleConstrainable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String label;
    protected String shortLabel;
    protected String displayLabelAttribute;
    protected String constraintText;
    protected String summary;
    protected String description;
    protected SimpleConstraint simpleConstraint = new SimpleConstraint();
    protected DataObjectAttribute dataObjectAttribute;

    @Override
    @BeanTagAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("invalid (blank) name");
        }
        this.name = name;
    }

    @BeanTagAttribute(name="label")
    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        if (this.getDataObjectAttribute() != null) {
            return this.getDataObjectAttribute().getLabel();
        }
        if (GlobalResourceLoader.isInitialized() && KRADServiceLocatorWeb.getUifDefaultingService() != null) {
            return KRADServiceLocatorWeb.getUifDefaultingService().deriveHumanFriendlyNameFromPropertyName(this.getName());
        }
        return this.getName();
    }

    public void setLabel(String label) {
        if (StringUtils.isBlank((String)label)) {
            throw new IllegalArgumentException("invalid (blank) label");
        }
        this.label = label;
    }

    @BeanTagAttribute(name="shortLabel")
    public String getShortLabel() {
        if (this.shortLabel != null) {
            return this.shortLabel;
        }
        if (this.getDataObjectAttribute() != null) {
            if (StringUtils.equals((String)this.getDataObjectAttribute().getLabel(), (String)this.getDataObjectAttribute().getShortLabel()) && this.label != null) {
                return this.getLabel();
            }
            return this.getDataObjectAttribute().getShortLabel();
        }
        return this.getLabel();
    }

    protected String getDirectShortLabel() {
        if (this.shortLabel != null) {
            return this.shortLabel;
        }
        if (this.getDataObjectAttribute() != null) {
            return this.getDataObjectAttribute().getShortLabel();
        }
        return "";
    }

    public void setShortLabel(String shortLabel) {
        if (StringUtils.isBlank((String)shortLabel)) {
            throw new IllegalArgumentException("invalid (blank) shortLabel");
        }
        this.shortLabel = shortLabel;
    }

    @BeanTagAttribute(name="constraintText")
    public String getConstraintText() {
        return this.constraintText;
    }

    public void setConstraintText(String constraintText) {
        this.constraintText = constraintText;
    }

    @BeanTagAttribute(name="summary")
    public String getSummary() {
        if (this.summary != null) {
            return this.summary;
        }
        return "";
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    @BeanTagAttribute(name="description")
    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        if (this.getDataObjectAttribute() != null) {
            return this.getDataObjectAttribute().getDescription();
        }
        return "";
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDisplayLabelAttribute() {
        if (this.displayLabelAttribute != null) {
            return this.displayLabelAttribute;
        }
        if (this.getDataObjectAttribute() != null) {
            return this.getDataObjectAttribute().getDisplayAttributeName();
        }
        return null;
    }

    public void setDisplayLabelAttribute(String displayLabelAttribute) {
        this.displayLabelAttribute = displayLabelAttribute;
    }

    @Override
    public SimpleConstraint getSimpleConstraint() {
        return this.simpleConstraint;
    }

    public void setSimpleConstraint(SimpleConstraint simpleConstraint) {
        this.simpleConstraint = simpleConstraint;
    }

    public void setRequired(Boolean required) {
        this.simpleConstraint.setRequired(required);
    }

    @Override
    @BeanTagAttribute(name="required")
    public Boolean isRequired() {
        if (this.simpleConstraint.isRequired() != null) {
            return this.simpleConstraint.isRequired();
        }
        if (this.getDataObjectAttribute() != null) {
            return this.getDataObjectAttribute().isRequired();
        }
        return Boolean.FALSE;
    }

    public DataObjectAttribute getDataObjectAttribute() {
        return this.dataObjectAttribute;
    }

    public void setDataObjectAttribute(DataObjectAttribute dataObjectAttribute) {
        this.dataObjectAttribute = dataObjectAttribute;
    }
}

