/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.DataDictionaryDefinitionBase;
import org.kuali.rice.krad.datadictionary.DataDictionaryPropertyUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;

@BeanTag(name="referenceDefinition")
public class ReferenceDefinition
extends DataDictionaryDefinitionBase {
    private static final long serialVersionUID = 1737968024207302931L;
    protected String attributeName;
    protected String attributeToHighlightOnFail;
    protected String displayFieldName;
    protected String collection;
    protected Class<?> collectionBusinessObjectClass;
    protected Class<?> businessObjectClass;

    @BeanTagAttribute(name="attributeName")
    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        if (StringUtils.isBlank((String)attributeName)) {
            throw new IllegalArgumentException("invalid (blank) attributeName");
        }
        this.attributeName = attributeName;
    }

    @BeanTagAttribute(name="attributeToHighlightOnFail")
    public String getAttributeToHighlightOnFail() {
        return this.attributeToHighlightOnFail;
    }

    public void setAttributeToHighlightOnFail(String attributeToHighlightOnFail) {
        if (StringUtils.isBlank((String)attributeToHighlightOnFail)) {
            throw new IllegalArgumentException("invalid (blank) attributeToHighlightOnFail");
        }
        this.attributeToHighlightOnFail = attributeToHighlightOnFail;
    }

    @BeanTagAttribute(name="displayFieldName")
    public String getDisplayFieldName() {
        return this.displayFieldName;
    }

    public void setDisplayFieldName(String displayFieldName) {
        this.displayFieldName = displayFieldName;
    }

    public boolean isDisplayFieldNameSet() {
        return StringUtils.isNotBlank((String)this.displayFieldName);
    }

    @BeanTagAttribute(name="collection")
    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public boolean isCollectionReference() {
        return StringUtils.isNotBlank((String)this.getCollection());
    }

    @BeanTagAttribute(name="collectionBusinessObjectClass")
    public Class<?> getCollectionBusinessObjectClass() {
        return this.collectionBusinessObjectClass;
    }

    public void setCollectionBusinessObjectClass(Class<?> collectionBusinessObjectClass) {
        this.collectionBusinessObjectClass = collectionBusinessObjectClass;
    }

    @Override
    public void dataDictionaryPostProcessing() {
        super.dataDictionaryPostProcessing();
        if (this.collectionBusinessObjectClass == null && this.isCollectionReference()) {
            this.collectionBusinessObjectClass = DataDictionaryPropertyUtils.getCollectionElementClass(this.businessObjectClass, this.collection);
        }
    }

    @Override
    public void completeValidation(Class<?> rootBusinessObjectClass, Class<?> otherBusinessObjectClass, ValidationTrace tracer) {
        String[] currentValues;
        String tmpAttributeName;
        String string = tmpAttributeName = this.isCollectionReference() ? this.collection : this.attributeName;
        if (!DataDictionaryPropertyUtils.isPropertyOf(rootBusinessObjectClass, tmpAttributeName)) {
            currentValues = new String[]{"rootBusinessObjectClass = " + rootBusinessObjectClass.getName(), "attribute = " + tmpAttributeName};
            tracer.createError("ReferenceDefinition attribute does not exist on parent object", currentValues);
        }
        if (this.isCollectionReference()) {
            if (this.collectionBusinessObjectClass == null) {
                currentValues = new String[]{"rootBusinessObjectClass = " + rootBusinessObjectClass.getName(), "attribute = " + tmpAttributeName};
                tracer.createError("ReferenceDefinition: Unable to determine BO class for collection", currentValues);
            } else if (!DataDictionaryPropertyUtils.isPropertyOf(this.collectionBusinessObjectClass, this.attributeToHighlightOnFail)) {
                currentValues = new String[]{"collectionBusinessObjectClass = " + this.collectionBusinessObjectClass.getName(), "attributeToHighlightOnFail = " + this.attributeToHighlightOnFail};
                tracer.createError("ReferenceDefinition: attributeToHighlightOnFail does not exist on collection class", currentValues);
            }
        } else if (!DataDictionaryPropertyUtils.isPropertyOf(rootBusinessObjectClass, this.attributeToHighlightOnFail)) {
            currentValues = new String[]{"rootBusinessObjectClass = " + rootBusinessObjectClass.getName(), "attributeToHighlightOnFail = " + this.attributeToHighlightOnFail};
            tracer.createError("ReferenceDefinition: attributeToHighlightOnFail does not exist on parent class", currentValues);
        }
    }

    @BeanTagAttribute(name="businessObjectClass")
    public Class<?> getBusinessObjectClass() {
        return this.businessObjectClass;
    }

    public void setBusinessObjectClass(Class<?> businessObjectClass) {
        this.businessObjectClass = businessObjectClass;
    }
}

