/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.rules.rule.event;

import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.rules.rule.event.RuleEventBase;

public abstract class DocumentEventBase
extends RuleEventBase
implements DocumentEvent {
    private static final Logger LOG = LogManager.getLogger(DocumentEventBase.class);
    protected Document document;

    protected DocumentEventBase(String description, String errorPathPrefix) {
        super(description, errorPathPrefix);
    }

    public DocumentEventBase(String description, String errorPathPrefix, Document document) {
        super(description, errorPathPrefix);
        this.document = document;
        LOG.debug(description);
    }

    @Override
    public final Document getDocument() {
        return this.document;
    }

    @Override
    public void validate() {
        if (this.getDocument() == null) {
            throw new IllegalArgumentException("invalid (null) event document");
        }
    }

    protected static String getDocumentId(Document document) {
        String docId = "(null document)";
        if (document != null) {
            String documentNumber = document.getDocumentNumber();
            docId = StringUtils.isBlank((String)documentNumber) ? "(blank documentNumber)" : documentNumber;
        }
        return docId;
    }
}

