/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;
import org.kuali.rice.krad.uif.modifier.ComponentModifier;

public class RunComponentModifiersTask
extends ViewLifecycleTaskBase<Component> {
    public RunComponentModifiersTask() {
        super(Component.class);
    }

    @Override
    protected void performLifecycleTask() {
        Component component = (Component)this.getElementState().getElement();
        List<ComponentModifier> componentModifiers = component.getComponentModifiers();
        if (componentModifiers == null) {
            return;
        }
        Object model = ViewLifecycle.getModel();
        String runPhase = this.getElementState().getViewPhase();
        for (ComponentModifier modifier : component.getComponentModifiers()) {
            if (!StringUtils.equals((String)modifier.getRunPhase(), (String)runPhase)) continue;
            boolean runCondition = true;
            if (StringUtils.isNotBlank((String)modifier.getRunCondition())) {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.putAll(component.getContext());
                if (context.isEmpty()) {
                    context.putAll(ViewLifecycle.getView().getContext());
                    context.put("component", component);
                }
                String conditionEvaluation = ViewLifecycle.getExpressionEvaluator().evaluateExpressionTemplate(context, modifier.getRunCondition());
                runCondition = Boolean.parseBoolean(conditionEvaluation);
            }
            if (!runCondition) continue;
            modifier.performModification(model, component);
        }
    }
}

