/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.property;

import com.codiform.moo.GetPropertyException;
import com.codiform.moo.SetPropertyException;
import com.codiform.moo.annotation.Property;
import com.codiform.moo.property.AbstractObjectProperty;
import java.lang.reflect.Field;

public class FieldProperty
extends AbstractObjectProperty {
    private Field field;

    public FieldProperty(Field field, Property annotation, String name, String expression, boolean explicit, boolean ignore) {
        super(name, annotation, expression, explicit, ignore);
        this.field = field;
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
    }

    @Override
    public Class<?> getType() {
        return this.field.getType();
    }

    @Override
    public void setValue(Object instance, Object value) {
        this.checkValue(value);
        try {
            this.field.set(instance, value);
        }
        catch (IllegalArgumentException exception) {
            throw new SetPropertyException(this.getName(), this.getType(), value, exception);
        }
        catch (IllegalAccessException exception) {
            throw new SetPropertyException(this.getName(), this.getType(), value, exception);
        }
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    @Override
    public boolean canGetValue() {
        return true;
    }

    @Override
    public Object getValue(Object instance) {
        try {
            return this.field.get(instance);
        }
        catch (IllegalArgumentException exception) {
            throw new GetPropertyException(this.getName(), this.getType(), exception);
        }
        catch (IllegalAccessException exception) {
            throw new GetPropertyException(this.getName(), this.getType(), exception);
        }
    }

    public String toString() {
        return "FieldProperty<" + this.getName() + ">";
    }
}

