<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2005 - 2019 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->


<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:ps="http://www.w3.org/2001/ProtocolSummarySchema" xmlns:qs="http://www.w3.org/2001/QuesionnaireSchema" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="'PDF'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="8.5in" page-width="11in" margin-left="1.65in" margin-right="0.79in">
				<fo:region-body margin-top="1.5in" margin-bottom="1.2in"/>
				<fo:region-before extent="1.5in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="headerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<fo:block/>
						<xsl:for-each select="$XML">
							<fo:block/>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block text-align="center" margin="0pt">
								<fo:block>
									<xsl:for-each select="ps:ProtocolSummary">
										<xsl:for-each select="ps:SchoolInfo">
											<xsl:for-each select="ps:SchoolName">
												<xsl:variable name="value-of-template">
													<xsl:apply-templates/>
												</xsl:variable>
												<xsl:choose>
													<xsl:when test="contains(string($value-of-template),'&#x2029;')">
														<fo:block font-family="Arial" font-size="12pt" font-weight="bold">
															<xsl:copy-of select="$value-of-template"/>
														</fo:block>
													</xsl:when>
													<xsl:otherwise>
														<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
															<xsl:copy-of select="$value-of-template"/>
														</fo:inline>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
								</fo:block>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block text-align="center" margin="0pt">
								<fo:block>
									<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
										<xsl:text>Protocol Summary</xsl:text>
									</fo:inline>
								</fo:block>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:block/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="proportional-column-width(1)"/>
								<xsl:for-each select="ps:ProtocolSummary">
									<fo:table-column column-width="proportional-column-width(1)"/>
								</xsl:for-each>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" text-align="left" display-align="center">
											<fo:block>
												<fo:inline>
													<xsl:text>Protocol Number:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<xsl:for-each select="ps:ProtocolSummary">
											<xsl:for-each select="ps:ProtocolDetails">
												<fo:table-cell font-family="Arial" font-size="9pt" margin-left="-185pt" padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="ps:ProtocolNumber">
															<xsl:variable name="value-of-template">
																<xsl:apply-templates/>
															</xsl:variable>
															<xsl:choose>
																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																	<fo:block>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:block>
																</xsl:when>
																<xsl:otherwise>
																	<fo:inline>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:inline>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</xsl:for-each>
										</xsl:for-each>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" text-align="left" display-align="center">
											<fo:block>
												<fo:inline>
													<xsl:text>Sequence Number:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<xsl:for-each select="ps:ProtocolSummary">
											<xsl:for-each select="ps:ProtocolDetails">
												<fo:table-cell font-family="Arial" font-size="9pt" margin-left="-185pt" padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="ps:SequenceNumber">
															<xsl:variable name="value-of-template">
																<xsl:apply-templates/>
															</xsl:variable>
															<xsl:choose>
																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																	<fo:block>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:block>
																</xsl:when>
																<xsl:otherwise>
																	<fo:inline>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:inline>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</xsl:for-each>
										</xsl:for-each>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" text-align="left" display-align="center">
											<fo:block>
												<fo:inline>
													<xsl:text>Status:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<xsl:for-each select="ps:ProtocolSummary">
											<xsl:for-each select="ps:ProtocolDetails">
												<fo:table-cell font-family="Arial" font-size="9pt" margin-left="-185pt" padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="ps:ProtocolStatusDesc">
															<xsl:variable name="value-of-template">
																<xsl:apply-templates/>
															</xsl:variable>
															<xsl:choose>
																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																	<fo:block>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:block>
																</xsl:when>
																<xsl:otherwise>
																	<fo:inline>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:inline>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</xsl:for-each>
										</xsl:for-each>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" text-align="left" display-align="center">
											<fo:block>
												<fo:inline>
													<xsl:text>Expiration Date:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<xsl:for-each select="ps:ProtocolSummary">
											<xsl:for-each select="ps:ProtocolDetails">
												<fo:table-cell font-family="Arial" font-size="9pt" margin-left="-185pt" padding="2pt" display-align="center">
													<fo:block>
														<xsl:choose>
															<xsl:when test="ps:ExpirationDate  = &quot;&quot;"/>
															<xsl:otherwise>
																<xsl:for-each select="ps:ExpirationDate">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																		<xsl:text>/</xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																		<xsl:text>/</xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																	</fo:inline>
																</xsl:for-each>
															</xsl:otherwise>
														</xsl:choose>
													</fo:block>
												</fo:table-cell>
											</xsl:for-each>
										</xsl:for-each>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" text-align="left" display-align="center">
											<fo:block>
												<fo:inline>
													<xsl:text>Last Approval Date:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<xsl:for-each select="ps:ProtocolSummary">
											<xsl:for-each select="ps:ProtocolDetails">
												<fo:table-cell font-family="Arial" font-size="9pt" margin-left="-185pt" padding="2pt" display-align="center">
													<fo:block>
														<xsl:choose>
															<xsl:when test="ps:LastApprovalDate  = &quot;&quot;"/>
															<xsl:otherwise>
																<xsl:for-each select="ps:LastApprovalDate">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																		<xsl:text>/</xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																		<xsl:text>/</xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																	</fo:inline>
																</xsl:for-each>
															</xsl:otherwise>
														</xsl:choose>
													</fo:block>
												</fo:table-cell>
											</xsl:for-each>
										</xsl:for-each>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" text-align="left" display-align="center">
											<fo:block>
												<fo:inline>
													<xsl:text>Investigator:</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<xsl:for-each select="ps:ProtocolSummary">
											<xsl:for-each select="ps:ProtocolDetails">
												<fo:table-cell font-family="Arial" font-size="9pt" margin-left="-185pt" padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="ps:Investigator">
															<xsl:variable name="value-of-template">
																<xsl:apply-templates/>
															</xsl:variable>
															<xsl:choose>
																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																	<fo:block>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:block>
																</xsl:when>
																<xsl:otherwise>
																	<fo:inline>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:inline>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</xsl:for-each>
										</xsl:for-each>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:block/>
							<xsl:if test="ps:ProtocolSummary/ps:PrintRequirement/ps:ProtocolDetailsRequired  = 1">
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table padding-top="10pt" table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="20%"/>
									<fo:table-column column-width="80%"/>
									<fo:table-column column-width="proportional-column-width(1)"/>
									<fo:table-column column-width="proportional-column-width(1)"/>
									<fo:table-body start-indent="0pt">
										<fo:table-row>
											<fo:table-cell font-family="Arial" font-size="12pt" font-weight="bold" padding="2pt" height="11" display-align="center">
												<fo:block>
													<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
														<xsl:text>Protocol Details </xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-weight="normal" padding="2pt" height="11" display-align="center">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell padding="2pt" height="11" display-align="center">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell padding="2pt" height="11" display-align="center">
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="center">
												<fo:block>
													<fo:inline font-family="Arial" font-size="10pt">
														<xsl:text>Type: </xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-family="Arial" font-size="10pt" margin-left="-10pt" padding="2pt" display-align="center">
												<fo:block>
													<xsl:for-each select="ps:ProtocolSummary">
														<xsl:for-each select="ps:ProtocolDetails">
															<xsl:for-each select="ps:ProtocolTypeDesc">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row font-family="Arial" font-size="10pt">
											<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="center">
												<fo:block>
													<fo:inline font-family="Arial" font-size="10pt">
														<xsl:text>Description:</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell margin-left="-10pt" padding="2pt" display-align="center">
												<fo:block>
													<xsl:for-each select="ps:ProtocolSummary">
														<xsl:for-each select="ps:ProtocolDetails">
															<xsl:for-each select="ps:Description">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row font-family="Arial" font-size="10pt">
											<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="center">
												<fo:block>
													<fo:inline font-family="Arial" font-size="10pt">
														<xsl:text>Application Date: </xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-weight="inherit" margin-left="-10pt" padding="2pt" display-align="center">
												<fo:block>
													<xsl:for-each select="ps:ProtocolSummary">
														<xsl:for-each select="ps:ProtocolDetails">
															<xsl:for-each select="ps:ApplicationDate">
																<fo:inline>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																</fo:inline>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row font-family="Arial" font-size="10pt">
											<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
												<fo:block>
													<fo:inline font-family="Arial" font-size="10pt">
														<xsl:text>Reference Num 1: </xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-weight="inherit" margin-left="-10pt" padding="2pt" display-align="center">
												<fo:block>
													<xsl:for-each select="ps:ProtocolSummary">
														<xsl:for-each select="ps:ProtocolDetails">
															<xsl:for-each select="ps:ReferenceNumber1">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row font-family="Arial" font-size="10pt">
											<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
												<fo:block>
													<fo:inline font-family="Arial" font-size="10pt">
														<xsl:text>Reference Num 2:</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell margin-left="-10pt" padding="2pt" display-align="center">
												<fo:block>
													<xsl:for-each select="ps:ProtocolSummary">
														<xsl:for-each select="ps:ProtocolDetails">
															<xsl:for-each select="ps:ReferenceNumber2">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row font-family="Arial" font-size="10pt">
											<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
												<fo:block>
													<fo:inline font-family="Arial" font-size="10pt">
														<xsl:text>FDA Application No: </xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell margin-left="-10pt" padding="2pt" display-align="center">
												<fo:block>
													<xsl:for-each select="ps:ProtocolSummary">
														<xsl:for-each select="ps:ProtocolDetails">
															<xsl:for-each select="ps:FdaApplicationNumber">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row font-family="Arial" font-size="10pt">
											<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
												<fo:block>
													<fo:inline>
														<xsl:text>Title:</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-size="10pt" padding="0" display-align="center">
												<fo:block>
													<xsl:for-each select="ps:ProtocolSummary">
														<xsl:for-each select="ps:ProtocolDetails">
															<xsl:for-each select="ps:Title">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell padding="2pt" display-align="center">
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</xsl:if>
							<fo:block/>
							<xsl:if test="ps:ProtocolSummary/ps:PrintRequirement/ps:OrganizationRequired  = 1">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="ps:ProtocolSummary/ps:ProtocolOrganization">
									<fo:table border="0" table-layout="fixed" width="100%" border-spacing="-1pt">
										<fo:table-column column-width="25%"/>
										<fo:table-column column-width="25%"/>
										<fo:table-column column-width="50%"/>
										<fo:table-header start-indent="0pt">
											<fo:table-row border="0">
												<fo:table-cell border="0" font-family="Arial" font-weight="bold" padding="0" height="10" text-align="left" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
															<xsl:text>Organizations</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="0" font-family="Arial" font-weight="bold" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" font-family="Arial" font-weight="bold" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-family="Arial" font-weight="bold" border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Type</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell font-family="Arial" font-weight="bold" border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Organization</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell font-family="Arial" font-weight="bold" border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Address</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="ps:ProtocolSummary">
												<xsl:for-each select="ps:ProtocolOrganization">
													<fo:table-row>
														<fo:table-cell font-family="Arial" font-size="10pt" border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:ProtocolOrgTypeDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial" font-size="10pt" border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:OrgName">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial" font-size="10pt" border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:Address">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="ps:ProtocolSummary/ps:PrintRequirement/ps:InvestigatorsRequired  = 1">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="ps:ProtocolSummary/ps:ProtocolInvestigators">
									<fo:table border="0" table-layout="fixed" width="100%" border-spacing="-1pt">
										<fo:table-column column-width="20%"/>
										<fo:table-column column-width="50%"/>
										<fo:table-column column-width="15%"/>
										<fo:table-column column-width="15%"/>
										<fo:table-header start-indent="0pt">
											<fo:table-row border="0" font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="0" padding="0" height="10" text-align="left" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
															<xsl:text>Investigators</xsl:text>
														</fo:inline>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>&#160;</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Person Name</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Units</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Affiliate</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Training Flag</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="ps:ProtocolSummary">
												<xsl:for-each select="ps:ProtocolInvestigators">
													<fo:table-row font-family="Arial" font-size="10pt">
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:PersonName">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<xsl:if test="ps:ProtocolUnits">
																	<fo:table table-layout="fixed" width="80%" border-spacing="2pt">
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-body start-indent="0pt">
																			<xsl:for-each select="ps:ProtocolUnits">
																				<fo:table-row font-family="Arial" font-size="10pt">
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<xsl:for-each select="ps:UnitNumber">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<xsl:for-each select="ps:UnitName">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																			</xsl:for-each>
																		</fo:table-body>
																	</fo:table>
																</xsl:if>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:AffiliationTypeDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:TrainingFlag">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="ps:ProtocolSummary/ps:PrintRequirement/ps:KeyPersonsRequired  = 1">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="ps:ProtocolSummary/ps:ProtocolKeyPersons">
									<fo:table border="0" table-layout="fixed" width="100%" border-spacing="-1pt">
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-header start-indent="0pt">
											<fo:table-row border="0" font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="0" font-family="Arial" font-size="10pt" font-weight="bold" padding="0" height="10" text-align="left" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
															<xsl:text>Study Personnel</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" font-family="Arial" font-size="10pt" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt" font-weight="bold">
															<xsl:text>PersonName</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt" font-weight="bold">
															<xsl:text>Role</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell font-family="Arial" font-size="10pt" border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Affiliation</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Training</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="ps:ProtocolSummary">
												<xsl:for-each select="ps:ProtocolKeyPersons">
													<fo:table-row>
														<fo:table-cell font-family="Arial" font-size="10pt" border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:PersonName">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial" font-size="10pt" border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:PersonRole">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial" font-size="10pt" border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:AffiliationTypeDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Arial" font-size="10pt" border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:TrainingFlag">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="ps:ProtocolSummary/ps:PrintRequirement/ps:CorrespondentsRequired  = 1">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="ps:ProtocolSummary/ps:ProtocolCorrespondents">
									<fo:table border="0" table-layout="fixed" width="100%" border-spacing="-1pt">
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-header start-indent="0pt">
											<fo:table-row border="0" font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="0" padding="0" height="10" text-align="left" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
															<xsl:text>Correspondents </xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Type</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Name</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Comments</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="ps:ProtocolSummary">
												<xsl:for-each select="ps:ProtocolCorrespondents">
													<fo:table-row font-family="Arial" font-size="10pt">
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:CorrespondentTypeDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:PersonName">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:Comments">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="ps:ProtocolSummary/ps:PrintRequirement/ps:ResearchAreasRequired  = 1">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="ps:ProtocolSummary/ps:ProtocolResearchAreas">
									<fo:table border="0" table-layout="fixed" width="100%" border-spacing="-1pt">
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-header start-indent="0pt">
											<fo:table-row border="0" font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="0" padding="0" height="10" text-align="left" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
															<xsl:text>Areas of Research </xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Code</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt" font-weight="bold">
															<xsl:text>Description</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="ps:ProtocolSummary">
												<xsl:for-each select="ps:ProtocolResearchAreas">
													<fo:table-row font-family="Arial" font-size="10pt">
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:ResearchAreaCode">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:ResearchAreaDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="ps:ProtocolSummary/ps:PrintRequirement/ps:FundingSourcesRequired  = 1">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="ps:ProtocolSummary/ps:ProtocolFundingSources">
									<fo:table border="0" font-family="Arial" font-size="10pt" table-layout="fixed" width="100%" border-spacing="-1pt">
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-header start-indent="0pt">
											<fo:table-row border="0" font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="0" padding="0" height="10" text-align="left" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
															<xsl:text>Funding Source</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Type</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Number/Code</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Name/Title</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="ps:ProtocolSummary">
												<xsl:for-each select="ps:ProtocolFundingSources">
													<fo:table-row font-family="Arial" font-size="10pt">
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:FundingSourceTypeDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:FundingSource">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:Title">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="ps:ProtocolSummary/ps:PrintRequirement/ps:ActionsRequired  = 1">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="ps:ProtocolSummary/ps:ProtocolActions">
									<fo:table border="0" table-layout="fixed" width="100%" border-spacing="-1pt">
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-header start-indent="0pt">
											<fo:table-row border="0" font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="0" padding="0" height="10" text-align="left" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
															<xsl:text>Actions</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Description</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Comments</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Action Date</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="ps:ProtocolSummary">
												<xsl:for-each select="ps:ProtocolActions">
													<fo:table-row font-family="Arial" font-size="10pt">
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:ProtocolActionTypeDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:Comments">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:choose>
																	<xsl:when test="ps:ActionDate  = &quot;&quot;"/>
																	<xsl:otherwise>
																		<xsl:for-each select="ps:ActionDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																				<xsl:text>/</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																				<xsl:text>/</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:otherwise>
																</xsl:choose>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="ps:ProtocolSummary/ps:PrintRequirement/ps:SubjectsRequired  = 1">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="ps:ProtocolSummary/ps:ProtocolSubjects">
									<fo:table border="0" table-layout="fixed" width="100%" border-spacing="-1pt">
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-header start-indent="0pt">
											<fo:table-row border="0" font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="0" padding="0" height="10" text-align="left" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
															<xsl:text>Subjects</xsl:text>
														</fo:inline>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>&#160;</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Subject</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Count</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="ps:ProtocolSummary">
												<xsl:for-each select="ps:ProtocolSubjects">
													<fo:table-row font-family="Arial" font-size="10pt">
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:VulnerableSubjectTypeDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:SubjectCount">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="ps:ProtocolSummary/ps:PrintRequirement/ps:DocumentsRequired  = 1">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="ps:ProtocolSummary/ps:ProtocolDocuments/ps:ProtocolDocument">
									<fo:table border="0" table-layout="fixed" width="100%" border-spacing="-1pt">
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-header start-indent="0pt">
											<fo:table-row border="0" font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="0" number-columns-spanned="2" padding="0" height="10" text-align="left" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
															<xsl:text>New/Changed Attachments</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" display-align="center">
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Description</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Last Updated</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Updated By</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="ps:ProtocolSummary">
												<xsl:for-each select="ps:ProtocolDocuments">
													<xsl:for-each select="ps:ProtocolDocument">
														<fo:table-row font-family="Arial" font-size="10pt">
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="ps:Description">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="ps:UpdateTimestamp">
																		<fo:inline>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																			<xsl:text>/</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																			<xsl:text>/</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																			<xsl:text> </xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 12, 2)), '00')"/>
																			<xsl:text>:</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 15, 2)), '00')"/>
																			<xsl:text>:</xsl:text>
																			<xsl:choose>
																				<xsl:when test="contains(string(string(.)), 'Z')">
																					<xsl:value-of select="format-number(number(substring-after(substring-after(substring-before(string(string(.)), 'Z'), ':'), ':')), '00')"/>
																				</xsl:when>
																				<xsl:when test="contains(string(string(.)), '+')">
																					<xsl:value-of select="format-number(number(substring-after(substring-after(substring-before(string(string(.)), '+'), ':'), ':')), '00')"/>
																				</xsl:when>
																				<xsl:when test="contains(substring(string(string(.)), 18), '-')">
																					<xsl:value-of select="format-number(number(substring-before(substring(string(string(.)), 18), '-')), '00')"/>
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:value-of select="format-number(number(substring(string(string(.)), 18)), '00')"/>
																				</xsl:otherwise>
																			</xsl:choose>
																			<xsl:text> </xsl:text>
																			<xsl:text/>
																		</fo:inline>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="ps:UpdateUser">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="ps:ProtocolSummary/ps:ProtocolDocuments/ps:ProtocolOtherDocuments">
									<fo:table border="0" table-layout="fixed" width="100%" border-spacing="-1pt">
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-header start-indent="0pt">
											<fo:table-row border="0" font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="0" padding="0" height="10" text-align="left" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
															<xsl:text>Other Attachments </xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Description</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Last Updated</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Updated By</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="ps:ProtocolSummary">
												<xsl:for-each select="ps:ProtocolDocuments">
													<xsl:for-each select="ps:ProtocolOtherDocuments">
														<fo:table-row font-family="Arial" font-size="10pt">
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="ps:Description">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="ps:UpdateTimestamp">
																		<fo:inline>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																			<xsl:text>/</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																			<xsl:text>/</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																			<xsl:text> </xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 12, 2)), '00')"/>
																			<xsl:text>:</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 15, 2)), '00')"/>
																			<xsl:text>:</xsl:text>
																			<xsl:choose>
																				<xsl:when test="contains(string(string(.)), 'Z')">
																					<xsl:value-of select="format-number(number(substring-after(substring-after(substring-before(string(string(.)), 'Z'), ':'), ':')), '00')"/>
																				</xsl:when>
																				<xsl:when test="contains(string(string(.)), '+')">
																					<xsl:value-of select="format-number(number(substring-after(substring-after(substring-before(string(string(.)), '+'), ':'), ':')), '00')"/>
																				</xsl:when>
																				<xsl:when test="contains(substring(string(string(.)), 18), '-')">
																					<xsl:value-of select="format-number(number(substring-before(substring(string(string(.)), 18), '-')), '00')"/>
																				</xsl:when>
																				<xsl:otherwise>
																					<xsl:value-of select="format-number(number(substring(string(string(.)), 18)), '00')"/>
																				</xsl:otherwise>
																			</xsl:choose>
																			<xsl:text> </xsl:text>
																			<xsl:text/>
																		</fo:inline>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="ps:UpdateUser">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="ps:ProtocolSummary/ps:PrintRequirement/ps:SpecialReviewRequired  = 1">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="ps:ProtocolSummary/ps:ProtocolSpecialReview">
									<fo:table border="0" table-layout="fixed" width="100%" border-spacing="-1pt">
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-header start-indent="0pt">
											<fo:table-row font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="0" padding="0" height="10" text-align="left" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
															<xsl:text>Special Review </xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Special Review</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Approval</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Protocol No</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Application Date</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Approval Date</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Comments</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="ps:ProtocolSummary">
												<xsl:for-each select="ps:ProtocolSpecialReview">
													<fo:table-row font-family="Arial" font-size="10pt">
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:SpecialReviewDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:ApprovalTypeDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:SpRevProtocolNumber">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:choose>
																	<xsl:when test="ps:ApplicationDate  = &quot;&quot;"/>
																	<xsl:otherwise>
																		<xsl:for-each select="ps:ApplicationDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																				<xsl:text>/</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																				<xsl:text>/</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:otherwise>
																</xsl:choose>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:choose>
																	<xsl:when test="ps:ApprovalDate  = &quot;&quot;"/>
																	<xsl:otherwise>
																		<xsl:for-each select="ps:ApprovalDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																				<xsl:text>/</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																				<xsl:text>/</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:otherwise>
																</xsl:choose>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:Comments">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="ps:ProtocolSummary/ps:PrintRequirement/ps:RiskLevelsRequired  = 1">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="ps:ProtocolSummary/ps:ProtocolRiskLevels">
									<fo:table border="0" table-layout="fixed" width="100%" border-spacing="-1pt">
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-header start-indent="0pt">
											<fo:table-row border="0" font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="0" padding="0" height="10" text-align="left" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
															<xsl:text>Risk Levels</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Risk Level</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Date Assigned</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Date Updated</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Status</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Comments</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="ps:ProtocolSummary">
												<xsl:for-each select="ps:ProtocolRiskLevels">
													<fo:table-row font-family="Arial" font-size="10pt">
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:RiskLevelDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:DateAssigned">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																		<xsl:text>/</xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																		<xsl:text>/</xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																	</fo:inline>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:choose>
																	<xsl:when test="ps:DateUpdated  = &quot;&quot;"/>
																	<xsl:otherwise>
																		<xsl:for-each select="ps:DateUpdated">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																				<xsl:text>/</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																				<xsl:text>/</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:otherwise>
																</xsl:choose>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:Status">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:Comments">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="ps:ProtocolSummary/ps:PrintRequirement/ps:NotesRequired  = 1">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="ps:ProtocolSummary/ps:ProtocolNotes">
									<fo:table border="0" table-layout="fixed" width="100%" border-spacing="-1pt">
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-header start-indent="0pt">
											<fo:table-row border="0" font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="0" padding="0" height="10" text-align="left" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
															<xsl:text>Protocol Notes</xsl:text>
														</fo:inline>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>&#160;</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Comment</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>By</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Time </xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="ps:ProtocolSummary">
												<xsl:for-each select="ps:ProtocolNotes">
													<fo:table-row font-family="Arial" font-size="10pt">
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:Comments">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:UpdateUser">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:UpdateTimestamp">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																		<xsl:text>/</xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																		<xsl:text>/</xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																		<xsl:text> </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 12, 2)), '00')"/>
																		<xsl:text>:</xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 15, 2)), '00')"/>
																		<xsl:text>:</xsl:text>
																		<xsl:choose>
																			<xsl:when test="contains(string(string(.)), 'Z')">
																				<xsl:value-of select="format-number(number(substring-after(substring-after(substring-before(string(string(.)), 'Z'), ':'), ':')), '00')"/>
																			</xsl:when>
																			<xsl:when test="contains(string(string(.)), '+')">
																				<xsl:value-of select="format-number(number(substring-after(substring-after(substring-before(string(string(.)), '+'), ':'), ':')), '00')"/>
																			</xsl:when>
																			<xsl:when test="contains(substring(string(string(.)), 18), '-')">
																				<xsl:value-of select="format-number(number(substring-before(substring(string(string(.)), 18), '-')), '00')"/>
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 18)), '00')"/>
																			</xsl:otherwise>
																		</xsl:choose>
																		<xsl:text> </xsl:text>
																		<xsl:text/>
																	</fo:inline>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="ps:ProtocolSummary/ps:PrintRequirement/ps:UserRolesRequired  = 1">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="proportional-column-width(1)"/>
									<fo:table-body start-indent="0pt">
										<fo:table-row>
											<fo:table-cell border="0" padding="2pt" height="10" text-align="left" display-align="center">
												<fo:block>
													<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
														<xsl:text>Roles</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
								<fo:block/>
								<xsl:for-each select="ps:ProtocolSummary">
									<xsl:for-each select="ps:ProtocolUserRoles">
										<xsl:choose>
											<xsl:when test="string-length(  ps:UserRoles )  = 0"/>
											<xsl:otherwise>
												<xsl:for-each select="ps:RoleName">
													<xsl:variable name="value-of-template">
														<xsl:apply-templates/>
													</xsl:variable>
													<xsl:choose>
														<xsl:when test="contains(string($value-of-template),'&#x2029;')">
															<fo:block font-family="Arial" font-size="10pt" font-weight="bold">
																<xsl:copy-of select="$value-of-template"/>
															</fo:block>
														</xsl:when>
														<xsl:otherwise>
															<fo:inline font-family="Arial" font-size="10pt" font-weight="bold">
																<xsl:copy-of select="$value-of-template"/>
															</fo:inline>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:for-each>
											</xsl:otherwise>
										</xsl:choose>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<xsl:if test="ps:UserRoles">
											<fo:table border="0" table-layout="fixed" width="100%" border-spacing="-1pt">
												<fo:table-column column-width="proportional-column-width(1)"/>
												<fo:table-column column-width="proportional-column-width(1)"/>
												<fo:table-column column-width="proportional-column-width(1)"/>
												<fo:table-header start-indent="0pt">
													<fo:table-row border="0" font-family="Arial" font-size="10pt" font-weight="bold">
														<fo:table-cell border="0" font-family="Arial" font-size="10pt" font-weight="bold" padding="0" height="10" display-align="center">
															<fo:block/>
														</fo:table-cell>
														<fo:table-cell border="0" padding="0" height="10" display-align="center">
															<fo:block/>
														</fo:table-cell>
														<fo:table-cell border="0" padding="0" height="10" display-align="center">
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row font-family="Arial" font-size="10pt" font-weight="bold">
														<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" border="solid 1pt gray" padding="0" height="20" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>User Id</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" height="20" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>User Name</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" height="20" display-align="center">
															<fo:block>
																<fo:inline>
																	<xsl:text>Unit Name</xsl:text>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-header>
												<fo:table-body start-indent="0pt">
													<xsl:for-each select="ps:UserRoles">
														<fo:table-row font-family="Arial" font-size="10pt">
															<fo:table-cell font-family="Arial" font-size="10pt" border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="ps:UserId">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="ps:UserName">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block>
																	<xsl:for-each select="ps:UnitName">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</fo:table-body>
											</fo:table>
										</xsl:if>
									</xsl:for-each>
								</xsl:for-each>
								<fo:block/>
							</xsl:if>
							<fo:block/>
							<fo:block/>
							<xsl:if test="ps:ProtocolSummary/ps:PrintRequirement/ps:ReferencesRequired  = 1">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="ps:ProtocolSummary/ps:ProtocolReferences">
									<fo:table border="0" table-layout="fixed" width="100%" border-spacing="-1pt">
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-header start-indent="0pt">
											<fo:table-row border="0" font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="0" padding="0" height="10" text-align="left" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
															<xsl:text>Reference List </xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Reference Type</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Reference Number</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Application Date</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Approval Date</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Comments</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="ps:ProtocolSummary">
												<xsl:for-each select="ps:ProtocolReferences">
													<fo:table-row font-family="Arial" font-size="10pt">
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:ProtocolReferenceTypeDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:ProtocolReferenceNumber">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:choose>
																	<xsl:when test="ps:ApplicationDate  = &quot;&quot;"/>
																	<xsl:otherwise>
																		<xsl:for-each select="ps:ApplicationDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																				<xsl:text>/</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																				<xsl:text>/</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:otherwise>
																</xsl:choose>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:choose>
																	<xsl:when test="ps:ApprovalDate  = &quot;&quot;"/>
																	<xsl:otherwise>
																		<xsl:for-each select="ps:ApprovalDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																				<xsl:text>/</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																				<xsl:text>/</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:otherwise>
																</xsl:choose>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:Comments">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:block/>
							</fo:block>
							<fo:block/>
							<xsl:if test="ps:ProtocolSummary/ps:PrintRequirement/ps:AmendRenewSRequired =1">
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="ps:ProtocolSummary/ps:ProtocolAmenRenewal">
									<fo:table border="0" table-layout="fixed" width="100%" border-spacing="-1pt">
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-header start-indent="0pt">
											<fo:table-row border="0" font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="0" padding="0" height="10" text-align="left" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
															<xsl:text>Amendment/Renewal</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" display-align="center">
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Type</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Version</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Status</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Created Date</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Summary</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="ps:ProtocolSummary">
												<xsl:for-each select="ps:ProtocolAmenRenewal">
													<fo:table-row font-family="Arial" font-size="10pt">
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:Type">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:Version">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:ProtocolStatusDesc">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:choose>
																	<xsl:when test="ps:DateCreated  = &quot;&quot;"/>
																	<xsl:otherwise>
																		<xsl:for-each select="ps:DateCreated">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																				<xsl:text>/</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																				<xsl:text>/</xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:otherwise>
																</xsl:choose>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:Summary">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:block/>
							</fo:block>
							<xsl:if test="ps:ProtocolSummary/ps:PrintRequirement/ps:AmendRenewModulesRequired  = 1">
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="ps:ProtocolSummary/ps:ProtocolAmenRenewal">
									<fo:table border="0" table-layout="fixed" width="100%" border-spacing="-1pt">
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-header start-indent="0pt">
											<fo:table-row border="0" font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="0" number-columns-spanned="2" padding="0" height="10" text-align="left" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
															<xsl:text>Amendment/Renewal Summary</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Summary</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline>
															<xsl:text>Editable Modules</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="ps:ProtocolSummary">
												<xsl:for-each select="ps:ProtocolAmenRenewal">
													<fo:table-row font-family="Arial" font-size="10pt">
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:Summary">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:ProtocolModules">
																	<xsl:for-each select="ps:Description">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																		<fo:inline>
																			<xsl:text>,</xsl:text>
																		</fo:inline>
																	</xsl:for-each>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
							<fo:block/>
							<xsl:if test="ps:ProtocolSummary/ps:PrintRequirement/ps:OtherDataRequired  = 1">
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block padding-top="10pt" margin="0pt">
									<fo:block>
										<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
											<xsl:text>&#160;</xsl:text>
										</fo:inline>
									</fo:block>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="ps:ProtocolSummary/ps:ProtocolOthersData">
									<fo:table border="0" table-layout="fixed" width="100%" border-spacing="-1pt">
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-header start-indent="0pt">
											<fo:table-row border="0" font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="0" padding="0" height="10" text-align="left" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="12pt" font-weight="bold">
															<xsl:text>Others </xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="0" padding="0" height="10" display-align="center">
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row font-family="Arial" font-size="10pt" font-weight="bold">
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Name</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block>
														<fo:inline font-family="Arial" font-size="10pt">
															<xsl:text>Value</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:for-each select="ps:ProtocolSummary">
												<xsl:for-each select="ps:ProtocolOthersData">
													<fo:table-row font-family="Arial" font-size="10pt">
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:ColumnName">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block>
																<xsl:for-each select="ps:ColumnValue">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:if>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="headerall">
		<fo:static-content flow-name="xsl-region-before">
			<fo:block>
				<fo:inline-container>
					<fo:block>
						<xsl:text>&#x2029;</xsl:text>
					</fo:block>
				</fo:inline-container>
				<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
					<fo:table-column column-width="50%"/>
					<fo:table-column column-width="50%"/>
					<fo:table-body start-indent="0pt">
						<fo:table-row>
							<fo:table-cell padding="0" number-columns-spanned="2" height="30" display-align="center">
								<fo:block/>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell font-size="10pt" padding="0" text-align="left" display-align="center">
								<fo:block>
									<xsl:for-each select="$XML">
										<xsl:for-each select="ps:ProtocolSummary">
											<xsl:for-each select="ps:SchoolInfo">
												<xsl:for-each select="ps:Acronym">
													<xsl:variable name="value-of-template">
														<xsl:apply-templates/>
													</xsl:variable>
													<xsl:choose>
														<xsl:when test="contains(string($value-of-template),'&#x2029;')">
															<fo:block font-family="Arial">
																<xsl:copy-of select="$value-of-template"/>
															</fo:block>
														</xsl:when>
														<xsl:otherwise>
															<fo:inline font-family="Arial">
																<xsl:copy-of select="$value-of-template"/>
															</fo:inline>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell font-size="10pt" padding="0" text-align="right" display-align="center">
								<fo:block/>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell font-size="10pt" padding="0" text-align="left" display-align="center">
								<fo:block>
									<fo:inline font-family="Arial">
										<xsl:text>Protocol #: </xsl:text>
									</fo:inline>
									<xsl:for-each select="ps:ProtocolSummary">
										<xsl:for-each select="ps:ProtocolDetails">
											<xsl:for-each select="ps:ProtocolNumber">
												<xsl:variable name="value-of-template">
													<xsl:apply-templates/>
												</xsl:variable>
												<xsl:choose>
													<xsl:when test="contains(string($value-of-template),'&#x2029;')">
														<fo:block font-family="Arial">
															<xsl:copy-of select="$value-of-template"/>
														</fo:block>
													</xsl:when>
													<xsl:otherwise>
														<fo:inline font-family="Arial">
															<xsl:copy-of select="$value-of-template"/>
														</fo:inline>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell font-size="10pt" padding="0" padding-left="160pt" text-align="left" display-align="center">
								<fo:block>
									<fo:inline font-family="Arial" padding-right="10pt" text-align="left">
										<xsl:text>Expiration Date:</xsl:text>
									</fo:inline>
									<xsl:choose>
										<xsl:when test="$XML/ps:ProtocolSummary/ps:ProtocolDetails/ps:ExpirationDate  = &quot;&quot;"/>
										<xsl:otherwise>
											<xsl:for-each select="$XML">
												<xsl:for-each select="ps:ProtocolSummary">
													<xsl:for-each select="ps:ProtocolDetails">
														<xsl:for-each select="ps:ExpirationDate">
															<fo:inline font-family="Arial">
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																<xsl:text>/</xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																<xsl:text>/</xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
															</fo:inline>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:otherwise>
									</xsl:choose>
									<fo:inline>
										<xsl:text>&#160;</xsl:text>
									</fo:inline>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell font-size="10pt" padding="0" text-align="left" display-align="center">
								<fo:block>
									<fo:inline font-family="Arial">
										<xsl:text>Investigator: </xsl:text>
									</fo:inline>
									<xsl:for-each select="$XML">
										<xsl:for-each select="ps:ProtocolSummary">
											<xsl:for-each select="ps:ProtocolDetails">
												<xsl:for-each select="ps:Investigator">
													<xsl:variable name="value-of-template">
														<xsl:apply-templates/>
													</xsl:variable>
													<xsl:choose>
														<xsl:when test="contains(string($value-of-template),'&#x2029;')">
															<fo:block font-family="Arial">
																<xsl:copy-of select="$value-of-template"/>
															</fo:block>
														</xsl:when>
														<xsl:otherwise>
															<fo:inline font-family="Arial">
																<xsl:copy-of select="$value-of-template"/>
															</fo:inline>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell font-size="10pt" padding="0" padding-left="160pt" text-align="left" display-align="center">
								<fo:block>
									<fo:inline font-family="Arial" padding-right="10pt" text-align="left">
										<xsl:text>Last Approval Date:</xsl:text>
									</fo:inline>
									<xsl:choose>
										<xsl:when test="$XML/ps:ProtocolSummary/ps:ProtocolDetails/ps:LastApprovalDate  = &quot;&quot;"/>
										<xsl:otherwise>
											<xsl:for-each select="$XML">
												<xsl:for-each select="ps:ProtocolSummary">
													<xsl:for-each select="ps:ProtocolDetails">
														<xsl:for-each select="ps:LastApprovalDate">
															<fo:inline font-family="Arial">
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																<xsl:text>/</xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																<xsl:text>/</xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
															</fo:inline>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:otherwise>
									</xsl:choose>
									<fo:inline>
										<xsl:text>&#160;</xsl:text>
									</fo:inline>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
								<fo:block>
									<fo:block text-align="center">
										<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
									</fo:block>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, '\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = '\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), '\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), '\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
