--
-- Kuali Coeus, a comprehensive research administration system for higher education.
--
-- Copyright 2005-2016 Kuali, Inc.
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
--
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

-- new role to group rates maintenance permissions
INSERT INTO KRIM_ROLE_ID_S VALUES(NULL);

INSERT INTO KRIM_ROLE_T (ROLE_ID, ROLE_NM, NMSPC_CD, DESC_TXT, ACTV_IND, KIM_TYP_ID, OBJ_ID, VER_NBR, LAST_UPDT_DT)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ROLE_ID_S)), 'Institute Rates Maintainer','KC-B','Institute Rates Maintainer for Budget','Y', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NM = 'Default' AND NMSPC_CD = 'KUALI'), UUID(), 1, NOW());

-- rate-class-types
INSERT INTO KRIM_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_T (PERM_ID,PERM_TMPL_ID,NMSPC_CD,NM,DESC_TXT,ACTV_IND,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_PERM_ID_S)),(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Read Class'),'KC-B','Read RateClassType','Read RateClassType in the KC system','Y',UUID(),1);

INSERT INTO KRIM_ATTR_DATA_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID,PERM_ID,KIM_TYP_ID,KIM_ATTR_DEFN_ID,ATTR_VAL,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ATTR_DATA_ID_S)),(SELECT PERM_ID FROM KRIM_PERM_T WHERE NMSPC_CD = 'KC-B' AND NM = 'Read RateClassType'),(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Class Name'),(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'boClass'),'org.kuali.coeus.common.budget.framework.rate.RateClassType',UUID(),1);

INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S)), UUID(), 1, (SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'User' AND NMSPC_CD='KUALI'), (SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'Read RateClassType' AND NMSPC_CD='KC-B'), 'Y');

INSERT INTO KRIM_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_T (PERM_ID,PERM_TMPL_ID,NMSPC_CD,NM,DESC_TXT,ACTV_IND,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_PERM_ID_S)),(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Write Class'),'KC-B','Write RateClassType','Write RateClassType in the KC system','Y',UUID(),1);

INSERT INTO KRIM_ATTR_DATA_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID,PERM_ID,KIM_TYP_ID,KIM_ATTR_DEFN_ID,ATTR_VAL,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ATTR_DATA_ID_S)),(SELECT PERM_ID FROM KRIM_PERM_T WHERE NMSPC_CD = 'KC-B' AND NM = 'Write RateClassType'),(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Class Name'),(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'boClass'),'org.kuali.coeus.common.budget.framework.rate.RateClassType',UUID(),1);

INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S)), UUID(), 1, (SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'Institute Rates Maintainer' AND NMSPC_CD='KC-B'), (SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'Write RateClassType' AND NMSPC_CD='KC-B'), 'Y');

-- rate-classes
INSERT INTO KRIM_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_T (PERM_ID,PERM_TMPL_ID,NMSPC_CD,NM,DESC_TXT,ACTV_IND,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_PERM_ID_S)),(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Read Class'),'KC-B','Read RateClass','Read RateClass in the KC system','Y',UUID(),1);

INSERT INTO KRIM_ATTR_DATA_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID,PERM_ID,KIM_TYP_ID,KIM_ATTR_DEFN_ID,ATTR_VAL,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ATTR_DATA_ID_S)),(SELECT PERM_ID FROM KRIM_PERM_T WHERE NMSPC_CD = 'KC-B' AND NM = 'Read RateType'),(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Class Name'),(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'boClass'),'org.kuali.coeus.common.budget.framework.rate.RateClass',UUID(),1);

INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S)), UUID(), 1, (SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'User' AND NMSPC_CD='KUALI'), (SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'Read RateClass' AND NMSPC_CD='KC-B'), 'Y');

INSERT INTO KRIM_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_T (PERM_ID,PERM_TMPL_ID,NMSPC_CD,NM,DESC_TXT,ACTV_IND,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_PERM_ID_S)),(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Write Class'),'KC-B','Write RateClass','Write RateClass in the KC system','Y',UUID(),1);

INSERT INTO KRIM_ATTR_DATA_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID,PERM_ID,KIM_TYP_ID,KIM_ATTR_DEFN_ID,ATTR_VAL,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ATTR_DATA_ID_S)),(SELECT PERM_ID FROM KRIM_PERM_T WHERE NMSPC_CD = 'KC-B' AND NM = 'Write RateClass'),(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Class Name'),(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'boClass'),'org.kuali.coeus.common.budget.framework.rate.RateClass',UUID(),1);

INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S)), UUID(), 1, (SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'Institute Rates Maintainer' AND NMSPC_CD='KC-B'), (SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'Write RateClass' AND NMSPC_CD='KC-B'), 'Y');

-- rate-types
INSERT INTO KRIM_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_T (PERM_ID,PERM_TMPL_ID,NMSPC_CD,NM,DESC_TXT,ACTV_IND,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_PERM_ID_S)),(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Read Class'),'KC-B','Read RateType','Read RateType in the KC system','Y',UUID(),1);

INSERT INTO KRIM_ATTR_DATA_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID,PERM_ID,KIM_TYP_ID,KIM_ATTR_DEFN_ID,ATTR_VAL,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ATTR_DATA_ID_S)),(SELECT PERM_ID FROM KRIM_PERM_T WHERE NMSPC_CD = 'KC-B' AND NM = 'Read RateType'),(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Class Name'),(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'boClass'),'org.kuali.coeus.common.budget.framework.rate.RateType',UUID(),1);

INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S)), UUID(), 1, (SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'User' AND NMSPC_CD='KUALI'), (SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'Read RateType' AND NMSPC_CD='KC-B'), 'Y');

INSERT INTO KRIM_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_T (PERM_ID,PERM_TMPL_ID,NMSPC_CD,NM,DESC_TXT,ACTV_IND,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_PERM_ID_S)),(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Write Class'),'KC-B','Write RateType','Write RateType in the KC system','Y',UUID(),1);

INSERT INTO KRIM_ATTR_DATA_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID,PERM_ID,KIM_TYP_ID,KIM_ATTR_DEFN_ID,ATTR_VAL,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ATTR_DATA_ID_S)),(SELECT PERM_ID FROM KRIM_PERM_T WHERE NMSPC_CD = 'KC-B' AND NM = 'Write RateType'),(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Class Name'),(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'boClass'),'org.kuali.coeus.common.budget.framework.rate.RateType',UUID(),1);

INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S)), UUID(), 1, (SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'Institute Rates Maintainer' AND NMSPC_CD='KC-B'), (SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'Write RateType' AND NMSPC_CD='KC-B'), 'Y');

-- institute-rates
INSERT INTO KRIM_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_T (PERM_ID,PERM_TMPL_ID,NMSPC_CD,NM,DESC_TXT,ACTV_IND,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_PERM_ID_S)),(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Read Class'),'KC-B','Read InstituteRate','Read InstituteRate in the KC system','Y',UUID(),1);

INSERT INTO KRIM_ATTR_DATA_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID,PERM_ID,KIM_TYP_ID,KIM_ATTR_DEFN_ID,ATTR_VAL,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ATTR_DATA_ID_S)),(SELECT PERM_ID FROM KRIM_PERM_T WHERE NMSPC_CD = 'KC-B' AND NM = 'Read InstituteRate'),(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Class Name'),(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'boClass'),'org.kuali.coeus.common.budget.framework.rate.InstituteRate',UUID(),1);

INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S)), UUID(), 1, (SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'User' AND NMSPC_CD='KUALI'), (SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'Read InstituteRate' AND NMSPC_CD='KC-B'), 'Y');

INSERT INTO KRIM_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_T (PERM_ID,PERM_TMPL_ID,NMSPC_CD,NM,DESC_TXT,ACTV_IND,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_PERM_ID_S)),(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Write Class'),'KC-B','Write InstituteRate','Write InstituteRate in the KC system','Y',UUID(),1);

INSERT INTO KRIM_ATTR_DATA_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID,PERM_ID,KIM_TYP_ID,KIM_ATTR_DEFN_ID,ATTR_VAL,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ATTR_DATA_ID_S)),(SELECT PERM_ID FROM KRIM_PERM_T WHERE NMSPC_CD = 'KC-B' AND NM = 'Write InstituteRate'),(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Class Name'),(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'boClass'),'org.kuali.coeus.common.budget.framework.rate.InstituteRate',UUID(),1);

INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S)), UUID(), 1, (SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'Institute Rates Maintainer' AND NMSPC_CD='KC-B'), (SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'Write InstituteRate' AND NMSPC_CD='KC-B'), 'Y');

-- common namespace
INSERT INTO KRCR_NMSPC_T (NMSPC_CD, OBJ_ID, VER_NBR, NM, ACTV_IND, APPL_ID)
VALUES ('KC-COMMON', UUID(), 1, 'Common', 'Y', 'KC');

-- activity-types
INSERT INTO KRIM_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_T (PERM_ID,PERM_TMPL_ID,NMSPC_CD,NM,DESC_TXT,ACTV_IND,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_PERM_ID_S)),(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Read Class'),'KC-COMMON','Read ActivityType','Read ActivityType in the KC system','Y',UUID(),1);

INSERT INTO KRIM_ATTR_DATA_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID,PERM_ID,KIM_TYP_ID,KIM_ATTR_DEFN_ID,ATTR_VAL,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ATTR_DATA_ID_S)),(SELECT PERM_ID FROM KRIM_PERM_T WHERE NMSPC_CD = 'KC-COMMON' AND NM = 'Read ActivityType'),(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Class Name'),(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'boClass'),'org.kuali.coeus.common.framework.type.ActivityType',UUID(),1);

INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S)), UUID(), 1, (SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'User' AND NMSPC_CD='KUALI'), (SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'Read ActivityType' AND NMSPC_CD='KC-COMMON'), 'Y');

INSERT INTO KRIM_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_T (PERM_ID,PERM_TMPL_ID,NMSPC_CD,NM,DESC_TXT,ACTV_IND,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_PERM_ID_S)),(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Write Class'),'KC-COMMON','Write ActivityType','Write ActivityType in the KC system','Y',UUID(),1);

INSERT INTO KRIM_ATTR_DATA_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID,PERM_ID,KIM_TYP_ID,KIM_ATTR_DEFN_ID,ATTR_VAL,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ATTR_DATA_ID_S)),(SELECT PERM_ID FROM KRIM_PERM_T WHERE NMSPC_CD = 'KC-COMMON' AND NM = 'Write ActivityType'),(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Class Name'),(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'boClass'),'org.kuali.coeus.common.framework.type.ActivityType',UUID(),1);

INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S)), UUID(), 1, (SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'Institute Rates Maintainer' AND NMSPC_CD='KC-B'), (SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'Write ActivityType' AND NMSPC_CD='KC-COMMON'), 'Y');

-- units
INSERT INTO KRIM_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_T (PERM_ID,PERM_TMPL_ID,NMSPC_CD,NM,DESC_TXT,ACTV_IND,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_PERM_ID_S)),(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Read Class'),'KC-COMMON','Read Unit','Read Unit in the KC system','Y',UUID(),1);

INSERT INTO KRIM_ATTR_DATA_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID,PERM_ID,KIM_TYP_ID,KIM_ATTR_DEFN_ID,ATTR_VAL,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ATTR_DATA_ID_S)),(SELECT PERM_ID FROM KRIM_PERM_T WHERE NMSPC_CD = 'KC-COMMON' AND NM = 'Read Unit'),(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Class Name'),(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'boClass'),'org.kuali.coeus.common.framework.unit.Unit',UUID(),1);

INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S)), UUID(), 1, (SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'User' AND NMSPC_CD='KUALI'), (SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'Read Unit' AND NMSPC_CD='KC-COMMON'), 'Y');

INSERT INTO KRIM_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_T (PERM_ID,PERM_TMPL_ID,NMSPC_CD,NM,DESC_TXT,ACTV_IND,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_PERM_ID_S)),(SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Write Class'),'KC-COMMON','Write Unit','Write Unit in the KC system','Y',UUID(),1);

INSERT INTO KRIM_ATTR_DATA_ID_S VALUES(NULL);
INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID,PERM_ID,KIM_TYP_ID,KIM_ATTR_DEFN_ID,ATTR_VAL,OBJ_ID,VER_NBR)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ATTR_DATA_ID_S)),(SELECT PERM_ID FROM KRIM_PERM_T WHERE NMSPC_CD = 'KC-COMMON' AND NM = 'Write Unit'),(SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Class Name'),(SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'boClass'),'org.kuali.coeus.common.framework.unit.Unit',UUID(),1);

INSERT INTO KRIM_ROLE_PERM_ID_S VALUES(NULL);
INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, VER_NBR, ROLE_ID, PERM_ID, ACTV_IND)
VALUES (CONCAT('KC', (SELECT (MAX(ID)) FROM KRIM_ROLE_PERM_ID_S)), UUID(), 1, (SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'Institute Rates Maintainer' AND NMSPC_CD='KC-B'), (SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'Write Unit' AND NMSPC_CD='KC-COMMON'), 'Y');

-- add as Institute Rates Maintainer member of other standard roles
INSERT INTO KRIM_ROLE_MBR_ID_S VALUES(NULL);
INSERT INTO KRIM_ROLE_MBR_T (ROLE_MBR_ID,VER_NBR,OBJ_ID,ROLE_ID, MBR_ID,MBR_TYP_CD, ACTV_FRM_DT, ACTV_TO_DT,LAST_UPDT_DT)
VALUES (CONCAT ('KC',(SELECT (MAX(ID)) FROM KRIM_ROLE_MBR_ID_S)), '1', UUID(), (SELECT ROLE_ID from KRIM_ROLE_T WHERE ROLE_NM='Institute Rates Maintainer' AND NMSPC_CD='KC-B'), (SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM='Technical Administrator' AND NMSPC_CD='KR-SYS'), 'R', NULL,NULL, NOW());

INSERT INTO KRIM_ROLE_MBR_ID_S VALUES(NULL);
INSERT INTO KRIM_ROLE_MBR_T (ROLE_MBR_ID,VER_NBR,OBJ_ID,ROLE_ID, MBR_ID,MBR_TYP_CD, ACTV_FRM_DT, ACTV_TO_DT,LAST_UPDT_DT)
VALUES (CONCAT ('KC',(SELECT (MAX(ID)) FROM KRIM_ROLE_MBR_ID_S)), '1', UUID(), (SELECT ROLE_ID from KRIM_ROLE_T WHERE ROLE_NM='Institute Rates Maintainer' AND NMSPC_CD='KC-B'), (SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM='Application Administrator' AND NMSPC_CD='KC-SYS'), 'R', NULL,NULL, NOW());

INSERT INTO KRIM_ROLE_MBR_ID_S VALUES(NULL);
INSERT INTO KRIM_ROLE_MBR_T (ROLE_MBR_ID,VER_NBR,OBJ_ID,ROLE_ID, MBR_ID,MBR_TYP_CD, ACTV_FRM_DT, ACTV_TO_DT,LAST_UPDT_DT)
VALUES (CONCAT ('KC',(SELECT (MAX(ID)) FROM KRIM_ROLE_MBR_ID_S)), '1', UUID(), (SELECT ROLE_ID from KRIM_ROLE_T WHERE ROLE_NM='Institute Rates Maintainer' AND NMSPC_CD='KC-B'), (SELECT ROLE_ID FROM KRIM_ROLE_T WHERE ROLE_NM = 'Manager' AND NMSPC_CD='KC-SYS'), 'R', NULL,NULL, NOW());

-- delete Maintain Institute Rates data
DELETE FROM KRIM_ROLE_PERM_T WHERE PERM_ID = (SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'Maintain Institute Rates' AND NMSPC_CD='KC-M');
DELETE FROM KRIM_PERM_ATTR_DATA_T WHERE PERM_ID = (SELECT PERM_ID FROM KRIM_PERM_T WHERE NM = 'Maintain Institute Rates' AND NMSPC_CD='KC-M');
DELETE FROM KRIM_PERM_T WHERE NM = 'Maintain Institute Rates' AND NMSPC_CD='KC-M';