/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.util.xa;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.Status;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.transaction.util.LoggerFacade;
import org.apache.commons.transaction.util.xa.TransactionalResource;
import org.apache.commons.transaction.util.xa.XidWrapper;

public abstract class AbstractXAResource
implements XAResource,
Status {
    private ThreadLocal activeTransactionBranch = new ThreadLocal();
    private Map suspendedContexts = new HashMap();
    private Map activeContexts = new HashMap();

    public abstract boolean isSameRM(XAResource var1) throws XAException;

    public abstract Xid[] recover(int var1) throws XAException;

    protected abstract LoggerFacade getLoggerFacade();

    protected abstract boolean includeBranchInXid();

    public void forget(Xid xid) throws XAException {
        TransactionalResource ts;
        if (this.getLoggerFacade().isFineEnabled()) {
            this.getLoggerFacade().logFine("Forgetting transaction branch " + xid);
        }
        if ((ts = this.getTransactionalResource(xid)) == null) {
            throw new XAException(-4);
        }
        this.setCurrentlyActiveTransactionalResource(null);
        this.removeActiveTransactionalResource(xid);
        this.removeSuspendedTransactionalResource(xid);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        TransactionalResource ts = this.getTransactionalResource(xid);
        if (ts == null) {
            throw new XAException(-4);
        }
        if (this.getLoggerFacade().isFineEnabled()) {
            this.getLoggerFacade().logFine("Committing transaction branch " + ts);
        }
        if (ts.getStatus() == 1) {
            throw new XAException(100);
        }
        if (ts.getStatus() != 2) {
            if (onePhase) {
                ts.prepare();
            } else {
                throw new XAException(-6);
            }
        }
        ts.commit();
        this.setCurrentlyActiveTransactionalResource(null);
        this.removeActiveTransactionalResource(xid);
        this.removeSuspendedTransactionalResource(xid);
    }

    public void rollback(Xid xid) throws XAException {
        TransactionalResource ts = this.getTransactionalResource(xid);
        if (ts == null) {
            throw new XAException(-4);
        }
        if (this.getLoggerFacade().isFineEnabled()) {
            this.getLoggerFacade().logFine("Rolling back transaction branch " + ts);
        }
        ts.rollback();
        this.setCurrentlyActiveTransactionalResource(null);
        this.removeActiveTransactionalResource(xid);
        this.removeSuspendedTransactionalResource(xid);
    }

    public int prepare(Xid xid) throws XAException {
        TransactionalResource ts = this.getTransactionalResource(xid);
        if (ts == null) {
            throw new XAException(-4);
        }
        if (this.getLoggerFacade().isFineEnabled()) {
            this.getLoggerFacade().logFine("Preparing transaction branch " + ts);
        }
        if (ts.getStatus() == 1) {
            throw new XAException(100);
        }
        int result = ts.prepare();
        ts.setStatus(2);
        return result;
    }

    public void end(Xid xid, int flags) throws XAException {
        TransactionalResource ts = this.getActiveTransactionalResource(xid);
        if (ts == null) {
            throw new XAException(-4);
        }
        if (this.getCurrentlyActiveTransactionalResource() == null) {
            throw new XAException(-5);
        }
        if (this.getLoggerFacade().isFineEnabled()) {
            this.getLoggerFacade().logFine(new StringBuffer(128).append("Thread ").append(Thread.currentThread()).append(flags == 0x2000000 ? " suspends" : (flags == 0x20000000 ? " fails" : " ends")).append(" work on behalf of transaction branch ").append(ts).toString());
        }
        switch (flags) {
            case 0x2000000: {
                ts.suspend();
                this.addSuspendedTransactionalResource(xid, ts);
                this.removeActiveTransactionalResource(xid);
                break;
            }
            case 0x20000000: {
                ts.setStatus(1);
                break;
            }
        }
        this.setCurrentlyActiveTransactionalResource(null);
    }

    public void start(Xid xid, int flags) throws XAException {
        TransactionalResource ts;
        if (this.getCurrentlyActiveTransactionalResource() != null) {
            throw new XAException(-5);
        }
        if (this.getLoggerFacade().isFineEnabled()) {
            this.getLoggerFacade().logFine(new StringBuffer(128).append("Thread ").append(Thread.currentThread()).append(flags == 0 ? " starts" : (flags == 0x200000 ? " joins" : " resumes")).append(" work on behalf of transaction branch ").append(xid).toString());
        }
        switch (flags) {
            default: {
                try {
                    ts = this.createTransactionResource(xid);
                    ts.begin();
                    break;
                }
                catch (Exception e) {
                    this.getLoggerFacade().logSevere("Could not create new transactional  resource", e);
                    throw new XAException(e.getMessage());
                }
            }
            case 0x8000000: {
                ts = this.getSuspendedTransactionalResource(xid);
                if (ts == null) {
                    throw new XAException(-4);
                }
                ts.resume();
                this.removeSuspendedTransactionalResource(xid);
            }
        }
        this.setCurrentlyActiveTransactionalResource(ts);
        this.addAcitveTransactionalResource(xid, ts);
    }

    protected abstract TransactionalResource createTransactionResource(Xid var1) throws Exception;

    protected TransactionalResource getCurrentlyActiveTransactionalResource() {
        TransactionalResource context = (TransactionalResource)this.activeTransactionBranch.get();
        return context;
    }

    protected void setCurrentlyActiveTransactionalResource(TransactionalResource context) {
        this.activeTransactionBranch.set(context);
    }

    protected TransactionalResource getTransactionalResource(Xid xid) {
        TransactionalResource ts = this.getActiveTransactionalResource(xid);
        if (ts != null) {
            return ts;
        }
        return this.getSuspendedTransactionalResource(xid);
    }

    protected TransactionalResource getActiveTransactionalResource(Xid xid) {
        Xid wxid = XidWrapper.wrap(xid, this.includeBranchInXid());
        return (TransactionalResource)this.activeContexts.get(wxid);
    }

    protected TransactionalResource getSuspendedTransactionalResource(Xid xid) {
        Xid wxid = XidWrapper.wrap(xid, this.includeBranchInXid());
        return (TransactionalResource)this.suspendedContexts.get(wxid);
    }

    protected void addAcitveTransactionalResource(Xid xid, TransactionalResource txContext) {
        Xid wxid = XidWrapper.wrap(xid, this.includeBranchInXid());
        this.activeContexts.put(wxid, txContext);
    }

    protected void addSuspendedTransactionalResource(Xid xid, TransactionalResource txContext) {
        Xid wxid = XidWrapper.wrap(xid, this.includeBranchInXid());
        this.suspendedContexts.put(wxid, txContext);
    }

    protected void removeActiveTransactionalResource(Xid xid) {
        Xid wxid = XidWrapper.wrap(xid, this.includeBranchInXid());
        this.activeContexts.remove(wxid);
    }

    protected void removeSuspendedTransactionalResource(Xid xid) {
        Xid wxid = XidWrapper.wrap(xid, this.includeBranchInXid());
        this.suspendedContexts.remove(wxid);
    }
}

