/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.role;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.NonUniqueResultException;
import javax.xml.namespace.QName;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.rice.coreservice.api.namespace.Namespace;
import org.kuali.rice.coreservice.api.namespace.NamespaceService;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMember;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeAttribute;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.kim.framework.role.RoleEbo;
import org.kuali.rice.kim.framework.role.RoleTypeService;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeBo;
import org.kuali.rice.kim.impl.common.delegate.DelegateMemberBo;
import org.kuali.rice.kim.impl.common.delegate.DelegateTypeBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityInternalService;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.role.RoleBoLite;
import org.kuali.rice.kim.impl.role.RoleDao;
import org.kuali.rice.kim.impl.role.RoleMemberAttributeDataBo;
import org.kuali.rice.kim.impl.role.RoleMemberBo;
import org.kuali.rice.kim.impl.role.RoleResponsibilityActionBo;
import org.kuali.rice.kim.impl.services.KimImplServiceLocator;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.registry.ServiceInfo;

abstract class RoleServiceBase {
    private static final Logger LOG = LogManager.getLogger(RoleServiceBase.class);
    protected DataObjectService dataObjectService;
    protected IdentityService identityService;
    protected NamespaceService namespaceService;
    protected KimTypeInfoService kimTypeInfoService;
    protected GroupService groupService;
    protected ResponsibilityInternalService responsibilityInternalService;
    protected RoleDao roleDao;
    protected DateTimeService dateTimeService;

    RoleServiceBase() {
    }

    protected Map<String, String> convertQualifierKeys(Map<String, String> qualification, Map<String, String> validAttributeIds) {
        HashMap<String, String> convertedQualification = new HashMap<String, String>();
        if (qualification != null && CollectionUtils.isNotEmpty(qualification.entrySet())) {
            for (Map.Entry<String, String> entry : qualification.entrySet()) {
                String attributeId = validAttributeIds.get(entry.getKey());
                if (!StringUtils.isNotEmpty((String)attributeId)) continue;
                convertedQualification.put(attributeId, entry.getValue());
            }
        }
        return convertedQualification;
    }

    protected void getNestedRoleTypeMemberIds(String roleId, Set<String> members) {
        ArrayList<String> roleList = new ArrayList<String>(1);
        roleList.add(roleId);
        List<RoleMemberBo> firstLevelMembers = this.getStoredRoleMembersForRoleIds(roleList, MemberType.ROLE.getCode(), Collections.emptyMap());
        for (RoleMemberBo member : firstLevelMembers) {
            if (!MemberType.ROLE.equals((Object)member.getType()) || members.contains(member.getMemberId())) continue;
            members.add(member.getMemberId());
            this.getNestedRoleTypeMemberIds(member.getMemberId(), members);
        }
    }

    protected List<RoleMemberBo> getRoleMembersForPrincipalId(Collection<String> roleIds, String principalId) {
        return this.getRoleMembersForPrincipalId(roleIds, principalId, new HashMap<String, String>(0));
    }

    protected List<RoleMemberBo> getRoleMembersForPrincipalId(Collection<String> roleIds, String principalId, Map<String, String> qualification) {
        ArrayList<Predicate> criteria = new ArrayList<Predicate>();
        if (CollectionUtils.isNotEmpty(roleIds)) {
            if (roleIds.size() == 1) {
                criteria.add(PredicateFactory.equal((String)"roleId", (Object)roleIds.iterator().next()));
            } else {
                criteria.add(PredicateFactory.in((String)"roleId", roleIds));
            }
        }
        if (StringUtils.isNotBlank((String)principalId)) {
            criteria.add(PredicateFactory.equal((String)"memberId", (Object)principalId));
        }
        criteria.add(PredicateFactory.equal((String)"typeCode", (Object)MemberType.PRINCIPAL.getCode()));
        Predicate roleQualificationPredicate = this.getRoleQualificationPredicate(qualification);
        if (roleQualificationPredicate != null) {
            criteria.add(roleQualificationPredicate);
        }
        return this.getRoleMembershipsForPredicates(criteria);
    }

    protected List<RoleMemberBo> getRoleMembersForGroupIds(String roleId, List<String> groupIds) {
        if (CollectionUtils.isEmpty(groupIds)) {
            return new ArrayList<RoleMemberBo>();
        }
        List coll = this.getDataObjectService().findMatching(RoleMemberBo.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"roleId", (Object)roleId), PredicateFactory.equal((String)"typeCode", (Object)MemberType.GROUP.getCode()), PredicateFactory.in((String)"memberId", groupIds)})).getResults();
        ArrayList<RoleMemberBo> results = new ArrayList<RoleMemberBo>(coll.size());
        DateTime now = new DateTime(this.getDateTimeService().getCurrentTimestamp().getTime());
        for (RoleMemberBo rm : coll) {
            if (!rm.isActive(now)) continue;
            results.add(rm);
        }
        return results;
    }

    protected List<RoleMemberBo> getRoleMemberBoList(RoleDaoAction daoActionToTake, Collection<String> roleIds, String principalId, Collection<String> groupIds, String memberTypeCode, Map<String, String> qualification) {
        if (roleIds == null || roleIds.isEmpty()) {
            roleIds = Collections.emptyList();
        }
        if (groupIds == null || groupIds.isEmpty()) {
            groupIds = Collections.emptyList();
        }
        HashMap<String, String> validAttributeIds = new HashMap<String, String>();
        HashSet<String> kimTypeIds = new HashSet<String>();
        for (String roleId : roleIds) {
            RoleBoLite role = this.getRoleBoLite(roleId);
            kimTypeIds.add(role.getKimTypeId());
        }
        if (qualification != null && CollectionUtils.isNotEmpty(qualification.entrySet())) {
            for (String kimTypeId : kimTypeIds) {
                for (Map.Entry<String, String> entry : qualification.entrySet()) {
                    validAttributeIds.put(entry.getKey(), this.getKimAttributeId(kimTypeId, entry.getKey()));
                }
            }
        }
        Map<String, String> convertedQualification = this.convertQualifierKeys(qualification, validAttributeIds);
        switch (daoActionToTake) {
            case ROLE_PRINCIPALS_FOR_PRINCIPAL_ID_AND_ROLE_IDS: {
                return this.getRoleMembersForPrincipalId(roleIds, principalId, convertedQualification);
            }
            case ROLE_GROUPS_FOR_GROUP_IDS_AND_ROLE_IDS: {
                return this.getRoleGroupsForGroupIdsAndRoleIds(roleIds, groupIds, convertedQualification);
            }
            case ROLE_MEMBERS_FOR_ROLE_IDS: {
                return this.roleDao.getRoleMembersForRoleIds(roleIds, memberTypeCode, convertedQualification);
            }
            case ROLE_MEMBERSHIPS_FOR_ROLE_IDS_AS_MEMBERS: {
                return this.getRoleMembershipsForRoleIdsAsMembers(roleIds, convertedQualification);
            }
            case ROLE_MEMBERS_FOR_ROLE_IDS_WITH_FILTERS: {
                return this.getRoleMembersForRoleIdsWithFilters(roleIds, principalId, groupIds, convertedQualification);
            }
        }
        throw new IllegalArgumentException("The 'daoActionToTake' parameter cannot refer to a non-role-member-related value!");
    }

    public List<RoleMemberBo> getRoleGroupsForGroupIdsAndRoleIds(Collection<String> roleIds, Collection<String> groupIds, Map<String, String> qualification) {
        ArrayList<Predicate> criteria = new ArrayList<Predicate>();
        if (CollectionUtils.isNotEmpty(roleIds)) {
            criteria.add(PredicateFactory.in((String)"roleId", roleIds));
        }
        if (CollectionUtils.isNotEmpty(groupIds)) {
            criteria.add(PredicateFactory.in((String)"memberId", groupIds));
        }
        criteria.add(PredicateFactory.equal((String)"typeCode", (Object)MemberType.GROUP.getCode()));
        Predicate roleQualificationPredicate = this.getRoleQualificationPredicate(qualification);
        if (roleQualificationPredicate != null) {
            criteria.add(roleQualificationPredicate);
        }
        return this.getRoleMembershipsForPredicates(criteria);
    }

    protected List<RoleMemberBo> getRoleMembershipsForRoleIdsAsMembers(Collection<String> roleIds, Map<String, String> qualification) {
        ArrayList<Predicate> criteria = new ArrayList<Predicate>();
        if (CollectionUtils.isNotEmpty(roleIds)) {
            criteria.add(PredicateFactory.in((String)"roleId", roleIds));
        }
        criteria.add(PredicateFactory.equal((String)"typeCode", (Object)MemberType.ROLE.getCode()));
        Predicate roleQualificationPredicate = this.getRoleQualificationPredicate(qualification);
        if (roleQualificationPredicate != null) {
            criteria.add(roleQualificationPredicate);
        }
        return this.getRoleMembershipsForPredicates(criteria);
    }

    protected List<RoleMemberBo> getRoleMembersForRoleIdsWithFilters(Collection<String> roleIds, String principalId, Collection<String> groupIds, Map<String, String> qualification) {
        Predicate roleQualificationPredicate;
        ArrayList<Predicate> criteria = new ArrayList<Predicate>();
        ArrayList<Predicate> orCriteria = new ArrayList<Predicate>();
        if (CollectionUtils.isNotEmpty(roleIds)) {
            orCriteria.add(PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"typeCode", (Object)MemberType.ROLE.getCode()), PredicateFactory.in((String)"roleId", roleIds)}));
        }
        if (StringUtils.isNotBlank((String)principalId)) {
            orCriteria.add(PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"typeCode", (Object)MemberType.PRINCIPAL.getCode()), PredicateFactory.equal((String)"memberId", (Object)principalId), PredicateFactory.in((String)"roleId", roleIds)}));
        }
        if (CollectionUtils.isNotEmpty(groupIds)) {
            orCriteria.add(PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"typeCode", (Object)MemberType.GROUP.getCode()), PredicateFactory.in((String)"memberId", groupIds), PredicateFactory.in((String)"roleId", roleIds)}));
        }
        if (!orCriteria.isEmpty()) {
            criteria.add(PredicateFactory.or((Predicate[])orCriteria.toArray(new Predicate[0])));
        }
        if ((roleQualificationPredicate = this.getRoleQualificationPredicate(qualification)) != null) {
            criteria.add(roleQualificationPredicate);
        }
        return this.getRoleMembershipsForPredicates(criteria);
    }

    protected List<RoleMemberBo> getRoleMembershipsForPredicates(Collection<Predicate> criteria) {
        List coll = this.getDataObjectService().findMatching(RoleMemberBo.class, QueryByCriteria.Builder.fromPredicates(criteria)).getResults();
        ArrayList<RoleMemberBo> results = new ArrayList<RoleMemberBo>(coll.size());
        DateTime now = new DateTime(this.getDateTimeService().getCurrentTimestamp().getTime());
        for (RoleMemberBo rm : coll) {
            if (!rm.isActive(now)) continue;
            results.add(rm);
        }
        return results;
    }

    protected Predicate getRoleQualificationPredicate(Map<String, String> qualification) {
        if (qualification == null || CollectionUtils.isEmpty(qualification.keySet())) {
            return null;
        }
        ArrayList<Predicate> attributePredicates = new ArrayList<Predicate>(qualification.size());
        for (Map.Entry<String, String> qualifier : qualification.entrySet()) {
            if (!StringUtils.isNotBlank((String)qualifier.getValue())) continue;
            Predicate subQueryCriteria = PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.like((String)"attributeValue", (CharSequence)qualifier.getValue()), PredicateFactory.equal((String)"kimAttributeId", (Object)qualifier.getKey()), PredicateFactory.equalsProperty((String)"assignedToId", null, (String)"parent.id")});
            Predicate existsSubquery = PredicateFactory.existsSubquery((String)RoleMemberAttributeDataBo.class.getName(), (Predicate)subQueryCriteria);
            attributePredicates.add(existsSubquery);
        }
        if (attributePredicates.isEmpty()) {
            return null;
        }
        if (attributePredicates.size() == 1) {
            return (Predicate)attributePredicates.get(0);
        }
        return PredicateFactory.and((Predicate[])attributePredicates.toArray(new Predicate[attributePredicates.size()]));
    }

    protected List<RoleMemberBo> getRoleMembershipsForMemberId(String memberType, String memberId, Map<String, String> qualification) {
        if (StringUtils.isBlank((String)memberId) || StringUtils.isBlank((String)memberType)) {
            return new ArrayList<RoleMemberBo>(0);
        }
        ArrayList<Predicate> criteria = new ArrayList<Predicate>();
        criteria.add(PredicateFactory.equal((String)"memberId", (Object)memberId));
        criteria.add(PredicateFactory.equal((String)"typeCode", (Object)memberType));
        Predicate roleQualificationPredicate = this.getRoleQualificationPredicate(qualification);
        if (roleQualificationPredicate != null) {
            criteria.add(roleQualificationPredicate);
        }
        return this.getRoleMembershipsForPredicates(criteria);
    }

    protected List<RoleMemberBo> getStoredRolePrincipalsForPrincipalIdAndRoleIds(Collection<String> roleIds, String principalId, Map<String, String> qualification) {
        return this.getRoleMemberBoList(RoleDaoAction.ROLE_PRINCIPALS_FOR_PRINCIPAL_ID_AND_ROLE_IDS, roleIds, principalId, Collections.emptyList(), null, qualification);
    }

    protected List<RoleMemberBo> getStoredRoleGroupsForGroupIdsAndRoleIds(Collection<String> roleIds, Collection<String> groupIds, Map<String, String> qualification) {
        return this.getRoleMemberBoList(RoleDaoAction.ROLE_GROUPS_FOR_GROUP_IDS_AND_ROLE_IDS, roleIds, null, groupIds, null, qualification);
    }

    protected List<RoleMemberBo> getStoredRoleMembersForRoleIds(Collection<String> roleIds, String memberTypeCode, Map<String, String> qualification) {
        return this.getRoleMemberBoList(RoleDaoAction.ROLE_MEMBERS_FOR_ROLE_IDS, roleIds, null, Collections.emptyList(), memberTypeCode, qualification);
    }

    protected List<RoleMemberBo> getStoredRoleMembershipsForRoleIdsAsMembers(Collection<String> roleIds, Map<String, String> qualification) {
        return this.getRoleMemberBoList(RoleDaoAction.ROLE_MEMBERSHIPS_FOR_ROLE_IDS_AS_MEMBERS, roleIds, null, Collections.emptyList(), null, qualification);
    }

    protected List<RoleMemberBo> getStoredRoleMembersForRoleIdsWithFilters(Collection<String> roleIds, String principalId, List<String> groupIds, Map<String, String> qualification) {
        return this.getRoleMemberBoList(RoleDaoAction.ROLE_MEMBERS_FOR_ROLE_IDS_WITH_FILTERS, roleIds, principalId, groupIds, null, qualification);
    }

    protected RoleMemberBo getRoleMemberBo(String roleMemberId) {
        if (StringUtils.isBlank((String)roleMemberId)) {
            return null;
        }
        return (RoleMemberBo)((Object)this.getDataObjectService().find(RoleMemberBo.class, (Object)roleMemberId));
    }

    protected RoleResponsibilityActionBo getRoleResponsibilityActionBo(String roleResponsibilityActionId) {
        if (StringUtils.isBlank((String)roleResponsibilityActionId)) {
            return null;
        }
        return (RoleResponsibilityActionBo)((Object)this.getDataObjectService().find(RoleResponsibilityActionBo.class, (Object)roleResponsibilityActionId));
    }

    protected Map<String, DelegateTypeBo> getStoredDelegationImplMapFromRoleIds(Collection<String> roleIds) {
        if (roleIds != null && !roleIds.isEmpty()) {
            HashMap<String, DelegateTypeBo> results = new HashMap<String, DelegateTypeBo>();
            List coll = this.getDataObjectService().findMatching(DelegateTypeBo.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.in((String)"roleId", roleIds), PredicateFactory.equal((String)"active", (Object)Boolean.TRUE)})).getResults();
            for (DelegateTypeBo delegateBo : coll) {
                results.put(delegateBo.getDelegationId(), delegateBo);
            }
            return results;
        }
        return Collections.emptyMap();
    }

    protected List<DelegateTypeBo> getStoredDelegationImplsForRoleIds(Collection<String> roleIds) {
        if (roleIds != null && !roleIds.isEmpty()) {
            List coll = this.getDataObjectService().findMatching(DelegateTypeBo.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.in((String)"roleId", roleIds), PredicateFactory.equal((String)"active", (Object)Boolean.TRUE)})).getResults();
            return new ArrayList<DelegateTypeBo>(coll);
        }
        return Collections.emptyList();
    }

    protected List<DelegateMemberBo> getStoredDelegationPrincipalsForPrincipalIdAndDelegationIds(Collection<String> delegationIds, String principalId) {
        ArrayList<Predicate> criteria = new ArrayList<Predicate>();
        if (!StringUtils.isNotBlank((String)principalId)) {
            return Collections.emptyList();
        }
        criteria.add(PredicateFactory.equal((String)"memberId", (Object)principalId));
        criteria.add(PredicateFactory.equal((String)"typeCode", (Object)MemberType.PRINCIPAL.getCode()));
        if (delegationIds != null && !delegationIds.isEmpty()) {
            criteria.add(PredicateFactory.in((String)"delegationId", delegationIds));
        }
        List coll = this.getDataObjectService().findMatching(DelegateMemberBo.class, QueryByCriteria.Builder.fromPredicates(criteria)).getResults();
        ArrayList<DelegateMemberBo> results = new ArrayList<DelegateMemberBo>(coll.size());
        DateTime now = new DateTime(this.getDateTimeService().getCurrentTimestamp().getTime());
        for (DelegateMemberBo rm : coll) {
            if (!rm.isActive(now)) continue;
            results.add(rm);
        }
        return results;
    }

    protected DelegateMemberBo getDelegateMemberBo(String delegationMemberId) {
        if (StringUtils.isBlank((String)delegationMemberId)) {
            return null;
        }
        return (DelegateMemberBo)((Object)this.getDataObjectService().find(DelegateMemberBo.class, (Object)delegationMemberId));
    }

    protected List<DelegateMemberBo> getDelegationMemberBoListByMemberAndDelegationId(String memberId, String delegationId) {
        HashMap<String, String> searchCriteria = new HashMap<String, String>(2);
        searchCriteria.put("memberId", memberId);
        searchCriteria.put("delegationId", delegationId);
        return new ArrayList<DelegateMemberBo>(this.getDataObjectService().findMatching(DelegateMemberBo.class, QueryByCriteria.Builder.andAttributes(searchCriteria).build()).getResults());
    }

    protected Object getMember(String memberTypeCode, String memberId) {
        if (StringUtils.isBlank((String)memberId)) {
            return null;
        }
        if (MemberType.PRINCIPAL.getCode().equals(memberTypeCode)) {
            return this.getIdentityService().getPrincipal(memberId);
        }
        if (MemberType.GROUP.getCode().equals(memberTypeCode)) {
            return this.getGroupService().getGroup(memberId);
        }
        if (MemberType.ROLE.getCode().equals(memberTypeCode)) {
            return this.getRoleBo(memberId);
        }
        return null;
    }

    protected String getMemberName(Object member) {
        if (member == null) {
            return "";
        }
        if (member instanceof Principal) {
            return ((Principal)member).getPrincipalName();
        }
        if (member instanceof Group) {
            return ((Group)member).getName();
        }
        if (member instanceof Role) {
            return ((Role)member).getName();
        }
        return member.toString();
    }

    protected RoleBo getRoleBo(String roleId) {
        if (StringUtils.isBlank((String)roleId)) {
            return null;
        }
        return (RoleBo)((Object)this.getDataObjectService().find(RoleBo.class, (Object)roleId));
    }

    protected RoleBoLite getRoleBoLite(String roleId) {
        if (StringUtils.isBlank((String)roleId)) {
            return null;
        }
        return (RoleBoLite)((Object)this.getDataObjectService().find(RoleBoLite.class, (Object)roleId));
    }

    protected DelegateTypeBo getDelegationOfType(String roleId, DelegationType delegationType) {
        List<DelegateTypeBo> roleDelegates = this.getRoleDelegations(roleId);
        if (this.isDelegationPrimary(delegationType)) {
            return this.getPrimaryDelegation(roleId, roleDelegates);
        }
        return this.getSecondaryDelegation(roleId, roleDelegates);
    }

    private DelegateTypeBo getSecondaryDelegation(String roleId, List<DelegateTypeBo> roleDelegates) {
        DelegateTypeBo secondaryDelegate = null;
        RoleBoLite roleBo = this.getRoleBoLite(roleId);
        for (DelegateTypeBo delegate : roleDelegates) {
            if (!this.isDelegationSecondary(delegate.getDelegationType())) continue;
            secondaryDelegate = delegate;
        }
        if (secondaryDelegate == null) {
            secondaryDelegate = new DelegateTypeBo();
            secondaryDelegate.setRoleId(roleId);
            secondaryDelegate.setDelegationType(DelegationType.SECONDARY);
            secondaryDelegate.setKimTypeId(roleBo.getKimTypeId());
        }
        return secondaryDelegate;
    }

    protected DelegateTypeBo getPrimaryDelegation(String roleId, List<DelegateTypeBo> roleDelegates) {
        DelegateTypeBo primaryDelegate = null;
        RoleBoLite roleBo = this.getRoleBoLite(roleId);
        for (DelegateTypeBo delegate : roleDelegates) {
            if (!this.isDelegationPrimary(delegate.getDelegationType())) continue;
            primaryDelegate = delegate;
        }
        if (primaryDelegate == null) {
            primaryDelegate = new DelegateTypeBo();
            primaryDelegate.setRoleId(roleId);
            primaryDelegate.setDelegationType(DelegationType.PRIMARY);
            primaryDelegate.setKimTypeId(roleBo.getKimTypeId());
        }
        return primaryDelegate;
    }

    protected RoleMemberBo matchingMemberRecord(List<RoleMemberBo> roleMembers, String memberId, String memberTypeCode, Map<String, String> qualifier) {
        for (RoleMemberBo rm : roleMembers) {
            if (!this.doesMemberMatch(rm, memberId, memberTypeCode, qualifier)) continue;
            return rm;
        }
        return null;
    }

    protected boolean isDelegationPrimary(DelegationType delegationType) {
        return DelegationType.PRIMARY.equals((Object)delegationType);
    }

    protected boolean isDelegationSecondary(DelegationType delegationType) {
        return DelegationType.SECONDARY.equals((Object)delegationType);
    }

    private List<DelegateTypeBo> getRoleDelegations(String roleId) {
        if (roleId == null) {
            return new ArrayList<DelegateTypeBo>();
        }
        return this.getStoredDelegationImplsForRoleIds(Collections.singletonList(roleId));
    }

    protected RoleBo getRoleBoByName(String namespaceCode, String roleName) {
        if (StringUtils.isBlank((String)namespaceCode) || StringUtils.isBlank((String)roleName)) {
            return null;
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>(3);
        criteria.put("namespaceCode", namespaceCode);
        criteria.put("name", roleName);
        criteria.put("active", Boolean.TRUE);
        QueryResults results = this.getDataObjectService().findMatching(RoleBo.class, QueryByCriteria.Builder.andAttributes(criteria).build());
        if (results.getResults().isEmpty()) {
            return null;
        }
        if (results.getResults().size() > 1) {
            throw new NonUniqueResultException("Finding a role by name should return a unique role, but encountered multiple. namespaceCode='" + namespaceCode + "', name='" + roleName + "'");
        }
        return (RoleBo)((Object)results.getResults().get(0));
    }

    protected RoleBoLite getRoleBoLiteByName(String namespaceCode, String roleName) {
        if (StringUtils.isBlank((String)namespaceCode) || StringUtils.isBlank((String)roleName)) {
            return null;
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>(3);
        criteria.put("namespaceCode", namespaceCode);
        criteria.put("name", roleName);
        criteria.put("active", Boolean.TRUE);
        QueryResults results = this.getDataObjectService().findMatching(RoleBoLite.class, QueryByCriteria.Builder.andAttributes(criteria).build());
        if (results.getResults().isEmpty()) {
            return null;
        }
        if (results.getResults().size() > 1) {
            throw new NonUniqueResultException("Finding a role by name should return a unique role, but encountered multiple. namespaceCode='" + namespaceCode + "', name='" + roleName + "'");
        }
        return (RoleBoLite)((Object)results.getResults().get(0));
    }

    protected List<RoleMember> doAnyMemberRecordsMatchByExactQualifier(RoleEbo role, String memberId, RoleDaoAction daoActionToTake, Map<String, String> qualifier) {
        List<RoleMemberBo> roleMemberBos = this.getRoleMembersByExactQualifierMatch(role, memberId, daoActionToTake, qualifier);
        ArrayList<RoleMember> roleMembers = new ArrayList<RoleMember>();
        if (CollectionUtils.isNotEmpty(roleMemberBos)) {
            for (RoleMemberBo bo : roleMemberBos) {
                roleMembers.add(RoleMemberBo.to(bo));
            }
            return roleMembers;
        }
        return Collections.emptyList();
    }

    protected List<RoleMemberBo> getRoleMembersByExactQualifierMatch(RoleEbo role, String memberId, RoleDaoAction daoActionToTake, Map<String, String> qualifier) {
        List attributesForExactMatch;
        List<RoleMemberBo> rms = new ArrayList<RoleMemberBo>();
        RoleTypeService roleTypeService = this.getRoleTypeService(role.getId());
        if (roleTypeService != null && CollectionUtils.isNotEmpty((Collection)(attributesForExactMatch = roleTypeService.getQualifiersForExactMatch()))) {
            switch (daoActionToTake) {
                case ROLE_GROUPS_FOR_GROUP_IDS_AND_ROLE_IDS: {
                    rms = this.getStoredRoleGroupsForGroupIdsAndRoleIds(Collections.singletonList(role.getId()), Collections.singletonList(memberId), this.populateQualifiersForExactMatch(qualifier, attributesForExactMatch));
                    break;
                }
                case ROLE_PRINCIPALS_FOR_PRINCIPAL_ID_AND_ROLE_IDS: {
                    rms = this.getStoredRolePrincipalsForPrincipalIdAndRoleIds(Collections.singletonList(role.getId()), memberId, this.populateQualifiersForExactMatch(qualifier, attributesForExactMatch));
                    break;
                }
                case ROLE_MEMBERSHIPS_FOR_ROLE_IDS_AS_MEMBERS: {
                    List<RoleMemberBo> allRoleMembers = this.getStoredRoleMembershipsForRoleIdsAsMembers(Collections.singletonList(role.getId()), this.populateQualifiersForExactMatch(qualifier, attributesForExactMatch));
                    for (RoleMemberBo rm : allRoleMembers) {
                        if (!rm.getMemberId().equals(memberId)) continue;
                        rms.add(rm);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The 'daoActionToTake' parameter cannot refer to a non-role-member-related value!");
                }
            }
        }
        return rms;
    }

    protected RoleMember doAnyMemberRecordsMatch(List<RoleMemberBo> roleMembers, String memberId, String memberTypeCode, Map<String, String> qualifier) {
        for (RoleMemberBo rm : roleMembers) {
            if (!rm.isActive() || !this.doesMemberMatch(rm, memberId, memberTypeCode, qualifier)) continue;
            return RoleMemberBo.to(rm);
        }
        return null;
    }

    protected boolean doesMemberMatch(RoleMemberBo roleMember, String memberId, String memberTypeCode, Map<String, String> qualifier) {
        if (roleMember.getMemberId().equals(memberId) && roleMember.getType().getCode().equals(memberTypeCode)) {
            Map<String, String> roleQualifier = roleMember.getAttributes();
            if ((qualifier == null || qualifier.isEmpty()) && (roleQualifier == null || roleQualifier.isEmpty())) {
                return true;
            }
            if (qualifier != null && roleQualifier != null && qualifier.equals(roleQualifier)) {
                return true;
            }
        }
        return false;
    }

    protected RoleTypeService getRoleTypeService(String roleId) {
        KimType roleType;
        RoleBoLite roleBo = this.getRoleBoLite(roleId);
        if (roleBo != null && (roleType = KimTypeBo.to(roleBo.getKimRoleType())) != null) {
            return this.getRoleTypeService(roleType);
        }
        return KimImplServiceLocator.getDefaultRoleTypeService();
    }

    protected RoleTypeService getRoleTypeServiceByName(String serviceName) {
        try {
            KimTypeService service = (KimTypeService)GlobalResourceLoader.getService((QName)QName.valueOf(serviceName));
            if (service != null && service instanceof RoleTypeService) {
                return (RoleTypeService)service;
            }
            LOG.warn("Unable to find role type service by name: " + serviceName + ". Defaulting to: kimNoMembersRoleTypeService ");
            return (RoleTypeService)KimImplServiceLocator.getService("kimNoMembersRoleTypeService");
        }
        catch (Exception ex) {
            LOG.warn("Unable to find role type service by name: " + serviceName, (Throwable)ex);
            return (RoleTypeService)KimImplServiceLocator.getService("kimNoMembersRoleTypeService");
        }
    }

    protected RoleTypeService getRoleTypeService(KimType typeInfo) {
        String serviceName = typeInfo.getServiceName();
        if (serviceName != null) {
            try {
                KimTypeService service = (KimTypeService)GlobalResourceLoader.getService((QName)QName.valueOf(serviceName));
                if (service != null && service instanceof RoleTypeService) {
                    return (RoleTypeService)service;
                }
                LOG.warn("Unable to find role type service with name: " + serviceName + ". Defaulting to: kimNoMembersRoleTypeService ");
                return (RoleTypeService)KimImplServiceLocator.getService("kimNoMembersRoleTypeService");
            }
            catch (Exception ex) {
                LOG.error("Unable to find role type service with name: " + serviceName, (Throwable)ex);
                return (RoleTypeService)KimImplServiceLocator.getService("kimNoMembersRoleTypeService");
            }
        }
        return KimImplServiceLocator.getDefaultRoleTypeService();
    }

    protected Map<String, String> populateQualifiersForExactMatch(Map<String, String> defaultQualification, List<String> attributes) {
        HashMap<String, String> qualifiersForExactMatch = new HashMap<String, String>();
        if (defaultQualification != null && CollectionUtils.isNotEmpty(defaultQualification.keySet())) {
            for (String attributeName : attributes) {
                if (!StringUtils.isNotEmpty((String)defaultQualification.get(attributeName))) continue;
                qualifiersForExactMatch.put(attributeName, defaultQualification.get(attributeName));
            }
        }
        return qualifiersForExactMatch;
    }

    protected String getKimAttributeId(String kimTypeId, String attributeName) {
        Collection<KimAttributeBo> attributeData = this.getAttributeByName(attributeName);
        String kimAttributeId = null;
        if (CollectionUtils.isNotEmpty(attributeData)) {
            kimAttributeId = CollectionUtils.size(attributeData) == 1 ? attributeData.iterator().next().getId() : this.getCorrectAttributeId(kimTypeId, attributeName, attributeData);
        }
        return kimAttributeId;
    }

    protected Collection<KimAttributeBo> getAttributeByName(String attributeName) {
        QueryResults attributeData = this.getDataObjectService().findMatching(KimAttributeBo.class, QueryByCriteria.Builder.forAttribute((String)"attributeName", (Object)attributeName).build());
        return attributeData.getResults();
    }

    protected String getCorrectAttributeId(String kimTypeId, String attributeName, Collection<KimAttributeBo> attributeData) {
        KimType kimType = this.getKimTypeInfoService().getKimType(kimTypeId);
        String attribute = this.getAttributeFromKimType(kimType, attributeName);
        if (attribute != null) {
            return attribute;
        }
        return this.getAttributeFromNamespace(kimType, attributeName, attributeData);
    }

    protected String getAttributeFromKimType(KimType kimType, String attributeName) {
        if (kimType != null) {
            for (KimTypeAttribute attribute : kimType.getAttributeDefinitions()) {
                if (attribute.getKimAttribute() == null || !StringUtils.equals((String)attributeName, (String)attribute.getKimAttribute().getAttributeName())) continue;
                return attribute.getKimAttribute().getId();
            }
        }
        return null;
    }

    protected String getAttributeFromNamespace(KimType kimType, String attributeName, Collection<KimAttributeBo> attributes) {
        String appId = this.getAppIdFromNamespace(kimType.getNamespaceCode());
        String attributeId = this.getAttributeFromAppId(attributes, appId);
        if (attributeId == null && (attributeId = this.getAttributeFromAppId(attributes, "RICE")) == null) {
            attributeId = this.getAttributeFromAppId(attributes, "KUALI");
        }
        return attributeId;
    }

    protected String getAppIdFromNamespace(String namespaceCode) {
        Namespace appNamespace = this.getNamespaceService().getNamespace(namespaceCode);
        if (appNamespace == null) {
            throw new RuntimeException("Namespace " + namespaceCode + " not mapped in namespace table.");
        }
        return appNamespace.getApplicationId();
    }

    protected String getAttributeFromAppId(Collection<KimAttributeBo> attributes, String appId) {
        for (KimAttributeBo attribute : attributes) {
            if (!StringUtils.equalsIgnoreCase((String)this.getAppIdFromNamespace(attribute.getNamespaceCode()), (String)appId)) continue;
            return attribute.getId();
        }
        return null;
    }

    protected KimTypeInfoService getKimTypeInfoService() {
        if (this.kimTypeInfoService == null) {
            this.kimTypeInfoService = KimApiServiceLocator.getKimTypeInfoService();
        }
        return this.kimTypeInfoService;
    }

    protected NamespaceService getNamespaceService() {
        if (this.namespaceService == null) {
            this.namespaceService = CoreServiceApiServiceLocator.getNamespaceService();
        }
        return this.namespaceService;
    }

    protected IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = KimApiServiceLocator.getIdentityService();
        }
        return this.identityService;
    }

    protected GroupService getGroupService() {
        if (this.groupService == null) {
            this.groupService = KimApiServiceLocator.getGroupService();
        }
        return this.groupService;
    }

    protected ResponsibilityInternalService getResponsibilityInternalService() {
        if (this.responsibilityInternalService == null) {
            this.responsibilityInternalService = KimImplServiceLocator.getResponsibilityInternalService();
        }
        return this.responsibilityInternalService;
    }

    protected RoleDao getRoleDao() {
        return this.roleDao;
    }

    public void setRoleDao(RoleDao roleDao) {
        this.roleDao = roleDao;
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KradDataServiceLocator.getDataObjectService();
        }
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = CoreApiServiceLocator.getDateTimeService();
        }
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void notifyOnMemberRemoval(RoleMember member) {
        String serviceName;
        KimType roleType;
        RoleBoLite roleBo = this.getRoleBoLite(member.getRoleId());
        if (roleBo != null && (roleType = KimTypeBo.to(roleBo.getKimRoleType())) != null && (serviceName = roleType.getServiceName()) != null) {
            KimTypeService service = null;
            try {
                boolean validVersion = false;
                List serviceInfos = KsbApiServiceLocator.getServiceRegistry().getOnlineServicesByName(QName.valueOf(serviceName));
                for (ServiceInfo serviceInfo : serviceInfos) {
                    String version = serviceInfo.getServiceVersion();
                    if (!StringUtils.isNotBlank((String)version) || version.compareTo("2.1.2") < 0) continue;
                    validVersion = true;
                    break;
                }
                if (validVersion && (service = (KimTypeService)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(QName.valueOf(serviceName))) != null && service instanceof RoleTypeService) {
                    ((RoleTypeService)service).roleMemberRemoved(member);
                }
            }
            catch (Exception ex) {
                LOG.error("Unable to find role type service with name: " + serviceName, (Throwable)ex);
            }
        }
    }

    protected static enum RoleDaoAction {
        ROLE_PRINCIPALS_FOR_PRINCIPAL_ID_AND_ROLE_IDS,
        ROLE_GROUPS_FOR_GROUP_IDS_AND_ROLE_IDS,
        ROLE_MEMBERS_FOR_ROLE_IDS,
        ROLE_MEMBERSHIPS_FOR_ROLE_IDS_AS_MEMBERS,
        ROLE_MEMBERS_FOR_ROLE_IDS_WITH_FILTERS;

    }
}

