/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.model.ForeignKeyConstraint;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableIndex;
import net.sourceforge.schemaspy.model.xml.TableColumnMeta;

public class TableColumn {
    private final Table table;
    private final String name;
    private final Object id;
    private String typeName;
    private String shortTypeName;
    private Integer type;
    private final int length;
    private final int decimalDigits;
    private final String detailedSize;
    private final boolean isNullable;
    private boolean isAutoUpdated;
    private Boolean isUnique;
    private final Object defaultValue;
    private String comments;
    private final Map<TableColumn, ForeignKeyConstraint> parents = new HashMap<TableColumn, ForeignKeyConstraint>();
    private final Map<TableColumn, ForeignKeyConstraint> children = new TreeMap<TableColumn, ForeignKeyConstraint>(new ColumnComparator());
    private boolean allowImpliedParents = true;
    private boolean allowImpliedChildren = true;
    private boolean isExcluded = false;
    private boolean isAllExcluded = false;
    private static final Logger logger = Logger.getLogger(TableColumn.class.getName());
    private static final boolean finerEnabled = logger.isLoggable(Level.FINER);

    TableColumn(Table table, ResultSet resultSet) throws SQLException {
        this.table = table;
        String string = resultSet.getString("COLUMN_NAME");
        this.name = string == null ? null : string.intern();
        string = resultSet.getString("TYPE_NAME");
        this.typeName = string == null ? "unknown" : string.intern();
        this.type = resultSet.getInt("DATA_TYPE");
        this.decimalDigits = resultSet.getInt("DECIMAL_DIGITS");
        Number number = (Number)resultSet.getObject("BUFFER_LENGTH");
        this.length = number != null && number.shortValue() > 0 ? (int)number.shortValue() : resultSet.getInt("COLUMN_SIZE");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.length);
        if (this.decimalDigits > 0) {
            stringBuilder.append(',');
            stringBuilder.append(this.decimalDigits);
        }
        this.detailedSize = stringBuilder.toString();
        this.isNullable = resultSet.getInt("NULLABLE") == 1;
        this.defaultValue = resultSet.getString("COLUMN_DEF");
        this.setComments(resultSet.getString("REMARKS"));
        this.id = new Integer(resultSet.getInt("ORDINAL_POSITION") - 1);
        Pattern pattern = Config.getInstance().getIndirectColumnExclusions();
        Pattern pattern2 = Config.getInstance().getColumnExclusions();
        this.isAllExcluded = this.matches(pattern2);
        boolean bl = this.isExcluded = this.isAllExcluded || this.matches(pattern);
        if (this.isExcluded && finerEnabled) {
            logger.finer("Excluding column " + this.getTable() + "." + this.getName() + ": matches " + pattern2 + ":" + this.isAllExcluded + " " + pattern + ":" + this.matches(pattern));
        }
    }

    public TableColumn(Table table, TableColumnMeta tableColumnMeta) {
        this.table = table;
        this.name = tableColumnMeta.getName();
        this.id = tableColumnMeta.getId();
        this.typeName = tableColumnMeta.getType();
        this.length = tableColumnMeta.getSize();
        this.decimalDigits = tableColumnMeta.getDigits();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.length);
        if (this.decimalDigits > 0) {
            stringBuilder.append(',');
            stringBuilder.append(this.decimalDigits);
        }
        this.detailedSize = stringBuilder.toString();
        this.isNullable = tableColumnMeta.isNullable();
        this.isAutoUpdated = tableColumnMeta.isAutoUpdated();
        this.defaultValue = tableColumnMeta.getDefaultValue();
        this.comments = tableColumnMeta.getComments();
    }

    public Table getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public Object getId() {
        return this.id;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer n) {
        this.type = n;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public String getShortTypeName() {
        return this.shortTypeName == null ? this.typeName : this.shortTypeName;
    }

    public void setShortType(String string) {
        this.shortTypeName = string;
    }

    public int getLength() {
        return this.length;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public String getDetailedSize() {
        return this.detailedSize;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isAutoUpdated() {
        return this.isAutoUpdated;
    }

    public void setIsAutoUpdated(boolean bl) {
        this.isAutoUpdated = bl;
    }

    public boolean isUnique() {
        if (this.isUnique == null) {
            for (TableIndex tableIndex : this.table.getIndexes()) {
                List<TableColumn> list;
                if (!tableIndex.isUnique() || (list = tableIndex.getColumns()).size() != 1 || !list.contains(this)) continue;
                this.isUnique = true;
                break;
            }
            if (this.isUnique == null) {
                this.isUnique = this.table.getPrimaryColumns().size() == 1 && this.isPrimary();
            }
        }
        return this.isUnique;
    }

    public boolean isPrimary() {
        return this.table.getPrimaryColumns().contains(this);
    }

    public boolean isForeignKey() {
        return !this.parents.isEmpty();
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String string) {
        this.comments = string == null || string.trim().length() == 0 ? null : string.trim();
    }

    public boolean isExcluded() {
        return this.isExcluded;
    }

    public boolean isAllExcluded() {
        return this.isAllExcluded;
    }

    public void addParent(TableColumn tableColumn, ForeignKeyConstraint foreignKeyConstraint) {
        this.parents.put(tableColumn, foreignKeyConstraint);
        this.table.addedParent();
    }

    public void removeParent(TableColumn tableColumn) {
        this.parents.remove(tableColumn);
    }

    public void unlinkParents() {
        for (TableColumn tableColumn : this.parents.keySet()) {
            tableColumn.removeChild(this);
        }
        this.parents.clear();
    }

    public Set<TableColumn> getParents() {
        return this.parents.keySet();
    }

    public ForeignKeyConstraint getParentConstraint(TableColumn tableColumn) {
        return this.parents.get(tableColumn);
    }

    public ForeignKeyConstraint removeAParentFKConstraint() {
        Iterator<TableColumn> iterator = this.parents.keySet().iterator();
        if (iterator.hasNext()) {
            TableColumn tableColumn = iterator.next();
            ForeignKeyConstraint foreignKeyConstraint = this.parents.remove(tableColumn);
            tableColumn.removeChild(this);
            return foreignKeyConstraint;
        }
        return null;
    }

    public ForeignKeyConstraint removeAChildFKConstraint() {
        Iterator<TableColumn> iterator = this.children.keySet().iterator();
        if (iterator.hasNext()) {
            TableColumn tableColumn = iterator.next();
            ForeignKeyConstraint foreignKeyConstraint = this.children.remove(tableColumn);
            tableColumn.removeParent(this);
            return foreignKeyConstraint;
        }
        return null;
    }

    public void addChild(TableColumn tableColumn, ForeignKeyConstraint foreignKeyConstraint) {
        this.children.put(tableColumn, foreignKeyConstraint);
        this.table.addedChild();
    }

    public void removeChild(TableColumn tableColumn) {
        this.children.remove(tableColumn);
    }

    public void unlinkChildren() {
        for (TableColumn tableColumn : this.children.keySet()) {
            tableColumn.removeParent(this);
        }
        this.children.clear();
    }

    public Set<TableColumn> getChildren() {
        return this.children.keySet();
    }

    public ForeignKeyConstraint getChildConstraint(TableColumn tableColumn) {
        return this.children.get(tableColumn);
    }

    public boolean matches(Pattern pattern) {
        return pattern.matcher(this.getTable().getName() + "." + this.getName()).matches();
    }

    public void update(TableColumnMeta tableColumnMeta) {
        String string = tableColumnMeta.getComments();
        if (string != null) {
            this.setComments(string);
        }
        if (!this.isPrimary() && tableColumnMeta.isPrimary()) {
            this.table.setPrimaryColumn(this);
        }
        this.allowImpliedParents = !tableColumnMeta.isImpliedParentsDisabled();
        this.allowImpliedChildren = !tableColumnMeta.isImpliedChildrenDisabled();
        this.isExcluded |= tableColumnMeta.isExcluded();
        this.isAllExcluded |= tableColumnMeta.isAllExcluded();
    }

    public String toString() {
        return this.getName();
    }

    public boolean allowsImpliedParents() {
        return this.allowImpliedParents;
    }

    public boolean allowsImpliedChildren() {
        return this.allowImpliedChildren;
    }

    private class ColumnComparator
    implements Comparator<TableColumn> {
        private ColumnComparator() {
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            int n = tableColumn.getTable().compareTo(tableColumn2.getTable());
            if (n == 0) {
                n = tableColumn.getName().compareToIgnoreCase(tableColumn2.getName());
            }
            return n;
        }
    }
}

