/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.api.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.api.document.DocumentWorkflowUserDetails;
import org.kuali.coeus.common.api.document.DocumentWorkloadDetails;
import org.kuali.coeus.common.api.document.dto.ApproverDto;
import org.kuali.coeus.common.api.document.dto.DevelopmentProposalSummaryDto;
import org.kuali.coeus.common.api.document.dto.DocumentDetailsDto;
import org.kuali.coeus.common.api.document.dto.PagedResultsDto;
import org.kuali.coeus.common.api.document.service.WorkflowDetailsService;
import org.kuali.coeus.elasticsearch.ElasticsearchIndexService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.NotImplementedException;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.coeus.sys.framework.rest.UnprocessableEntityException;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KewDocHeaderDao;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.infrastructure.DocumentType;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationUnassociatedDetail;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.service.ActionRequestService;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.actiontaken.service.ActionTakenService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.document.search.DocumentSearchResult;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v1"})
@RestController(value="documentController")
public class DocumentController {
    private static final String DOCUMENT_NUMBER_ATTRIBUTE = "documentNumber";
    private static final String WORKLOAD_BALANCING_PRIORITY_STOP = "Workload_Balancing_Priority_Stop";
    private static final String SEPARATOR = ", ";
    @Autowired
    @Qualifier(value="actionTakenService")
    private ActionTakenService actionTakenService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="kewDocHeaderDao")
    private KewDocHeaderDao kewDocHeaderDao;
    @Autowired
    @Qualifier(value="personService")
    private PersonService personService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="groupService")
    private GroupService groupService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="actionRequestService")
    private ActionRequestService actionRequestService;
    @Autowired
    @Qualifier(value="workflowDetailsService")
    private WorkflowDetailsService workflowDetailsService;
    private ElasticsearchIndexService elasticsearchIndexService;
    private static final Logger LOG = LogManager.getLogger(DocumentController.class);

    @RequestMapping(method={RequestMethod.GET}, value={"/enroute-documents"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public PagedResultsDto<DocumentDetailsDto> documentsRoutingToUser(@RequestParam(value="user") String user, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="skip", required=false) Integer skip) {
        return this.getDocumentsRoutingForUser(user, limit, skip);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/workload-balancing-documents"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public PagedResultsDto<DevelopmentProposalSummaryDto> documentsAtWorkloadStop(@RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="skip", required=false) Integer skip) {
        return this.getDocumentsAtWorkloadBalancingStop(limit, skip);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/saved-documents"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public PagedResultsDto<DocumentDetailsDto> documentsSavedForUser(@RequestParam(value="user") String user, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="skip", required=false) Integer skip) {
        return this.documentSavedForUser(user, limit, skip);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/progress-documents"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public PagedResultsDto<DocumentDetailsDto> getDocumentsInProgressForUser(@RequestParam(value="user") String user, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="skip", required=false) Integer skip) {
        return this.documentsInProgressForUser(user, limit, skip);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/documents/{documentId}/approver"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public ApproverDto assignApprover(@RequestBody ApproverDto approverDto, @PathVariable String documentId) throws Exception {
        Document document = this.documentService.getByDocumentHeaderId(documentId);
        this.checkDocAndPerms(document);
        Person approver = this.getPerson(approverDto.getApproverId());
        DevelopmentProposal developmentProposal = ((ProposalDevelopmentDocument)document).getDevelopmentProposal();
        developmentProposal.setAssignerId(this.globalVariableService.getUserSession().getPrincipalId());
        developmentProposal.setApproverId(approverDto.getApproverId());
        this.dataObjectService.save((Object)developmentProposal, new PersistenceOption[0]);
        approverDto.setProposalNumber(developmentProposal.getProposalNumber());
        approverDto.setApproverName(approver.getName());
        return approverDto;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/documents/{documentId}/approver"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public void deleteApprover(@PathVariable String documentId) throws Exception {
        Document document = this.documentService.getByDocumentHeaderId(documentId);
        this.checkDocAndPerms(document);
        DevelopmentProposal developmentProposal = ((ProposalDevelopmentDocument)document).getDevelopmentProposal();
        developmentProposal.setApproverId(null);
        developmentProposal.setAssignerId(this.globalVariableService.getUserSession().getPrincipalId());
        this.dataObjectService.save((Object)developmentProposal, new PersistenceOption[0]);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/documents/{documentId}/approver"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public ApproverDto getApprover(@PathVariable String documentId) throws Exception {
        Document document = this.documentService.getByDocumentHeaderId(documentId);
        this.checkDocAndPerms(document);
        DevelopmentProposal developmentProposal = ((ProposalDevelopmentDocument)document).getDevelopmentProposal();
        ApproverDto approverDto = new ApproverDto();
        Person approver = this.personService.getPerson(developmentProposal.getApproverId());
        if (approver != null) {
            approverDto.setApproverName(approver != null ? approver.getName() : "");
            approverDto.setApproverId(approver.getPrincipalId());
        }
        approverDto.setProposalNumber(developmentProposal.getProposalNumber());
        return approverDto;
    }

    @PostMapping(value={"/generate-workflow-details"}, consumes={"application/json"}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public String generateAllWorkflowDetails() {
        this.checkAuthorizedToGenerateWorkflowDetails();
        this.workflowDetailsService.simulateWorkflowOnAllDocuments();
        return "Started workflow details generation job successfully.";
    }

    @PostMapping(value={"/generate-workflow-details/{documentId}"}, consumes={"application/json"}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public String generateDocumentWorkflowDetails(@PathVariable String documentId) throws Exception {
        if (StringUtils.isBlank((CharSequence)documentId)) {
            throw new IllegalArgumentException("Must provide a document ID.");
        }
        this.checkAuthorizedToGenerateWorkflowDetails();
        this.workflowDetailsService.generateDetailsFromSimulation(this.documentService.getByDocumentHeaderId(documentId));
        return String.format("Generated workflow details for document #%s", documentId);
    }

    @PostMapping(value={"/index-documents"}, consumes={"application/json"}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public String indexAllDocuments(@RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="skip", required=false) Integer skip) throws Exception {
        this.checkAuthorizedToIndexIntoElasticsearch();
        List<String> docIds = this.kewDocHeaderDao.getAllDocumentIds(limit, skip);
        this.getElasticsearchIndexService().bulkIndex(docIds);
        return String.format("Started indexing %s documents", docIds.size());
    }

    @PostMapping(value={"/index-documents/{documentId}"}, consumes={"application/json"}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public String indexDocument(@PathVariable String documentId) throws Exception {
        if (StringUtils.isBlank((CharSequence)documentId)) {
            throw new IllegalArgumentException("Must provide a document ID.");
        }
        this.checkAuthorizedToIndexIntoElasticsearch();
        if (!this.getElasticsearchIndexService().index(documentId).get().booleanValue()) {
            return String.format("Failed to index document %s", documentId);
        }
        return String.format("Indexed document %s into Elasticsearch", documentId);
    }

    protected void checkAuthorizedToIndexIntoElasticsearch() {
        String userId = this.globalVariableService.getUserSession().getPrincipalId();
        if (!this.permissionService.hasPermission(userId, "KC-SYS", "Index Elasticsearch Documents")) {
            String username = this.globalVariableService.getUserSession().getPrincipalName();
            throw new UnauthorizedAccessException("User " + username + " is not authorized to index documents into Elasticsearch");
        }
        if (!this.configurationService.getPropertyValueAsBoolean("elasticsearch.enabled")) {
            throw new UnsupportedOperationException("Elasticsearch indexing is disabled");
        }
    }

    protected void checkAuthorizedToGenerateWorkflowDetails() {
        String userId = this.globalVariableService.getUserSession().getPrincipalId();
        if (!this.permissionService.hasPermission(userId, "KC-SYS", "Generate Workflow Details")) {
            String username = this.globalVariableService.getUserSession().getPrincipalName();
            throw new UnauthorizedAccessException("User " + username + " is not authorized to generate workflow details");
        }
    }

    protected void checkDocAndPerms(Document document) throws WorkflowException {
        this.checkIfPersonHasPerms("KC-PD", "Assign Proposal Development Workload Approver");
        if (Objects.isNull(document) || !document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName().equalsIgnoreCase("ProposalDevelopmentDocument")) {
            throw new NotImplementedException("Approvers can only be assigned to Proposal Development Documents.");
        }
    }

    protected PagedResultsDto<DevelopmentProposalSummaryDto> getDocumentsAtWorkloadBalancingStop(Integer limit, Integer skip) {
        PagedResultsDto<DocumentWorkloadDetails> pagedResults = this.kewDocHeaderDao.getProposalsInWorkloadStop(this.getWorkloadBalancingStop(), limit, skip);
        List<DocumentWorkloadDetails> documentDetails = pagedResults.getResults();
        List<Object> documentList = new ArrayList();
        try {
            List<Document> documents = this.getAllDocuments(documentDetails.stream().map(DocumentWorkloadDetails::getDocumentNumber).collect(Collectors.toList()));
            documentList = documents.stream().map(document -> this.getDocumentSummary((Document)document, documentDetails)).collect(Collectors.toList());
        }
        catch (WorkflowException e) {
            LOG.error("An error occurred" + e);
            throw new UnprocessableEntityException("An error occurred " + e.getMessage());
        }
        return new PagedResultsDto<DevelopmentProposalSummaryDto>(documentList, pagedResults.getTotal());
    }

    protected String getWorkloadBalancingStop() {
        return this.parameterService.getParameterValueAsString("KC-PD", "Document", WORKLOAD_BALANCING_PRIORITY_STOP);
    }

    private DevelopmentProposalSummaryDto getDocumentSummary(Document document, List<DocumentWorkloadDetails> documentDetails) {
        List allPendingRequests = this.actionRequestService.findAllPendingRequests(document.getDocumentNumber());
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        DevelopmentProposal proposal = proposalDevelopmentDocument.getDevelopmentProposal();
        DevelopmentProposalSummaryDto developmentProposalSummaryDto = new DevelopmentProposalSummaryDto();
        developmentProposalSummaryDto.setProposalNumber(proposal.getProposalNumber());
        developmentProposalSummaryDto.setTitle(proposal.getTitle());
        if (proposal.getApproverId() != null) {
            Person approver = this.personService.getPerson(proposal.getApproverId());
            developmentProposalSummaryDto.setAssignedApprover(this.createApprover(approver));
        }
        String piName = Objects.isNull(proposal.getPrincipalInvestigator()) ? "" : proposal.getPrincipalInvestigator().getLastName() + SEPARATOR + proposal.getPrincipalInvestigator().getFirstName();
        developmentProposalSummaryDto.setPiName(piName);
        developmentProposalSummaryDto.setUnitNumber(proposal.getUnitNumber());
        developmentProposalSummaryDto.setSponsorName(proposal.getSponsorName());
        developmentProposalSummaryDto.setDocumentNumber(proposalDevelopmentDocument.getDocumentNumber());
        developmentProposalSummaryDto.setDueDate(proposal.getDeadlineDate() == null ? null : Long.valueOf(proposal.getDeadlineDate().getTime()));
        DocumentWorkloadDetails workloadDetails = documentDetails.stream().filter(documentWorkflowDetails -> documentWorkflowDetails.getDocumentNumber().equalsIgnoreCase(document.getDocumentNumber())).findFirst().get();
        developmentProposalSummaryDto.setStopNumber(workloadDetails.getCurrentPeopleFlowStop());
        developmentProposalSummaryDto.setLastActionTime(workloadDetails.getLastActionTime().getTime());
        this.setApprovers(allPendingRequests, developmentProposalSummaryDto);
        return developmentProposalSummaryDto;
    }

    private void setApprovers(List<ActionRequestValue> allPendingRequests, DevelopmentProposalSummaryDto developmentProposalSummaryDto) {
        try {
            this.checkIfPersonHasPerms("KC-PD", "Assign Proposal Development Workload Approver");
            developmentProposalSummaryDto.setAllApprovers(allPendingRequests.stream().filter(request -> !request.isRoleRequest()).flatMap(request -> request.isGroupRequest() ? this.getGroupMembers(request.getGroupId()).stream() : Stream.of(request.getPerson())).filter(Objects::nonNull).map(this::createApprover).collect(Collectors.toSet()));
        }
        catch (UnauthorizedAccessException e) {
            developmentProposalSummaryDto.setAllApprovers(Collections.emptySet());
        }
        developmentProposalSummaryDto.setPrimaryApproverName(allPendingRequests.stream().filter(ActionRequestValue::isRoleRequest).findFirst().map(ActionRequestValue::getQualifiedRoleNameLabel).orElse(allPendingRequests.stream().findFirst().map(this::getActionRequestLabel).orElse(null)));
    }

    protected Set<Person> getGroupMembers(String groupId) {
        return this.groupService.getMemberPrincipalIds(groupId).stream().map(this::getPerson).collect(Collectors.toSet());
    }

    protected ApproverDto createApprover(Person approver) {
        ApproverDto approverDto = new ApproverDto();
        approverDto.setApproverId(approver.getPrincipalId());
        approverDto.setApproverName(approver.getName());
        return approverDto;
    }

    protected String getActionRequestLabel(ActionRequestValue actionRequest) {
        if (actionRequest.isGroupRequest()) {
            return actionRequest.getGroupName();
        }
        if (actionRequest.getPerson() != null) {
            return this.getPersonName(actionRequest.getPerson());
        }
        return actionRequest.getAnnotation();
    }

    private String getPersonName(Person person) {
        return person.getLastName() + SEPARATOR + person.getFirstName();
    }

    private PagedResultsDto<DocumentDetailsDto> getDocumentsRoutingForUser(String routingToUser, Integer limit, Integer skip) {
        List documentList;
        this.checkAndRetrievePerson(routingToUser);
        PagedResultsDto<DocumentWorkflowUserDetails> results = this.kewDocHeaderDao.getWorkflowDetailsOfEnrouteProposalsForUser(routingToUser, limit, skip);
        List<DocumentWorkflowUserDetails> documentDetails = results.getResults();
        try {
            List<Document> documents = this.getAllDocuments(documentDetails.stream().map(DocumentWorkflowUserDetails::getDocumentNumber).collect(Collectors.toList()));
            documentList = documents.stream().map(document -> {
                DocumentDetailsDto detailsDto = this.getDocumentDetailsDto((Document)document);
                documentDetails.stream().filter(detail -> detail.getDocumentNumber().equals(document.getDocumentNumber())).findFirst().ifPresent(deets -> {
                    detailsDto.setStepsAway(deets.getSteps());
                    detailsDto.setDelegateType(deets.getDelegateType());
                });
                return detailsDto;
            }).collect(Collectors.toList());
        }
        catch (WorkflowException workflowException) {
            LOG.error("An error occurred" + workflowException);
            throw new UnprocessableEntityException("An error occurred " + workflowException.getMessage());
        }
        return new PagedResultsDto<DocumentDetailsDto>(documentList, results.getTotal());
    }

    protected PagedResultsDto<DocumentDetailsDto> documentsInProgressForUser(String inProgressForUser, Integer limit, Integer skip) {
        this.checkAndRetrievePerson(inProgressForUser);
        List inProgressDocuments = this.kewDocHeaderDao.getSavedDocuments(inProgressForUser, "ProposalDevelopmentDocument", limit, skip).stream().map(this::getDocumentDetailsDto).collect(Collectors.toList());
        return new PagedResultsDto<DocumentDetailsDto>(inProgressDocuments, inProgressDocuments.size());
    }

    protected PagedResultsDto<DocumentDetailsDto> documentSavedForUser(String savedForUser, Integer limit, Integer skip) {
        this.checkAndRetrievePerson(savedForUser);
        List savedDocuments = this.kewDocHeaderDao.getSavedDocuments(savedForUser, null, limit, skip).stream().map(this::getDocumentDetailsDto).collect(Collectors.toList());
        return new PagedResultsDto<DocumentDetailsDto>(savedDocuments, savedDocuments.size());
    }

    protected void checkIfPersonHasPerms(String namespaceCode, String permissionName) {
        String currentUser = this.globalVariableService.getUserSession().getPrincipalId();
        if (!this.permissionService.hasPermission(currentUser, namespaceCode, permissionName)) {
            throw new UnauthorizedAccessException("User " + currentUser + " is not authorized to assign approvers");
        }
    }

    protected Person checkAndRetrievePerson(String user) {
        Person person = this.getPerson(user);
        String currentUser = this.globalVariableService.getUserSession().getPrincipalId();
        if (!currentUser.equalsIgnoreCase(user)) {
            throw new UnauthorizedAccessException("User " + currentUser + " cannot view the documents of user " + user);
        }
        return person;
    }

    private Person getPerson(String user) {
        Person person = this.personService.getPerson(user);
        if (person == null) {
            throw new UnprocessableEntityException("Person with id " + user + " not found.");
        }
        return person;
    }

    private List<Document> getAllDocuments(List<String> documentNumbers) throws WorkflowException {
        return this.documentService.getDocumentsByListOfDocumentHeaderIds(ProposalDevelopmentDocument.class, documentNumbers);
    }

    private DocumentDetailsDto getDocumentDetailsDto(Document doc) {
        DocumentDetailsDto documentDetailsDto = new DocumentDetailsDto();
        documentDetailsDto.setDocumentTitle(doc.getDocumentTitle());
        documentDetailsDto.setDocumentNumber(doc.getDocumentNumber());
        WorkflowDocument workflowDocument = doc.getDocumentHeader().getWorkflowDocument();
        if (!Objects.isNull(workflowDocument)) {
            documentDetailsDto.setDocumentCreateDate(workflowDocument.getDateCreated().getMillis());
            workflowDocument.getActionsTaken().stream().max(Comparator.comparing(ActionTaken::getActionDate)).ifPresent(actionTaken -> {
                documentDetailsDto.setLastActionDate(actionTaken.getActionDate().getMillis());
                Person lastActionUser = this.getPerson(actionTaken.getPrincipalId());
                documentDetailsDto.setLastActionUser(lastActionUser.getName());
            });
            documentDetailsDto.setDocHandlerUrl(workflowDocument.getDocumentHandlerUrl());
            documentDetailsDto.setDocumentType(workflowDocument.getDocumentTypeName());
            this.populateDocumentSpecificFields(documentDetailsDto);
        }
        return documentDetailsDto;
    }

    private DocumentDetailsDto getDocumentDetailsDto(DocumentSearchResult doc) {
        DocumentDetailsDto documentDetailsDto = new DocumentDetailsDto();
        documentDetailsDto.setDocumentTitle(doc.getDocument().getTitle());
        documentDetailsDto.setDocumentNumber(doc.getDocument().getDocumentId());
        long formattedDate = doc.getDocument().getDateCreated().getMillis();
        documentDetailsDto.setDocumentCreateDate(formattedDate);
        this.actionTakenService.findByDocumentIdIgnoreCurrentInd(doc.getDocument().getDocumentId()).stream().max(Comparator.comparing(ActionTakenValue::getActionDate)).ifPresent(actionTaken -> {
            documentDetailsDto.setLastActionDate(actionTaken.getActionDate().getTime());
            Person lastActionUser = this.getPerson(actionTaken.getPrincipalId());
            documentDetailsDto.setLastActionUser(lastActionUser.getName());
        });
        documentDetailsDto.setDocHandlerUrl(doc.getDocument().getDocumentHandlerUrl());
        documentDetailsDto.setDocumentType(doc.getDocument().getDocumentTypeName());
        this.populateDocumentSpecificFields(documentDetailsDto);
        return documentDetailsDto;
    }

    private void populateDocumentSpecificFields(DocumentDetailsDto details) {
        String docNumber = details.getDocumentNumber();
        String docTypeName = details.getDocumentType();
        if (StringUtils.isBlank((CharSequence)docNumber) || StringUtils.isBlank((CharSequence)docTypeName)) {
            return;
        }
        DocumentType documentType = DocumentType.fromName(docTypeName);
        switch (documentType) {
            case PROPOSAL_DEVELOPMENT_DOCUMENT: {
                this.populateDevelopmentProposalFields(details, docNumber);
                break;
            }
            case INSTITUTIONAL_PROPOSAL_DOCUMENT: {
                this.populateInstitutionProposalFields(details, docNumber);
                break;
            }
            case AWARD_DOCUMENT: {
                this.populateAwardFields(details, docNumber);
                break;
            }
            case AWARD_BUDGET_DOCUMENT: {
                this.populateAwardBudgetFields(details, docNumber);
                break;
            }
            case SUBAWARD_DOCUMENT: {
                this.populateSubAwardFields(details, docNumber);
                break;
            }
            case NEGOTIATION_DOCUMENT: {
                this.populateNegotiationFields(details, docNumber);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Document Type: " + docTypeName);
            }
        }
    }

    private void populateDevelopmentProposalFields(DocumentDetailsDto details, String docNumber) {
        QueryByCriteria query = QueryByCriteria.Builder.forAttribute((String)"proposalDocument.documentNumber", (Object)docNumber).build();
        Optional<DevelopmentProposal> devProposal = Optional.ofNullable((DevelopmentProposal)this.dataObjectService.findUnique(DevelopmentProposal.class, query));
        devProposal.map(DevelopmentProposal::getPrincipalInvestigator).ifPresent(pi -> {
            details.setPiFirstName(pi.getFirstName());
            details.setPiLastName(pi.getLastName());
        });
        devProposal.map(DevelopmentProposal::getSponsor).ifPresent(details::setSponsor);
        devProposal.map(DevelopmentProposal::getDeadlineDate).map(Date::getTime).ifPresent(details::setDueDate);
        devProposal.map(DevelopmentProposal::getDeadlineTime).ifPresent(details::setDueTime);
    }

    private void populateInstitutionProposalFields(DocumentDetailsDto details, String docNumber) {
        Map<String, String> criteria = Collections.singletonMap("institutionalProposalDocument.documentNumber", docNumber);
        Optional<InstitutionalProposal> instProposal = Optional.ofNullable((InstitutionalProposal)this.businessObjectService.findByPrimaryKey(InstitutionalProposal.class, criteria));
        instProposal.map(InstitutionalProposal::getPrincipalInvestigator).map(InstitutionalProposalPerson::getLastName).ifPresent(details::setPiLastName);
        instProposal.map(InstitutionalProposal::getSponsor).ifPresent(details::setSponsor);
        instProposal.map(InstitutionalProposal::getDeadlineDate).map(Date::getTime).ifPresent(details::setDueDate);
        instProposal.map(InstitutionalProposal::getDeadlineTime).ifPresent(details::setDueTime);
    }

    private void populateAwardFields(DocumentDetailsDto details, String docNumber) {
        Map<String, String> criteria = Collections.singletonMap("awardDocument.documentNumber", docNumber);
        Optional<Award> award = Optional.ofNullable((Award)this.businessObjectService.findByPrimaryKey(Award.class, criteria));
        award.map(Award::getPrincipalInvestigator).ifPresent(pi -> {
            details.setPiFirstName(pi.getFirstName());
            details.setPiLastName(pi.getLastName());
        });
        award.map(Award::getSponsor).ifPresent(details::setSponsor);
    }

    private void populateAwardBudgetFields(DocumentDetailsDto details, String docNumber) {
        Map<String, String> criteria = Collections.singletonMap("awardBudgetDocument.documentNumber", docNumber);
        Optional<AwardBudgetExt> awardBudget = Optional.ofNullable((AwardBudgetExt)this.businessObjectService.findByPrimaryKey(AwardBudgetExt.class, criteria));
        awardBudget.map(AwardBudgetExt::getAward).map(Award::getPrincipalInvestigator).ifPresent(pi -> {
            details.setPiFirstName(pi.getFirstName());
            details.setPiLastName(pi.getLastName());
        });
        awardBudget.map(AwardBudgetExt::getAward).map(Award::getSponsor).ifPresent(details::setSponsor);
    }

    private void populateSubAwardFields(DocumentDetailsDto details, String docNumber) {
        Map<String, String> criteria = Collections.singletonMap("subAwardDocument.documentNumber", docNumber);
        Optional<SubAward> subaward = Optional.ofNullable((SubAward)this.businessObjectService.findByPrimaryKey(SubAward.class, criteria));
        subaward.map(SubAward::getRequisitioner).ifPresent(pi -> {
            details.setPiFirstName(pi.getFirstName());
            details.setPiLastName(pi.getLastName());
        });
        subaward.map(SubAward::getSponsorCode).ifPresent(details::setSponsorCode);
        subaward.map(SubAward::getSponsorName).ifPresent(details::setSponsorName);
    }

    private void populateNegotiationFields(DocumentDetailsDto details, String docNumber) {
        Map<String, String> criteria = Collections.singletonMap(DOCUMENT_NUMBER_ATTRIBUTE, docNumber);
        Optional<Negotiation> negotiation = Optional.ofNullable((Negotiation)this.businessObjectService.findByPrimaryKey(Negotiation.class, criteria));
        negotiation.map(Negotiation::getNegotiator).ifPresent(pi -> {
            details.setPiFirstName(pi.getFirstName());
            details.setPiLastName(pi.getLastName());
        });
        negotiation.map(Negotiation::getUnAssociatedDetail).map(NegotiationUnassociatedDetail::getSponsor).ifPresent(details::setSponsor);
    }

    public ElasticsearchIndexService getElasticsearchIndexService() {
        if (this.elasticsearchIndexService == null) {
            this.elasticsearchIndexService = KcServiceLocator.getService(ElasticsearchIndexService.class);
        }
        return this.elasticsearchIndexService;
    }
}

