/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.shortUrl;

import javax.servlet.http.HttpServletResponse;
import org.kuali.coeus.common.framework.shortUrl.ResourceNotFoundException;
import org.kuali.coeus.common.framework.shortUrl.ShortUrlService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller(value="shortUrlController")
public class ShortUrlController {
    public static final String REDIRECT = "redirect:";
    public static final String PROPOSAL_NUMBER = "proposal_number";
    public static final String EPS_PROPOSAL = "eps_proposal";
    public static final String AWARD = "award";
    public static final String AWARD_NUMBER = "award_number";
    public static final String PROPOSAL = "proposal";
    public static final String SUBAWARD = "subaward";
    public static final String NEGOTIATION = "negotiation";
    public static final String NEGOTIATION_ID = "negotiation_id";
    public static final String PROTOCOL = "protocol";
    public static final String PROTOCOL_NUMBER = "protocol_number";
    public static final String IACUC_PROTOCOL = "iacuc_protocol";
    public static final String COMMITTEE = "committee";
    public static final String COMMITTEE_ID = "committee_id";
    public static final String UNABLE_TO_RETRIEVE_DOCUMENT_FOR_ID = "Unable to retrieve document for id %s";
    public static final String SUBAWARD_CODE = "subaward_code";
    @Autowired
    @Qualifier(value="shortUrlService")
    private ShortUrlService shortUrlService;

    @Transactional
    @RequestMapping(value={"documents/{docId}"})
    public String documentShortUrl(@PathVariable String docId, HttpServletResponse response) throws Exception {
        try {
            return REDIRECT + this.getShortUrlService().constructUrl(docId);
        }
        catch (ResourceNotFoundException e) {
            response.sendError(404, "Unable to retrieve document Number " + docId);
            return null;
        }
    }

    @Transactional
    @RequestMapping(value={"development-proposals/{proposalNumber}"})
    public String propDevShortUrl(@PathVariable String proposalNumber, HttpServletResponse response) throws Exception {
        return this.redirect((id, table, column) -> this.getShortUrlService().constructUrl((String)id, (String)table, (String)column), proposalNumber, EPS_PROPOSAL, PROPOSAL_NUMBER, response);
    }

    @Transactional
    @RequestMapping(value={"awards/{awardNumber}"})
    public String awardShortUrl(@PathVariable String awardNumber, HttpServletResponse response) throws Exception {
        return this.redirect((id, table, column) -> this.getShortUrlService().constructUrlByVersionStatus((String)id, (String)table, (String)column), awardNumber, AWARD, AWARD_NUMBER, response);
    }

    @Transactional
    @RequestMapping(value={"proposals/{proposalNumber}"})
    public String proposalShortUrl(@PathVariable String proposalNumber, HttpServletResponse response) throws Exception {
        return this.redirect((id, table, column) -> this.getShortUrlService().constructUrlByVersionStatus((String)id, (String)table, (String)column), proposalNumber, PROPOSAL, PROPOSAL_NUMBER, response);
    }

    @Transactional
    @RequestMapping(value={"subawards/{subawardId}"})
    public String subawardShortUrl(@PathVariable String subawardId, HttpServletResponse response) throws Exception {
        return this.redirect((id, table, column) -> this.getShortUrlService().constructUrlByVersionHistory((String)id, (String)table, (String)column), subawardId, SUBAWARD, SUBAWARD_CODE, response);
    }

    @Transactional
    @RequestMapping(value={"negotiations/{negotiationId}"})
    public String negotiationShortUrl(@PathVariable String negotiationId, HttpServletResponse response) throws Exception {
        return this.redirect((id, table, column) -> this.getShortUrlService().constructUrl((String)id, (String)table, (String)column), negotiationId, NEGOTIATION, NEGOTIATION_ID, response);
    }

    @Transactional
    @RequestMapping(value={"irb-protocols/{protocolNumber}"})
    public String irbShortUrl(@PathVariable String protocolNumber, HttpServletResponse response) throws Exception {
        return this.redirect((id, table, column) -> this.getShortUrlService().constructUrl((String)id, (String)table, (String)column), protocolNumber, PROTOCOL, PROTOCOL_NUMBER, response);
    }

    @Transactional
    @RequestMapping(value={"iacuc-protocols/{protocolNumber}"})
    public String iacucShortUrl(@PathVariable String protocolNumber, HttpServletResponse response) throws Exception {
        return this.redirect((id, table, column) -> this.getShortUrlService().constructUrl((String)id, (String)table, (String)column), protocolNumber, IACUC_PROTOCOL, PROTOCOL_NUMBER, response);
    }

    @Transactional
    @RequestMapping(value={"committees/{committeeId}"})
    public String committeeShortUrl(@PathVariable String committeeId, HttpServletResponse response) throws Exception {
        return this.redirect((id, table, column) -> this.getShortUrlService().constructUrlByMaxSequenceNumber((String)id, (String)table, (String)column), committeeId, COMMITTEE, COMMITTEE_ID, response);
    }

    String redirect(ThreeParameterFunction<String, String, String, String> urlFunction, String id, String table, String column, HttpServletResponse response) throws Exception {
        try {
            return REDIRECT + urlFunction.apply(id, table, column);
        }
        catch (ResourceNotFoundException e) {
            response.sendError(404, String.format(UNABLE_TO_RETRIEVE_DOCUMENT_FOR_ID, id));
            return null;
        }
    }

    public ShortUrlService getShortUrlService() {
        return this.shortUrlService;
    }

    public void setShortUrlService(ShortUrlService shortUrlService) {
        this.shortUrlService = shortUrlService;
    }

    @FunctionalInterface
    static interface ThreeParameterFunction<A, B, C, D> {
        public D apply(A var1, B var2, C var3);
    }
}

