/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch.serializers;

import java.util.Set;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.elasticsearch.GrantsSearchDocument;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchDocumentSerializer;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.rice.krad.document.Document;

public class ElasticsearchDevelopmentProposalSerializer
extends ElasticsearchDocumentSerializer {
    @Override
    public GrantsSearchDocument translateDocument(Object doc) {
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)doc;
        DevelopmentProposal devProposal = document.getDevelopmentProposal();
        GrantsSearchDocument esDoc = new GrantsSearchDocument();
        this.setGenericDocumentFields(esDoc, (Document)document);
        esDoc.setPrimaryKey(devProposal.getProposalNumber());
        esDoc.setSequenceNumber(0);
        esDoc.setSequenceStatus(VersionStatus.ACTIVE.name());
        esDoc.setTypeCode(devProposal.getProposalTypeCode());
        esDoc.setTypeDescription(devProposal.getProposalType().getDescription());
        esDoc.setStartDate(devProposal.getRequestedStartDateInitial());
        esDoc.setEndDate(devProposal.getRequestedEndDateInitial());
        this.setCommonFields(esDoc, devProposal);
        return esDoc;
    }

    void setCommonFields(GrantsSearchDocument esDoc, DevelopmentProposal devProposal) {
        esDoc.addProposalNumber(devProposal.getProposalNumber());
        esDoc.setTitle(devProposal.getTitle());
        esDoc.setSponsorCode(devProposal.getSponsorCode());
        esDoc.setSponsorName(devProposal.getSponsorName());
        if (devProposal.getPrimeSponsor() != null) {
            esDoc.setPrimeSponsorCode(devProposal.getPrimeSponsorCode());
            esDoc.setPrimeSponsorName(devProposal.getPrimeSponsor().getSponsorName());
        }
        esDoc.setLeadUnitNumber(devProposal.getOwnedByUnitNumber());
        esDoc.setLeadUnitName(devProposal.getOwnedByUnitName());
        this.setDevProposalPersonFields(esDoc, devProposal);
        this.setPdSpecificFields(esDoc, devProposal);
    }

    protected void setDevProposalPersonFields(GrantsSearchDocument esDoc, DevelopmentProposal devProposal) {
        esDoc.setPrincipalInvestigatorName(devProposal.getPrincipalInvestigatorName());
        super.setPersonFields(esDoc, devProposal.getProposalPersons());
    }

    @Override
    public Set<String> getViewPermissions() {
        return Set.of("View Proposal");
    }

    @Override
    public boolean supports(Object document) {
        return document instanceof ProposalDevelopmentDocument;
    }
}

