/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.person;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.location.api.services.LocationApiServiceLocator;
import org.kuali.rice.location.api.state.State;
import org.kuali.rice.location.api.state.StateService;

public class KcStateValuesFinder
extends UifKeyValuesFinderBase {
    private static final long serialVersionUID = 3624265421997217342L;
    private StateService stateService;

    public List<KeyValue> getKeyValues(ViewModel model, InputField field) {
        ArrayList<KeyValue> labels = new ArrayList<KeyValue>();
        ProposalPerson person = (ProposalPerson)ObjectPropertyUtils.getPropertyValue((Object)model, (String)field.getBindingInfo().getBindByNamePrefix());
        List baseCodes = person == null || StringUtils.isEmpty((CharSequence)person.getCountryCode()) ? this.getStateService().findAllStatesInCountry("US") : this.getStateService().findAllStatesInCountryByAltCode(person.getCountryCode());
        ArrayList codes = new ArrayList(baseCodes);
        Collections.sort(codes, new Comparator<State>(){

            @Override
            public int compare(State o1, State o2) {
                int countryCompare = o1.getCountryCode().compareTo(o2.getCountryCode());
                if (countryCompare == 0) {
                    int stateCompare = o1.getName().compareTo(o2.getName());
                    return stateCompare;
                }
                return countryCompare;
            }
        });
        ArrayList<ConcreteKeyValue> newLabels = new ArrayList<ConcreteKeyValue>();
        newLabels.add(new ConcreteKeyValue("", ""));
        for (State state : codes) {
            if (!state.isActive()) continue;
            newLabels.add(new ConcreteKeyValue(state.getCode(), state.getCountryCode() + " - " + state.getName()));
        }
        labels = newLabels;
        this.clearInternalCache();
        return labels;
    }

    protected StateService getStateService() {
        if (this.stateService == null) {
            this.stateService = LocationApiServiceLocator.getStateService();
        }
        return this.stateService;
    }

    public void setStateService(StateService stateService) {
        this.stateService = stateService;
    }
}

