/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.Truth;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="s2SConfigurationService")
public class S2SConfigurationServiceImpl
implements S2SConfigurationService {
    private static final Logger LOG = LogManager.getLogger(S2SConfigurationServiceImpl.class);
    private static final Pattern PLACEHOLDER = Pattern.compile("@\\{#param\\((.*?)\\)\\}");
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;

    public String getValueAsString(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name is blank");
        }
        String config = this.parameterService.getParameterValueAsString("KC-S2S", "All", name);
        config = config != null ? this.replaceParameterPlaceholders(config) : this.configurationService.getPropertyValueAsString(name);
        return config;
    }

    public Boolean getValueAsBoolean(String name) {
        String val = this.getValueAsString(name);
        Boolean b = Truth.strToBooleanIgnoreCase((String)val);
        if (val != null && b == null) {
            LOG.warn("config: " + name + " with value: " + val + " is not a valid Boolean");
        }
        return b;
    }

    protected String replaceParameterPlaceholders(String parameterValue) {
        return this.replaceParameterPlaceholders(parameterValue, new HashSet<Parm>());
    }

    protected Parm extractParm(String params) {
        String[] ps = params.split(",");
        String namespace = ps[0].replace("'", "").replace("\"", "").trim();
        String component = ps[1].replace("'", "").replace("\"", "").trim();
        String name = ps[2].replace("'", "").replace("\"", "").trim();
        return new Parm(namespace, component, name);
    }

    protected void detectCycles(Set<Parm> current, Set<Parm> processed, String parameterValue, String replacedParameterValue) {
        for (Parm p : current) {
            if (processed.contains(p)) {
                throw new IllegalStateException("Parameter value contains cycle " + parameterValue);
            }
            processed.add(p);
        }
        for (Parm p : current) {
            if (!StringUtils.isNotBlank((CharSequence)p.namespace) || !StringUtils.isNotBlank((CharSequence)p.component) || !StringUtils.isNotBlank((CharSequence)p.name) || !parameterValue.equals(replacedParameterValue)) continue;
            throw new IllegalStateException("Parameter value contains a direct cycle " + parameterValue);
        }
    }

    protected String replaceParameterValues(Set<Parm> current, String parameterValue) {
        String replacedParameterValue = parameterValue;
        Matcher placeholderMatcher = PLACEHOLDER.matcher(replacedParameterValue);
        while (placeholderMatcher.find()) {
            String placeholder = placeholderMatcher.group(0);
            String params = placeholderMatcher.group(1);
            Parm p = this.extractParm(params);
            current.add(p);
            if (StringUtils.isNotBlank((CharSequence)p.namespace) && StringUtils.isNotBlank((CharSequence)p.component) & StringUtils.isNotBlank((CharSequence)p.name)) {
                String value = this.parameterService.getParameterValueAsString(p.namespace, p.component, p.name);
                replacedParameterValue = replacedParameterValue.replace(placeholder, value != null ? value : "");
                continue;
            }
            LOG.warn("Parameter value contains an invalid reference to another parameter " + parameterValue);
        }
        return replacedParameterValue;
    }

    protected String replaceParameterPlaceholders(String parameterValue, Set<Parm> processed) {
        HashSet<Parm> current = new HashSet<Parm>();
        String replacedParameterValue = this.replaceParameterValues(current, parameterValue);
        this.detectCycles(current, processed, parameterValue, replacedParameterValue);
        if (!parameterValue.equals(replacedParameterValue)) {
            return this.replaceParameterPlaceholders(replacedParameterValue, processed);
        }
        return replacedParameterValue;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public List<String> getValuesFromCommaSeparatedParam(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name is blank");
        }
        String value = this.getValueAsString(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return new ArrayList<String>();
        }
        String[] valuesAsStringArray = value.split(",");
        return Arrays.asList(valuesAsStringArray);
    }

    protected static final class Parm {
        private final String namespace;
        private final String component;
        private final String name;

        public Parm(String namespace, String component, String name) {
            this.namespace = namespace;
            this.component = component;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parm parm = (Parm)o;
            if (this.component != null ? !this.component.equals(parm.component) : parm.component != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(parm.name) : parm.name != null) {
                return false;
            }
            return !(this.namespace != null ? !this.namespace.equals(parm.namespace) : parm.namespace != null);
        }

        public int hashCode() {
            int result = this.namespace != null ? this.namespace.hashCode() : 0;
            result = 31 * result + (this.component != null ? this.component.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Parm{namespace='" + this.namespace + "', component='" + this.component + "', name='" + this.name + "'}";
        }
    }
}

