/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.copy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.SystemAuthorizationService;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.copy.ProtocolCopyService;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentPersonnelBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.noteattachment.ProtocolNotepadBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.protocol.ProtocolNumberServiceBase;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class ProtocolCopyServiceImplBase<GenericProtocolDocument extends ProtocolDocumentBase>
implements ProtocolCopyService<GenericProtocolDocument> {
    private static final String PROTOCOL_CREATED = "ProtocolBase created";
    private static final String CUSTOM_ATTRIBUTE = "customAttribute";
    private DocumentService documentService;
    private SystemAuthorizationService systemAuthorizationService;
    private KcAuthorizationService kraAuthorizationService;
    private KcPersonService kcPersonService;
    private SequenceAccessorService sequenceAccessorService;
    private RoleService roleService;

    @Override
    public GenericProtocolDocument copyProtocol(GenericProtocolDocument srcDoc) throws Exception {
        return this.copyProtocol(srcDoc, this.getProtocolNumberServiceHook().generateProtocolNumber(), false);
    }

    public GenericProtocolDocument copyProtocol(GenericProtocolDocument srcDoc, String protocolNumber, boolean isAmendmentRenewal) throws Exception {
        GenericProtocolDocument newDoc = this.createNewProtocol(srcDoc, protocolNumber, isAmendmentRenewal);
        this.initializeAuthorization(srcDoc, newDoc);
        return newDoc;
    }

    protected GenericProtocolDocument createNewProtocol(GenericProtocolDocument srcDoc, String protocolNumber, boolean isAmendmentRenewal) throws Exception {
        ProtocolDocumentBase newDoc = (ProtocolDocumentBase)this.getDocumentService().getNewDocument(srcDoc.getClass());
        newDoc.getProtocol().setProtocolNumber(protocolNumber);
        newDoc.getProtocol().setSequenceNumber(0);
        newDoc.getDocumentHeader().setDocumentTemplateNumber(srcDoc.getDocumentNumber());
        Long nextProtocolId = this.sequenceAccessorService.getNextAvailableSequenceNumber(this.getSequenceNumberNameHook(), newDoc.getProtocol().getClass());
        newDoc.getProtocol().setProtocolId(nextProtocolId);
        this.copyOverviewProperties(srcDoc, newDoc);
        this.copyRequiredProperties(srcDoc, newDoc);
        this.copyAdditionalProperties(srcDoc, newDoc);
        this.copyProtocolLists(srcDoc, newDoc);
        if (isAmendmentRenewal && !((ProtocolDocumentBase)srcDoc).getProtocol().isAmendment()) {
            this.removeDeletedAttachment(newDoc.getProtocol());
        }
        this.copyCustomDataAttributeValues(srcDoc, newDoc);
        ProtocolActionBase protocolAction = this.getProtocolActionNewInstanceHook(newDoc.getProtocol(), null, this.getProtocolActionProtocolCreatedCodeHook());
        protocolAction.setComments(PROTOCOL_CREATED);
        newDoc.getProtocol().getProtocolActions().add(protocolAction);
        if (!isAmendmentRenewal) {
            newDoc.getProtocol().setAttachmentProtocols(new ArrayList<ProtocolAttachmentProtocolBase>());
            newDoc.getProtocol().setNotepads(new ArrayList<ProtocolNotepadBase>());
            if (newDoc.getProtocol().getProtocolPersons() != null) {
                for (ProtocolPersonBase person : newDoc.getProtocol().getProtocolPersons()) {
                    person.setAttachmentPersonnels(new ArrayList<ProtocolAttachmentPersonnelBase>());
                }
            }
        } else {
            this.initPersonAttachments(newDoc.getProtocol());
        }
        return (GenericProtocolDocument)newDoc;
    }

    private void removeDeletedAttachment(ProtocolBase protocol) {
        ArrayList<Integer> documentIds = new ArrayList<Integer>();
        ArrayList<ProtocolAttachmentProtocolBase> attachments = new ArrayList<ProtocolAttachmentProtocolBase>();
        for (ProtocolAttachmentProtocolBase attachment : protocol.getAttachmentProtocols()) {
            attachment.setProtocol(protocol);
            if (!"3".equals(attachment.getDocumentStatusCode())) continue;
            documentIds.add(attachment.getDocumentId());
        }
        if (!documentIds.isEmpty()) {
            for (ProtocolAttachmentProtocolBase attachment : protocol.getAttachmentProtocols()) {
                attachment.setProtocol(protocol);
                if (documentIds.contains(attachment.getDocumentId())) continue;
                attachments.add(attachment);
            }
            protocol.setAttachmentProtocols(attachments);
        }
    }

    private void initPersonId(ProtocolBase protocol) {
        for (ProtocolPersonBase person : protocol.getProtocolPersons()) {
            Integer nextPersonId = this.sequenceAccessorService.getNextAvailableSequenceNumber(this.getSequenceNumberNameHook(), person.getClass()).intValue();
            person.setProtocolPersonId(nextPersonId);
        }
    }

    private void initPersonAttachments(ProtocolBase protocol) {
        for (ProtocolPersonBase person : protocol.getProtocolPersons()) {
            for (ProtocolAttachmentPersonnelBase attachment : person.getAttachmentPersonnels()) {
                attachment.setPersonId(person.getProtocolPersonId());
            }
        }
    }

    protected void copyOverviewProperties(GenericProtocolDocument src, GenericProtocolDocument dest) {
        DocumentHeader srcHdr = src.getDocumentHeader();
        DocumentHeader destHdr = dest.getDocumentHeader();
        destHdr.setDocumentDescription(srcHdr.getDocumentDescription());
        destHdr.setExplanation(srcHdr.getExplanation());
        destHdr.setOrganizationDocumentNumber(srcHdr.getOrganizationDocumentNumber());
    }

    protected void copyRequiredProperties(GenericProtocolDocument srcDoc, GenericProtocolDocument destDoc) {
        destDoc.getDocumentHeader().setDocumentDescription(srcDoc.getDocumentHeader().getDocumentDescription());
        ((ProtocolDocumentBase)destDoc).getProtocol().setProtocolTypeCode(((ProtocolDocumentBase)srcDoc).getProtocol().getProtocolTypeCode());
        ((ProtocolDocumentBase)destDoc).getProtocol().setTitle(((ProtocolDocumentBase)srcDoc).getProtocol().getTitle());
        ((ProtocolDocumentBase)destDoc).getProtocol().setLeadUnitNumber(((ProtocolDocumentBase)srcDoc).getProtocol().getLeadUnitNumber());
        ((ProtocolDocumentBase)destDoc).getProtocol().setPrincipalInvestigatorId(((ProtocolDocumentBase)srcDoc).getProtocol().getPrincipalInvestigatorId());
    }

    protected void copyAdditionalProperties(GenericProtocolDocument srcDoc, GenericProtocolDocument destDoc) {
        ((ProtocolDocumentBase)destDoc).getProtocol().setFdaApplicationNumber(((ProtocolDocumentBase)srcDoc).getProtocol().getFdaApplicationNumber());
        ((ProtocolDocumentBase)destDoc).getProtocol().setReferenceNumber1(((ProtocolDocumentBase)srcDoc).getProtocol().getReferenceNumber1());
        ((ProtocolDocumentBase)destDoc).getProtocol().setReferenceNumber2(((ProtocolDocumentBase)srcDoc).getProtocol().getReferenceNumber2());
        ((ProtocolDocumentBase)destDoc).getProtocol().setDescription(((ProtocolDocumentBase)srcDoc).getProtocol().getDescription());
        ((ProtocolDocumentBase)destDoc).getProtocol().setCorrespondentIndicator(((ProtocolDocumentBase)srcDoc).getProtocol().getCorrespondentIndicator());
        ((ProtocolDocumentBase)destDoc).getProtocol().setFundingSourceIndicator(((ProtocolDocumentBase)srcDoc).getProtocol().getFundingSourceIndicator());
        ((ProtocolDocumentBase)destDoc).getProtocol().setKeyStudyPersonIndicator(((ProtocolDocumentBase)srcDoc).getProtocol().getKeyStudyPersonIndicator());
        ((ProtocolDocumentBase)destDoc).getProtocol().setRelatedProjectsIndicator(((ProtocolDocumentBase)srcDoc).getProtocol().getRelatedProjectsIndicator());
        ((ProtocolDocumentBase)destDoc).getProtocol().setReferenceIndicator(((ProtocolDocumentBase)srcDoc).getProtocol().getReferenceIndicator());
        ((ProtocolDocumentBase)destDoc).getProtocol().setSpecialReviewIndicator(((ProtocolDocumentBase)srcDoc).getProtocol().getSpecialReviewIndicator());
    }

    protected void initializeAuthorization(GenericProtocolDocument srcDoc, GenericProtocolDocument destDoc) {
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        this.kraAuthorizationService.addDocumentLevelRole(userId, this.getProtocolAggregatorHook(), ((ProtocolDocumentBase)destDoc).getProtocol());
        this.kraAuthorizationService.addDocumentLevelRole(userId, this.getProtocolApproverHook(), ((ProtocolDocumentBase)destDoc).getProtocol());
        List<Role> roles = this.systemAuthorizationService.getRoles(this.getProtocolRoleTypeHook());
        for (Role role : roles) {
            if (this.getRoleService().isDerivedRole(role.getId())) continue;
            List<String> users = this.kraAuthorizationService.getPrincipalsInRole(role.getName(), ((ProtocolDocumentBase)srcDoc).getProtocol());
            ArrayList<KcPerson> persons = new ArrayList<KcPerson>();
            for (String uid : users) {
                KcPerson person = this.kcPersonService.getKcPersonByPersonId(uid);
                if (person == null || !person.getActive().booleanValue()) continue;
                persons.add(person);
            }
            for (KcPerson person : persons) {
                if (StringUtils.equals((CharSequence)person.getPersonId(), (CharSequence)userId)) continue;
                this.kraAuthorizationService.addDocumentLevelRole(person.getPersonId(), role.getName(), ((ProtocolDocumentBase)destDoc).getProtocol());
            }
        }
    }

    protected void copyProtocolLists(GenericProtocolDocument srcDoc, GenericProtocolDocument destDoc) {
        ProtocolBase srcProtocol = ((ProtocolDocumentBase)srcDoc).getProtocol();
        ProtocolBase destProtocol = ((ProtocolDocumentBase)destDoc).getProtocol();
        destProtocol.setProtocolResearchAreas(this.deepCopy(srcProtocol.getProtocolResearchAreas()));
        destProtocol.setProtocolReferences(this.deepCopy(srcProtocol.getProtocolReferences()));
        destProtocol.setProtocolLocations(this.deepCopy(srcProtocol.getProtocolLocations()));
        destProtocol.setProtocolFundingSources(this.deepCopy(srcProtocol.getProtocolFundingSources()));
        destProtocol.setProtocolPersons(this.deepCopy(srcProtocol.getProtocolPersons()));
        destProtocol.setSpecialReviews(this.deepCopy(srcProtocol.getSpecialReviews()));
        destProtocol.cleanupSpecialReviews(srcProtocol);
        destProtocol.setAttachmentProtocols(this.deepCopy(srcProtocol.getAttachmentProtocols()));
        destProtocol.setNotepads(this.deepCopy(srcProtocol.getNotepads()));
        this.initPersonId(destProtocol);
    }

    protected <T> T deepCopy(T obj) {
        if (obj instanceof Serializable) {
            return (T)ObjectUtils.deepCopy((Serializable)((Serializable)obj));
        }
        return obj;
    }

    protected void copyCustomDataAttributeValues(GenericProtocolDocument srcProtocolDocument, GenericProtocolDocument destProtocolDocument) {
        ((ProtocolDocumentBase)destProtocolDocument).initialize();
        for (Map.Entry<String, CustomAttributeDocument> entry : ((KcTransactionalDocumentBase)destProtocolDocument).getCustomAttributeDocuments().entrySet()) {
            CustomAttributeDocument cad = ((KcTransactionalDocumentBase)srcProtocolDocument).getCustomAttributeDocuments().get(entry.getKey());
            if (!ObjectUtils.isNotNull((Object)cad)) continue;
            if (ObjectUtils.isNull((Object)cad.getCustomAttribute())) {
                cad.refreshReferenceObject(CUSTOM_ATTRIBUTE);
            }
            entry.getValue().getCustomAttribute().setValue(cad.getCustomAttribute().getValue());
        }
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    protected abstract Class<? extends ProtocolActionBase> getProtocolActionBOClassHook();

    protected abstract String getProtocolActionProtocolCreatedCodeHook();

    protected abstract String getSequenceNumberNameHook();

    protected abstract ProtocolNumberServiceBase getProtocolNumberServiceHook();

    protected abstract ProtocolActionBase getProtocolActionNewInstanceHook(ProtocolBase var1, ProtocolSubmissionBase var2, String var3);

    protected abstract String getProtocolAggregatorHook();

    protected abstract String getProtocolApproverHook();

    protected abstract String getProtocolRoleTypeHook();

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public RoleService getRoleService() {
        return this.roleService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setSystemAuthorizationService(SystemAuthorizationService systemAuthorizationService) {
        this.systemAuthorizationService = systemAuthorizationService;
    }

    public void setKraAuthorizationService(KcAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    public SystemAuthorizationService getSystemAuthorizationService() {
        return this.systemAuthorizationService;
    }

    public KcAuthorizationService getKraAuthorizationService() {
        return this.kraAuthorizationService;
    }

    public SequenceAccessorService getSequenceAccessorService() {
        return this.sequenceAccessorService;
    }
}

