/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.print;

import com.lowagie.text.Image;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.print.watermark.Font;
import org.kuali.coeus.common.framework.print.watermark.Watermark;
import org.kuali.coeus.common.framework.print.watermark.WatermarkBean;
import org.kuali.coeus.common.framework.print.watermark.WatermarkConstants;
import org.kuali.coeus.common.framework.print.watermark.Watermarkable;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.notification.ProtocolNotificationRendererBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class ProtocolPrintWatermarkBase
implements Watermarkable {
    private KcPersistableBusinessObjectBase persistableBusinessObject;
    private static final Logger LOG = LogManager.getLogger(ProtocolPrintWatermarkBase.class);
    private static final String INVALID_WATERMARK_CODE = "-1";
    private WatermarkBean watermarkBean;

    private BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    @Override
    public WatermarkBean getWatermark() {
        ProtocolBase protocol = (ProtocolBase)this.getPersistableBusinessObject();
        String protocolStatusCode = protocol.getProtocolStatusCode();
        if (protocolStatusCode != null) {
            WatermarkBean waterMarkBean = null;
            try {
                waterMarkBean = this.getProtocolWatermarkBeanObject(protocolStatusCode);
            }
            catch (Exception e) {
                LOG.error("Exception Occurred in (ProtocolPrintWatermarkBase) :", (Throwable)e);
            }
            return waterMarkBean;
        }
        return null;
    }

    @Override
    public WatermarkBean getInvalidWatermark() {
        String watermarkStatusCode = INVALID_WATERMARK_CODE;
        WatermarkBean waterMarkBean = null;
        try {
            waterMarkBean = this.getProtocolWatermarkBeanObject(watermarkStatusCode);
        }
        catch (Exception e) {
            LOG.error("Exception Occurred in (ProtocolPrintWatermarkBase) :", (Throwable)e);
        }
        return waterMarkBean;
    }

    public WatermarkBean getProtocolWatermarkBeanObject(String protocolStatusCode) {
        WatermarkBean watermarkBean = new WatermarkBean();
        Watermark watermark = null;
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("statusCode", protocolStatusCode);
        if (this.getPersistableBusinessObject() instanceof Protocol) {
            fields.put("groupName", "IRB");
        } else if (this.getPersistableBusinessObject() instanceof IacucProtocol) {
            fields.put("groupName", "IACUC");
        }
        Collection watermarks = this.getBusinessObjectService().findMatching(Watermark.class, fields);
        if (watermarks != null && watermarks.size() > 0) {
            watermark = (Watermark)watermarks.iterator().next();
        }
        if (watermark != null && watermark.isWatermarkStatus()) {
            try {
                String watermarkFontSize = watermark.getFontSize() == null ? "25" : watermark.getFontSize();
                String watermarkFontColour = watermark.getFontColor() == null ? "FONT-COLOR" : watermark.getFontColor();
                watermarkBean.setType(watermark.getWatermarkType() == null ? "TEXT" : watermark.getWatermarkType());
                watermarkBean.setPosition(watermark.getWatermarkPosition() == null ? "HEADER" : watermark.getWatermarkPosition());
                String watermarkPositionFontSize = watermark.getPositionFontSize() == null ? "25" : watermark.getPositionFontSize();
                watermarkBean.setAlignment(watermark.getWatermarkAlignment() == null ? "CENTER" : watermark.getWatermarkAlignment());
                watermarkBean.setFont(this.getWatermarkFont("FONT", watermarkFontSize, watermarkFontColour));
                watermarkBean.setPositionFont(this.getWatermarkPositionFont("FONT", watermarkPositionFontSize, watermarkFontColour));
                ProtocolNotificationRendererBase renderer = this.getNewProtocolNotificationRendererInstanceHook((ProtocolBase)this.getPersistableBusinessObject());
                if (watermark.getWatermarkText() != null) {
                    watermarkBean.setText(renderer.render(watermark.getWatermarkText()));
                }
                if (watermarkBean.getType().equals("IMAGE")) {
                    watermarkBean.setText(watermark.getFileName());
                    byte[] imageData = watermark.getAttachmentContent();
                    if (imageData != null) {
                        Image imageFile = Image.getInstance((byte[])imageData);
                        watermarkBean.setFileImage(imageFile);
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Exception Occurred in (ProtocolPrintWatermarkBase) :", (Throwable)e);
            }
            return watermarkBean;
        }
        return null;
    }

    protected abstract ProtocolNotificationRendererBase getNewProtocolNotificationRendererInstanceHook(ProtocolBase var1);

    private Font getWatermarkFont(String watermarkFontName, String watermarkSize, String watermarkColour) {
        Font watermarkFont = new Font(25);
        watermarkFont.setFont(watermarkFontName);
        if (StringUtils.isNotBlank((CharSequence)watermarkSize)) {
            try {
                watermarkFont.setSize(Integer.parseInt(watermarkSize));
            }
            catch (NumberFormatException numberFormatException) {
                watermarkFont.setSize(50);
                LOG.error("Exception Occurring in ProtocolPrintWatermarkBase:(getFont:numberFormatException)");
            }
        } else {
            watermarkFont.setSize(50);
        }
        if (StringUtils.isNotBlank((CharSequence)watermarkColour)) {
            watermarkFont.setColor(watermarkColour);
        } else {
            watermarkFont.setColor(WatermarkConstants.DEFAULT_WATERMARK_COLOR);
        }
        return watermarkFont;
    }

    private Font getWatermarkPositionFont(String watermarkFontName, String watermarkSize, String watermarkColour) {
        Font watermarkFont = new Font(25);
        watermarkFont.setFont(watermarkFontName);
        if (StringUtils.isNotBlank((CharSequence)watermarkSize)) {
            try {
                watermarkFont.setSize(Integer.parseInt(watermarkSize));
            }
            catch (NumberFormatException numberFormatException) {
                watermarkFont.setSize(50);
                LOG.error("Exception Occurring in ProtocolPrintWatermarkBase:(getFont:numberFormatException)");
            }
        } else {
            watermarkFont.setSize(50);
        }
        if (StringUtils.isNotBlank((CharSequence)watermarkColour)) {
            watermarkFont.setColor(watermarkColour);
        } else {
            watermarkFont.setColor(WatermarkConstants.DEFAULT_WATERMARK_COLOR);
        }
        return watermarkFont;
    }

    public WatermarkBean getWatermarkBean() {
        return this.watermarkBean;
    }

    public void setWatermarkBean(WatermarkBean watermarkBean) {
        this.watermarkBean = watermarkBean;
    }

    public KcPersistableBusinessObjectBase getPersistableBusinessObject() {
        return this.persistableBusinessObject;
    }

    public void setPersistableBusinessObject(KcPersistableBusinessObjectBase persistableBusinessObject) {
        this.persistableBusinessObject = persistableBusinessObject;
    }
}

