/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.CounterRequest;
import net.bull.javamelody.internal.model.CounterRequestAggregation;
import net.bull.javamelody.internal.model.Period;
import net.bull.javamelody.internal.model.Range;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;
import net.bull.javamelody.internal.web.html.HtmlCounterErrorReport;
import net.bull.javamelody.internal.web.html.HtmlCounterRequestGraphReport;

public class HtmlCounterReport
extends HtmlAbstractReport {
    private static final Pattern SQL_KEYWORDS_PATTERN = Pattern.compile("\\b(select|from|where|order by|group by|update|delete|insert into|values)\\b", 2);
    private final Counter counter;
    private final Range range;
    private final CounterRequestAggregation counterRequestAggregation;
    private final HtmlCounterRequestGraphReport htmlCounterRequestGraphReport;
    private final DecimalFormat systemErrorFormat = I18N.createPercentFormat();
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();

    HtmlCounterReport(Counter counter, Range range, Writer writer) {
        super(writer);
        assert (counter != null);
        assert (range != null);
        this.counter = counter;
        this.range = range;
        this.counterRequestAggregation = new CounterRequestAggregation(counter);
        this.htmlCounterRequestGraphReport = new HtmlCounterRequestGraphReport(range, writer);
    }

    @Override
    void toHtml() throws IOException {
        List<CounterRequest> requests = this.counterRequestAggregation.getRequests();
        if (requests.isEmpty()) {
            this.writeNoRequests();
            return;
        }
        String counterName = this.counter.getName();
        CounterRequest globalRequest = this.counterRequestAggregation.getGlobalRequest();
        if (this.isErrorAndNotJobCounter()) {
            assert (!requests.isEmpty());
            List<CounterRequest> summaryRequest = Collections.singletonList(requests.get(0));
            this.writeRequests(counterName, this.counter.getChildCounterName(), summaryRequest, false, true, false);
        } else {
            List<CounterRequest> summaryRequests = Arrays.asList(globalRequest, this.counterRequestAggregation.getWarningRequest(), this.counterRequestAggregation.getSevereRequest());
            this.writeRequests(globalRequest.getName(), this.counter.getChildCounterName(), summaryRequests, false, false, false);
        }
        this.writeSizeAndLinks(requests, globalRequest);
        this.writeln("<div id='details" + counterName + "' style='display: none;'>");
        this.writeRequests(counterName, this.counter.getChildCounterName(), requests, HtmlCounterReport.isRequestGraphDisplayed(this.counter), true, false);
        this.writeln("</div>");
        if (this.isErrorCounter()) {
            this.writeln("<div id='logs" + counterName + "' style='display: none;'><div>");
            new HtmlCounterErrorReport(this.counter, this.getWriter()).toHtml();
            this.writeln("</div></div>");
        }
    }

    private void writeSizeAndLinks(List<CounterRequest> requests, CounterRequest globalRequest) throws IOException {
        long end = this.range.getEndDate() != null ? Math.min(this.range.getEndDate().getTime(), System.currentTimeMillis()) : System.currentTimeMillis();
        long deltaMillis = Math.max(end - this.counter.getStartDate().getTime(), 1L);
        long hitsParMinute = 60000L * globalRequest.getHits() / deltaMillis;
        this.writeln("<div align='right'>");
        String nbKey = this.isJobCounter() ? "nb_jobs" : (this.isErrorCounter() ? "nb_erreurs" : "nb_requetes");
        this.writeln(HtmlCounterReport.getFormattedString(nbKey, this.integerFormat.format(hitsParMinute), this.integerFormat.format(requests.size())));
        String separator = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        if (this.counter.isBusinessFacadeCounter()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeln("<a href='?part=counterSummaryPerClass&amp;counter=" + this.counter.getName() + "' class='noPrint'>#Resume_par_classe#</a>");
            if (HtmlCounterReport.isPdfEnabled()) {
                this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                this.writeln("<a href='?part=runtimeDependencies&amp;format=pdf&amp;counter=" + this.counter.getName() + "' class='noPrint'>#Dependencies#</a>");
            }
        }
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeShowHideLink("details" + this.counter.getName(), "#Details#");
        if (this.isErrorCounter()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeShowHideLink("logs" + this.counter.getName(), "#Dernieres_erreurs#");
        }
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        if (this.range.getPeriod() == Period.TOUT) {
            this.writeln("<a href='?action=clear_counter&amp;counter=" + this.counter.getName() + HtmlCounterReport.getCsrfTokenUrlPart() + "' title='" + HtmlCounterReport.getFormattedString("Vider_stats", this.counter.getName()) + '\'');
            this.writeln("class='noPrint' onclick=\"javascript:return confirm('" + HtmlCounterReport.javascriptEncode(HtmlCounterReport.getFormattedString("confirm_vider_stats", this.counter.getName())) + "');\">#Reinitialiser#</a>");
        }
        this.writeln("</div>");
    }

    private void writeNoRequests() throws IOException {
        if (this.isJobCounter()) {
            this.writeln("#Aucun_job#");
        } else if (this.isErrorCounter()) {
            this.writeln("#Aucune_erreur#");
        } else {
            this.writeln("#Aucune_requete#");
        }
    }

    private boolean isErrorCounter() {
        return this.counter.isErrorCounter();
    }

    private boolean isJobCounter() {
        return this.counter.isJobCounter();
    }

    private boolean isErrorAndNotJobCounter() {
        return this.isErrorCounter() && !this.isJobCounter();
    }

    public static boolean isRequestGraphDisplayed(Counter parentCounter) {
        return (!parentCounter.isErrorCounter() || parentCounter.isJobCounter()) && !parentCounter.isJspOrStrutsCounter();
    }

    void writeRequestsAggregatedOrFilteredByClassName(String requestId) throws IOException {
        List<CounterRequest> requestList = this.counterRequestAggregation.getRequestsAggregatedOrFilteredByClassName(requestId);
        boolean includeSummaryPerClassLink = requestId == null;
        boolean includeDetailLink = !includeSummaryPerClassLink;
        this.writeRequests(this.counter.getName(), this.counter.getChildCounterName(), requestList, includeDetailLink, includeDetailLink, includeSummaryPerClassLink);
    }

    private void writeRequests(String tableName, String childCounterName, List<CounterRequest> requestList, boolean includeGraph, boolean includeDetailLink, boolean includeSummaryPerClassLink) throws IOException {
        assert (requestList != null);
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable();
        table.beginTable(tableName);
        this.writeTableHead(childCounterName);
        for (CounterRequest request : requestList) {
            table.nextRow();
            this.writeRequest(request, includeGraph, includeDetailLink, includeSummaryPerClassLink);
        }
        table.endTable();
    }

    private void writeTableHead(String childCounterName) throws IOException {
        if (this.isJobCounter()) {
            this.write("<th>#Job#</th>");
        } else if (this.isErrorCounter()) {
            this.write("<th>#Erreur#</th>");
        } else {
            this.write("<th>#Requete#</th>");
        }
        if (this.counterRequestAggregation.isTimesDisplayed()) {
            this.write("<th class='sorttable_numeric'>#temps_cumule#</th>");
            this.write("<th class='sorttable_numeric'>#Hits#</th>");
            this.write("<th class='sorttable_numeric'>#Temps_moyen#</th>");
            this.write("<th class='sorttable_numeric'>#Temps_max#</th>");
            this.write("<th class='sorttable_numeric'>#Ecart_type#</th>");
        } else {
            this.write("<th class='sorttable_numeric'>#Hits#</th>");
        }
        if (this.counterRequestAggregation.isCpuTimesDisplayed()) {
            this.write("<th class='sorttable_numeric'>#temps_cpu_cumule#</th>");
            this.write("<th class='sorttable_numeric'>#Temps_cpu_moyen#</th>");
        }
        if (this.counterRequestAggregation.isAllocatedKBytesDisplayed()) {
            this.write("<th class='sorttable_numeric'>#Ko_alloues_moyens#</th>");
        }
        if (!this.isErrorAndNotJobCounter()) {
            this.write("<th class='sorttable_numeric'>#erreur_systeme#</th>");
        }
        if (this.counterRequestAggregation.isResponseSizeDisplayed()) {
            this.write("<th class='sorttable_numeric'>#Taille_moyenne#</th>");
        }
        if (this.counterRequestAggregation.isChildHitsDisplayed()) {
            this.write("<th class='sorttable_numeric'>" + HtmlCounterReport.getFormattedString("hits_fils_moyens", childCounterName));
            this.write("</th><th class='sorttable_numeric'>" + HtmlCounterReport.getFormattedString("temps_fils_moyen", childCounterName) + "</th>");
        }
    }

    private void writeRequest(CounterRequest request, boolean includeGraph, boolean includeDetailLink, boolean includeSummaryPerClassLink) throws IOException {
        String nextColumn = "</td> <td align='right'>";
        this.write("<td class='wrappedText'>");
        this.writeRequestName(request.getId(), request.getName(), includeGraph, includeDetailLink, includeSummaryPerClassLink);
        CounterRequest globalRequest = this.counterRequestAggregation.getGlobalRequest();
        if (this.counterRequestAggregation.isTimesDisplayed()) {
            this.write("</td> <td align='right'>");
            this.writePercentage(request.getDurationsSum(), globalRequest.getDurationsSum());
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(request.getHits()));
            this.write("</td> <td align='right'>");
            int mean = request.getMean();
            this.write("<span class='");
            this.write(this.getSlaHtmlClass(mean));
            this.write("'>");
            this.write(this.integerFormat.format(mean));
            this.write("</span>");
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(request.getMaximum()));
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(request.getStandardDeviation()));
        } else {
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(request.getHits()));
        }
        if (this.counterRequestAggregation.isCpuTimesDisplayed()) {
            this.write("</td> <td align='right'>");
            this.writePercentage(request.getCpuTimeSum(), globalRequest.getCpuTimeSum());
            this.write("</td> <td align='right'>");
            int cpuTimeMean = request.getCpuTimeMean();
            this.write("<span class='");
            this.write(this.getSlaHtmlClass(cpuTimeMean));
            this.write("'>");
            this.write(this.integerFormat.format(cpuTimeMean));
            this.write("</span>");
        }
        if (this.counterRequestAggregation.isAllocatedKBytesDisplayed()) {
            this.write("</td> <td align='right'>");
            int allocatedKBytesMean = request.getAllocatedKBytesMean();
            this.write(this.integerFormat.format(allocatedKBytesMean));
        }
        if (!this.isErrorAndNotJobCounter()) {
            this.write("</td> <td align='right'>");
            this.write(this.systemErrorFormat.format(request.getSystemErrorPercentage()));
        }
        if (this.counterRequestAggregation.isResponseSizeDisplayed()) {
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(request.getResponseSizeMean() / 1024));
        }
        if (this.counterRequestAggregation.isChildHitsDisplayed()) {
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(request.getChildHitsMean()));
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(request.getChildDurationsMean()));
        }
        this.write("</td>");
    }

    void writeRequestName(String requestId, String requestName, boolean includeGraph, boolean includeDetailLink, boolean includeSummaryPerClassLink) throws IOException {
        if (includeGraph) {
            assert (includeDetailLink);
            assert (!includeSummaryPerClassLink);
            this.htmlCounterRequestGraphReport.writeRequestGraph(requestId, requestName);
        } else if (includeDetailLink) {
            assert (!includeSummaryPerClassLink);
            this.write("<a href='?part=graph&amp;graph=");
            this.write(requestId);
            this.write("'>");
            this.writeDirectly(HtmlCounterReport.htmlEncodeRequestName(requestId, requestName));
            this.write("</a>");
        } else if (includeSummaryPerClassLink) {
            this.write("<a href='?part=counterSummaryPerClass&amp;counter=");
            this.write(this.counter.getName());
            this.write("&amp;graph=");
            this.write(requestId);
            this.write("'>");
            this.writeDirectly(HtmlCounterReport.htmlEncodeRequestName(requestId, requestName));
            this.write("</a> ");
        } else {
            this.writeDirectly(HtmlCounterReport.htmlEncodeRequestName(requestId, requestName));
        }
    }

    String getSlaHtmlClass(int mean) {
        String color = mean < this.counterRequestAggregation.getWarningThreshold() || mean == 0 ? "info" : (mean < this.counterRequestAggregation.getSevereThreshold() ? "warning" : "severe");
        return color;
    }

    private void writePercentage(long dividende, long diviseur) throws IOException {
        if (diviseur == 0L) {
            this.write("0");
        } else {
            this.write(this.integerFormat.format(100L * dividende / diviseur));
        }
    }

    static String htmlEncodeRequestName(String requestId, String requestName) {
        if (requestId.startsWith("sql")) {
            String htmlEncoded = HtmlCounterReport.htmlEncodeButNotSpace(requestName);
            return SQL_KEYWORDS_PATTERN.matcher(htmlEncoded).replaceAll("<span class='sqlKeyword'>$1</span>");
        }
        return HtmlCounterReport.htmlEncodeButNotSpace(requestName);
    }
}

