/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.SpringContext;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.common.InputOutput;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.CacheInformations;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.model.CollectorServer;
import net.bull.javamelody.internal.model.ConnectionInformations;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.CounterRequestContext;
import net.bull.javamelody.internal.model.DatabaseInformations;
import net.bull.javamelody.internal.model.HeapHistogram;
import net.bull.javamelody.internal.model.HsErrPid;
import net.bull.javamelody.internal.model.JavaInformations;
import net.bull.javamelody.internal.model.JndiBinding;
import net.bull.javamelody.internal.model.MBeanNode;
import net.bull.javamelody.internal.model.MavenArtifact;
import net.bull.javamelody.internal.model.Period;
import net.bull.javamelody.internal.model.ProcessInformations;
import net.bull.javamelody.internal.model.Range;
import net.bull.javamelody.internal.model.SamplingProfiler;
import net.bull.javamelody.internal.model.SessionInformations;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;
import net.bull.javamelody.internal.web.html.HtmlCacheInformationsReport;
import net.bull.javamelody.internal.web.html.HtmlConnectionInformationsReport;
import net.bull.javamelody.internal.web.html.HtmlCoreReport;
import net.bull.javamelody.internal.web.html.HtmlCounterRequestGraphReport;
import net.bull.javamelody.internal.web.html.HtmlDatabaseInformationsReport;
import net.bull.javamelody.internal.web.html.HtmlDependenciesReport;
import net.bull.javamelody.internal.web.html.HtmlHeapHistogramReport;
import net.bull.javamelody.internal.web.html.HtmlHotspotsReport;
import net.bull.javamelody.internal.web.html.HtmlHsErrPidReport;
import net.bull.javamelody.internal.web.html.HtmlJndiTreeReport;
import net.bull.javamelody.internal.web.html.HtmlMBeansReport;
import net.bull.javamelody.internal.web.html.HtmlProcessInformationsReport;
import net.bull.javamelody.internal.web.html.HtmlSessionInformationsReport;
import net.bull.javamelody.internal.web.html.HtmlSourceReport;
import net.bull.javamelody.internal.web.html.HtmlSpringContextReport;

public class HtmlReport
extends HtmlAbstractReport {
    private static final String SCRIPT_BEGIN = "<script type='text/javascript'>";
    private static final String SCRIPT_END = "</script>";
    private static final URL THEMED_MONITORING_CSS = HtmlReport.class.getResource("/net/bull/javamelody/resource/themedMonitoring.css");
    private static final URL THEMED_MONITORING_JS = HtmlReport.class.getResource("/net/bull/javamelody/resource/themedMonitoring.js");
    private final Collector collector;
    private final CollectorServer collectorServer;
    private final List<JavaInformations> javaInformationsList;
    private final Range range;
    private final HtmlCoreReport htmlCoreReport;

    public HtmlReport(Collector collector, CollectorServer collectorServer, List<JavaInformations> javaInformationsList, Range range, Writer writer) {
        super(writer);
        assert (collector != null);
        assert (javaInformationsList != null && !javaInformationsList.isEmpty());
        assert (range != null);
        this.collector = collector;
        this.collectorServer = collectorServer;
        this.javaInformationsList = javaInformationsList;
        this.range = range;
        this.htmlCoreReport = new HtmlCoreReport(collector, collectorServer, javaInformationsList, range, writer);
    }

    public HtmlReport(Collector collector, CollectorServer collectorServer, List<JavaInformations> javaInformationsList, Period period, Writer writer) {
        this(collector, collectorServer, javaInformationsList, period.getRange(), writer);
    }

    @Override
    void toHtml() throws IOException {
        this.writeHtmlHeader();
        this.htmlCoreReport.toHtml();
        this.writeHtmlFooter();
    }

    public void toHtml(String message, String anchorNameForRedirect) throws IOException {
        this.writeHtmlHeader();
        this.htmlCoreReport.toHtml(message, anchorNameForRedirect);
        this.writeHtmlFooter();
    }

    public void writeLastShutdown() throws IOException {
        this.writeHtmlHeader(false, true);
        this.htmlCoreReport.toHtml(null, null);
        this.writeHtmlFooter();
    }

    public static void writeAddAndRemoveApplicationLinks(String currentApplication, Writer writer) throws IOException {
        HtmlCoreReport.writeAddAndRemoveApplicationLinks(currentApplication, writer);
    }

    public void writeAllCurrentRequestsAsPart() throws IOException {
        Map<JavaInformations, List<CounterRequestContext>> currentRequests;
        this.writeHtmlHeader();
        List<Counter> counters = this.collector.getRangeCountersToBeDisplayed(this.range);
        if (this.collectorServer == null) {
            assert (this.javaInformationsList.size() == 1);
            JavaInformations javaInformations = this.javaInformationsList.get(0);
            List<CounterRequestContext> rootCurrentContexts = this.collector.getRootCurrentContexts(counters);
            currentRequests = Collections.singletonMap(javaInformations, rootCurrentContexts);
        } else {
            currentRequests = this.collectorServer.collectCurrentRequests(this.collector.getApplication());
            ArrayList<CounterRequestContext> allCurrentRequests = new ArrayList<CounterRequestContext>();
            for (List<CounterRequestContext> rootCurrentContexts : currentRequests.values()) {
                allCurrentRequests.addAll(rootCurrentContexts);
            }
            CounterRequestContext.replaceParentCounters(allCurrentRequests, counters);
        }
        this.htmlCoreReport.writeAllCurrentRequestsAsPart(currentRequests);
        this.writeHtmlFooter();
    }

    public void writeAllThreadsAsPart() throws IOException {
        this.writeHtmlHeader();
        this.htmlCoreReport.writeAllThreadsAsPart();
        this.writeHtmlFooter();
    }

    public void writeThreadsDump() throws IOException {
        this.htmlCoreReport.writeThreadsDump();
    }

    public void writeCounterSummaryPerClass(String counterName, String requestId) throws IOException {
        this.writeHtmlHeader();
        this.htmlCoreReport.writeCounterSummaryPerClass(counterName, requestId);
        this.writeHtmlFooter();
    }

    public void writeSource(String className) throws IOException {
        assert (className != null);
        this.writeHtmlHeader();
        new HtmlSourceReport(className, this.getWriter()).toHtml();
        this.writeHtmlFooter();
    }

    public void writeDependencies() throws IOException {
        this.writeHtmlHeader();
        Map<String, MavenArtifact> dependencies = MavenArtifact.getWebappDependencies();
        new HtmlDependenciesReport(dependencies, this.getWriter()).toHtml();
        this.writeHtmlFooter();
    }

    public void writeSpringContext() throws IOException {
        this.writeHtmlHeader();
        SpringContext springContext = SpringContext.getSingleton();
        new HtmlSpringContextReport(springContext, this.getWriter()).toHtml();
        this.writeHtmlFooter();
    }

    public void writeHtmlHeader() throws IOException {
        this.writeHtmlHeader(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHtmlHeader(boolean includeSlider, boolean includeCssInline) throws IOException {
        this.writeln("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        this.writeDirectly("<html lang='" + I18N.getCurrentLocale().getLanguage() + "'><head><title>" + HtmlReport.getFormattedString("Monitoring_sur", this.collector.getApplication()) + "</title>");
        this.writeln("");
        if (includeCssInline) {
            this.writeln("<style type='text/css'>");
            InputStream in = this.getClass().getResourceAsStream(Parameters.getResourcePath("monitoring.css"));
            try {
                String monitoringCss = InputOutput.pumpToString(in, Charset.forName("UTF-8"));
                this.writeDirectly(monitoringCss);
            }
            finally {
                in.close();
            }
            this.writeln("</style>");
        } else {
            this.writeln("<link rel='stylesheet' href='?resource=monitoring.css' type='text/css'/>");
            if (THEMED_MONITORING_CSS != null) {
                this.writeln("<link rel='stylesheet' href='?resource=themedMonitoring.css' type='text/css'/>");
            }
            this.writeln("<link rel='stylesheet' href='?resource=customizableMonitoring.css' type='text/css'/>");
        }
        this.writeln("<link type='image/png' rel='shortcut icon' href='?resource=systemmonitor.png' />");
        this.writeln("<script type='text/javascript' src='?resource=resizable_tables.js'></script>");
        this.writeln("<script type='text/javascript' src='?resource=sorttable.js'></script>");
        this.writeln("<script type='text/javascript' src='?resource=prototype.js'></script>");
        this.writeln("<script type='text/javascript' src='?resource=effects.js'></script>");
        this.writeln("<script type='text/javascript' src='?resource=lightwindow.js'></script>");
        if (includeSlider) {
            this.writeln("<script type='text/javascript' src='?resource=slider.js'></script>");
        }
        if (THEMED_MONITORING_JS != null) {
            this.writeln("<script type='text/javascript' src='?resource=themedMonitoring.js'></script>");
        }
        this.writeln("<script type='text/javascript' src='?resource=customizableMonitoring.js'></script>");
        this.writeJavaScript();
        this.writeln("</head><body>");
    }

    public void writeHtmlFooter() throws IOException {
        String analyticsId = Parameter.ANALYTICS_ID.getValue();
        if (analyticsId != null && !"disabled".equals(analyticsId)) {
            this.writeDirectly(SCRIPT_BEGIN);
            this.writeDirectly("var gaJsHost = (('https:' == document.location.protocol) ? 'https://ssl.' : 'http://www.');\n");
            this.writeDirectly("document.write(unescape(\"%3Cscript src='\" + gaJsHost + \"google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E\"));\n");
            this.writeDirectly(SCRIPT_END);
            this.writeDirectly(SCRIPT_BEGIN);
            this.writeDirectly(" try{\n");
            this.writeDirectly("var pageTracker = _gat._getTracker('" + analyticsId + "');\n");
            this.writeDirectly("pageTracker._trackPageview();\n");
            this.writeDirectly("} catch(err) {}\n");
            this.writeDirectly(SCRIPT_END);
            this.writeDirectly("\n");
        }
        this.writeln("</body></html>");
    }

    private void writeJavaScript() throws IOException {
        this.writeln(SCRIPT_BEGIN);
        this.writeln("function showHide(id){");
        this.writeln("  if (document.getElementById(id).style.display=='none') {");
        this.writeln("    if (document.getElementById(id + 'Img') != null) {");
        this.writeln("      document.getElementById(id + 'Img').src='?resource=bullets/minus.png';");
        this.writeln("    }");
        this.writeln("    try {");
        this.writeln("      Effect.SlideDown(id, { duration: 0.5 });");
        this.writeln("    } catch (e) {");
        this.writeln("      document.getElementById(id).style.display='inline';");
        this.writeln("    }");
        this.writeln("  } else {");
        this.writeln("    if (document.getElementById(id + 'Img') != null) {");
        this.writeln("      document.getElementById(id + 'Img').src='?resource=bullets/plus.png';");
        this.writeln("    }");
        this.writeln("    try {");
        this.writeln("      Effect.SlideUp(id, { duration: 0.5 });");
        this.writeln("    } catch (e) {");
        this.writeln("      document.getElementById(id).style.display='none';");
        this.writeln("    }");
        this.writeln("  }");
        this.writeln("}");
        this.writeln(SCRIPT_END);
    }

    public void writeMessageIfNotNull(String message, String partToRedirectTo) throws IOException {
        this.htmlCoreReport.writeMessageIfNotNull(message, partToRedirectTo, null);
    }

    public void writeRequestAndGraphDetail(String graphName) throws IOException {
        this.writeHtmlHeader(true, false);
        this.writeln("<div align='center'>");
        this.htmlCoreReport.writeRefreshAndPeriodLinks(graphName, "graph");
        this.writeln("</div>");
        new HtmlCounterRequestGraphReport(this.range, this.getWriter()).writeRequestAndGraphDetail(this.collector, this.collectorServer, graphName);
        this.writeHtmlFooter();
    }

    public void writeRequestUsages(String graphName) throws IOException {
        this.writeHtmlHeader(true, false);
        this.writeln("<div align='center'>");
        this.htmlCoreReport.writeRefreshAndPeriodLinks(graphName, "usages");
        this.writeln("</div>");
        new HtmlCounterRequestGraphReport(this.range, this.getWriter()).writeRequestUsages(this.collector, graphName);
        this.writeHtmlFooter();
    }

    public void writeSessions(List<SessionInformations> sessionsInformations, String message, String sessionsPart) throws IOException {
        assert (sessionsInformations != null);
        this.writeHtmlHeader();
        this.writeMessageIfNotNull(message, sessionsPart);
        new HtmlSessionInformationsReport(sessionsInformations, this.getWriter()).toHtml();
        this.writeHtmlFooter();
    }

    public void writeSessionDetail(String sessionId, SessionInformations sessionInformations) throws IOException {
        assert (sessionId != null);
        this.writeHtmlHeader();
        new HtmlSessionInformationsReport(null, this.getWriter()).writeSessionDetails(sessionId, sessionInformations);
        this.writeHtmlFooter();
    }

    public void writeHotspots(List<SamplingProfiler.SampledMethod> hotspots) throws IOException {
        this.writeHtmlHeader();
        new HtmlHotspotsReport(hotspots, this.getWriter()).toHtml();
        this.writeHtmlFooter();
    }

    public void writeHeapHistogram(HeapHistogram heapHistogram, String message, String heapHistoPart) throws IOException {
        assert (heapHistogram != null);
        this.writeHtmlHeader();
        this.writeMessageIfNotNull(message, heapHistoPart);
        new HtmlHeapHistogramReport(heapHistogram, this.getWriter()).toHtml();
        this.writeHtmlFooter();
    }

    public void writeProcesses(List<ProcessInformations> processInformationsList) throws IOException {
        assert (processInformationsList != null);
        this.writeHtmlHeader();
        new HtmlProcessInformationsReport(processInformationsList, this.getWriter()).toHtml();
        this.writeHtmlFooter();
    }

    public void writeProcesses(Map<String, List<ProcessInformations>> processesByTitle) throws IOException {
        assert (processesByTitle != null);
        this.writeHtmlHeader();
        new HtmlProcessInformationsReport(new ArrayList<ProcessInformations>(), this.getWriter()).writeLinks();
        for (Map.Entry<String, List<ProcessInformations>> entry : processesByTitle.entrySet()) {
            String title = entry.getKey();
            List<ProcessInformations> processes = entry.getValue();
            this.writeDirectly("<h3 class='chapterTitle'><img src='?resource=processes.png' alt='" + title + "'/>&nbsp;" + title + "</h3>");
            new HtmlProcessInformationsReport(processes, this.getWriter()).writeTable();
        }
        this.writeHtmlFooter();
    }

    public void writeDatabase(DatabaseInformations databaseInformations) throws IOException {
        assert (databaseInformations != null);
        this.writeHtmlHeader();
        new HtmlDatabaseInformationsReport(databaseInformations, this.getWriter()).toHtml();
        this.writeHtmlFooter();
    }

    public void writeConnections(List<ConnectionInformations> connectionInformationsList, boolean withoutHeaders) throws IOException {
        assert (connectionInformationsList != null);
        HtmlConnectionInformationsReport htmlConnectionInformationsReport = new HtmlConnectionInformationsReport(connectionInformationsList, this.getWriter());
        if (withoutHeaders) {
            htmlConnectionInformationsReport.writeConnections();
        } else {
            this.writeHtmlHeader();
            htmlConnectionInformationsReport.toHtml();
            this.writeHtmlFooter();
        }
    }

    public void writeJndi(List<JndiBinding> jndiBindings, String path) throws IOException {
        assert (jndiBindings != null);
        this.writeHtmlHeader();
        new HtmlJndiTreeReport(jndiBindings, path, this.getWriter()).toHtml();
        this.writeHtmlFooter();
    }

    public void writeMBeans(List<MBeanNode> mbeans) throws IOException {
        assert (mbeans != null);
        this.writeHtmlHeader();
        new HtmlMBeansReport(mbeans, this.getWriter()).toHtml();
        this.writeHtmlFooter();
    }

    public void writeMBeans(Map<String, List<MBeanNode>> mbeansByTitle) throws IOException {
        assert (mbeansByTitle != null);
        this.writeHtmlHeader();
        new HtmlMBeansReport(new ArrayList<MBeanNode>(), this.getWriter()).writeLinks();
        for (Map.Entry<String, List<MBeanNode>> entry : mbeansByTitle.entrySet()) {
            String title = entry.getKey();
            List<MBeanNode> nodes = entry.getValue();
            this.writeDirectly("<h3 class='chapterTitle'><img src='?resource=mbeans.png' alt='" + title + "'/>&nbsp;" + title + "</h3>");
            new HtmlMBeansReport(nodes, this.getWriter()).writeTree();
        }
        this.writeHtmlFooter();
    }

    public void writeCacheWithKeys(String cacheId, CacheInformations cacheInformations, String message, String cacheKeyPart, boolean withoutHeaders) throws IOException {
        assert (cacheId != null);
        if (cacheInformations != null) {
            HtmlCacheInformationsReport htmlCacheInformationsReport = new HtmlCacheInformationsReport(Collections.singletonList(cacheInformations), this.getWriter());
            if (withoutHeaders) {
                htmlCacheInformationsReport.writeCacheWithKeys(cacheId, withoutHeaders);
            } else {
                this.writeHtmlHeader();
                htmlCacheInformationsReport.writeCacheWithKeys(cacheId, withoutHeaders);
                this.writeHtmlFooter();
                this.writeMessageIfNotNull(message, cacheKeyPart);
            }
        }
    }

    public void writeCrashes() throws IOException {
        this.writeHtmlHeader();
        List<HsErrPid> hsErrPidList = this.htmlCoreReport.getHsErrPidList();
        HtmlHsErrPidReport htmlHsErrPidReport = new HtmlHsErrPidReport(hsErrPidList, this.getWriter());
        htmlHsErrPidReport.toHtml();
        this.writeHtmlFooter();
    }
}

