/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import java.util.List;
import org.kuali.rice.krad.bo.Exporter;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntryBase;
import org.kuali.rice.krad.datadictionary.HelpDefinition;
import org.kuali.rice.krad.datadictionary.InactivationBlockingDefinition;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validation.capability.MustOccurConstrainable;
import org.kuali.rice.krad.datadictionary.validation.constraint.MustOccurConstraint;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

@BeanTag(name="dataObjectEntry")
public class DataObjectEntry
extends DataDictionaryEntryBase
implements MustOccurConstrainable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected Class<?> dataObjectClass;
    protected Class<?> baseDataObjectClass;
    protected String titleAttribute;
    protected String objectLabel;
    protected String objectDescription;
    protected List<String> primaryKeys;
    protected Class<? extends Exporter> exporterClass;
    protected List<MustOccurConstraint> mustOccurConstraints;
    protected List<String> groupByAttributesForEffectiveDating;
    protected HelpDefinition helpDefinition;
    protected boolean boNotesEnabled = false;
    protected List<InactivationBlockingDefinition> inactivationBlockingDefinitions;

    @Override
    public void completeValidation() {
        this.completeValidation(new ValidationTrace());
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        super.completeValidation(tracer);
    }

    @Override
    public String getJstlKey() {
        if (this.dataObjectClass == null) {
            throw new IllegalStateException("cannot generate JSTL key: dataObjectClass is null");
        }
        return this.dataObjectClass.getSimpleName();
    }

    @Override
    public String getFullClassName() {
        return this.dataObjectClass.getName();
    }

    @Override
    public Class<?> getEntryClass() {
        return this.dataObjectClass;
    }

    @BeanTagAttribute
    public Class<?> getDataObjectClass() {
        return this.dataObjectClass;
    }

    public void setDataObjectClass(Class<?> dataObjectClass) {
        this.dataObjectClass = dataObjectClass;
    }

    public void setBaseDataObjectClass(Class<?> baseDataObjectClass) {
        this.baseDataObjectClass = baseDataObjectClass;
    }

    @BeanTagAttribute(name="baseDataObjectClass")
    public Class<?> getBaseDataObjectClass() {
        return this.baseDataObjectClass;
    }

    @Override
    @BeanTagAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @BeanTagAttribute
    public String getObjectLabel() {
        if (this.objectLabel != null) {
            return this.objectLabel;
        }
        if (this.getDataObjectMetadata() != null) {
            return this.getDataObjectMetadata().getLabel();
        }
        return KRADServiceLocatorWeb.getUifDefaultingService().deriveHumanFriendlyNameFromPropertyName(this.dataObjectClass.getSimpleName());
    }

    public void setObjectLabel(String objectLabel) {
        this.objectLabel = objectLabel;
    }

    @BeanTagAttribute
    public String getObjectDescription() {
        if (this.objectDescription != null) {
            return this.objectDescription;
        }
        if (this.getDataObjectMetadata() != null) {
            return this.getDataObjectMetadata().getDescription();
        }
        return "";
    }

    public void setObjectDescription(String objectDescription) {
        this.objectDescription = objectDescription;
    }

    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public HelpDefinition getHelpDefinition() {
        return this.helpDefinition;
    }

    public void setHelpDefinition(HelpDefinition helpDefinition) {
        this.helpDefinition = helpDefinition;
    }

    @Override
    @BeanTagAttribute
    public List<MustOccurConstraint> getMustOccurConstraints() {
        return this.mustOccurConstraints;
    }

    public void setMustOccurConstraints(List<MustOccurConstraint> mustOccurConstraints) {
        this.mustOccurConstraints = mustOccurConstraints;
    }

    @BeanTagAttribute
    public String getTitleAttribute() {
        if (this.titleAttribute != null) {
            return this.titleAttribute;
        }
        if (this.getDataObjectMetadata() != null) {
            return this.getDataObjectMetadata().getPrimaryDisplayAttributeName();
        }
        return null;
    }

    public void setTitleAttribute(String titleAttribute) {
        this.titleAttribute = titleAttribute;
    }

    @BeanTagAttribute
    public List<String> getPrimaryKeys() {
        if (this.primaryKeys != null) {
            return this.primaryKeys;
        }
        if (this.getDataObjectMetadata() != null) {
            return this.getDataObjectMetadata().getPrimaryKeyAttributeNames();
        }
        return null;
    }

    public void setPrimaryKeys(List<String> primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    @BeanTagAttribute
    public Class<? extends Exporter> getExporterClass() {
        return this.exporterClass;
    }

    public void setExporterClass(Class<? extends Exporter> exporterClass) {
        this.exporterClass = exporterClass;
    }

    @BeanTagAttribute
    public List<String> getGroupByAttributesForEffectiveDating() {
        return this.groupByAttributesForEffectiveDating;
    }

    public void setGroupByAttributesForEffectiveDating(List<String> groupByAttributesForEffectiveDating) {
        this.groupByAttributesForEffectiveDating = groupByAttributesForEffectiveDating;
    }

    @BeanTagAttribute
    public boolean isBoNotesEnabled() {
        return this.boNotesEnabled;
    }

    public void setBoNotesEnabled(boolean boNotesEnabled) {
        this.boNotesEnabled = boNotesEnabled;
    }

    @BeanTagAttribute
    public List<InactivationBlockingDefinition> getInactivationBlockingDefinitions() {
        return this.inactivationBlockingDefinitions;
    }

    public void setInactivationBlockingDefinitions(List<InactivationBlockingDefinition> inactivationBlockingDefinitions) {
        this.inactivationBlockingDefinitions = inactivationBlockingDefinitions;
    }
}

