/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.kuali.rice.krad.datadictionary.Copyable;
import org.kuali.rice.krad.uif.component.DelayedCopy;
import org.kuali.rice.krad.uif.util.LifecycleElement;

public class LifecycleAwareList<T>
implements List<T>,
Copyable,
Serializable {
    private static final long serialVersionUID = -8971217230511446882L;
    private final LifecycleElement lifecycleElement;
    @DelayedCopy(inherit=true)
    private List<T> delegate;

    public LifecycleAwareList(LifecycleElement lifecycleElement) {
        this.lifecycleElement = lifecycleElement;
        this.delegate = Collections.emptyList();
    }

    public LifecycleAwareList(LifecycleElement lifecycleElement, List<T> delegate) {
        this.lifecycleElement = lifecycleElement;
        List<T> wrapped = delegate;
        while (wrapped instanceof LifecycleAwareList) {
            wrapped = ((LifecycleAwareList)wrapped).delegate;
        }
        this.delegate = delegate;
    }

    private void ensureMutable() {
        this.lifecycleElement.checkMutable(true);
        if (this.delegate == Collections.EMPTY_LIST) {
            this.delegate = new ArrayList<T>();
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iter();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <A> A[] toArray(A[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean add(T e) {
        this.ensureMutable();
        return this.delegate.add(e);
    }

    @Override
    public boolean remove(Object o) {
        this.lifecycleElement.checkMutable(true);
        return this.delegate != Collections.EMPTY_LIST && this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.ensureMutable();
        return this.delegate.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.ensureMutable();
        return this.delegate.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.lifecycleElement.checkMutable(true);
        return this.delegate != Collections.EMPTY_LIST && this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.lifecycleElement.checkMutable(true);
        return this.delegate != Collections.EMPTY_LIST && this.delegate.retainAll(c);
    }

    @Override
    public void clear() {
        if (this.delegate != Collections.EMPTY_LIST) {
            this.delegate.clear();
        }
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public T get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public T set(int index, T element) {
        this.lifecycleElement.checkMutable(true);
        return this.delegate.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.ensureMutable();
        this.delegate.add(index, element);
    }

    @Override
    public T remove(int index) {
        this.lifecycleElement.checkMutable(true);
        return this.delegate.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        this.ensureMutable();
        return new ListIter();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        this.ensureMutable();
        return new ListIter(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return new LifecycleAwareList<T>(this.lifecycleElement, this.delegate.subList(fromIndex, toIndex));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private class Iter
    implements Iterator<T> {
        private final Iterator<T> delegate;

        private Iter() {
            this.delegate = LifecycleAwareList.this.delegate.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            LifecycleAwareList.this.lifecycleElement.checkMutable(true);
            this.delegate.remove();
        }
    }

    private class ListIter
    implements ListIterator<T> {
        private final ListIterator<T> delegate;

        private ListIter() {
            this.delegate = LifecycleAwareList.this.delegate.listIterator();
        }

        private ListIter(int index) {
            this.delegate = LifecycleAwareList.this.delegate.listIterator(index);
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return this.delegate.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        @Override
        public T previous() {
            return this.delegate.previous();
        }

        @Override
        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        @Override
        public void remove() {
            LifecycleAwareList.this.lifecycleElement.checkMutable(true);
            this.delegate.remove();
        }

        @Override
        public void set(T e) {
            LifecycleAwareList.this.lifecycleElement.checkMutable(true);
            this.delegate.set(e);
        }

        @Override
        public void add(T e) {
            LifecycleAwareList.this.lifecycleElement.checkMutable(true);
            this.delegate.add(e);
        }
    }
}

