/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.award.finance.timeAndMoney.dao.TimeAndMoneyPostsDao;
import org.kuali.coeus.common.framework.auth.perm.Permissionable;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.external.award.AwardAccountService;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.kra.timeandmoney.AwardVersionHistory;
import org.kuali.kra.timeandmoney.document.PendingTransactionComparator;
import org.kuali.kra.timeandmoney.history.TimeAndMoneyActionSummary;
import org.kuali.kra.timeandmoney.service.ActivePendingTransactionsService;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyService;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyVersionService;
import org.kuali.kra.timeandmoney.transactions.AwardAmountTransaction;
import org.kuali.kra.timeandmoney.transactions.PendingTransaction;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.document.Copyable;
import org.kuali.rice.krad.document.SessionDocument;
import org.kuali.rice.krad.util.ObjectUtils;

public class TimeAndMoneyDocument
extends KcTransactionalDocumentBase
implements Copyable,
SessionDocument,
Permissionable,
Comparable {
    private static final long serialVersionUID = -2554022334215932544L;
    private static final Logger LOG = LogManager.getLogger(TimeAndMoneyDocument.class);
    public static final String DOCUMENT_TYPE_CODE = "TAMD";
    private String rootAwardNumber;
    private String awardNumber;
    private String documentStatus;
    private Map<String, AwardHierarchyNode> awardHierarchyNodes;
    private Map<String, AwardHierarchy> awardHierarchyItems;
    private List<PendingTransaction> pendingTransactions;
    private List<AwardAmountTransaction> awardAmountTransactions;
    private List<TimeAndMoneyActionSummary> timeAndMoneyActionSummaryItems;
    private Award award;
    private AwardAmountTransaction newAwardAmountTransaction;
    private List<AwardVersionHistory> awardVersionHistoryList;
    private List<String> order;
    private List<AwardAmountInfo> awardAmountInfos;
    private transient TimeAndMoneyVersionService timeAndMoneyVersionService;
    private TimeAndMoneyService timeAndMoneyService;
    private AwardAccountService awardAccountService;

    public TimeAndMoneyDocument() {
        this.init();
    }

    @Override
    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    public boolean isInitialSave() {
        return this.getObjectId() == null;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.pendingTransactions);
        return managedLists;
    }

    protected void init() {
        this.awardHierarchyNodes = new TreeMap<String, AwardHierarchyNode>();
        this.awardHierarchyItems = new HashMap<String, AwardHierarchy>();
        this.pendingTransactions = new ArrayList<PendingTransaction>();
        this.awardAmountTransactions = new ArrayList<AwardAmountTransaction>();
        this.timeAndMoneyActionSummaryItems = new ArrayList<TimeAndMoneyActionSummary>();
        this.newAwardAmountTransaction = new AwardAmountTransaction();
        this.awardVersionHistoryList = new ArrayList<AwardVersionHistory>();
        this.order = new ArrayList<String>();
        this.documentStatus = VersionStatus.PENDING.toString();
    }

    public boolean isAuthorizedToPostTimeAndMoney(String principalId) {
        return this.isPostTimeAndMoneyFeatureEnabled() && this.getDocumentHeader().getWorkflowDocument().isFinal() && !this.isPosted(this.getDocumentNumber()) && this.hasPostTimeAndMoneyPermission(principalId);
    }

    public boolean isPosted(String documentNumber) {
        return this.getTimeAndMoneyPostsDao().getTimeAndMoneyPostsByDocumentNumber(documentNumber) != null;
    }

    public TimeAndMoneyPostsDao getTimeAndMoneyPostsDao() {
        return KcServiceLocator.getService(TimeAndMoneyPostsDao.class);
    }

    public boolean hasPostTimeAndMoneyPermission(String principalId) {
        return this.getPermissionService().hasPermission(principalId, "KC-SYS", "Post Time and Money");
    }

    protected boolean isPostTimeAndMoneyFeatureEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-T", "All", "TM_POST_ENABLED");
    }

    protected ParameterService getParameterService() {
        return KcServiceLocator.getService(ParameterService.class);
    }

    protected PermissionService getPermissionService() {
        return KcServiceLocator.getService(PermissionService.class);
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (StringUtils.equals((CharSequence)"P", (CharSequence)statusChangeEvent.getNewRouteStatus())) {
            this.setAwardHierarchyItems(this.getAwardHierarchyService().getAwardHierarchy(this.rootAwardNumber, this.getOrder()));
            this.setAwardNumber(this.rootAwardNumber);
            Award tmpAward = this.getCurrentAward(this);
            this.setAward(tmpAward);
            if (tmpAward != null) {
                this.getAwardHierarchyService().populateAwardHierarchyNodesForTandMDoc(this.getAwardHierarchyItems(), this.getAwardHierarchyNodes(), tmpAward.getAwardNumber(), tmpAward.getSequenceNumber().toString(), this);
            } else {
                this.getAwardHierarchyService().populateAwardHierarchyNodesForTandMDoc(this.getAwardHierarchyItems(), this.getAwardHierarchyNodes(), null, null, this);
            }
            this.getActivePendingTransactionsService().approveTransactions(this, this.awardAmountTransactions.get(0));
            this.getTimeAndMoneyVersionService().updateDocumentStatus(this, VersionStatus.ACTIVE);
            if (LOG.isDebugEnabled()) {
                LOG.debug("TimeAndMoneyDocument in Processed status and saved with document status of " + this.getDocumentStatus());
            }
            this.autoPostTimeAndMoney();
        } else if (StringUtils.equals((CharSequence)"F", (CharSequence)statusChangeEvent.getNewRouteStatus()) && !VersionStatus.ACTIVE.name().equals(this.getDocumentStatus())) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("TimeAndMoneyDocument in final status but document status still " + this.getDocumentStatus() + " so setting to ACTIVE again");
            }
            this.getTimeAndMoneyVersionService().updateDocumentStatus(this, VersionStatus.ACTIVE);
        }
    }

    protected void autoPostTimeAndMoney() {
        if (this.isAutoPostTimeAndMoney() && this.getAwardAccountService().isFinancialRestApiEnabled()) {
            Award award = this.getAward();
            this.getTimeAndMoneyService().addPostEntry(award.getAwardId(), award.getAwardNumber(), this.getDocumentNumber());
        }
    }

    protected boolean isAutoPostTimeAndMoney() {
        return this.getParameterService().getParameterValueAsBoolean("KC-T", "All", "TM_AUTO_POST_ENABLED");
    }

    protected TimeAndMoneyService getTimeAndMoneyService() {
        if (this.timeAndMoneyService == null) {
            this.timeAndMoneyService = KcServiceLocator.getService(TimeAndMoneyService.class);
        }
        return this.timeAndMoneyService;
    }

    public AwardAccountService getAwardAccountService() {
        if (this.awardAccountService == null) {
            this.awardAccountService = KcServiceLocator.getService(AwardAccountService.class);
        }
        return this.awardAccountService;
    }

    protected AwardHierarchyService getAwardHierarchyService() {
        return KcServiceLocator.getService(AwardHierarchyService.class);
    }

    private Award getCurrentAward(TimeAndMoneyDocument timeAndMoneyDocument) {
        Award tmpAward = timeAndMoneyDocument.getAward();
        if (tmpAward == null) {
            tmpAward = this.getAwardVersionService().getWorkingAwardVersion(timeAndMoneyDocument.getAwardNumber());
        }
        return tmpAward;
    }

    public AwardVersionService getAwardVersionService() {
        return KcServiceLocator.getService(AwardVersionService.class);
    }

    protected ActivePendingTransactionsService getActivePendingTransactionsService() {
        return KcServiceLocator.getService(ActivePendingTransactionsService.class);
    }

    @Override
    public String getDocumentKey() {
        return "award";
    }

    @Override
    public String getDocumentNumberForPermission() {
        return this.getRootAwardNumber();
    }

    @Override
    public List<String> getRoleNames() {
        ArrayList<String> roles = new ArrayList<String>();
        return roles;
    }

    public boolean getDocumentRouteStatus() {
        return this.getDocumentHeader().getWorkflowDocument().isEnroute() || this.getDocumentHeader().getWorkflowDocument().isFinal();
    }

    public boolean isNew() {
        return this.documentNumber == null;
    }

    public String getAwardNumber() {
        return this.awardNumber;
    }

    public void setAwardNumber(String awardNumber) {
        this.awardNumber = awardNumber;
    }

    public String getDocumentStatus() {
        return this.documentStatus;
    }

    public void setDocumentStatus(String documentStatus) {
        this.documentStatus = documentStatus;
    }

    public Map<String, AwardHierarchyNode> getAwardHierarchyNodes() {
        return this.awardHierarchyNodes;
    }

    public void setAwardHierarchyNodes(Map<String, AwardHierarchyNode> awardHierarchyNodes) {
        this.awardHierarchyNodes = awardHierarchyNodes;
    }

    public List<PendingTransaction> getPendingTransactions() {
        Collections.sort(this.pendingTransactions, new PendingTransactionComparator());
        return this.pendingTransactions;
    }

    public void setPendingTransactions(List<PendingTransaction> pendingTransactions) {
        this.pendingTransactions = pendingTransactions;
    }

    public void add(PendingTransaction newPendingTransaction) {
        this.getPendingTransactions().add(newPendingTransaction);
    }

    public Map<String, AwardHierarchy> getAwardHierarchyItems() {
        return this.awardHierarchyItems;
    }

    public void setAwardHierarchyItems(Map<String, AwardHierarchy> awardHierarchyItems) {
        this.awardHierarchyItems = awardHierarchyItems;
    }

    public List<AwardAmountTransaction> getAwardAmountTransactions() {
        return this.awardAmountTransactions;
    }

    public void setAwardAmountTransactions(List<AwardAmountTransaction> awardAmountTransactions) {
        this.awardAmountTransactions = awardAmountTransactions;
    }

    public List<TimeAndMoneyActionSummary> getTimeAndMoneyActionSummaryItems() {
        return this.timeAndMoneyActionSummaryItems;
    }

    public void setTimeAndMoneyActionSummaryItems(List<TimeAndMoneyActionSummary> timeAndMoneyActionSummaryItems) {
        this.timeAndMoneyActionSummaryItems = timeAndMoneyActionSummaryItems;
    }

    public Award getAward() {
        return this.award;
    }

    public void setAward(Award award) {
        this.award = award;
    }

    public AwardAmountTransaction getNewAwardAmountTransaction() {
        return this.newAwardAmountTransaction;
    }

    public void setNewAwardAmountTransaction(AwardAmountTransaction newAwardAmountTransaction) {
        this.newAwardAmountTransaction = newAwardAmountTransaction;
    }

    public String getRootAwardNumber() {
        return this.rootAwardNumber;
    }

    public void setRootAwardNumber(String rootAwardNumber) {
        this.rootAwardNumber = rootAwardNumber;
    }

    public void prepareForSave() {
        super.prepareForSave();
        if (ObjectUtils.isNull((Object)this.getVersionNumber())) {
            this.setVersionNumber(new Long(0L));
        }
    }

    @Override
    public String getNamespace() {
        return "KC-AWARD";
    }

    @Override
    public String getLeadUnitNumber() {
        if (this.getAward() != null) {
            return this.getAward().getLeadUnitNumber();
        }
        return null;
    }

    @Override
    public String getDocumentRoleTypeCode() {
        return "KC-AWARD";
    }

    public List<AwardVersionHistory> getAwardVersionHistoryList() {
        return this.awardVersionHistoryList;
    }

    public void setAwardVersionHistoryList(List<AwardVersionHistory> awardVersionHistoryList) {
        this.awardVersionHistoryList = awardVersionHistoryList;
    }

    public List<String> getOrder() {
        return this.order;
    }

    public void setOrder(List<String> order) {
        this.order = order;
    }

    @Override
    public boolean isProcessComplete() {
        String docRouteStatus;
        boolean isComplete = false;
        if (this.getDocumentHeader().hasWorkflowDocument() && "F".equals(docRouteStatus = this.getDocumentHeader().getWorkflowDocument().getStatus().getCode())) {
            isComplete = true;
        }
        return isComplete;
    }

    @Override
    protected void preUpdate() {
        if (!VersionStatus.ARCHIVED.name().equals(this.documentStatus)) {
            super.preUpdate();
        }
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        TimeAndMoneyDocument comparator = (TimeAndMoneyDocument)o;
        String myKey = StringUtils.leftPad((String)this.getDocumentNumber(), (int)40);
        String otherKey = StringUtils.leftPad((String)comparator.getDocumentNumber(), (int)40);
        return myKey.compareTo(otherKey);
    }

    @Override
    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return new ArrayList();
    }

    @Override
    public String getDocumentBoNumber() {
        return "TIME AND MONEY-" + this.getAwardNumber();
    }

    public TimeAndMoneyVersionService getTimeAndMoneyVersionService() {
        if (this.timeAndMoneyVersionService == null) {
            this.timeAndMoneyVersionService = KcServiceLocator.getService(TimeAndMoneyVersionService.class);
        }
        return this.timeAndMoneyVersionService;
    }

    public void setTimeAndMoneyVersionService(TimeAndMoneyVersionService timeAndMoneyVersionService) {
        this.timeAndMoneyVersionService = timeAndMoneyVersionService;
    }

    public List<AwardAmountInfo> getAwardAmountInfos() {
        return this.awardAmountInfos;
    }

    public void setAwardAmountInfos(List<AwardAmountInfo> awardAmountInfos) {
        this.awardAmountInfos = awardAmountInfos;
    }
}

