/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.ksb.messaging.HttpException;
import org.kuali.rice.ksb.security.HttpClientHeaderDigitalSigner;
import org.kuali.rice.ksb.security.SignatureVerifyingInputStream;
import org.kuali.rice.ksb.security.admin.service.JavaSecurityManagementService;
import org.kuali.rice.ksb.security.service.DigitalSignatureService;
import org.springframework.remoting.httpinvoker.HttpComponentsHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerClientConfiguration;

public class KSBHttpInvokerRequestExecutor
extends HttpComponentsHttpInvokerRequestExecutor {
    private Boolean secure = Boolean.TRUE;

    public KSBHttpInvokerRequestExecutor() {
    }

    public KSBHttpInvokerRequestExecutor(Boolean secure) {
        this.secure = secure;
    }

    public KSBHttpInvokerRequestExecutor(HttpClient httpClient) {
        super(httpClient);
    }

    protected void setRequestBody(HttpInvokerClientConfiguration config, HttpPost httpPost, ByteArrayOutputStream baos) throws IOException {
        if (this.isSecure()) {
            try {
                this.signRequest(httpPost, baos);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to sign the outgoing message.", e);
            }
        }
        super.setRequestBody(config, httpPost, baos);
    }

    protected InputStream getResponseBody(HttpInvokerClientConfiguration config, HttpResponse postMethod) throws IOException {
        if (this.isSecure()) {
            boolean foundValidCertificate;
            Header digitalSignatureHeader = postMethod.getFirstHeader("KEW_DIGITAL_SIGNATURE");
            Header keyStoreAliasHeader = postMethod.getFirstHeader("KEW_KEYSTORE_ALIAS");
            Header certificateHeader = postMethod.getFirstHeader("KEW_CERTIFICATE_ALIAS");
            if (digitalSignatureHeader == null || StringUtils.isEmpty((String)digitalSignatureHeader.getValue())) {
                throw new RuntimeException("A digital signature header was required on the response but none was found.");
            }
            boolean foundValidKeystoreAlias = keyStoreAliasHeader != null && StringUtils.isNotBlank((String)keyStoreAliasHeader.getValue());
            boolean bl = foundValidCertificate = certificateHeader != null && StringUtils.isNotBlank((String)certificateHeader.getValue());
            if (!foundValidCertificate && !foundValidKeystoreAlias) {
                throw new RuntimeException("Either a key store alias header or a certificate header was required on the response but neither were found.");
            }
            byte[] digitalSignature = Base64.decodeBase64((byte[])digitalSignatureHeader.getValue().getBytes("UTF-8"));
            Object errorQualifier = "General Security Error";
            try {
                Signature signature = null;
                if (foundValidCertificate) {
                    errorQualifier = "Error with given certificate";
                    byte[] encodedCertificate = Base64.decodeBase64((byte[])certificateHeader.getValue().getBytes("UTF-8"));
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    signature = this.getDigitalSignatureService().getSignatureForVerification(cf.generateCertificate(new ByteArrayInputStream(encodedCertificate)));
                } else if (foundValidKeystoreAlias) {
                    String keystoreAlias = keyStoreAliasHeader.getValue();
                    errorQualifier = "Error with given alias " + keystoreAlias;
                    signature = this.getDigitalSignatureService().getSignatureForVerification(keystoreAlias);
                }
                return new SignatureVerifyingInputStream(digitalSignature, signature, super.getResponseBody(config, postMethod));
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Problem verifying signature: " + (String)errorQualifier, e);
            }
        }
        return super.getResponseBody(config, postMethod);
    }

    protected void validateResponse(HttpInvokerClientConfiguration config, HttpResponse response) throws HttpException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 300) {
            throw new HttpException(statusCode, "Did not receive successful HTTP response: status code = " + statusCode + ", status message = [" + response.getStatusLine().getReasonPhrase() + "]");
        }
    }

    protected void signRequest(HttpPost postMethod, ByteArrayOutputStream baos) throws Exception {
        Signature signature = this.getDigitalSignatureService().getSignatureForSigning();
        HttpClientHeaderDigitalSigner signer = new HttpClientHeaderDigitalSigner(signature, (HttpRequest)postMethod, this.getJavaSecurityManagementService().getModuleKeyStoreAlias());
        signer.getSignature().update(baos.toByteArray());
        signer.sign();
    }

    protected boolean isSecure() {
        return this.getSecure();
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    protected DigitalSignatureService getDigitalSignatureService() {
        return (DigitalSignatureService)GlobalResourceLoader.getService((String)"rice.ksb.digitalSignatureService");
    }

    protected JavaSecurityManagementService getJavaSecurityManagementService() {
        return (JavaSecurityManagementService)GlobalResourceLoader.getService((String)"rice.ksb.javaSecurityManagementService");
    }
}

