/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.service.impl;

import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.metadata.DataObjectAttribute;
import org.kuali.rice.krad.data.metadata.DataObjectAttributeRelationship;
import org.kuali.rice.krad.data.metadata.DataObjectMetadata;
import org.kuali.rice.krad.data.metadata.DataObjectRelationship;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.TextAreaControl;
import org.kuali.rice.krad.uif.control.TextControl;
import org.kuali.rice.krad.uif.control.UserControl;
import org.kuali.rice.krad.uif.service.UifDefaultingService;
import org.kuali.rice.krad.uif.util.ComponentFactory;

public class UifDefaultingServiceImpl
implements UifDefaultingService {
    private static final Logger LOG = LogManager.getLogger(UifDefaultingServiceImpl.class);
    protected DataDictionaryService dataDictionaryService;
    protected DataObjectService dataObjectService;
    protected static final String ANY_CHARACTER_PATTERN_CONSTRAINT = "UTF8AnyCharacterPatternConstraint";
    protected static final String DATE_PATTERN_CONSTRAINT = "BasicDatePatternConstraint";
    protected static final String FLOATING_POINT_PATTERN_CONSTRAINT = "FloatingPointPatternConstraintTemplate";
    protected static final String BIG_DECIMAL_PATTERN_CONSTRAINT = "BigDecimalPatternConstraintTemplate";
    protected static final String TIMESTAMP_PATTERN_CONSTRAINT = "TimestampPatternConstraint";
    protected static final String CURRENCY_PATTERN_CONSTRAINT = "CurrencyPatternConstraint";

    @Override
    public String deriveHumanFriendlyNameFromPropertyName(String camelCasedName) {
        if (StringUtils.isBlank((String)camelCasedName)) {
            return camelCasedName;
        }
        if (camelCasedName.contains(".")) {
            camelCasedName = StringUtils.substringAfterLast((String)camelCasedName, (String)".");
        }
        StringBuilder label = new StringBuilder(camelCasedName);
        label.replace(0, 1, label.substring(0, 1).toUpperCase());
        for (int i = 0; i < label.length(); ++i) {
            if (!Character.isUpperCase(label.charAt(i)) && !Character.isDigit(label.charAt(i))) continue;
            label.insert(i, ' ');
            ++i;
        }
        return label.toString().trim();
    }

    protected Control getControlInstance(AttributeDefinition attrDef, DataObjectAttribute dataObjectAttribute) {
        Control c = null;
        if (attrDef.getOptionsFinder() != null) {
            c = ComponentFactory.getSelectControl();
        } else if (attrDef.getName().endsWith(".principalName") && dataObjectAttribute != null) {
            c = ComponentFactory.getUserControl();
            String relationshipName = StringUtils.removeEnd((String)attrDef.getName(), (String)".principalName");
            DataObjectMetadata metadata = this.dataObjectService.getMetadataRepository().getMetadata(dataObjectAttribute.getOwningType());
            if (metadata != null) {
                DataObjectRelationship relationship = metadata.getRelationship(relationshipName);
                if (relationship != null && CollectionUtils.isNotEmpty((Collection)relationship.getAttributeRelationships())) {
                    ((UserControl)c).setPrincipalIdPropertyName(((DataObjectAttributeRelationship)relationship.getAttributeRelationships().get(0)).getParentAttributeName());
                    ((UserControl)c).setPersonNamePropertyName(relationshipName + ".name");
                    ((UserControl)c).setPersonObjectPropertyName(relationshipName);
                }
            } else {
                LOG.warn("Attempt to pull relationship name: " + relationshipName + " resulted in missing metadata when looking for: " + dataObjectAttribute.getOwningType());
            }
        } else {
            switch (attrDef.getDataType()) {
                case STRING: {
                    if (attrDef.getMaxLength() != null && attrDef.getMaxLength() > 200) {
                        c = ComponentFactory.getTextAreaControl();
                        break;
                    }
                    c = ComponentFactory.getTextControl();
                    break;
                }
                case BOOLEAN: {
                    c = ComponentFactory.getCheckboxControl();
                    break;
                }
                case DATE: 
                case DATETIME: 
                case TRUNCATED_DATE: {
                    c = ComponentFactory.getDateControl();
                    break;
                }
                case CURRENCY: 
                case DOUBLE: 
                case FLOAT: 
                case INTEGER: 
                case LARGE_INTEGER: 
                case LONG: 
                case PRECISE_DECIMAL: {
                    c = ComponentFactory.getTextControl();
                    break;
                }
                case MARKUP: {
                    c = ComponentFactory.getTextAreaControl();
                    break;
                }
                default: {
                    c = ComponentFactory.getTextControl();
                }
            }
        }
        return c;
    }

    protected void customizeControlInstance(Control c, AttributeDefinition attrDef, DataObjectAttribute dataObjectAttribute) {
        c.setRequired(attrDef.isRequired());
        if (c instanceof TextControl) {
            if (attrDef.getMaxLength() != null) {
                ((TextControl)c).setMaxLength(attrDef.getMaxLength());
                ((TextControl)c).setSize(attrDef.getMaxLength());
                if (attrDef.getMaxLength() > 80) {
                    ((TextControl)c).setTextExpand(true);
                }
            }
            if (attrDef.getMinLength() != null) {
                ((TextControl)c).setMinLength(attrDef.getMinLength());
            }
        }
        if (c instanceof TextAreaControl) {
            if (attrDef.getMaxLength() != null) {
                ((TextAreaControl)c).setMaxLength(attrDef.getMaxLength());
                ((TextAreaControl)c).setRows(attrDef.getMaxLength() / ((TextAreaControl)c).getCols());
            }
            if (attrDef.getMinLength() != null) {
                ((TextAreaControl)c).setMinLength(attrDef.getMinLength());
            }
        }
    }

    @Override
    public Control deriveControlAttributeFromMetadata(AttributeDefinition attrDef) {
        DataObjectAttribute dataObjectAttribute = attrDef.getDataObjectAttribute();
        Control c = this.getControlInstance(attrDef, dataObjectAttribute);
        if (c != null) {
            this.customizeControlInstance(c, attrDef, dataObjectAttribute);
        }
        return c;
    }

    @Override
    public ValidCharactersConstraint deriveValidCharactersConstraint(AttributeDefinition attrDef) {
        Object consObj;
        ValidCharactersConstraint validCharactersConstraint = null;
        if (attrDef.getDataObjectAttribute() != null && StringUtils.isNotBlank((String)attrDef.getDataObjectAttribute().getValidCharactersConstraintBeanName()) && (consObj = this.dataDictionaryService.getDictionaryBean(attrDef.getDataObjectAttribute().getValidCharactersConstraintBeanName())) != null && consObj instanceof ValidCharactersConstraint) {
            validCharactersConstraint = (ValidCharactersConstraint)consObj;
        }
        if (validCharactersConstraint == null && attrDef.getDataType() != null) {
            if (attrDef.getDataType() == DataType.CURRENCY) {
                validCharactersConstraint = (ValidCharactersConstraint)this.dataDictionaryService.getDictionaryBean(CURRENCY_PATTERN_CONSTRAINT);
            } else if (attrDef.getDataType() == DataType.PRECISE_DECIMAL) {
                validCharactersConstraint = (ValidCharactersConstraint)this.dataDictionaryService.getDictionaryBean(BIG_DECIMAL_PATTERN_CONSTRAINT);
            } else if (attrDef.getDataType().isNumeric()) {
                validCharactersConstraint = (ValidCharactersConstraint)this.dataDictionaryService.getDictionaryBean(FLOATING_POINT_PATTERN_CONSTRAINT);
            } else if (attrDef.getDataType().isTemporal()) {
                if (attrDef.getDataType() == DataType.DATE) {
                    validCharactersConstraint = (ValidCharactersConstraint)this.dataDictionaryService.getDictionaryBean(DATE_PATTERN_CONSTRAINT);
                } else if (attrDef.getDataType() == DataType.TIMESTAMP) {
                    validCharactersConstraint = (ValidCharactersConstraint)this.dataDictionaryService.getDictionaryBean(TIMESTAMP_PATTERN_CONSTRAINT);
                }
            }
        }
        if (validCharactersConstraint == null) {
            validCharactersConstraint = (ValidCharactersConstraint)this.dataDictionaryService.getDictionaryBean(ANY_CHARACTER_PATTERN_CONSTRAINT);
        }
        return validCharactersConstraint;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

