/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.HTTPUtilities;
import org.owasp.esapi.Logger;
import org.owasp.esapi.SecurityConfiguration;
import org.owasp.esapi.StringUtilities;
import org.owasp.esapi.User;
import org.owasp.esapi.ValidationErrorList;
import org.owasp.esapi.codecs.Hex;
import org.owasp.esapi.crypto.CipherText;
import org.owasp.esapi.crypto.PlainText;
import org.owasp.esapi.errors.AccessControlException;
import org.owasp.esapi.errors.AuthenticationException;
import org.owasp.esapi.errors.EncodingException;
import org.owasp.esapi.errors.EncryptionException;
import org.owasp.esapi.errors.IntegrityException;
import org.owasp.esapi.errors.IntrusionException;
import org.owasp.esapi.errors.ValidationException;
import org.owasp.esapi.errors.ValidationUploadException;

public class DefaultHTTPUtilities
implements HTTPUtilities {
    private static volatile HTTPUtilities instance = null;
    private static String DISKFILEITEM_SERIALIZABLE = "org.apache.commons.fileupload.disk.DiskFileItem.serializable";
    private final Logger logger = ESAPI.getLogger("HTTPUtilities");
    static final int maxBytes = ESAPI.securityConfiguration().getAllowedFileUploadSize();
    private ThreadLocalRequest currentRequest = new ThreadLocalRequest();
    private ThreadLocalResponse currentResponse = new ThreadLocalResponse();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HTTPUtilities getInstance() {
        if (instance != null) return instance;
        Class<DefaultHTTPUtilities> clazz = DefaultHTTPUtilities.class;
        synchronized (DefaultHTTPUtilities.class) {
            if (instance != null) return instance;
            instance = new DefaultHTTPUtilities();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.addCookie(this.getCurrentResponse(), cookie);
    }

    @Override
    public void addCookie(HttpServletResponse response, Cookie cookie) {
        String name = cookie.getName();
        String value = cookie.getValue();
        int maxAge = cookie.getMaxAge();
        String domain = cookie.getDomain();
        String path = cookie.getPath();
        boolean secure = cookie.getSecure();
        ValidationErrorList errors = new ValidationErrorList();
        String cookieName = ESAPI.validator().getValidInput("cookie name", name, "HTTPCookieName", 50, false, errors);
        String cookieValue = ESAPI.validator().getValidInput("cookie value", value, "HTTPCookieValue", 5000, false, errors);
        if (errors.size() == 0) {
            if (ESAPI.securityConfiguration().getForceHttpOnlyCookies()) {
                String header = this.createCookieHeader(cookieName, cookieValue, maxAge, domain, path, secure);
                this.addHeader(response, "Set-Cookie", header);
            } else {
                cookie.setSecure(secure || ESAPI.securityConfiguration().getForceSecureCookies());
                response.addCookie(cookie);
            }
            return;
        }
        this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to add unsafe data to cookie (skip mode). Skipping cookie and continuing.");
    }

    @Override
    public String addCSRFToken(String href) {
        User user = ESAPI.authenticator().getCurrentUser();
        if (user.isAnonymous()) {
            return href;
        }
        String token = "ctoken=" + user.getCSRFToken();
        return href.indexOf(63) != -1 ? href + "&" + token : href + "?" + token;
    }

    @Override
    public void addHeader(String name, String value) {
        this.addHeader(this.getCurrentResponse(), name, value);
    }

    @Override
    public void addHeader(HttpServletResponse response, String name, String value) {
        try {
            String strippedName = StringUtilities.replaceLinearWhiteSpace(name);
            String strippedValue = StringUtilities.replaceLinearWhiteSpace(value);
            String safeName = ESAPI.validator().getValidInput("addHeader", strippedName, "HTTPHeaderName", 20, false);
            String safeValue = ESAPI.validator().getValidInput("addHeader", strippedValue, "HTTPHeaderValue", 500, false);
            response.addHeader(safeName, safeValue);
        }
        catch (ValidationException e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to add invalid header denied", e);
        }
    }

    @Override
    public void assertSecureChannel() throws AccessControlException {
        this.assertSecureChannel(this.getCurrentRequest());
    }

    @Override
    public void assertSecureChannel(HttpServletRequest request) throws AccessControlException {
        if (request == null) {
            throw new AccessControlException("Insecure request received", "HTTP request was null");
        }
        StringBuffer sb = request.getRequestURL();
        if (sb == null) {
            throw new AccessControlException("Insecure request received", "HTTP request URL was null");
        }
        String url = sb.toString();
        if (!url.startsWith("https")) {
            throw new AccessControlException("Insecure request received", "HTTP request did not use SSL");
        }
    }

    @Override
    public void assertSecureRequest() throws AccessControlException {
        this.assertSecureRequest(this.getCurrentRequest());
    }

    @Override
    public void assertSecureRequest(HttpServletRequest request) throws AccessControlException {
        this.assertSecureChannel(request);
        String receivedMethod = request.getMethod();
        String requiredMethod = "POST";
        if (!receivedMethod.equals(requiredMethod)) {
            throw new AccessControlException("Insecure request received", "Received request using " + receivedMethod + " when only " + requiredMethod + " is allowed");
        }
    }

    @Override
    public HttpSession changeSessionIdentifier() throws AuthenticationException {
        return this.changeSessionIdentifier(this.getCurrentRequest());
    }

    @Override
    public HttpSession changeSessionIdentifier(HttpServletRequest request) throws AuthenticationException {
        HttpSession oldSession = request.getSession();
        ConcurrentHashMap<String, Object> temp = new ConcurrentHashMap<String, Object>();
        Enumeration e = oldSession.getAttributeNames();
        while (e != null && e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object value = oldSession.getAttribute(name);
            temp.put(name, value);
        }
        oldSession.invalidate();
        HttpSession newSession = request.getSession();
        User user = ESAPI.authenticator().getCurrentUser();
        user.addSession(newSession);
        user.removeSession(oldSession);
        for (Map.Entry stringObjectEntry : temp.entrySet()) {
            newSession.setAttribute((String)stringObjectEntry.getKey(), stringObjectEntry.getValue());
        }
        return newSession;
    }

    @Override
    public void clearCurrent() {
        this.currentRequest.set(null);
        this.currentResponse.set(null);
    }

    private String createCookieHeader(String name, String value, int maxAge, String domain, String path, boolean secure) {
        String header = name + "=" + value;
        if (maxAge >= 0) {
            header = header + "; Max-Age=" + maxAge;
        }
        if (domain != null) {
            header = header + "; Domain=" + domain;
        }
        if (path != null) {
            header = header + "; Path=" + path;
        }
        if (secure || ESAPI.securityConfiguration().getForceSecureCookies()) {
            header = header + "; Secure";
        }
        if (ESAPI.securityConfiguration().getForceHttpOnlyCookies()) {
            header = header + "; HttpOnly";
        }
        return header;
    }

    @Override
    public String decryptHiddenField(String encrypted) {
        try {
            return this.decryptString(encrypted);
        }
        catch (EncryptionException e) {
            throw new IntrusionException("Invalid request", "Tampering detected. Hidden field data did not decrypt properly.", e);
        }
    }

    @Override
    public Map<String, String> decryptQueryString(String encrypted) throws EncryptionException {
        String plaintext = this.decryptString(encrypted);
        return this.queryToMap(plaintext);
    }

    @Override
    public Map<String, String> decryptStateFromCookie() throws EncryptionException {
        return this.decryptStateFromCookie(this.getCurrentRequest());
    }

    @Override
    public Map<String, String> decryptStateFromCookie(HttpServletRequest request) throws EncryptionException {
        try {
            String encrypted = this.getCookie(request, "estate");
            if (encrypted == null) {
                return new HashMap<String, String>();
            }
            String plaintext = this.decryptString(encrypted);
            return this.queryToMap(plaintext);
        }
        catch (ValidationException e) {
            return null;
        }
    }

    @Override
    public String encryptHiddenField(String value) throws EncryptionException {
        return this.encryptString(value);
    }

    @Override
    public String encryptQueryString(String query) throws EncryptionException {
        return this.encryptString(query);
    }

    @Override
    public void encryptStateInCookie(HttpServletResponse response, Map<String, String> cleartext) throws EncryptionException {
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, String>> i = cleartext.entrySet().iterator();
        while (i.hasNext()) {
            try {
                Map.Entry<String, String> entry = i.next();
                String name = ESAPI.encoder().encodeForURL(entry.getKey().toString());
                String value = ESAPI.encoder().encodeForURL(entry.getValue().toString());
                sb.append(name).append("=").append(value);
                if (!i.hasNext()) continue;
                sb.append("&");
            }
            catch (EncodingException e) {
                this.logger.error(Logger.SECURITY_FAILURE, "Problem encrypting state in cookie - skipping entry", e);
            }
        }
        String encrypted = this.encryptString(sb.toString());
        if (encrypted.length() > 4096) {
            this.logger.error(Logger.SECURITY_FAILURE, "Problem encrypting state in cookie - skipping entry");
            throw new EncryptionException("Encryption failure", "Encrypted cookie state of " + encrypted.length() + " longer than allowed " + 4096);
        }
        Cookie cookie = new Cookie("estate", encrypted);
        this.addCookie(response, cookie);
    }

    @Override
    public void encryptStateInCookie(Map<String, String> cleartext) throws EncryptionException {
        this.encryptStateInCookie(this.getCurrentResponse(), cleartext);
    }

    @Override
    public String getCookie(HttpServletRequest request, String name) throws ValidationException {
        Cookie c = this.getFirstCookie(request, name);
        if (c == null) {
            return null;
        }
        String value = c.getValue();
        return ESAPI.validator().getValidInput("HTTP cookie value: " + value, value, "HTTPCookieValue", 1000, false);
    }

    @Override
    public String getCookie(String name) throws ValidationException {
        return this.getCookie(this.getCurrentRequest(), name);
    }

    @Override
    public String getCSRFToken() {
        User user = ESAPI.authenticator().getCurrentUser();
        if (user == null) {
            return null;
        }
        return user.getCSRFToken();
    }

    @Override
    public HttpServletRequest getCurrentRequest() {
        return this.currentRequest.getRequest();
    }

    @Override
    public HttpServletResponse getCurrentResponse() {
        return this.currentResponse.getResponse();
    }

    @Override
    public List<File> getFileUploads() throws ValidationException {
        return this.getFileUploads(this.getCurrentRequest(), ESAPI.securityConfiguration().getUploadDirectory(), ESAPI.securityConfiguration().getAllowedFileExtensions());
    }

    @Override
    public List<File> getFileUploads(HttpServletRequest request) throws ValidationException {
        return this.getFileUploads(request, ESAPI.securityConfiguration().getUploadDirectory(), ESAPI.securityConfiguration().getAllowedFileExtensions());
    }

    @Override
    public List<File> getFileUploads(HttpServletRequest request, File finalDir) throws ValidationException {
        return this.getFileUploads(request, finalDir, ESAPI.securityConfiguration().getAllowedFileExtensions());
    }

    @Override
    public List<File> getFileUploads(HttpServletRequest request, File finalDir, List allowedExtensions) throws ValidationException {
        File tempDir = ESAPI.securityConfiguration().getUploadTempDirectory();
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            throw new ValidationUploadException("Upload failed", "Could not create temp directory: " + tempDir.getAbsolutePath());
        }
        if (finalDir != null) {
            if (!finalDir.exists() && !finalDir.mkdirs()) {
                throw new ValidationUploadException("Upload failed", "Could not create final upload directory: " + finalDir.getAbsolutePath());
            }
        } else {
            if (!ESAPI.securityConfiguration().getUploadDirectory().exists() && !ESAPI.securityConfiguration().getUploadDirectory().mkdirs()) {
                throw new ValidationUploadException("Upload failed", "Could not create final upload directory: " + ESAPI.securityConfiguration().getUploadDirectory().getAbsolutePath());
            }
            finalDir = ESAPI.securityConfiguration().getUploadDirectory();
        }
        ArrayList<File> newFiles = new ArrayList<File>();
        String dfiPrevValue = "false";
        try {
            dfiPrevValue = System.getProperty(DISKFILEITEM_SERIALIZABLE);
            System.setProperty(DISKFILEITEM_SERIALIZABLE, "false");
            final HttpSession session = request.getSession(false);
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                throw new ValidationUploadException("Upload failed", "Not a multipart request");
            }
            DiskFileItemFactory factory = new DiskFileItemFactory(0, tempDir);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setSizeMax((long)maxBytes);
            ProgressListener progressListener = new ProgressListener(){
                private long megaBytes = -1L;
                private long progress = 0L;

                public void update(long pBytesRead, long pContentLength, int pItems) {
                    if (pItems == 0) {
                        return;
                    }
                    long mBytes = pBytesRead / 1000000L;
                    if (this.megaBytes == mBytes) {
                        return;
                    }
                    this.megaBytes = mBytes;
                    this.progress = (long)((double)pBytesRead / (double)pContentLength * 100.0);
                    if (session != null) {
                        session.setAttribute("progress", (Object)Long.toString(this.progress));
                    }
                }
            };
            upload.setProgressListener(progressListener);
            List items = upload.parseRequest(request);
            for (FileItem item : items) {
                if (item.isFormField() || item.getName() == null || item.getName().equals("")) continue;
                String[] fparts = item.getName().split("[\\/\\\\]");
                String filename = fparts[fparts.length - 1];
                if (!ESAPI.validator().isValidFileName("upload", filename, allowedExtensions, false)) {
                    throw new ValidationUploadException("Upload only simple filenames with the following extensions " + allowedExtensions, "Upload failed isValidFileName check");
                }
                this.logger.info(Logger.SECURITY_SUCCESS, "File upload requested: " + filename);
                File f = new File(finalDir, filename);
                if (f.exists()) {
                    String[] parts = filename.split("\\/.");
                    String extension = "";
                    if (parts.length > 1) {
                        extension = parts[parts.length - 1];
                    }
                    String filenm = filename.substring(0, filename.length() - extension.length());
                    f = File.createTempFile(filenm, "." + extension, finalDir);
                }
                item.write(f);
                newFiles.add(f);
                item.delete();
                this.logger.fatal(Logger.SECURITY_SUCCESS, "File successfully uploaded: " + f);
                if (session == null) continue;
                session.setAttribute("progress", (Object)Long.toString(0L));
            }
        }
        catch (Exception e) {
            if (e instanceof ValidationUploadException) {
                throw (ValidationException)e;
            }
            throw new ValidationUploadException("Upload failure", "Problem during upload:" + e.getMessage(), e);
        }
        finally {
            if (dfiPrevValue != null) {
                System.setProperty(DISKFILEITEM_SERIALIZABLE, dfiPrevValue);
            }
        }
        return Collections.synchronizedList(newFiles);
    }

    private Cookie getFirstCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return null;
    }

    @Override
    public String getHeader(HttpServletRequest request, String name) throws ValidationException {
        String value = request.getHeader(name);
        return ESAPI.validator().getValidInput("HTTP header value: " + value, value, "HTTPHeaderValue", 150, false);
    }

    @Override
    public String getHeader(String name) throws ValidationException {
        return this.getHeader(this.getCurrentRequest(), name);
    }

    @Override
    public String getParameter(HttpServletRequest request, String name) throws ValidationException {
        String value = request.getParameter(name);
        return ESAPI.validator().getValidInput("HTTP parameter value: " + value, value, "HTTPParameterValue", 2000, true);
    }

    @Override
    public String getParameter(String name) throws ValidationException {
        return this.getParameter(this.getCurrentRequest(), name);
    }

    @Override
    public void killAllCookies() {
        this.killAllCookies(this.getCurrentRequest(), this.getCurrentResponse());
    }

    @Override
    public void killAllCookies(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                this.killCookie(request, response, cookie.getName());
            }
        }
    }

    @Override
    public void killCookie(HttpServletRequest request, HttpServletResponse response, String name) {
        String path = "//";
        String domain = "";
        Cookie cookie = this.getFirstCookie(request, name);
        if (cookie != null) {
            path = cookie.getPath();
            domain = cookie.getDomain();
        }
        Cookie deleter = new Cookie(name, "deleted");
        deleter.setMaxAge(0);
        if (domain != null) {
            deleter.setDomain(domain);
        }
        if (path != null) {
            deleter.setPath(path);
        }
        response.addCookie(deleter);
    }

    @Override
    public void killCookie(String name) {
        this.killCookie(this.getCurrentRequest(), this.getCurrentResponse(), name);
    }

    @Override
    public void logHTTPRequest() {
        this.logHTTPRequest(this.getCurrentRequest(), this.logger, null);
    }

    @Override
    public void logHTTPRequest(HttpServletRequest request, Logger logger) {
        this.logHTTPRequest(request, logger, null);
    }

    @Override
    public void logHTTPRequest(HttpServletRequest request, Logger logger, List parameterNamesToObfuscate) {
        StringBuilder params = new StringBuilder();
        Iterator i = request.getParameterMap().keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String[] stringArray = (String[])request.getParameterMap().get(key);
            for (int j = 0; j < stringArray.length; ++j) {
                params.append(key).append("=");
                if (parameterNamesToObfuscate != null && parameterNamesToObfuscate.contains(key)) {
                    params.append("********");
                } else {
                    params.append(stringArray[j]);
                }
                if (j >= stringArray.length - 1) continue;
                params.append("&");
            }
            if (!i.hasNext()) continue;
            params.append("&");
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cooky : cookies) {
                if (cooky.getName().equals(ESAPI.securityConfiguration().getHttpSessionIdName())) continue;
                params.append("+").append(cooky.getName()).append("=").append(cooky.getValue());
            }
        }
        String string = request.getMethod() + " " + request.getRequestURL() + (params.length() > 0 ? "?" + params : "");
        logger.info(Logger.SECURITY_SUCCESS, string);
    }

    private Map<String, String> queryToMap(String query) {
        String[] parts;
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String part : parts = query.split("&")) {
            try {
                String[] nvpair = part.split("=");
                String name = ESAPI.encoder().decodeFromURL(nvpair[0]);
                String value = ESAPI.encoder().decodeFromURL(nvpair[1]);
                map.put(name, value);
            }
            catch (EncodingException encodingException) {
                // empty catch block
            }
        }
        return map;
    }

    @Override
    public void sendForward(HttpServletRequest request, HttpServletResponse response, String location) throws AccessControlException, ServletException, IOException {
        if (!location.startsWith("WEB-INF")) {
            throw new AccessControlException("Forward failed", "Bad forward location: " + location);
        }
        RequestDispatcher dispatcher = request.getRequestDispatcher(location);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    @Override
    public void sendForward(String location) throws AccessControlException, ServletException, IOException {
        this.sendForward(this.getCurrentRequest(), this.getCurrentResponse(), location);
    }

    @Override
    public void sendRedirect(HttpServletResponse response, String location) throws AccessControlException, IOException {
        if (!ESAPI.validator().isValidRedirectLocation("Redirect", location, false)) {
            this.logger.fatal(Logger.SECURITY_FAILURE, "Bad redirect location: " + location);
            throw new AccessControlException("Redirect failed", "Bad redirect location: " + location);
        }
        response.sendRedirect(location);
    }

    @Override
    public void sendRedirect(String location) throws AccessControlException, IOException {
        this.sendRedirect(this.getCurrentResponse(), location);
    }

    @Override
    public void setContentType() {
        this.setContentType(this.getCurrentResponse());
    }

    @Override
    public void setContentType(HttpServletResponse response) {
        response.setContentType(ESAPI.securityConfiguration().getResponseContentType());
    }

    @Override
    public void setCurrentHTTP(HttpServletRequest request, HttpServletResponse response) {
        this.currentRequest.setRequest(request);
        this.currentResponse.setResponse(response);
    }

    @Override
    public void setHeader(HttpServletResponse response, String name, String value) {
        try {
            SecurityConfiguration sc = ESAPI.securityConfiguration();
            String strippedName = StringUtilities.replaceLinearWhiteSpace(name);
            String strippedValue = StringUtilities.replaceLinearWhiteSpace(value);
            String safeName = ESAPI.validator().getValidInput("setHeader", strippedName, "HTTPHeaderName", sc.getIntProp("HttpUtilities.MaxHeaderNameSize"), false);
            String safeValue = ESAPI.validator().getValidInput("setHeader", strippedValue, "HTTPHeaderValue", sc.getIntProp("HttpUtilities.MaxHeaderValueSize"), false);
            response.setHeader(safeName, safeValue);
        }
        catch (ValidationException e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to set invalid header denied", e);
        }
    }

    @Override
    public void setHeader(String name, String value) {
        this.setHeader(this.getCurrentResponse(), name, value);
    }

    @Override
    public void setNoCacheHeaders() {
        this.setNoCacheHeaders(this.getCurrentResponse());
    }

    @Override
    public void setNoCacheHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", -1L);
    }

    @Override
    public String setRememberToken(HttpServletRequest request, HttpServletResponse response, String password, int maxAge, String domain, String path) {
        User user = ESAPI.authenticator().getCurrentUser();
        try {
            this.killCookie(request, response, "rtoken");
            String clearToken = user.getAccountName() + "|" + password;
            long expiry = ESAPI.encryptor().getRelativeTimeStamp(maxAge * 1000);
            String cryptToken = ESAPI.encryptor().seal(clearToken, expiry);
            SecurityConfiguration sg = ESAPI.securityConfiguration();
            boolean forceSecureCookies = sg.getBooleanProp("HttpUtilities.ForceSecureCookies");
            boolean forceHttpOnly = sg.getBooleanProp("HttpUtilities.ForceHttpOnlyCookies");
            Cookie cookie = new Cookie("rtoken", cryptToken);
            cookie.setMaxAge(maxAge);
            cookie.setDomain(domain);
            cookie.setPath(path);
            cookie.setHttpOnly(forceHttpOnly);
            cookie.setSecure(forceSecureCookies);
            response.addCookie(cookie);
            this.logger.info(Logger.SECURITY_SUCCESS, "Enabled remember me token for " + user.getAccountName());
            return cryptToken;
        }
        catch (IntegrityException e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to set remember me token failed for " + user.getAccountName(), e);
            return null;
        }
    }

    @Override
    public String setRememberToken(HttpServletRequest request, HttpServletResponse response, int maxAge, String domain, String path) {
        String rval = "";
        User user = ESAPI.authenticator().getCurrentUser();
        try {
            this.killCookie(request, response, "rtoken");
            String clearToken = user.getAccountName();
            long expiry = ESAPI.encryptor().getRelativeTimeStamp(maxAge * 1000);
            String cryptToken = ESAPI.encryptor().seal(clearToken, expiry);
            SecurityConfiguration sg = ESAPI.securityConfiguration();
            boolean forceSecureCookies = sg.getBooleanProp("HttpUtilities.ForceSecureCookies");
            boolean forceHttpOnly = sg.getBooleanProp("HttpUtilities.ForceHttpOnlyCookies");
            Cookie cookie = new Cookie("rtoken", cryptToken);
            cookie.setMaxAge(maxAge);
            cookie.setDomain(domain);
            cookie.setPath(path);
            cookie.setHttpOnly(forceHttpOnly);
            cookie.setSecure(forceSecureCookies);
            response.addCookie(cookie);
            this.logger.info(Logger.SECURITY_SUCCESS, "Enabled remember me token for " + user.getAccountName());
        }
        catch (IntegrityException e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to set remember me token failed for " + user.getAccountName(), e);
            return null;
        }
        return rval;
    }

    @Override
    public String setRememberToken(String password, int maxAge, String domain, String path) {
        return this.setRememberToken(this.getCurrentRequest(), this.getCurrentResponse(), password, maxAge, domain, path);
    }

    @Override
    public void verifyCSRFToken() throws IntrusionException {
        this.verifyCSRFToken(this.getCurrentRequest());
    }

    @Override
    public void verifyCSRFToken(HttpServletRequest request) throws IntrusionException {
        User user = ESAPI.authenticator().getCurrentUser();
        if (request.getAttribute(user.getCSRFToken()) != null) {
            return;
        }
        String token = request.getParameter("ctoken");
        if (!user.getCSRFToken().equals(token)) {
            throw new IntrusionException("Authentication failed", "Possibly forged HTTP request without proper CSRF token detected");
        }
    }

    @Override
    public <T> T getSessionAttribute(String key) {
        HttpSession session = ESAPI.currentRequest().getSession(false);
        if (session != null) {
            return (T)session.getAttribute(key);
        }
        return null;
    }

    @Override
    public <T> T getSessionAttribute(HttpSession session, String key) {
        return (T)session.getAttribute(key);
    }

    @Override
    public <T> T getRequestAttribute(String key) {
        return (T)ESAPI.currentRequest().getAttribute(key);
    }

    @Override
    public <T> T getRequestAttribute(HttpServletRequest request, String key) {
        return (T)request.getAttribute(key);
    }

    private String encryptString(String plaintext) throws EncryptionException {
        PlainText pt = new PlainText(plaintext);
        CipherText ct = ESAPI.encryptor().encrypt(pt);
        byte[] serializedCiphertext = ct.asPortableSerializedByteArray();
        return Hex.encode(serializedCiphertext, false);
    }

    private String decryptString(String ciphertext) throws EncryptionException {
        byte[] serializedCiphertext = Hex.decode(ciphertext);
        CipherText restoredCipherText = CipherText.fromPortableSerializedBytes(serializedCiphertext);
        PlainText plaintext = ESAPI.encryptor().decrypt(restoredCipherText);
        return plaintext.toString();
    }

    private class ThreadLocalResponse
    extends InheritableThreadLocal<HttpServletResponse> {
        private ThreadLocalResponse() {
        }

        public HttpServletResponse getResponse() {
            return (HttpServletResponse)super.get();
        }

        @Override
        public HttpServletResponse initialValue() {
            return null;
        }

        public void setResponse(HttpServletResponse newResponse) {
            super.set(newResponse);
        }
    }

    private class ThreadLocalRequest
    extends InheritableThreadLocal<HttpServletRequest> {
        private ThreadLocalRequest() {
        }

        public HttpServletRequest getRequest() {
            return (HttpServletRequest)super.get();
        }

        @Override
        public HttpServletRequest initialValue() {
            return null;
        }

        public void setRequest(HttpServletRequest newRequest) {
            super.set(newRequest);
        }
    }
}

