/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.kuali.rice.kew.engine.node.BranchState;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name="KREW_RTE_BRCH_T")
public class Branch
implements Serializable,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
PersistenceWeavedRest {
    private static final long serialVersionUID = 7164561979112939112L;
    @Id
    @GeneratedValue(generator="KREW_RTE_NODE_S")
    @PortableSequenceGenerator(name="KREW_RTE_NODE_S")
    @Column(name="RTE_BRCH_ID")
    private String branchId;
    @ManyToOne
    @JoinColumn(name="PARNT_ID")
    private Branch parentBranch;
    @Column(name="NM")
    private String name;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="branch", orphanRemoval=true)
    private List<BranchState> branchState = new ArrayList<BranchState>();
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="INIT_RTE_NODE_INSTN_ID")
    private RouteNodeInstance initialNode;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="SPLT_RTE_NODE_INSTN_ID")
    private RouteNodeInstance splitNode;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="JOIN_RTE_NODE_INSTN_ID")
    private RouteNodeInstance joinNode;
    @Version
    @Column(name="VER_NBR")
    private Integer lockVerNbr;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public RouteNodeInstance getSplitNode() {
        return this._persistence_get_splitNode();
    }

    public void setSplitNode(RouteNodeInstance splitNode) {
        this._persistence_set_splitNode(splitNode);
    }

    public RouteNodeInstance getInitialNode() {
        return this._persistence_get_initialNode();
    }

    public void setInitialNode(RouteNodeInstance activeNode) {
        this._persistence_set_initialNode(activeNode);
    }

    public String getBranchId() {
        return this._persistence_get_branchId();
    }

    public void setBranchId(String branchId) {
        this._persistence_set_branchId(branchId);
    }

    public RouteNodeInstance getJoinNode() {
        return this._persistence_get_joinNode();
    }

    public void setJoinNode(RouteNodeInstance joinNode) {
        this._persistence_set_joinNode(joinNode);
    }

    public Branch getParentBranch() {
        return this._persistence_get_parentBranch();
    }

    public void setParentBranch(Branch parentBranch) {
        this._persistence_set_parentBranch(parentBranch);
    }

    public BranchState getBranchState(String key) {
        for (BranchState branchState : this._persistence_get_branchState()) {
            if (!branchState.getKey().equals(key)) continue;
            return branchState;
        }
        return null;
    }

    public void addBranchState(BranchState state) {
        this._persistence_get_branchState().add(state);
        state.setBranch(this);
    }

    public List<BranchState> getBranchState() {
        return this._persistence_get_branchState();
    }

    public void setBranchState(List<BranchState> branchState) {
        this._persistence_get_branchState().clear();
        this._persistence_get_branchState().addAll(branchState);
    }

    public BranchState getDocBranchState(int index) {
        while (this._persistence_get_branchState().size() <= index) {
            this._persistence_get_branchState().add(new BranchState());
        }
        return (BranchState)((Object)this._persistence_get_branchState().get(index));
    }

    public Integer getLockVerNbr() {
        return this._persistence_get_lockVerNbr();
    }

    public void setLockVerNbr(Integer lockVerNbr) {
        this._persistence_set_lockVerNbr(lockVerNbr);
    }

    public Branch deepCopy(Map<Object, Object> visited) {
        if (visited.containsKey(this)) {
            return (Branch)visited.get(this);
        }
        Branch copy = new Branch();
        visited.put(this, copy);
        copy._persistence_set_branchId(this._persistence_get_branchId());
        copy._persistence_set_name(this._persistence_get_name());
        copy._persistence_set_lockVerNbr(this._persistence_get_lockVerNbr());
        if (this._persistence_get_parentBranch() != null) {
            copy._persistence_set_parentBranch(this._persistence_get_parentBranch().deepCopy(visited));
        }
        if (this._persistence_get_branchState() != null) {
            ArrayList<BranchState> copies = new ArrayList<BranchState>();
            for (BranchState state : this._persistence_get_branchState()) {
                copies.add(state.deepCopy(visited));
            }
            copy._persistence_set_branchState(copies);
        }
        if (this._persistence_get_initialNode() != null) {
            copy._persistence_set_initialNode(this._persistence_get_initialNode().deepCopy(visited));
        }
        if (this._persistence_get_splitNode() != null) {
            copy._persistence_set_splitNode(this._persistence_get_splitNode().deepCopy(visited));
        }
        if (this._persistence_get_joinNode() != null) {
            copy._persistence_set_joinNode(this._persistence_get_joinNode().deepCopy(visited));
        }
        return copy;
    }

    public String toString() {
        return "[Branch: branchId=" + this._persistence_get_branchId() + ", parentBranch=" + (this._persistence_get_parentBranch() == null ? "null" : this._persistence_get_parentBranch().getBranchId()) + "]";
    }

    public Object _persistence_post_clone() {
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Branch();
    }

    public Object _persistence_get(String string) {
        if (string == "parentBranch") {
            return this.parentBranch;
        }
        if (string == "branchId") {
            return this.branchId;
        }
        if (string == "initialNode") {
            return this.initialNode;
        }
        if (string == "branchState") {
            return this.branchState;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "lockVerNbr") {
            return this.lockVerNbr;
        }
        if (string == "splitNode") {
            return this.splitNode;
        }
        if (string == "joinNode") {
            return this.joinNode;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "parentBranch") {
            this.parentBranch = (Branch)object;
            return;
        }
        if (string == "branchId") {
            this.branchId = (String)object;
            return;
        }
        if (string == "initialNode") {
            this.initialNode = (RouteNodeInstance)object;
            return;
        }
        if (string == "branchState") {
            this.branchState = (List)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "lockVerNbr") {
            this.lockVerNbr = (Integer)object;
            return;
        }
        if (string == "splitNode") {
            this.splitNode = (RouteNodeInstance)object;
            return;
        }
        if (string == "joinNode") {
            this.joinNode = (RouteNodeInstance)object;
            return;
        }
    }

    public Branch _persistence_get_parentBranch() {
        this._persistence_checkFetched("parentBranch");
        return this.parentBranch;
    }

    public void _persistence_set_parentBranch(Branch branch) {
        this._persistence_checkFetchedForSet("parentBranch");
        this.parentBranch = branch;
    }

    public String _persistence_get_branchId() {
        this._persistence_checkFetched("branchId");
        return this.branchId;
    }

    public void _persistence_set_branchId(String string) {
        this._persistence_checkFetchedForSet("branchId");
        this.branchId = string;
    }

    public RouteNodeInstance _persistence_get_initialNode() {
        this._persistence_checkFetched("initialNode");
        return this.initialNode;
    }

    public void _persistence_set_initialNode(RouteNodeInstance routeNodeInstance) {
        this._persistence_checkFetchedForSet("initialNode");
        this.initialNode = routeNodeInstance;
    }

    public List _persistence_get_branchState() {
        this._persistence_checkFetched("branchState");
        return this.branchState;
    }

    public void _persistence_set_branchState(List list) {
        this._persistence_checkFetchedForSet("branchState");
        this.branchState = list;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this.name = string;
    }

    public Integer _persistence_get_lockVerNbr() {
        this._persistence_checkFetched("lockVerNbr");
        return this.lockVerNbr;
    }

    public void _persistence_set_lockVerNbr(Integer n) {
        this._persistence_checkFetchedForSet("lockVerNbr");
        this.lockVerNbr = n;
    }

    public RouteNodeInstance _persistence_get_splitNode() {
        this._persistence_checkFetched("splitNode");
        return this.splitNode;
    }

    public void _persistence_set_splitNode(RouteNodeInstance routeNodeInstance) {
        this._persistence_checkFetchedForSet("splitNode");
        this.splitNode = routeNodeInstance;
    }

    public RouteNodeInstance _persistence_get_joinNode() {
        this._persistence_checkFetched("joinNode");
        return this.joinNode;
    }

    public void _persistence_set_joinNode(RouteNodeInstance routeNodeInstance) {
        this._persistence_checkFetchedForSet("joinNode");
        this.joinNode = routeNodeInstance;
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

