/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node.hierarchyrouting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.DynamicNode;
import org.kuali.rice.kew.engine.node.DynamicResult;
import org.kuali.rice.kew.engine.node.NoOpNode;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.ProcessDefinitionBo;
import org.kuali.rice.kew.engine.node.RequestsNode;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.SimpleJoinNode;
import org.kuali.rice.kew.engine.node.SimpleSplitNode;
import org.kuali.rice.kew.engine.node.hierarchyrouting.HierarchyProvider;
import org.kuali.rice.kew.engine.transition.SplitTransitionEngine;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.Utilities;

public class HierarchyRoutingNode
implements DynamicNode {
    protected final Logger LOG = LogManager.getLogger(this.getClass());
    public static final String HIERARCHY_PROVIDER = "hierarchyProvider";
    public static final String STOP_ID = "stop_id";
    protected static final String SPLIT_PROCESS_NAME = "Hierarchy Split";
    protected static final String JOIN_PROCESS_NAME = "Hierarchy Join";
    protected static final String REQUEST_PROCESS_NAME = "Hierarchy Request";
    protected static final String NO_STOP_NAME = "No stop";
    private static final String VISITED_STOPS = "visited_stops";
    private static final String V_STOPS_DEL = ",";
    private static final String INITIAL_SPLIT_NODE_MARKER = "InitialSplitNode";

    protected HierarchyProvider getHierarchyProvider(RouteNodeInstance nodeInstance, RouteContext context) {
        Map<String, String> cfgMap = Utilities.getKeyValueCollectionAsMap(nodeInstance.getRouteNode().getConfigParams());
        String hierarchyProviderClass = cfgMap.get(HIERARCHY_PROVIDER);
        if (StringUtils.isEmpty((String)hierarchyProviderClass)) {
            throw new WorkflowRuntimeException("hierarchyProvider configuration parameter not set for HierarchyRoutingNode: " + nodeInstance.getName());
        }
        QName qn = QName.valueOf(hierarchyProviderClass);
        ObjectDefinition od = "".equals(qn.getNamespaceURI()) ? new ObjectDefinition(qn.getLocalPart()) : new ObjectDefinition(qn.getLocalPart(), qn.getNamespaceURI());
        HierarchyProvider hp = (HierarchyProvider)GlobalResourceLoader.getObject((ObjectDefinition)od);
        hp.init(nodeInstance, context);
        return hp;
    }

    @Override
    public DynamicResult transitioningInto(RouteContext context, RouteNodeInstance dynamicNodeInstance, RouteHelper helper) throws Exception {
        HierarchyProvider provider = this.getHierarchyProvider(dynamicNodeInstance, context);
        DocumentType documentType = this.setUpDocumentType(provider, context.getDocument().getDocumentType(), dynamicNodeInstance);
        RouteNode splitNode = documentType.getNamedProcess(SPLIT_PROCESS_NAME).getInitialRouteNode();
        RouteNodeInstance splitNodeInstance = helper.getNodeFactory().createRouteNodeInstance(context.getDocument().getDocumentId(), splitNode);
        splitNodeInstance.setBranch(dynamicNodeInstance.getBranch());
        HierarchyRoutingNode.markAsInitialSplitNode(splitNodeInstance);
        boolean i = false;
        List<HierarchyProvider.Stop> stops = provider.getLeafStops(context);
        if (stops.isEmpty()) {
            RouteNode noStopNode = documentType.getNamedProcess(NO_STOP_NAME).getInitialRouteNode();
            RouteNodeInstance noChartOrgInstance = helper.getNodeFactory().createRouteNodeInstance(context.getDocument().getDocumentId(), noStopNode);
            noChartOrgInstance.setBranch(dynamicNodeInstance.getBranch());
            provider.setStop(noChartOrgInstance, null);
            return new DynamicResult(true, noChartOrgInstance);
        }
        for (HierarchyProvider.Stop stop : stops) {
            RouteNode requestNode = this.getStopRequestNode(stop, documentType);
            this.createInitialRequestNodeInstance(provider, stop, splitNodeInstance, dynamicNodeInstance, requestNode);
        }
        return new DynamicResult(false, splitNodeInstance);
    }

    @Override
    public DynamicResult transitioningOutOf(RouteContext context, RouteHelper helper) throws Exception {
        HierarchyProvider provider = this.getHierarchyProvider(context.getNodeInstance().getProcess(), context);
        RouteNodeInstance processInstance = context.getNodeInstance().getProcess();
        RouteNodeInstance curStopNode = context.getNodeInstance();
        HashMap<String, RouteNodeInstance> stopRequestNodeMap = new HashMap<String, RouteNodeInstance>();
        this.findStopRequestNodes(provider, context, stopRequestNodeMap);
        HierarchyProvider.Stop stop = provider.getStop(curStopNode);
        if (provider.isRoot(stop)) {
            return new DynamicResult(true, null);
        }
        InnerTransitionResult transition = this.canTransitionFrom(provider, stop, stopRequestNodeMap.values(), helper);
        DynamicResult result = null;
        if (transition.isCanTransition()) {
            DocumentType documentType = context.getDocument().getDocumentType();
            RouteNodeInstance requestNode = this.createNextStopRequestNodeInstance(provider, context, stop, processInstance, helper);
            if (transition.getSiblings().isEmpty()) {
                result = new DynamicResult(false, requestNode);
            }
        } else {
            result = new DynamicResult(false, null);
        }
        result.getNextNodeInstances().addAll(this.getNewlyAddedOrgRouteInstances(provider, context, helper));
        return result;
    }

    private void findStopRequestNodes(HierarchyProvider provider, RouteContext context, Map<String, RouteNodeInstance> stopRequestNodes) {
        List<RouteNodeInstance> nodeInstances = KEWServiceLocator.getRouteNodeService().getFlattenedNodeInstances(context.getDocument(), true);
        for (RouteNodeInstance nodeInstance : nodeInstances) {
            if (!provider.hasStop(nodeInstance)) continue;
            this.LOG.debug("Stop node instance: " + nodeInstance);
            stopRequestNodes.put(nodeInstance.getRouteNodeInstanceId(), nodeInstance);
        }
    }

    private RouteNodeInstance createNextStopRequestNodeInstance(HierarchyProvider provider, RouteContext context, HierarchyProvider.Stop stop, RouteNodeInstance processInstance, RouteHelper helper) {
        HierarchyProvider.Stop futureStop = provider.getParent(stop);
        this.LOG.debug("Creating next stop request node instance " + provider.getStopIdentifier(futureStop) + " as parent of " + provider.getStopIdentifier(stop));
        RouteNode requestsPrototype = this.getStopRequestNode(futureStop, context.getDocument().getDocumentType());
        RouteNodeInstance requestNode = helper.getNodeFactory().createRouteNodeInstance(context.getDocument().getDocumentId(), requestsPrototype);
        requestNode.setBranch(processInstance.getBranch());
        NodeState ns = new NodeState();
        ns.setKey(STOP_ID);
        ns.setValue(provider.getStopIdentifier(futureStop));
        requestNode.addNodeState(ns);
        provider.setStop(requestNode, futureStop);
        this.LOG.debug("Stop set on request node: " + provider.getStop(requestNode));
        this.addStopToProcessState(provider, processInstance, futureStop);
        return requestNode;
    }

    private InnerTransitionResult canTransitionFrom(HierarchyProvider provider, HierarchyProvider.Stop currentStop, Collection<RouteNodeInstance> requestNodes, RouteHelper helper) {
        this.LOG.debug("Testing whether we can transition from stop: " + currentStop);
        HierarchyProvider.Stop parent = provider.getParent(currentStop);
        InnerTransitionResult result = new InnerTransitionResult();
        result.setCanTransition(false);
        for (RouteNodeInstance requestNode : requestNodes) {
            if (!provider.hasStop(requestNode)) {
                this.LOG.debug("request node " + requestNode.getName() + " does not have a stop associated with it");
                continue;
            }
            HierarchyProvider.Stop requestNodeStop = provider.getStop(requestNode);
            if (requestNodeStop != null) {
                this.LOG.debug("Request node: " + requestNode.getRouteNodeInstanceId() + " has stop " + requestNodeStop.toString());
            }
            if (requestNodeStop != null && provider.equals(currentStop, requestNodeStop)) {
                this.LOG.debug("Skipping node " + requestNode.getName() + " because it is associated with the current stop");
                continue;
            }
            HierarchyProvider.Stop stop = provider.getStop(requestNode);
            this.LOG.debug("Found an outstanding stop: " + stop);
            boolean isChildOfMyParent = this.isDescendent(provider, parent, stop);
            if (!isChildOfMyParent) continue;
            this.LOG.debug("Found stop node whose parent is my parent:");
            this.LOG.debug("Stop: " + stop);
            this.LOG.debug("Node: " + requestNode);
            if (!requestNode.isActive()) continue;
            result.getSiblings().clear();
            return result;
        }
        result.setCanTransition(true);
        return result;
    }

    protected boolean isDescendent(HierarchyProvider provider, HierarchyProvider.Stop parent, HierarchyProvider.Stop otherStop) {
        return provider.isRoot(parent) || this.hasAsParent(provider, parent, otherStop);
    }

    private static void markAsInitialSplitNode(RouteNodeInstance splitNode) {
        NodeState ns = new NodeState();
        ns.setKey(INITIAL_SPLIT_NODE_MARKER);
        ns.setValue(INITIAL_SPLIT_NODE_MARKER);
        splitNode.addNodeState(ns);
    }

    private static boolean isInitialSplitNode(RouteNodeInstance routeNodeInstance) {
        return routeNodeInstance.getNodeState(INITIAL_SPLIT_NODE_MARKER) != null;
    }

    private void addStopToProcessState(HierarchyProvider provider, RouteNodeInstance processInstance, HierarchyProvider.Stop stop) {
        String stopStateName = provider.getStopIdentifier(stop);
        NodeState visitedStopsState = processInstance.getNodeState(VISITED_STOPS);
        if (visitedStopsState == null) {
            NodeState ns = new NodeState();
            ns.setKey(VISITED_STOPS);
            ns.setValue(stopStateName + V_STOPS_DEL);
            processInstance.addNodeState(ns);
        } else if (!HierarchyRoutingNode.getVisitedStopsList(processInstance).contains(stopStateName)) {
            visitedStopsState.setValue(visitedStopsState.getValue() + stopStateName + V_STOPS_DEL);
        }
    }

    private static List<String> getVisitedStopsList(RouteNodeInstance process) {
        return Arrays.asList(process.getNodeState(VISITED_STOPS).getValue().split(V_STOPS_DEL));
    }

    private boolean isNewStop(HierarchyProvider provider, HierarchyProvider.Stop stop, RouteNodeInstance process) {
        String orgStateName = provider.getStopIdentifier(stop);
        List<String> visitedOrgs = HierarchyRoutingNode.getVisitedStopsList(process);
        boolean isInVisitedList = visitedOrgs.contains(orgStateName);
        if (isInVisitedList) {
            return false;
        }
        boolean willEventualRouteThere = false;
        Iterator<String> iter = visitedOrgs.iterator();
        while (iter.hasNext() && !willEventualRouteThere) {
            String visitedStopStateName = iter.next();
            HierarchyProvider.Stop visitedStop = provider.getStopByIdentifier(visitedStopStateName);
            willEventualRouteThere = this.hasAsParent(provider, stop, visitedStop) || willEventualRouteThere;
        }
        return !willEventualRouteThere;
    }

    private RouteNodeInstance createInitialRequestNodeInstance(HierarchyProvider provider, HierarchyProvider.Stop stop, RouteNodeInstance splitNodeInstance, RouteNodeInstance processInstance, RouteNode requestsNode) {
        String branchName = "Branch " + provider.getStopIdentifier(stop);
        RouteNodeInstance orgRequestInstance = SplitTransitionEngine.createSplitChild(branchName, requestsNode, splitNodeInstance);
        splitNodeInstance.addNextNodeInstance(orgRequestInstance);
        NodeState ns = new NodeState();
        ns.setKey(STOP_ID);
        ns.setValue(provider.getStopIdentifier(stop));
        orgRequestInstance.addNodeState(ns);
        provider.setStop(orgRequestInstance, stop);
        this.addStopToProcessState(provider, processInstance, stop);
        return orgRequestInstance;
    }

    private List<RouteNodeInstance> getNewlyAddedOrgRouteInstances(HierarchyProvider provider, RouteContext context, RouteHelper helper) throws Exception {
        RouteNodeInstance processInstance = context.getNodeInstance().getProcess();
        RouteNodeInstance chartOrgNode = context.getNodeInstance();
        List<HierarchyProvider.Stop> stops = provider.getLeafStops(context);
        ArrayList<RouteNodeInstance> newStopsRoutingTo = new ArrayList<RouteNodeInstance>();
        for (HierarchyProvider.Stop stop : stops) {
            if (!this.isNewStop(provider, stop, processInstance)) continue;
            List<RouteNodeInstance> processNodes = chartOrgNode.getPreviousNodeInstances();
            for (RouteNodeInstance splitNodeInstance : processNodes) {
                if (!HierarchyRoutingNode.isInitialSplitNode(splitNodeInstance)) continue;
                RouteNode requestsNode = this.getStopRequestNode(stop, context.getDocument().getDocumentType());
                RouteNodeInstance newOrgRequestNode = this.createInitialRequestNodeInstance(provider, stop, splitNodeInstance, processInstance, requestsNode);
                newStopsRoutingTo.add(newOrgRequestNode);
            }
        }
        return newStopsRoutingTo;
    }

    private boolean hasAsParent(HierarchyProvider provider, HierarchyProvider.Stop parent, HierarchyProvider.Stop child) {
        if (child == null || provider.isRoot(child)) {
            return false;
        }
        if (provider.equals(parent, child)) {
            return true;
        }
        child = provider.getParent(child);
        return this.hasAsParent(provider, parent, child);
    }

    private DocumentType setUpDocumentType(HierarchyProvider provider, DocumentType documentType, RouteNodeInstance dynamicNodeInstance) {
        boolean altered = false;
        if (documentType.getNamedProcess(SPLIT_PROCESS_NAME) == null) {
            RouteNode splitNode = HierarchyRoutingNode.getSplitNode(dynamicNodeInstance);
            documentType.addProcess(this.getPrototypeProcess(splitNode, documentType));
            altered = true;
        }
        if (documentType.getNamedProcess(JOIN_PROCESS_NAME) == null) {
            RouteNode joinNode = HierarchyRoutingNode.getJoinNode(dynamicNodeInstance);
            documentType.addProcess(this.getPrototypeProcess(joinNode, documentType));
            altered = true;
        }
        if (documentType.getNamedProcess(REQUEST_PROCESS_NAME) == null) {
            RouteNode requestsNode = this.getRequestNode(provider, dynamicNodeInstance);
            documentType.addProcess(this.getPrototypeProcess(requestsNode, documentType));
            altered = true;
        }
        if (documentType.getNamedProcess(NO_STOP_NAME) == null) {
            RouteNode noChartOrgNode = HierarchyRoutingNode.getNoChartOrgNode(dynamicNodeInstance);
            documentType.addProcess(this.getPrototypeProcess(noChartOrgNode, documentType));
            altered = true;
        }
        if (altered) {
            KEWServiceLocator.getDocumentTypeService().save(documentType);
        }
        return KEWServiceLocator.getDocumentTypeService().findByName(documentType.getName());
    }

    protected ProcessDefinitionBo getPrototypeProcess(RouteNode node, DocumentType documentType) {
        ProcessDefinitionBo process = new ProcessDefinitionBo();
        process.setDocumentType(documentType);
        process.setInitial(false);
        process.setInitialRouteNode(node);
        process.setName(node.getRouteNodeName());
        return process;
    }

    private static RouteNode getSplitNode(RouteNodeInstance process) {
        RouteNode dynamicNode = process.getRouteNode();
        RouteNode splitNode = new RouteNode();
        splitNode.setActivationType(dynamicNode.getActivationType());
        splitNode.setDocumentType(dynamicNode.getDocumentType());
        splitNode.setFinalApprovalInd(dynamicNode.getFinalApprovalInd());
        splitNode.setExceptionWorkgroupId(dynamicNode.getExceptionWorkgroupId());
        splitNode.setMandatoryRouteInd(dynamicNode.getMandatoryRouteInd());
        splitNode.setNodeType(SimpleSplitNode.class.getName());
        splitNode.setRouteMethodCode("FR");
        splitNode.setRouteMethodName(null);
        splitNode.setRouteNodeName(SPLIT_PROCESS_NAME);
        return splitNode;
    }

    private static RouteNode getJoinNode(RouteNodeInstance process) {
        RouteNode dynamicNode = process.getRouteNode();
        RouteNode joinNode = new RouteNode();
        joinNode.setActivationType(dynamicNode.getActivationType());
        joinNode.setDocumentType(dynamicNode.getDocumentType());
        joinNode.setFinalApprovalInd(dynamicNode.getFinalApprovalInd());
        joinNode.setExceptionWorkgroupId(dynamicNode.getExceptionWorkgroupId());
        joinNode.setMandatoryRouteInd(dynamicNode.getMandatoryRouteInd());
        joinNode.setNodeType(SimpleJoinNode.class.getName());
        joinNode.setRouteMethodCode("FR");
        joinNode.setRouteMethodName(null);
        joinNode.setRouteNodeName(JOIN_PROCESS_NAME);
        return joinNode;
    }

    private RouteNode getRequestNode(HierarchyProvider provider, RouteNodeInstance process) {
        RouteNode dynamicNode = process.getRouteNode();
        RouteNode requestsNode = new RouteNode();
        requestsNode.setActivationType(dynamicNode.getActivationType());
        requestsNode.setDocumentType(dynamicNode.getDocumentType());
        requestsNode.setFinalApprovalInd(dynamicNode.getFinalApprovalInd());
        requestsNode.setExceptionWorkgroupId(dynamicNode.getExceptionWorkgroupId());
        requestsNode.setMandatoryRouteInd(dynamicNode.getMandatoryRouteInd());
        requestsNode.setNodeType(RequestsNode.class.getName());
        requestsNode.setRouteMethodCode("FR");
        requestsNode.setRouteMethodName(process.getRouteNode().getRouteMethodName());
        requestsNode.setRouteNodeName(REQUEST_PROCESS_NAME);
        provider.configureRequestNode(process, requestsNode);
        return requestsNode;
    }

    private static RouteNode getNoChartOrgNode(RouteNodeInstance process) {
        RouteNode dynamicNode = process.getRouteNode();
        RouteNode noChartOrgNOde = new RouteNode();
        noChartOrgNOde.setActivationType(dynamicNode.getActivationType());
        noChartOrgNOde.setDocumentType(dynamicNode.getDocumentType());
        noChartOrgNOde.setFinalApprovalInd(dynamicNode.getFinalApprovalInd());
        noChartOrgNOde.setExceptionWorkgroupId(dynamicNode.getExceptionWorkgroupId());
        noChartOrgNOde.setMandatoryRouteInd(dynamicNode.getMandatoryRouteInd());
        noChartOrgNOde.setNodeType(NoOpNode.class.getName());
        noChartOrgNOde.setRouteMethodCode("FR");
        noChartOrgNOde.setRouteMethodName(null);
        noChartOrgNOde.setRouteNodeName(NO_STOP_NAME);
        return noChartOrgNOde;
    }

    protected RouteNode getStopRequestNode(HierarchyProvider.Stop stop, DocumentType documentType) {
        return documentType.getNamedProcess(REQUEST_PROCESS_NAME).getInitialRouteNode();
    }

    private static class InnerTransitionResult {
        private boolean canTransition;
        private List<RouteNodeInstance> siblings = new ArrayList<RouteNodeInstance>();

        private InnerTransitionResult() {
        }

        public boolean isCanTransition() {
            return this.canTransition;
        }

        public void setCanTransition(boolean canTransition) {
            this.canTransition = canTransition;
        }

        public List<RouteNodeInstance> getSiblings() {
            return this.siblings;
        }

        public void setSiblings(List<RouteNodeInstance> siblings) {
            this.siblings = siblings;
        }
    }
}

