/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.transition;

import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.transition.DynamicTransitionEngine;
import org.kuali.rice.kew.engine.transition.JoinTransitionEngine;
import org.kuali.rice.kew.engine.transition.SimpleTransitionEngine;
import org.kuali.rice.kew.engine.transition.SplitTransitionEngine;
import org.kuali.rice.kew.engine.transition.SubProcessTransitionEngine;
import org.kuali.rice.kew.engine.transition.TransitionEngine;

public class TransitionEngineFactory {
    public static TransitionEngine createTransitionEngine(RouteNodeInstance nodeInstance) throws Exception {
        RouteHelper helper = new RouteHelper();
        RouteNode routeNode = nodeInstance.getRouteNode();
        TransitionEngine engine = null;
        if (helper.isSimpleNode(routeNode)) {
            engine = new SimpleTransitionEngine();
        } else if (helper.isSplitNode(routeNode)) {
            engine = new SplitTransitionEngine();
        } else if (helper.isJoinNode(routeNode)) {
            engine = new JoinTransitionEngine();
        } else if (helper.isDynamicNode(routeNode)) {
            engine = new DynamicTransitionEngine();
        } else if (helper.isSubProcessNode(routeNode)) {
            engine = new SubProcessTransitionEngine();
        } else {
            throw new WorkflowException("Could not locate transition engine for node " + routeNode.getNodeType());
        }
        engine.setRouteHelper(helper);
        return engine;
    }
}

