/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.checksums;

import java.nio.ByteBuffer;
import java.util.Optional;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.checksums.SdkChecksum;
import software.amazon.awssdk.utils.BinaryUtils;

@SdkInternalApi
public class ChecksumCalculatingAsyncRequestBody
implements AsyncRequestBody {
    private final AsyncRequestBody wrapped;
    private final SdkChecksum sdkChecksum;

    public ChecksumCalculatingAsyncRequestBody(AsyncRequestBody wrapped, SdkChecksum sdkChecksum) {
        this.wrapped = wrapped;
        this.sdkChecksum = sdkChecksum;
    }

    public Optional<Long> contentLength() {
        return this.wrapped.contentLength();
    }

    public void subscribe(Subscriber<? super ByteBuffer> s) {
        this.sdkChecksum.reset();
        this.wrapped.subscribe((Subscriber)new ChecksumCalculatingSubscriber(s, this.sdkChecksum));
    }

    private static final class ChecksumCalculatingSubscriber
    implements Subscriber<ByteBuffer> {
        private final Subscriber<? super ByteBuffer> wrapped;
        private final SdkChecksum checksum;

        ChecksumCalculatingSubscriber(Subscriber<? super ByteBuffer> wrapped, SdkChecksum sdkChecksum) {
            this.wrapped = wrapped;
            this.checksum = sdkChecksum;
        }

        public void onSubscribe(Subscription s) {
            this.wrapped.onSubscribe(s);
        }

        public void onNext(ByteBuffer byteBuffer) {
            byte[] buf = BinaryUtils.copyBytesFrom((ByteBuffer)byteBuffer);
            this.checksum.update(buf, 0, buf.length);
            this.wrapped.onNext((Object)byteBuffer);
        }

        public void onError(Throwable t) {
            this.wrapped.onError(t);
        }

        public void onComplete() {
            this.wrapped.onComplete();
        }
    }
}

