<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2014 - 2020 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->

<xsl:stylesheet xmlns:PHSHumanSubjectsAndClinicalTrialsInfo_3_0="http://apply.grants.gov/forms/PHSHumanSubjectsAndClinicalTrialsInfo_3_0-V3.0"
				xmlns:codes="http://apply.grants.gov/system/UniversalCodes-V2.0"
				version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  
				xmlns:fo="http://www.w3.org/1999/XSL/Format"
				xmlns:grant="http://apply.grants.gov/system/MetaGrantApplication" 
				xmlns:HumanSubjectStudy_3_0="http://apply.grants.gov/forms/HumanSubjectStudy_3_0-V3.0"
				xmlns:glob="http://apply.grants.gov/system/Global-V1.0"
				xmlns:att="http://apply.grants.gov/system/Attachments-V1.0" 
				xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" 
				xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" 
				xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
				xmlns:header="http://apply.grants.gov/system/Header-V1.0">
	
	<xsl:param name="govTrackingNumber" />
	<xsl:param name="opportunityID" />
	<xsl:param name="receivedDateTime" />
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:template match="PHSHumanSubjectsAndClinicalTrialsInfo_3_0:PHSHumanSubjectsAndClinicalTrialsInfo_3_0">
		<fo:root>
			<fo:layout-master-set> 
				<fo:simple-page-master master-name="first" 
					page-height="11in" page-width="8.5in" margin-left="0.2in" 
					margin-right="0.2in"> 
					<fo:region-body margin-top="1.30in" margin-bottom="0.6in" /> 
					<fo:region-before region-name="region-before-first" 
						extent="0.1in" /> 
					<fo:region-after region-name="region-after-all" 
						extent="0.6in" />
				</fo:simple-page-master>
				<fo:simple-page-master master-name="rest"
					page-height="11in" page-width="8.5in" margin-left="0.2in"
					margin-right="0.2in">
					<fo:region-body margin-top="0.5in" margin-bottom="0.6in" />
					<fo:region-after region-name="region-after-all"
						extent="0.6in" />
				</fo:simple-page-master>
 
				<fo:page-sequence-master master-name="all-pages">
					<fo:repeatable-page-master-alternatives>
						<fo:conditional-page-master-reference
							master-reference="first" page-position="first" />
						<fo:conditional-page-master-reference
							master-reference="rest" page-position="rest" />
					</fo:repeatable-page-master-alternatives>
				</fo:page-sequence-master>
			</fo:layout-master-set> 
			
			<fo:page-sequence master-reference="all-pages" initial-page-number="1" format="1">
							
				<fo:static-content flow-name="region-before-first">
					<fo:block-container position="absolute" left="0.2in"
						top="0.5in" height="15px">
						<fo:block text-align="center" font-size="12px"
							font-family="arialuni" font-weight="bold">PHS Human Subjects and Clinical Trials Information
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="0.2in"
						top="0.7in" height="12px">
						<fo:block text-align="end" font-size="6px" font-family="arialuni">OMB Number: 0925-0001
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="0.2in"
						top="0.9in" height="12px">
						<fo:block text-align="end" font-size="6px" font-family="arialuni">Expiration Date: 02/28/2023
						</fo:block>
					</fo:block-container>
				</fo:static-content>
				
				<fo:static-content flow-name="region-after-all">
					<fo:table width="100%" space-before.optimum="0pt"
						space-after.optimum="0pt" table-layout="fixed">
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-body> 
						<!--  -->
							<fo:table-row>
								<fo:table-cell hyphenate="true" language="en"
									padding-start="0pt" padding-end="0pt" padding-before="1pt"
									padding-after="1pt" display-align="before" text-align="left"
									border-style="solid" border-width="0pt" border-color="white">
									<fo:block>
										<fo:inline font-size="8px">
											Tracking Number: 
											<xsl:value-of select="$govTrackingNumber" />
										</fo:inline>
									</fo:block>
								</fo:table-cell> 
								<fo:table-cell hyphenate="true" language="en" 
									line-height="9pt" padding-start="0pt" padding-end="0pt" 
									padding-before="1pt" padding-after="1pt" display-align="before" 
									text-align="right" border-style="solid" border-width="0pt" 
									border-color="white">
									<fo:block>
										<fo:inline font-size="8px">
											Funding Opportunity Number:
											<xsl:value-of select="$opportunityID" />
										</fo:inline>
										<fo:inline font-size="8px">
											Received Date: 
											<xsl:value-of select="$receivedDateTime" />
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>			
			
		
			
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
							<xsl:call-template name="phsClinicalTrialSummaryTemplate" />
					</fo:block>
				</fo:flow>
			</fo:page-sequence>
			
		</fo:root>
	</xsl:template>
	
	<xsl:template name="phsClinicalTrialSummaryTemplate">
					<!-- table which should have all the attachment listings -->
				<fo:table font-size="12pt" width="100%"
						space-before.optimum="1pt" space-after.optimum="1pt" table-layout="fixed"
						height="100%">
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />

						<fo:table-body start-indent="20pt">
								<!-- Empty line -->
								<fo:table-row>
									<fo:table-cell>
										<fo:block>
											<fo:leader leader-pattern="space" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								
								<fo:table-row>
									<fo:table-cell>
										<fo:block>
											<fo:leader leader-pattern="space" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								
								<fo:table-row>
									<fo:table-cell>
										<fo:block>
											<fo:leader leader-pattern="space" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								
								<fo:table-row>
									<fo:table-cell>
										<fo:block>
											<fo:leader leader-pattern="space" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
									<fo:table-row>
												<fo:table-cell hyphenate="true" language="en"
															 line-height="11pt" number-columns-spanned= "5" padding-start="2pt"
															 padding-end="2pt" padding-before="2pt" padding-after="2pt"
															 display-align="center" text-align="start" border-style="solid"
															 border-width="1pt" border-color="white">
											<fo:block font-size="9px" font-weight="bold">Use of Human Specimens and/or Data</fo:block>										
										</fo:table-cell>																			   
									</fo:table-row>
									<fo:table-row>
												<fo:table-cell hyphenate="true" language="en"
															 line-height="11pt" number-columns-spanned= "5" padding-start="20pt"
															 padding-end="2pt" padding-before="2pt" padding-after="2pt"
															 display-align="center" text-align="start" border-style="solid"
															 border-width="1pt" border-color="white">
											<fo:block font-size="8px">Does any of the proposed research in the application involve human specimens and/or data *</fo:block>										
										</fo:table-cell>
										
										    <xsl:call-template name="radio-field">
												<xsl:with-param name="xml_field" select="PHSHumanSubjectsAndClinicalTrialsInfo_3_0:InvolveHumanSpecimens"/>
											</xsl:call-template>   
									</fo:table-row>
									 		<fo:table-row>
												<fo:table-cell hyphenate="true" language="en"
															 line-height="11pt" number-columns-spanned= "5" padding-start="20pt"
															 padding-end="2pt" padding-before="2pt" padding-after="2pt"
															  text-align="start" border-style="solid"
															 border-width="1pt" border-color="white">
									 				<fo:block font-size="8px">Provide an explanation for any use of human specimens and/or data not considered to be human subjects research.</fo:block>
									 			</fo:table-cell>
				
									<fo:table-cell hyphenate="true" language="en"
										line-height="11pt" number-columns-spanned="8" padding-start="28pt"
										padding-end="2pt" padding-before="2pt" padding-after="2pt"
										 text-align="start" border-style="solid"
										border-width="1pt" border-color="white">
								 			<xsl:variable name="text"><xsl:value-of select="PHSHumanSubjectsAndClinicalTrialsInfo_3_0:Explanation/PHSHumanSubjectsAndClinicalTrialsInfo_3_0:attFile/att:FileName"/> </xsl:variable>
											<xsl:variable name="string-mod">
											    <xsl:call-template name="string-replace">
											        <xsl:with-param name="str" select="$text" />
											        <xsl:with-param name="gap" select="85"/>
											    </xsl:call-template>
											</xsl:variable>
								 			<fo:block font-size="8px"><xsl:value-of select="$string-mod"/></fo:block>										 									
									</fo:table-cell>	
									 		</fo:table-row>
								<fo:table-row height="20px">
									<xsl:choose>
										<xsl:when test="PHSHumanSubjectsAndClinicalTrialsInfo_3_0:HumanSubjectsIndicator = 'Y: Yes'">
												<fo:table-cell hyphenate="true" language="en"
															 line-height="11pt" number-columns-spanned= "5" padding-start="2pt"
															 padding-end="2pt" padding-before="2pt" padding-after="2pt"
															 display-align="center" text-align="start" border-style="solid"
															 border-width="1pt" border-color="white">
			                                        <fo:block font-size="8px">Are Human Subjects Involved
			                                        </fo:block>
			                                   </fo:table-cell>
										</xsl:when>
										<xsl:otherwise>
												<fo:table-cell hyphenate="true" language="en"
															 line-height="11pt" number-columns-spanned= "5" padding-start="2pt"
															 padding-end="2pt" padding-before="2pt" padding-after="2pt"
															 display-align="center" text-align="start" border-style="solid"
															 border-width="1pt" border-color="white">
			                                        <fo:block font-size="8px">Are Human Subjects Involved
			                                        </fo:block>
			                                   </fo:table-cell>										
										</xsl:otherwise>
									</xsl:choose>
											<xsl:call-template name="radio-field">
												<xsl:with-param name="xml_field" select="PHSHumanSubjectsAndClinicalTrialsInfo_3_0:HumanSubjectsIndicator"/>
											</xsl:call-template>                                                                          
			                      </fo:table-row>
			                      <fo:table-row height="20px">
			                      	<xsl:choose>
										<xsl:when test="PHSHumanSubjectsAndClinicalTrialsInfo_3_0:ExemptFedReg = 'Y: Yes'">
												<fo:table-cell hyphenate="true" language="en"
															 line-height="11pt" number-columns-spanned= "5" padding-start="2pt"
															 padding-end="2pt" padding-before="2pt" padding-after="2pt"
															 display-align="center" text-align="start" border-style="solid"
															 border-width="1pt" border-color="white">
			                                        <fo:block font-size="8px">Is the Project Exempt from Federal regulations?
			                                        </fo:block>
			                                   </fo:table-cell>
										</xsl:when>
										<xsl:otherwise>
												<fo:table-cell hyphenate="true" language="en"
															 line-height="11pt" number-columns-spanned= "5" padding-start="2pt"
															 padding-end="2pt" padding-before="2pt" padding-after="2pt"
															 display-align="center" text-align="start" border-style="solid"
															 border-width="1pt" border-color="white">
			                                        <fo:block font-size="8px">Is the Project Exempt from Federal regulations?
			                                        </fo:block>
			                                   </fo:table-cell>										
										</xsl:otherwise>
									</xsl:choose>
									<xsl:call-template name="radio-field">
												<xsl:with-param name="xml_field" select="PHSHumanSubjectsAndClinicalTrialsInfo_3_0:ExemptFedReg"/>
									</xsl:call-template>  
			                      </fo:table-row>
			                      <fo:table-row height="20px">
			                      	<fo:table-cell hyphenate="true" language="en"  line-height="11pt" number-columns-spanned= "5" padding-start="2pt"
															 padding-end="2pt" padding-before="2pt" padding-after="2pt"
															 display-align="center" text-align="start" border-style="solid"
															 border-width="1pt" border-color="white">
										<fo:block font-size="8px">Exemption Number</fo:block>
									</fo:table-cell>
									<fo:table-cell hyphenate="true" language="en" line-height="11pt" number-columns-spanned="6" padding-start="28pt"
												   padding-end="2pt" padding-before="2pt" padding-after="2pt"
										            text-align="start" border-style="solid"
										           border-width="1pt" border-color="white">
												<fo:table font-size="9px" table-layout="fixed" 	width="100%">
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-column column-width="proportional-column-width(1)" />
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<xsl:call-template name="exemption_checkbox">
																<xsl:with-param name="checkbox_value">E1</xsl:with-param>
																<xsl:with-param name="checkbox_text">1</xsl:with-param>
															</xsl:call-template>

															<xsl:call-template name="exemption_checkbox">
																<xsl:with-param name="checkbox_value">E2</xsl:with-param>
																<xsl:with-param name="checkbox_text">2</xsl:with-param>
															</xsl:call-template>

															<xsl:call-template name="exemption_checkbox">
																<xsl:with-param name="checkbox_value">E3</xsl:with-param>
																<xsl:with-param name="checkbox_text">3</xsl:with-param>
															</xsl:call-template>
			
															<xsl:call-template name="exemption_checkbox">
																<xsl:with-param name="checkbox_value">E4</xsl:with-param>
																<xsl:with-param name="checkbox_text">4</xsl:with-param>
															</xsl:call-template>
														
															<xsl:call-template name="exemption_checkbox">
																<xsl:with-param name="checkbox_value">E5</xsl:with-param>
																<xsl:with-param name="checkbox_text">5</xsl:with-param>
															</xsl:call-template>
														
															<xsl:call-template name="exemption_checkbox">
																<xsl:with-param name="checkbox_value">E6</xsl:with-param>
																<xsl:with-param name="checkbox_text">6</xsl:with-param>
															</xsl:call-template>
															
															<xsl:call-template name="exemption_checkbox">
																<xsl:with-param name="checkbox_value">E7</xsl:with-param>
																<xsl:with-param name="checkbox_text">7</xsl:with-param>
															</xsl:call-template>
															
															 <xsl:call-template name="exemption_checkbox">
																<xsl:with-param name="checkbox_value">E8</xsl:with-param>
																<xsl:with-param name="checkbox_text">8</xsl:with-param>
															</xsl:call-template>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:table-cell>
									
			                      </fo:table-row>
			                      <fo:table-row height="20px">
									<fo:table-cell hyphenate="true" language="en"
										line-height="11pt" number-columns-spanned="5" padding-start="2pt"
										padding-end="2pt" padding-before="2pt" padding-after="2pt"
										 text-align="start" border-style="solid"
										border-width="1pt" border-color="white">
								 				<fo:block font-size="8px">Other Requested Information</fo:block>
								 			</fo:table-cell>
				
									<fo:table-cell hyphenate="true" language="en"
										line-height="11pt" number-columns-spanned="8" padding-start="28pt"
										padding-end="2pt" padding-before="2pt" padding-after="2pt"
										 text-align="start" border-style="solid"
										border-width="1pt" border-color="white">								 			
								 			<xsl:variable name="text"><xsl:value-of select="PHSHumanSubjectsAndClinicalTrialsInfo_3_0:OtherRequestedInformation/PHSHumanSubjectsAndClinicalTrialsInfo_3_0:attFile/att:FileName"/> </xsl:variable>
											<xsl:variable name="string-mod">
											    <xsl:call-template name="string-replace">
											        <xsl:with-param name="str" select="$text" />
											        <xsl:with-param name="gap" select="85"/>
											    </xsl:call-template>
											</xsl:variable>
								 			<fo:block font-size="8px"><xsl:value-of select="$string-mod"/></fo:block>	
								 			
								 										
									</fo:table-cell>																
								</fo:table-row>
							<xsl:if test="PHSHumanSubjectsAndClinicalTrialsInfo_3_0:HumanSubjectsIndicator = 'Y: Yes'">				                      						
								<fo:table-row>
									<fo:table-cell hyphenate="true" language="en"
										line-height="11pt" number-columns-spanned="3" padding-start="2pt"
										padding-end="2pt" padding-before="2pt" padding-after="2pt"
										 text-align="start" border-style="solid"
										border-width="1pt" border-color="white">
										<fo:block page-break-before="always">
											<fo:inline font-size="9px" font-weight="bold">
												Human Subject Studies
											</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell hyphenate="true" language="en"
										line-height="11pt" number-columns-spanned="13" padding-before="2pt" padding-after="2pt"
										 text-align="left" border-style="solid"
										border-width="1pt" border-color="white">
										<fo:block>
											<fo:table width="100%" space-before.optimum="1pt" space-after.optimum="2pt" table-layout="fixed"  border-style="solid">
																		<fo:table-column column-width="20%"/> 
																		<fo:table-column column-width="60%"/> 
																		<fo:table-column column-width="20%"/> 
																		 <fo:table-header start-indent="0pt">
																			  <fo:table-cell padding="2pt"  border-style="solid">
													                             	<fo:block font-weight="bold" font-size="8px"> Study#</fo:block>
													                          </fo:table-cell>
													                          <fo:table-cell padding="2pt"  border-style="solid">
													                           		<fo:block font-weight="bold" font-size="8px"> Study Title</fo:block>
													                          </fo:table-cell>
													                           <fo:table-cell padding="2pt"  border-style="solid">
													                                 <fo:block font-weight="bold" font-size="8px"> Clinical Trial?</fo:block>
													                                   </fo:table-cell>					 	
																		 </fo:table-header>
																			<fo:table-body start-indent="0pt">
																				<xsl:variable name="length" select="count(PHSHumanSubjectsAndClinicalTrialsInfo_3_0:HumanSubjectStudyAttachment/HumanSubjectStudy_3_0:HumanSubjectStudy_3_0)"/>
																				<xsl:if test="$length = 0">
																				<fo:table-cell padding="2pt"  number-columns-spanned="3">
													                           			<fo:block font-size="8px">The form does not have any study records</fo:block>
													                          	</fo:table-cell>
																		</xsl:if>
																		<xsl:for-each select="PHSHumanSubjectsAndClinicalTrialsInfo_3_0:HumanSubjectStudyAttachment/HumanSubjectStudy_3_0:HumanSubjectStudy_3_0">
																				<xsl:variable name="i" select="position()" />
																				<fo:table-row>
																					<fo:table-cell padding="2pt"  border-style="solid">
															                             <fo:block font-size="8px">
															                                 <fo:inline border-bottom="solid 0.3mm">
															                                 <xsl:value-of select='$i'/>
															                                 </fo:inline>
															                             </fo:block>
															                          </fo:table-cell>
															                          <fo:table-cell padding="2pt"  border-style="solid">
															                            <fo:block font-size="8px"><xsl:value-of select="HumanSubjectStudy_3_0:StudyTitle"/></fo:block>
															                            </fo:table-cell>
															                            <fo:table-cell padding="2pt"  border-style="solid">
															                         <fo:block font-size="8px">												                              		                              
															                            <xsl:choose>
															                             <xsl:when test="(HumanSubjectStudy_3_0:ClinicalTrialQuestionnaire/HumanSubjectStudy_3_0:HumanSubjectsIndicator = 'Y: Yes') and
															                              				(HumanSubjectStudy_3_0:ClinicalTrialQuestionnaire/HumanSubjectStudy_3_0:InterventionAssigned = 'Y: Yes') and
															                              				(HumanSubjectStudy_3_0:ClinicalTrialQuestionnaire/HumanSubjectStudy_3_0:EvaluateIntervention = 'Y: Yes') and
															                              				(HumanSubjectStudy_3_0:ClinicalTrialQuestionnaire/HumanSubjectStudy_3_0:HealthRelatedOutcome = 'Y: Yes')"> Yes</xsl:when>
															                             <xsl:otherwise> No </xsl:otherwise>
															                            </xsl:choose>
															                       </fo:block>
															               	</fo:table-cell>
													                              
																	</fo:table-row>
																</xsl:for-each>
																			 
														</fo:table-body>
												</fo:table>															
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								</xsl:if>
								
			               </fo:table-body>
						</fo:table>
						
<!-- adding space between gap -->
				
	</xsl:template>
		<xsl:template name="string-replace">
		        <xsl:param name="str"/>
		        <xsl:param name="gap"/>		        
		        <xsl:choose>
		            <xsl:when test="string-length($str) > $gap">
		                <xsl:value-of select="substring($str,1,$gap)"/>
		                <xsl:value-of select="' '"/>		                
		                <xsl:call-template name="string-replace">
		                    <xsl:with-param name="str" select="substring($str,$gap + 1)"/>
		                    <xsl:with-param name="gap" select="$gap"/>
		                </xsl:call-template>
		            </xsl:when>
		            <xsl:otherwise>
		                <xsl:value-of select="$str"/>
		            </xsl:otherwise>
		        </xsl:choose>
		    </xsl:template>

	
	<!--  Create label with display text, ${label_text} -->
	<xsl:template name="label">
		<xsl:param name="padding-start" select="3" />
		<xsl:param name="number-columns-spanned" select="2" />
		<xsl:param name="label_text" />

		<fo:table-cell number-columns-spanned="{$number-columns-spanned}"
			text-align="left" padding-start="{$padding-start}" padding-end="3pt"
			padding-before="1pt" padding-after="6pt">
			<fo:block font-family="arialuni" font-size="9px">
				<xsl:value-of select="$label_text" />
			</fo:block>
		</fo:table-cell>
	</xsl:template>
   
   
   <!--  
	Creates radio field for a given ${xml_field} with 'Yes' or 'No' options
	Marks the value where ${xml_field} = radio_box value as selected
	 -->
	<xsl:template name="radio-field">
		<xsl:param name="xml_field" />
						<fo:table-cell hyphenate="true" language="en"
							line-height="11pt" padding-start="2pt" number-columns-spanned="4"
							padding-end="2pt" padding-before="2pt" padding-after="2pt"
							display-align="center" text-align="start" 
							border-width="1pt" border-color="white">
			<fo:block>
				<fo:table font-size="9px" table-layout="fixed" width="100%">
					<fo:table-column column-width="proportional-column-width(1)" />
					<fo:table-body start-indent="0pt">
						<fo:table-row>
							<fo:table-cell border="solid 1pt white" border-spacing="1pt" padding="2pt">
								<fo:table>
									<fo:table-column column-width="25%" />
									<fo:table-column column-width="25%" />
									<fo:table-column column-width="25%" />
									<fo:table-column column-width="25%" />
									<fo:table-body>
										<fo:table-row>
											<xsl:call-template name="yesOrNoRadio">
												<xsl:with-param name="xml_field" select="$xml_field" />
											</xsl:call-template>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	
	<xsl:template name="yesOrNoRadio">
		<xsl:param name="xml_field" />
		<!-- YES -->
		<xsl:call-template name="options">
			<xsl:with-param name="xml_field" select="$xml_field" />
			<xsl:with-param name="radio_text">
				Yes
			</xsl:with-param>
			<xsl:with-param name="radio_value">
				Y: Yes
			</xsl:with-param>
		</xsl:call-template>
		<!-- NO -->
		<xsl:call-template name="options">
			<xsl:with-param name="xml_field" select="$xml_field" />
			<xsl:with-param name="radio_text">
				No
			</xsl:with-param>
			<xsl:with-param name="radio_value">
				N: No
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="options">
		<xsl:param name="xml_field" />
		<xsl:param name="radio_text" />
		<xsl:param name="radio_value" />
		<fo:table-cell  text-align="right" border-spacing="2px" display-align="center">
			<fo:block>
				<xsl:call-template name="radio">
					<xsl:with-param name="xml_field" select="$xml_field" />
					<xsl:with-param name="radio_value" select="$radio_value" />
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell text-align="left" border-spacing="2px" display-align="center">
			<fo:block>
				<xsl:value-of select="$radio_text" />
			</fo:block>
		</fo:table-cell>
	</xsl:template>

	<xsl:template name="radio">
		<xsl:param name="xml_field" />
		<xsl:param name="radio_value" />
		<xsl:choose>
			<xsl:when
				test="normalize-space($xml_field) = normalize-space($radio_value)">
				<fo:inline font-family="ZapfDingbats" font-size="9px" padding-start="7pt" padding-end="7pt">&#x25cf;</fo:inline>
			</xsl:when>
			<xsl:otherwise>
				<fo:inline font-family="ZapfDingbats" font-size="9px" padding-start="7pt" padding-end="7pt" >&#x274d;</fo:inline>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!--  
	Create checkboxes with display text, ${checkbox_text}, and assign the value, ${checkbox_value}
	If the checkbox value is contained in ExemptionNumber Node, the checkbox is marked off
	 -->
	<xsl:template name="exemption_checkbox">
		<xsl:param name="checkbox_text" />
		<xsl:param name="checkbox_value" />
		<fo:table-cell hyphenate="true" language="en" padding-start="0pt" padding-end="0pt" padding-before="0pt"
		padding-after="0pt" display-align="before" text-align="start"
		border-style="solid" border-width="0pt" border-color="white">
			<fo:block font-size="9px">
				<fo:inline font-family="ZapfDingbats">&#x274F;</fo:inline>
				<fo:block-container keep-together="always"
					position="absolute">
					<fo:block>
						<xsl:choose>
							<xsl:when
								test="normalize-space($checkbox_value) = PHSHumanSubjectsAndClinicalTrialsInfo_3_0:ExemptionNumbers/PHSHumanSubjectsAndClinicalTrialsInfo_3_0:ExemptionNumber">
								<fo:inline font-family="ZapfDingbats" font-size="8pt">&#x2714;
								</fo:inline>
							</xsl:when>
						</xsl:choose>
					</fo:block>
				</fo:block-container>
				<fo:block-container position="absolute" left="10pt">
					<fo:block>
						<xsl:value-of select="$checkbox_text" />
					</fo:block>
				</fo:block-container>
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	
</xsl:stylesheet>
