/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.dd;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.dd.DataDictionaryOverride;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.impl.dd.DataDictionaryOverrideUtils;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.maintenance.KualiMaintainableImpl;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.service.SequenceAccessorService;

public class DataDictionaryOverrideMaintainableImpl
extends KualiMaintainableImpl {
    private static final String DATA_DICTIONARY_RUNTIME_OVERRIDE_PARM = "DATA_DICTIONARY_RUNTIME_OVERRIDE";
    private static final String SEQ_DD_OVERRIDE_ID = "SEQ_DD_OVERRIDE_ID";
    private transient ParameterService parameterService;
    private transient SequenceAccessorService sequenceAccessorService;

    public void saveBusinessObject() {
        DataDictionaryOverride override = (DataDictionaryOverride)this.getBusinessObject();
        if (!"Delete".equals(this.getMaintenanceAction())) {
            if (StringUtils.isBlank((CharSequence)override.getId())) {
                override.setId(this.getSequenceAccessorService().getNextAvailableSequenceNumber(SEQ_DD_OVERRIDE_ID, DataDictionaryOverride.class).toString());
            }
            if (this.isRuntimeApplicationEnabled()) {
                this.resetDataDictionary(override.isActive() ? DataDictionaryOverrideUtils.createNewWithOverride(this.getDataDictionaryService().getDataDictionary(), override.getId(), override.getAttachmentContent()) : DataDictionaryOverrideUtils.createNewRemovingOverride(this.getDataDictionaryService().getDataDictionary(), override.getId()));
            }
            super.saveBusinessObject();
        }
    }

    protected void resetDataDictionary(DataDictionary modifiedDataDictionary) {
        List<org.kuali.rice.krad.service.DataDictionaryService> ddServices = KcServiceLocator.getServicesOfType(org.kuali.rice.krad.service.DataDictionaryService.class);
        ddServices.forEach(ddService -> {
            ddService.setDataDictionary(modifiedDataDictionary);
            if (ddService instanceof DataDictionaryService) {
                ((DataDictionaryService)ddService).getDataDictionaryMap().clear();
            }
        });
    }

    public void deleteDataObject() {
        DataDictionaryOverride override = (DataDictionaryOverride)this.getBusinessObject();
        if (this.isRuntimeApplicationEnabled()) {
            this.resetDataDictionary(DataDictionaryOverrideUtils.createNewRemovingOverride(this.getDataDictionaryService().getDataDictionary(), override.getId()));
        }
        super.deleteDataObject();
    }

    protected boolean isRuntimeApplicationEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-SYS", "All", DATA_DICTIONARY_RUNTIME_OVERRIDE_PARM);
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public SequenceAccessorService getSequenceAccessorService() {
        if (this.sequenceAccessorService == null) {
            this.sequenceAccessorService = KcServiceLocator.getService(SequenceAccessorService.class);
        }
        return this.sequenceAccessorService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }
}

