/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.identity.personal;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kim.api.identity.personal.EntityEthnicityContract;
import org.w3c.dom.Element;

@XmlRootElement(name="entityEthnicity")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="EntityEthnicityType", propOrder={"id", "entityId", "ethnicityCode", "ethnicityCodeUnmasked", "subEthnicityCode", "subEthnicityCodeUnmasked", "suppressPersonal", "versionNumber", "objectId", "_futureElements"})
public final class EntityEthnicity
extends AbstractDataTransferObject
implements EntityEthnicityContract {
    @XmlElement(name="entityId", required=false)
    private final String entityId;
    @XmlElement(name="ethnicityCode", required=false)
    private final String ethnicityCode;
    @XmlElement(name="ethnicityCodeUnmasked", required=false)
    private final String ethnicityCodeUnmasked;
    @XmlElement(name="subEthnicityCode", required=false)
    private final String subEthnicityCode;
    @XmlElement(name="subEthnicityCodeUnmasked", required=false)
    private final String subEthnicityCodeUnmasked;
    @XmlElement(name="suppressPersonal", required=false)
    private final boolean suppressPersonal;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private EntityEthnicity() {
        this.entityId = null;
        this.ethnicityCode = null;
        this.ethnicityCodeUnmasked = null;
        this.subEthnicityCode = null;
        this.subEthnicityCodeUnmasked = null;
        this.suppressPersonal = false;
        this.versionNumber = null;
        this.objectId = null;
        this.id = null;
    }

    private EntityEthnicity(Builder builder) {
        this.entityId = builder.getEntityId();
        this.ethnicityCode = builder.getEthnicityCode();
        this.ethnicityCodeUnmasked = builder.getEthnicityCodeUnmasked();
        this.subEthnicityCode = builder.getSubEthnicityCode();
        this.subEthnicityCodeUnmasked = builder.getSubEthnicityCodeUnmasked();
        this.suppressPersonal = builder.isSuppressPersonal();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
        this.id = builder.getId();
    }

    @Override
    public String getEntityId() {
        return this.entityId;
    }

    @Override
    public String getEthnicityCode() {
        return this.ethnicityCode;
    }

    @Override
    public String getEthnicityCodeUnmasked() {
        return this.ethnicityCodeUnmasked;
    }

    @Override
    public String getSubEthnicityCode() {
        return this.subEthnicityCode;
    }

    @Override
    public String getSubEthnicityCodeUnmasked() {
        return this.subEthnicityCodeUnmasked;
    }

    @Override
    public boolean isSuppressPersonal() {
        return this.suppressPersonal;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getId() {
        return this.id;
    }

    static class Elements {
        static final String ENTITY_ID = "entityId";
        static final String ETHNICITY_CODE = "ethnicityCode";
        static final String ETHNICITY_CODE_UNMASKED = "ethnicityCodeUnmasked";
        static final String SUB_ETHNICITY_CODE = "subEthnicityCode";
        static final String SUB_ETHNICITY_CODE_UNMASKED = "subEthnicityCodeUnmasked";
        static final String SUPPRESS_PERSONAL = "suppressPersonal";
        static final String ID = "id";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "entityEthnicity";
        static final String TYPE_NAME = "EntityEthnicityType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    EntityEthnicityContract {
        private String entityId;
        private String ethnicityCode;
        private String subEthnicityCode;
        private boolean suppressPersonal;
        private Long versionNumber;
        private String objectId;
        private String id;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(EntityEthnicityContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create();
            builder.setEntityId(contract.getEntityId());
            builder.setEthnicityCode(contract.getEthnicityCodeUnmasked());
            builder.setSubEthnicityCode(contract.getSubEthnicityCodeUnmasked());
            builder.setSuppressPersonal(contract.isSuppressPersonal());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            builder.setId(contract.getId());
            return builder;
        }

        public EntityEthnicity build() {
            return new EntityEthnicity(this);
        }

        @Override
        public String getEntityId() {
            return this.entityId;
        }

        @Override
        public String getEthnicityCode() {
            if (this.isSuppressPersonal()) {
                return "Xxxxxx";
            }
            return this.ethnicityCode;
        }

        @Override
        public String getEthnicityCodeUnmasked() {
            return this.ethnicityCode;
        }

        @Override
        public String getSubEthnicityCode() {
            if (this.isSuppressPersonal()) {
                return "Xxxxxx";
            }
            return this.subEthnicityCode;
        }

        @Override
        public String getSubEthnicityCodeUnmasked() {
            return this.subEthnicityCode;
        }

        @Override
        public boolean isSuppressPersonal() {
            return this.suppressPersonal;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public String getId() {
            return this.id;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public void setEthnicityCode(String ethnicityCode) {
            this.ethnicityCode = ethnicityCode;
        }

        public void setSubEthnicityCode(String subEthnicityCode) {
            this.subEthnicityCode = subEthnicityCode;
        }

        private void setSuppressPersonal(boolean suppressPersonal) {
            this.suppressPersonal = suppressPersonal;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public void setId(String id) {
            if (StringUtils.isWhitespace((String)id)) {
                throw new IllegalArgumentException("id is blank");
            }
            this.id = id;
        }
    }
}

