/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.service.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Element;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.exception.WorkflowServiceErrorImpl;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.RuleTemplateOptionBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateAttributeBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.rule.dao.RuleDAO;
import org.kuali.rice.kew.rule.dao.RuleDelegationDAO;
import org.kuali.rice.kew.rule.dao.RuleTemplateDAO;
import org.kuali.rice.kew.rule.service.RuleAttributeService;
import org.kuali.rice.kew.rule.service.RuleTemplateService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.xml.RuleTemplateXmlParser;
import org.kuali.rice.kew.xml.export.RuleTemplateXmlExporter;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Required;

public class RuleTemplateServiceImpl
implements RuleTemplateService {
    private static final Logger LOG = LogManager.getLogger(RuleTemplateServiceImpl.class);
    private static final String RULE_TEMPLATE_NAME_REQUIRED = "rule.template.name.required";
    private static final String RULE_TEMPLATE_DESCRIPTION_REQUIRED = "rule.template.description.required";
    private static final String XML_PARSE_ERROR = "general.error.parsexml";
    private RuleTemplateDAO ruleTemplateDAO;
    private RuleDAO ruleDAO;
    private RuleDelegationDAO ruleDelegationDAO;
    private DataObjectService dataObjectService;

    @Override
    public void deleteRuleTemplateOption(String ruleTemplateOptionId) {
        RuleTemplateOptionBo ruleTemplateOptionBo = (RuleTemplateOptionBo)((Object)this.getDataObjectService().find(RuleTemplateOptionBo.class, (Object)ruleTemplateOptionId));
        this.getDataObjectService().delete((Object)ruleTemplateOptionBo);
    }

    @Override
    public RuleTemplateBo findByRuleTemplateName(String ruleTemplateName) {
        return this.getRuleTemplateDAO().findByRuleTemplateName(ruleTemplateName);
    }

    @Override
    public RuleTemplateAttributeBo findByRuleTemplateAttributeId(String ruleTemplateAttributeId) {
        return (RuleTemplateAttributeBo)this.getDataObjectService().find(RuleTemplateAttributeBo.class, (Object)ruleTemplateAttributeId);
    }

    @Override
    public List<RuleTemplateBo> findAll() {
        return this.ruleTemplateDAO.findAll();
    }

    @Override
    public List findByRuleTemplate(RuleTemplateBo ruleTemplate) {
        return this.ruleTemplateDAO.findByRuleTemplate(ruleTemplate);
    }

    @Override
    public RuleTemplateBo save(RuleTemplateBo ruleTemplate) {
        LOG.debug("save RuleTemplateServiceImpl");
        this.validate(ruleTemplate);
        this.fixAssociations(ruleTemplate);
        LOG.debug("end save RuleTemplateServiceImpl");
        return this.getRuleTemplateDAO().save(ruleTemplate);
    }

    @Override
    public void save(RuleTemplateAttributeBo ruleTemplateAttribute) {
        this.getDataObjectService().save((Object)ruleTemplateAttribute, new PersistenceOption[0]);
    }

    @Override
    public void saveRuleDefaults(RuleDelegationBo ruleDelegation, RuleBaseValues ruleBaseValues) {
        KEWServiceLocator.getRuleService().saveRule(ruleBaseValues, false);
        if (ruleDelegation != null) {
            KEWServiceLocator.getRuleService().saveRule(ruleDelegation.getDelegationRule(), false);
            KEWServiceLocator.getRuleDelegationService().save(ruleDelegation);
        }
    }

    private void fixAssociations(RuleTemplateBo ruleTemplate) {
        if (ruleTemplate != null && ruleTemplate.getId() != null) {
            for (RuleTemplateAttributeBo ruleTemplateAttribute : ruleTemplate.getRuleTemplateAttributes()) {
                if (ruleTemplateAttribute.getRuleTemplate() == null || ruleTemplateAttribute.getRuleTemplateId() == null) {
                    ruleTemplateAttribute.setRuleTemplate(ruleTemplate);
                }
                if (ruleTemplateAttribute.getRuleAttribute() != null) continue;
                RuleAttributeService ruleAttributeService = (RuleAttributeService)KEWServiceLocator.getService("enRuleAttributeService");
                ruleTemplateAttribute.setRuleAttribute(ruleAttributeService.findByRuleAttributeId(ruleTemplateAttribute.getRuleAttributeId()));
            }
            for (RuleTemplateOptionBo option : ruleTemplate.getRuleTemplateOptions()) {
                if (option.getRuleTemplate() != null && option.getRuleTemplateId() != null) continue;
                option.setRuleTemplate(ruleTemplate);
            }
        }
    }

    private void validate(RuleTemplateBo ruleTemplate) {
        LOG.debug("validating ruleTemplate");
        ArrayList<WorkflowServiceErrorImpl> errors = new ArrayList<WorkflowServiceErrorImpl>();
        if (ruleTemplate.getName() == null || ruleTemplate.getName().trim().equals("")) {
            errors.add(new WorkflowServiceErrorImpl("Please enter a rule template name.", RULE_TEMPLATE_NAME_REQUIRED));
            LOG.error("Rule template name is missing");
        } else {
            RuleTemplateBo nameInUse;
            ruleTemplate.setName(ruleTemplate.getName().trim());
            if (ruleTemplate.getId() == null && (nameInUse = this.findByRuleTemplateName(ruleTemplate.getName())) != null) {
                errors.add(new WorkflowServiceErrorImpl("Rule template name already in use", "rule.template.name.duplicate"));
                LOG.error("Rule template name already in use");
            }
        }
        if (ruleTemplate.getDescription() == null || ruleTemplate.getDescription().equals("")) {
            errors.add(new WorkflowServiceErrorImpl("Please enter a rule template description.", RULE_TEMPLATE_DESCRIPTION_REQUIRED));
            LOG.error("Rule template description is missing");
        }
        LOG.debug("end validating ruleTemplate");
        if (!errors.isEmpty()) {
            throw new WorkflowServiceErrorException("RuleTemplate Validation Error", errors);
        }
    }

    @Override
    public RuleTemplateBo findByRuleTemplateId(String ruleTemplateId) {
        LOG.debug("findByRuleTemplateId RuleTemplateServiceImpl");
        return this.getRuleTemplateDAO().findByRuleTemplateId(ruleTemplateId);
    }

    @Override
    public void delete(String ruleTemplateId) {
        LOG.debug("delete RuleTemplateServiceImpl");
        this.getRuleTemplateDAO().delete(ruleTemplateId);
        LOG.debug("end delete RuleTemplateServiceImpl");
    }

    public RuleTemplateDAO getRuleTemplateDAO() {
        return this.ruleTemplateDAO;
    }

    public void setRuleTemplateDAO(RuleTemplateDAO ruleTemplateDAO) {
        this.ruleTemplateDAO = ruleTemplateDAO;
    }

    public RuleDAO getRuleDAO() {
        return this.ruleDAO;
    }

    public void setRuleDAO(RuleDAO ruleDAO) {
        this.ruleDAO = ruleDAO;
    }

    public RuleDelegationDAO getRuleDelegationDAO() {
        return this.ruleDelegationDAO;
    }

    public void setRuleDelegationDAO(RuleDelegationDAO ruleDelegationDAO) {
        this.ruleDelegationDAO = ruleDelegationDAO;
    }

    public void loadXml(InputStream inputStream, String principalId) {
        RuleTemplateXmlParser parser = new RuleTemplateXmlParser();
        try {
            parser.parseRuleTemplates(inputStream);
        }
        catch (Exception e) {
            LOG.error("Error loading xml file", (Throwable)e);
            WorkflowServiceErrorException wsee = new WorkflowServiceErrorException("Error loading xml file", new WorkflowServiceErrorImpl("Error loading xml file", XML_PARSE_ERROR));
            wsee.initCause(e);
            throw wsee;
        }
    }

    public Element export(ExportDataSet dataSet) {
        RuleTemplateXmlExporter exporter = new RuleTemplateXmlExporter();
        return exporter.export(dataSet);
    }

    public boolean supportPrettyPrint() {
        return true;
    }

    @Override
    public String getNextRuleTemplateId() {
        return this.getRuleTemplateDAO().getNextRuleTemplateId();
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

