/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.InactivatableFromTo;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.InactivateableFromToService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.LookupService;
import org.kuali.rice.krad.util.BeanPropertyComparator;

public class InactivateableFromToServiceImpl
implements InactivateableFromToService {
    protected DateTimeService dateTimeService;
    protected LookupService lookupService;
    protected DataDictionaryService dataDictionaryService;

    public List<InactivatableFromTo> findMatchingActive(Class<? extends InactivatableFromTo> clazz, Map fieldValues) {
        fieldValues.put("active", "true");
        return (List)this.lookupService.findCollectionBySearchUnbounded(clazz, fieldValues);
    }

    public List<InactivatableFromTo> findMatchingActiveAsOfDate(Class<? extends InactivatableFromTo> clazz, Map fieldValues, Date activeAsOfDate) {
        fieldValues.put("active", "true");
        fieldValues.put("activeAsOfDate", this.dateTimeService.toDateString(activeAsOfDate));
        return (List)this.lookupService.findCollectionBySearchUnbounded(clazz, fieldValues);
    }

    public List<InactivatableFromTo> filterOutNonActive(List<InactivatableFromTo> filterList) {
        return this.filterOutNonActive(filterList, this.dateTimeService.getCurrentDate());
    }

    public List<InactivatableFromTo> filterOutNonActive(List<InactivatableFromTo> filterList, Date activeAsOfDate) {
        ArrayList<InactivatableFromTo> filteredList = new ArrayList<InactivatableFromTo>();
        for (InactivatableFromTo inactivateable : filterList) {
            inactivateable.setActiveAsOfDate(new Timestamp(activeAsOfDate.getTime()));
            if (!inactivateable.isActive()) continue;
            filteredList.add(inactivateable);
        }
        return filteredList;
    }

    public List<InactivatableFromTo> findMatchingCurrent(Class<? extends InactivatableFromTo> clazz, Map fieldValues) {
        fieldValues.put("active", "true");
        fieldValues.put("current", "true");
        return (List)this.lookupService.findCollectionBySearchUnbounded(clazz, fieldValues);
    }

    public List<InactivatableFromTo> findMatchingCurrent(Class<? extends InactivatableFromTo> clazz, Map fieldValues, Date currentAsOfDate) {
        fieldValues.put("active", "true");
        fieldValues.put("current", "true");
        fieldValues.put("activeAsOfDate", this.dateTimeService.toDateString(currentAsOfDate));
        return (List)this.lookupService.findCollectionBySearchUnbounded(clazz, fieldValues);
    }

    public List<InactivatableFromTo> filterOutNonCurrent(List<InactivatableFromTo> filterList) {
        return this.filterOutNonCurrent(filterList, this.dateTimeService.getCurrentDate());
    }

    public List<InactivatableFromTo> filterOutNonCurrent(List<InactivatableFromTo> filterList, Date currentAsOfDate) {
        List<InactivatableFromTo> activeList = this.filterOutNonActive(filterList, currentAsOfDate);
        if (activeList.isEmpty()) {
            return activeList;
        }
        ArrayList<InactivatableFromTo> currentList = new ArrayList();
        List groupByList = this.getDataDictionaryService().getGroupByAttributesForEffectiveDating(activeList.get(0).getClass());
        if (groupByList != null) {
            ArrayList<String> sortByList = new ArrayList<String>(groupByList);
            sortByList.add("activeFromDate");
            Collections.sort(activeList, new BeanPropertyComparator(sortByList, true));
            Collections.reverse(activeList);
            String previousGroupByString = "";
            Timestamp previousActiveFromDate = null;
            for (InactivatableFromTo inactivateable : activeList) {
                String groupByString = this.buildGroupByValueString((BusinessObject)inactivateable, groupByList);
                if (!StringUtils.equals((String)groupByString, (String)previousGroupByString)) {
                    currentList.add(inactivateable);
                } else if (inactivateable.getActiveFromDate().equals((Object)previousActiveFromDate)) {
                    currentList.add(inactivateable);
                }
                previousGroupByString = groupByString;
                previousActiveFromDate = inactivateable.getActiveFromDate();
            }
        } else {
            currentList = activeList;
        }
        return currentList;
    }

    protected String buildGroupByValueString(BusinessObject businessObject, List<String> groupByList) {
        Object groupByValueString = "";
        for (String groupByField : groupByList) {
            Object fieldValue = KradDataServiceLocator.getDataObjectService().wrap((Object)businessObject).getPropertyValueNullSafe(groupByField);
            groupByValueString = (String)groupByValueString + "|";
            if (fieldValue == null) continue;
            groupByValueString = (String)groupByValueString + fieldValue;
        }
        return groupByValueString;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    protected DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

