--
-- Kuali Coeus, a comprehensive research administration system for higher education.
--
-- Copyright 2005-2020 Kuali, Inc.
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
--
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

-- Narratives
INSERT INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'ED_SF424_Supplement_2_0-V2.0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'ED_SF424_Supplement_Attachment'), 'N', 'admin', NOW(), UUID());

-- Errors
INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/ED_SF424_Supplement_2_0/IsNoviceApplicant', 'Please answer all the questions for the form "ED_SF424_Supplement_2_0-V2.0" within the Questions tab.', 'questions', NOW(), 'admin', 1, UUID());

-- Questionnaire
INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO QUESTIONNAIRE (QUESTIONNAIRE_REF_ID, QUESTIONNAIRE_ID, SEQUENCE_NUMBER, NAME, DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, IS_FINAL, VER_NBR, OBJ_ID)
VALUES((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID), -9, 1, 'EDSF424 Supplement 2.0 Questions', 'These questions support EDSF424 Supplement 2.0 Grants.gov forms.', NOW(), 'admin', 'Y', 1, UUID());

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);
INSERT INTO S2S_FORM_TO_QUESTIONNAIRE (S2S_FORM_TO_QUESTIONNAIRE_ID, OPP_NAME_SPACE, FORM_NAME, QUESTIONNAIRE_ID, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, VER_NBR)
VALUES ((SELECT MAX(ID) FROM SEQ_QUESTIONNAIRE_REF_ID), 'http://apply.grants.gov/forms/ED_SF424_Supplement_2_0-V2.0', 'ED_SF424_Supplement_2_0-V2.0', '-9', NOW(), 'admin', UUID(), 1);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -9),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=133 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = 133)),
        1, 0, 1, 'N', null, 'null', 'admin', NOW(), UUID(), 1, null);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO QUESTIONNAIRE_USAGE (QUESTIONNAIRE_USAGE_ID, MODULE_ITEM_CODE, MODULE_SUB_ITEM_CODE, QUESTIONNAIRE_REF_ID_FK, QUESTIONNAIRE_SEQUENCE_NUMBER, RULE_ID, QUESTIONNAIRE_LABEL, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, IS_MANDATORY)
VALUES ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID), 3, 2, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -9 AND SEQUENCE_NUMBER = 1), 1, null,'EDSF424 Supplement 2.0 Questions', NOW(), 'admin', 1, UUID(), 'N');

