/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public final class CacheKeyUtils {
    private CacheKeyUtils() {
        throw new UnsupportedOperationException();
    }

    public static <K extends Comparable<K>> String key(Collection<K> col) {
        if (col == null) {
            return "";
        }
        ArrayList<K> sorted = new ArrayList<K>(col);
        if (col.size() > 1) {
            Collections.sort(sorted);
        }
        StringBuilder b = new StringBuilder("[");
        for (Comparable entry : sorted) {
            if (entry == null) continue;
            b.append(entry);
            b.append(",");
        }
        b.append("]");
        return b.toString();
    }

    public static <K extends Comparable<K>> String mapKey(Map<K, ?> col) {
        if (col == null) {
            return "";
        }
        ArrayList<K> sorted = new ArrayList<K>(col.keySet());
        if (col.size() > 1) {
            Collections.sort(sorted);
        }
        StringBuilder b = new StringBuilder("[");
        for (Comparable entry : sorted) {
            if (entry == null) continue;
            b.append(entry);
            b.append("|");
            b.append(col.get(entry));
            b.append(",");
        }
        b.append("]");
        return b.toString();
    }
}

